(*	$Id: Dos.Mod,v 40.15 1999/06/17 14:13:08 tauchmann Exp $		*)
(*	$VER: Dos.Mod 40.15 1999/06/17 [AmigaOS] oo2c 32-1.4.3, egcs V2.91.66	*)
(*
**  Oberon Interface Module:
**
**   1993 by Fridtjof Siebert
**  updated for V39, V40 by Hartmut Goebel <AmiNet:dev/obero/Interfaces3_6.lha> <interface-bugs@oberon.nbg.sub.org> <htgoebel@cip.informatik.uni-erlangen.de> <Aufseplatz 5;90459 Nrnberg;Germany>
**                   based on include V40.15
**   1999 by GNU <GeekGadgets:amiga/*/oo2c-32_1.4.3-bin020.tgz>
**  converted to oo2c by <MartinTauchmann@bigfoot.com> <http://MartinTauchmann.home.pages.de>

    This file is an part of Amiga port of oo2c. <http://www.uni-kl.de/OOC/>

    ooc is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ooc is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with ooc. If not, write to the Free Software Foundation, 59
    Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)
(* include:dos/dos.h
               datetime.h
               ...
*)
MODULE Dos [INTERFACE "C";LINK LIB "amiga" ADD_OPTION AllowsSystemFlags END];(* Working 99% *)
(*MODULE Dos [INTERFACE "C", INIT_FCT;LINK LIB "amiga" ADD_OPTION AllowsSystemFlags END];(* Working 99% *)*)
(*MODULE Dos [FOREIGN "C";LINK LIB "amiga" ADD_OPTION AllowsSystemFlags END];(* Working 99% *)*)
(*MODULE Dos [LIBRARY "dos" "0:40:1";FOREIGN "C";LINK LIB "amiga" ADD_OPTION AllowsSystemFlags END];(* Working 99% *)*)
(*MODULE Dos;*)

IMPORT	y:=SYSTEM,
	e:=Exec,
	t:=Timer,
	u:=Utility;


CONST
  dosName * = "dos.library";
  DOSTRUE * = e.LTRUE;
  DOSFALSE * = e.LFALSE;

(* Mode parameter to Open() *)
  oldFile    * =  1005;  (* Open existing file read/write
                          * positioned at beginning of file. *)
  newFile    * =  1006;  (* Open freshly created file (delete
                          * old file) read/write, exclusive lock. *)
  readWrite  * =  1004;  (* Open old file w/shared lock,
                          * creates file if doesn't exist. *)

(* Relative position to Seek() *)
  beginning  * =  -1;      (* relative to Begining Of File *)
  current    * =   0;      (* relative to Current file position *)
  end        * =   1;      (* relative to End Of File    *)

  bitsPerByte     * =  8;
  bytesPerLong    * =  4;
  bitsPerLong     * =  32;
  maxInt          * =  7FFFFFFFH;
  minInt          * =  80000000H;

(* Passed as type to Lock() *)
  sharedLock      * =  -2;    (* File is readable by others *)
  accessRead      * =  -2;    (* Synonym *)
  exclusiveLock   * =  -1;    (* No other access allowed    *)
  accessWrite     * =  -1;    (* Synonym *)


TYPE

  DatePtr                 * = POINTER TO Date;
  FileInfoBlockPtr        * = POINTER TO FileInfoBlock;
  InfoDataPtr             * = POINTER TO InfoData;
  DateTimePtr             * = POINTER TO DateTime;
  AnchorPathPtr           * = POINTER TO AnchorPath;
  AChainPtr               * = POINTER TO AChain;
  ProcessPtr              * = POINTER TO Process;
  DosPacketPtr            * = POINTER TO DosPacket;
  StandardPacketPtr       * = POINTER TO StandardPacket;
  ErrorStringPtr          * = POINTER TO ErrorString;
  DosLibraryPtr           * = POINTER TO DosLibrary;
  RootNodePtr             * = POINTER TO RootNode;
  CliProcListPtr          * = POINTER TO CliProcList;
  AssignListPtr           * = POINTER TO AssignList;
  DevProcPtr              * = POINTER TO DevProc;
  ExAllDataPtr            * = POINTER TO ExAllData;
  ExAllControlPtr         * = POINTER TO ExAllControl;
  DeviceNodePtr           * = POINTER TO DeviceNode;
  NotifyMessagePtr        * = POINTER TO NotifyMessage;
  NotifyRequestPtr        * = POINTER TO NotifyRequest;
  CSourcePtr              * = POINTER TO CSource;
  RDArgsPtr               * = POINTER TO RDArgs;
  RecordLockPtr           * = POINTER TO RecordLock;
  LocalVarPtr             * = POINTER TO LocalVar;
  SegmentPtr              * = POINTER TO Segment;
  DosListNodePtr          * = POINTER TO DosListNode;
  DeviceListAPtr          * = POINTER TO DeviceList;
  DevInfoAPtr             * = POINTER TO DevInfo;
  DosListAPtr             * = POINTER TO DosList;
  CommandLineInterfaceAPtr* = POINTER TO CommandLineInterface;

  FileLockPtr             * = (*BPTR*) POINTER TO FileLock;
  FileHandlePtr           * = (*BPTR*) POINTER TO FileHandle;
  DosEnvecPtr             * = (*BPTR*) POINTER TO DosEnvec;
  DeviceListPtr           * = (*BPTR*) POINTER TO DeviceList;
  DevInfoPtr              * = (*BPTR*) POINTER TO DevInfo;
  DosListPtr              * = (*BPTR*) POINTER TO DosList;
  CommandLineInterfacePtr * = (*BPTR*) POINTER TO CommandLineInterface;
  TaskArrayPtr            * = (*BPTR*) POINTER TO TaskArray;
  DosInfoPtr              * = (*BPTR*) POINTER TO DosInfo;
  FileSysStartupMsgPtr    * = (*BPTR*) POINTER TO FileSysStartupMsg;
  PathLockPtr             * = (*BPTR*) POINTER TO PathLock;

  Date * = RECORD [NO_DESCRIPTOR]
    days * : LONGINT;          (* Number of days since Jan. 1, 1978 *)
    minute * : LONGINT;        (* Number of minutes past midnight *)
    tick * : LONGINT;          (* Number of ticks past minute *)
  END;

CONST
  ticksPerSecond * = 50;       (* Number of ticks in one second *)

TYPE

(* Returned by Examine() and ExNext(), must be on a 4 byte boundary *)
  FileInfoBlock * = RECORD [NO_DESCRIPTOR]
    diskKey * : LONGINT;
    dirEntryType * : LONGINT;       (* Type of Directory. If < 0, then a plain file.
                                     * If > 0 a directory *)
    fileName * : ARRAY 108 OF CHAR; (* Null terminated. Max 30 chars used for now *)
    protection * : y.SET32;         (* bit mask of protection, rwxd are 3-0.      *)
    entryType * : LONGINT;
    size * : LONGINT;               (* Number of bytes in file *)
    numBlock * : LONGINT;           (* Number of blocks in file *)
    date * : Date;                  (* Date file last changed *)
    comment * : ARRAY 80 OF CHAR;   (* Null terminated comment associated with file *)

   (* Note: the following fields are not supported by all filesystems.        *)
   (* They should be initialized to 0 sending an ACTION_EXAMINE packet.       *)
   (* When Examine() is called, these are set to 0 for you.           *)
   (* AllocDosObject() also initializes them to 0.                    *)
    ownerUID *: INTEGER;            (* owner's UID *)
    ownerGID *: INTEGER;            (* owner's GID *)

    reserved * : ARRAY 32 OF CHAR;
  END;

CONST

(* FileInfoBLock.protection flag definitions: *)
(* Regular RWED bits are 0 == allowed. *)
(* NOTE: GRP and OTR RWED permissions are 0 == not allowed! *)
(* Group and Other permissions are not directly handled by the filesystem *)
  otrRead    * = 15;  (* Other: file is readable *)
  otrWrite   * = 14;  (* Other: file is writable *)
  otrExecute * = 13;  (* Other: file is executable *)
  otrDelete  * = 12;  (* Other: prevent file from being deleted *)
  grpRead    * = 11;  (* Group: file is readable *)
  grpWrite   * = 10;  (* Group: file is writable *)
  grpExecute * =  9;  (* Group: file is executable *)
  grpDelete  * =  8;  (* Group: prevent file from being deleted *)

  script   * = 6;        (* program is a script (execute) file *)
  pure     * = 5;        (* program is reentrant and rexecutable *)
  archive  * = 4;        (* cleared whenever file is changed *)
  readProt * = 3;        (* ignored by old filesystem *)
  writeProt* = 2;        (* ignored by old filesystem *)
  execute  * = 1;        (* ignored by system, used by Shell *)
  delete   * = 0;        (* prevent file from being deleted *)

(* Standard maximum length for an error string from fault.  However, most *)
(* error strings should be kept under 60 characters if possible.  Don't   *)
(* forget space for the header you pass in. *)
  faultMax * = 82;

TYPE

(* All BCPL data must be long word aligned.  BCPL pointers are the long word
 *  address (i.e byte address divided by 4 (>>2)) *)
  BPTR * = e.BPTR;                   (* Long word pointer *)
  BSTR * = (*BPTR*) POINTER TO e.STRING;     (* Long word pointer to BCPL string  *)

(* BCPL strings have a length in the first byte and then the characters.
 * For example:  s[0]=3 s[1]=S s[2]=Y s[3]=S                             *)

TYPE

(* returned by Info(), must be on a 4 byte boundary *)
  InfoData * = RECORD [NO_DESCRIPTOR]
    numSoftErrors * : LONGINT;   (* number of soft errors on disk *)
    unitNumber    * : LONGINT;   (* Which unit disk is (was) mounted on *)
    diskState     * : LONGINT;   (* See defines below *)
    numBlock      * : LONGINT;   (* Number of blocks on disk *)
    numBlockUsed  * : LONGINT;   (* Number of block in use *)
    bytesPerBlock * : LONGINT;
    diskType      * : LONGINT;   (* Disk Type code *)
    volumeNode    * : DeviceListPtr; (* BCPL pointer to volume node *)
    inUse         * : LONGINT;   (* Flag, zero if not in use *)
  END;

CONST

(* InfoData.diskState *)
  writeProtect * = 80;    (* Disk is write protected *)
  validating   * = 81;    (* Disk is currently being validated *)
  validated    * = 82;    (* Disk is consistent and writeable *)

(* InfoData.diskType *)
(* Any other new filesystems should also, if possible. *)
  noDiskPresent        * = -1;
(*
  unreadableDisk       * = y.VAL(LONGINT,'BAD\o');
  dosDisk              * = y.VAL(LONGINT,'DOS\o');
  ffsDisk              * = y.VAL(LONGINT,'DOS\x01');
  interDosDisk         * = y.VAL(LONGINT,'DOS\x02');
  interFFSDisk         * = y.VAL(LONGINT,'DOS\x03');
  fastDirDosDisk       * = y.VAL(LONGINT,'DOS\x04');
  fastDirFFSDisk       * = y.VAL(LONGINT,'DOS\x05');
  notReallyDos         * = y.VAL(LONGINT,'NDOS' );
  kickStartDisk        * = y.VAL(LONGINT,'KICK' );
  msdosDisk            * = y.VAL(LONGINT,'MSD\o');
*)
(* Errors from IoErr(), etc. *)
  noFreeStore                * = 103;
  taskTableFull              * = 105;
  badTemplate                * = 114;
  badNumber                  * = 115;
  requiredArgMissing         * = 116;
  keyNeedsArg                * = 117;
  tooManyArgs                * = 118;
  unmatchedQuotes            * = 119;
  lineTooLong                * = 120;
  fileNotObject              * = 121;
  invalidResidentLibrary     * = 122;
  noDefaultDir               * = 201;
  objectInUse                * = 202;
  objectExists               * = 203;
  dirNotFound                * = 204;
  objectNotFound             * = 205;
  badStreamName              * = 206;
  objectTooLarge             * = 207;
  actionNotKnown             * = 209;
  invalidComponentName       * = 210;
  invalidLock                * = 211;
  objectWrongType            * = 212;
  diskNotValidated           * = 213;
  diskWriteProtected         * = 214;
  renameAcrossDevices        * = 215;
  directoryNotEmpty          * = 216;
  tooManyLevels              * = 217;
  deviceNotMounted           * = 218;
  seekError                  * = 219;
  commentTooBig              * = 220;
  diskFull                   * = 221;
  deleteProtected            * = 222;
  writeProtected             * = 223;
  readProtected              * = 224;
  notADosDisk                * = 225;
  noDisk                     * = 226;
  noMoreEntries              * = 232;
(* added for 1.4 *)
  isSoftLink                 * = 233;
  objectLinked               * = 234;
  badHunk                    * = 235;
  notImplemented             * = 236;
  recordNotLocked            * = 240;
  lockCollision              * = 241;
  lockTimeOut                * = 242;
  unLockError                * = 243;

(* These are the return codes used by convention by AmigaDOS commands *)
(* See FAILAT and IF for relvance to EXECUTE files                    *)
  ok                    * =  0; (* No problems, success *)
  warn                  * =  5; (* A warning only *)
  error                 * = 10; (* Something wrong *)
  fail                  * = 20; (* Complete or severe failure*)

(* Bit numbers that signal you that a user has issued a break *)
  ctrlC  * = 12;
  ctrlD  * = 13;
  ctrlE  * = 14;
  ctrlF  * = 15;

(* Values returned by SameLock() *)
  same          * = 0;
  sameHandler   * = 1;      (* actually same volume *)
  different     * = -1;

(* types for ChangeMode() *)
  changeLock  * = 0;
  changeFH    * = 1;

(* Values for MakeLink() *)
  hard   * = 0;
  soft   * = 1;      (* softlinks are not fully supported yet *)

(* values returned by ReadItem *)
  equal      * =  -2;              (* "=" Symbol *)
  itemError  * =  -1;              (* error *)
  nothing    * =  0;               (* *N, ;, endstreamch *)
  unQuoted   * =  1;               (* unquoted item *)
  quoted     * =  2;               (* quoted item *)

(* types for AllocDosObject/FreeDosObject *)
  fileHandle      * = 0;      (* few people should use this *)
  exAllControl    * = 1;      (* Must be used to allocate this! *)
  fib             * = 2;      (* useful *)
  stdpkt          * = 3;      (* for doing packet-level I/O *)
  cli             * = 4;      (* for shell-writers, etc *)
  rdArgs          * = 5;      (* for ReadArgs if you pass it in *)

TYPE

(*
 *      Data structures and equates used by the V1.4 DOS functions
 * StrtoDate() and DatetoStr()
 *)

CONST

(* You need this much room for each of the DateTime strings: *)
  lenDatString * = 16;

TYPE
  DatString * = ARRAY 16 OF CHAR;
  DatStringPtr * = POINTER TO DatString;

(*--------- String/Date structures etc *)
  DateTime * = RECORD [NO_DESCRIPTOR]               (* DOS Date *)
    date * : Date;
    format * : SHORTINT;            (* controls appearance of dat_StrDate *)
    flags  * : y.SET8;            (* see BITDEF's below *)
    strDay * : DatStringPtr;        (* day of the week string *)
    strDate* : DatStringPtr;        (* date string *)
    strTime* : DatStringPtr;        (* time string *)
  END;

CONST

(* flags for DateTime.flags *)

  subst   * = 0;              (* substitute Today, Tomorrow, etc. *)
  future  * = 1;              (* day of the week is in future *)

(*
 *      date format values
 *)

  formatDos   * = 0;              (* dd-mmm-yy *)
  formatInt   * = 1;              (* yy-mm-dd  *)
  formatUSA   * = 2;              (* mm-dd-yy  *)
  formatCDN   * = 3;              (* dd-mm-yy  *)
  formatMax   * = formatCDN;


(***********************************************************************
************************ PATTERN MATCHING ******************************
************************************************************************

* structure expected by MatchFirst, MatchNext.
* Allocate this structure and initialize it as follows:
*
* Set ap_BreakBits to the signal bits (CDEF) that you want to take a
* break on, or NULL, if you don't want to convenience the user.
*
* If you want to have the FULL PATH NAME of the files you found,
* allocate a buffer at the END of this structure, and put the size of
* it into ap_Length.  If you don't want the full path name, make sure
* you set ap_Length to zero.  In this case, the name of the file, and stats
* are available in the ap_Info, as per usual.
*
* Then call MatchFirst() and then afterwards, MatchNext() with this structure.
* You should check the return value each time (see below) and take the
* appropriate action, ultimately calling MatchEnd() when there are
* no more files and you are done.  You can tell when you are done by
* checking for the normal AmigaDOS return code ERROR_NO_MORE_ENTRIES.
*
*)

TYPE
  AnchorPath * = RECORD [NO_DESCRIPTOR]
        base * : AChainPtr;        (* pointer to first anchor *)
        last * : AChainPtr;        (* pointer to last anchor *)
        breakBits * : y.SET32;     (* Bits we want to break on *)
        foundBreak * : y.SET32;    (* Bits we broke on. Also returns ERROR_BREAK *)
        flags * : y.SET8;        (* New use for extra word. *)
        reserved * : e.BYTE;
        strLen * : INTEGER;        (* This is what AnchoPath.length used to be *)
        info * : FileInfoBlock;
        buf * : e.STRING;          (* Buffer for path name *)
  END;

CONST
(* AnchorPath.flags *)
  doWild  * = 0;       (* User option ALL *)
  itsWild * = 1;       (* Set by MatchFirst, used by MatchNext *)
                       (* Application can test itsWild, too *)
  doDir   * = 2;       (* Bit is SET if a DIR node should be *)
                       (* entered. Application can RESET this *)
                       (* bit after MatchFirst/MatchNext to AVOID *)
                       (* entering a dir. *)
  didDir  * = 3;       (* Bit is SET for an "expired" dir node. *)
  noMemErr* = 4;       (* Set on memory error *)
  doDot   * = 5;       (* If set, allow conversion of '.' to *)
                       (* CurrentDir *)
  dirChanged * = 6;    (* ap_Current->an_Lock changed *)
                       (* since last MatchNext call *)

TYPE
  AChain * = RECORD [NO_DESCRIPTOR]
        child  * : AChainPtr;
        parent * : AChainPtr;
        lock   * : FileLockPtr;
        info   * : FileInfoBlock;
        flags  * : y.SET8;
        string * : e.STRING;
  END;

CONST

  patternBit  * = 0;
  examinedBit * = 1;
  completed   * = 2;
  allBit      * = 3;
  single      * = 4;

(*
 * Constants used by wildcard routines, these are the pre-parsed tokens
 * referred to by pattern match.  It is not necessary for you to do
 * anything about these, MatchFirst() MatchNext() handle all these for you.
 *)

  pAny           * = 80H;    (* Token for '*' or '#?  *)
  pSingle        * = 81H;    (* Token for '?' *)
  pOrStart       * = 82H;    (* Token for '(' *)
  pOrNext        * = 83H;    (* Token for '|' *)
  pOrEnd         * = 84H;    (* Token for ')' *)
  pNot           * = 85H;    (* Token for '~' *)
  pNotEnd        * = 86H;    (* Token for *)
  pNotClass      * = 87H;    (* Token for '^' *)
  pClass         * = 88H;    (* Token for '[]' *)
  pRepBeg        * = 89H;    (* Token for '[' *)
  pRepEnd        * = 8AH;    (* Token for ']' *)
  pStop          * = 8BH;    (* Token to force end of evaluation *)

(* Values for an_Status, NOTE: These are the actual bit numbers *)

  complexBit   * = 1;       (* Parsing complex pattern *)
  examineBit   * = 2;       (* Searching directory *)

(*
 * Returns from MatchFirst(), MatchNext()
 * You can also get dos error returns, such as ERROR_NO_MORE_ENTRIES,
 * these are in the dos.h file.
 *)

  bufferOverflow * = 303;     (* User or internal buffer overflow *)
  break          * = 304;     (* A break character was received *)
  notExecutable  * = 305;     (* A file has E bit cleared *)

TYPE

  ProcessId * = e.MsgPortPtr; (* Points to Process.msgPort *)

(* All DOS processes have this structure *)
(* Create and Device Proc returns pointer to the MsgPort in this structure *)
(* dev_proc = (struct Process * ) (DeviceProc(..) - sizeof(struct Task)); *)

  Process * = RECORD [NO_DESCRIPTOR]
    task 		* : e.Task;
    msgPort        * : e.MsgPort;     (* This is BPTR address from DOS functions  *)
    pad            * : INTEGER;       (* Remaining variables on 4 byte boundaries *)
    segList        * : e.BPTR;        (* Array of seg lists used by this process  *)
    stackSize      * : LONGINT;       (* Size of process stack in bytes           *)
    globVec        * : e.APTR;        (* Global vector for this process (BCPL)    *)
    taskNum        * : LONGINT;       (* CLI task number of zero if not a CLI     *)
    stackBase      * : e.BPTR;        (* Ptr to high memory end of process stack  *)
    result2        * : LONGINT;       (* Value of secondary result from last call *)
    currentDir     * : FileLockPtr;   (* Lock associated with current directory   *)
    cis            * : FileHandlePtr; (* Current CLI Input Stream                 *)
    cos            * : FileHandlePtr; (* Current CLI Output Stream                *)
    consoleTask    * : ProcessId;     (* Console handler process for current window*)
    fileSystemTask * : ProcessId;     (* File handler process for current drive   *)
    cli            * : CommandLineInterfacePtr;  (* pointer to CommandLineInterface          *)
    returnAddr     * : e.APTR;        (* pointer to previous stack frame          *)
    pktWait        * : e.APTR;        (* Function to be called when awaiting msg  *)
    windowPtr      * : e.APTR;        (* Window for error printing                *)

    (* following definitions are new with 2.0 *)
    homeDir        * : FileLockPtr;   (* Home directory of executing program      *)
    PR_flags          * : y.SET32;       (* flags telling dos about process          *)
    exitCode       * : e.PROC;        (* code to call on exit of program or NULL  *)
    exitData       * : LONGINT;       (* Passed as an argument to pr_ExitCode.    *)
    arguments      * : e.LSTRPTR;     (* Arguments passed to the process at start *)
    localVars      * : e.MinList;     (* Local environment variables             *)
    shellPrivate   * : LONGINT;       (* for the use of the current shell         *)
    ces            * : FileHandlePtr; (* Error stream - if NULL, use pr_COS       *)
  END;

CONST

(*
 * Flags for Process.flags
 *)
  freeSegList     * = 0;
  freeCurrDir     * = 1;
  freeCLI         * = 2;
  closeInput      * = 3;
  closeOutput     * = 4;
  freeArgs        * = 5;

TYPE

(* The long word address (BPTR) of this structure is returned by
 * Open() and other routines that return a file.  You need only worry
 * about this struct to do async io's via PutMsg() instead of
 * standard file system calls *)

  FileHandle * = RECORD [NO_DESCRIPTOR]
    link * : e.MessagePtr;      (* EXEC message              *)
    port * : e.MsgPortPtr;      (* Reply port for the packet *)
    type * : ProcessId;         (* Port to do PutMsg() to
                                 * Address is negative if a plain file *)
    buf  * : LONGINT;
    pos  * : LONGINT;
    end  * : LONGINT;
    func1* : LONGINT;
    func2* : LONGINT;
    func3* : LONGINT;
    arg1 * : LONGINT;
    arg2 * : LONGINT;
  END;

(* This is the extension to EXEC Messages used by DOS *)

  DosPacket * = RECORD [NO_DESCRIPTOR]
    link * : e.MessagePtr;      (* EXEC message              *)
    port * : e.MsgPortPtr;      (* Reply port for the packet *)
                                (* Must be filled in each send. *)
    type * : LONGINT;           (* See ACTION_... below and                    (* action *)
                                 * 'R' means Read, 'W' means Write to the
                                 * file system *)
    res1 * : LONGINT;           (* For file system calls this is the result    (* status *)
                                 * that would have been returned by the
                                 * function, e.g. Write ('W') returns actual
                                 * length written *)
    res2 * : LONGINT;           (* For file system calls this is what would    (* status2 *)
                                 * have been returned by IoErr() *)
    arg1 * : LONGINT;                                                          (* bufAddr *)
    arg2 * : LONGINT;
    arg3 * : LONGINT;
    arg4 * : LONGINT;
    arg5 * : LONGINT;
    arg6 * : LONGINT;
    arg7 * : LONGINT;
  END;

(* A Packet does not require the Message to be before it in memory, but
 * for convenience it is useful to associate the two.
 * Also see the function init_std_pkt for initializing this structure *)

  StandardPacket * = RECORD [NO_DESCRIPTOR] 
    message * : e.Message;
    pkt * : DosPacket;
  END;

CONST

(* DosPacket.type *)
  nil              * = 0;
  startup          * = 0;
  getBlock         * = 2;       (* OBSOLETE *)
  setMap           * = 4;
  die              * = 5;
  event            * = 6;
  currentVolume    * = 7;
  locateObject     * = 8;
  renameDisk       * = 9;
  write            * = ORD('W');
  read             * = ORD('R');
  freeLock         * = 15;
  deleteObject     * = 16;
  renameObject     * = 17;
  moreCache        * = 18;
  copyDir          * = 19;
  waitChar         * = 20;
  setProtect       * = 21;
  createDir        * = 22;
  examineObject    * = 23;
  examineNext      * = 24;
  diskInfo         * = 25;
  info             * = 26;
  flush            * = 27;
  setComment       * = 28;
  parent           * = 29;
  timer            * = 30;
  inhibit          * = 31;
  diskType         * = 32;
  diskChange       * = 33;
  setDate          * = 34;

  screenMode       * = 994;

  readReturn       * = 1001;
  writeReturn      * = 1002;
  seek             * = 1008;
  findUpdate       * = 1004;
  findInput        * = 1005;
  findOutput       * = 1006;
  actionEnd        * = 1007;
  setFileSize      * = 1022;    (* fast file system only in 1.3 *)
  writeprotect     * = 1023;    (* fast file system only in 1.3 *)

(* new 2.0 packets *)
  sameLock         * = 40;
  changeSignal     * = 995;
  format           * = 1020;
  makeLink         * = 1021;
  (**)
  (**)
  readLink         * = 1024;
  fhFromLock       * = 1026;
  isFileSystem     * = 1027;
  changeMode       * = 1028;
  (**)
  copyDirFH        * = 1030;
  parentFH         * = 1031;
  examineAll       * = 1033;
  examineFH        * = 1034;

  lockRecord       * = 2008;
  freeRecord       * = 2009;

  addNotify        * = 4097;
  removeNotify     * = 4098;

(* Added in V39: *)
  examineAllEnd    * = 1035;
  setOwner         * = 1036;


TYPE

(*
 * A structure for holding error messages - stored as array with error == 0
 * for the last entry.
 *)

  ErrorString * = RECORD [NO_DESCRIPTOR]
    nums    * : e.APTR;
    strings * : e.APTR;
  END;

(* DOS library node structure.
 * This is the data at positive offsets from the library node.
 * Negative offsets from the node is the jump table to DOS functions
 * node = (struct DosLibrary * ) OpenLibrary( "dos.library" .. )      *)

  DosLibrary * = RECORD [NO_DESCRIPTOR]
    library * : e.Library;
    root * : RootNodePtr;       (* Pointer to RootNode, described below *)
    gv   * : e.APTR;            (* Pointer to BCPL global vector        *)
    a2     : LONGINT;           (* Private register dump of DOS         *)
    a5     : LONGINT;
    a6     : LONGINT;
    errors * : ErrorStringPtr; (* pointer to array of error msgs *)
    timeReq   : t.TimeRequestPtr; (* private pointer to timer request *)
    utilityBase   : e.LibraryPtr; (* private ptr to utility library *)
  END;

(*                             *)

  TaskArray * = RECORD [NO_DESCRIPTOR]
    maxCLI * : LONGINT;
    cli    * : ARRAY 10000000H OF ProcessId;
  END;

  RootNode * = RECORD [NO_DESCRIPTOR]
    taskArray * : TaskArrayPtr;      (* [0] is max number of CLI's
                                      * [1] is APTR to process id of CLI 1
                                      * [n] is APTR to process id of CLI n       *)
    consoleSegment * : e.BPTR;       (* SegList for the CLI                      *)
    time * : Date;                   (* Current time                             *)
    restartSeg * : e.BPTR;           (* SegList for the disk validator process   *)
    info * : DosInfoPtr;             (* Pointer to the Info structure            *)
    fileHandlerSegment * : e.BPTR;   (* segment for a file handler               *)
    cliList * : e.MinList;           (* new list of all CLI processes            *)
                                     (* the first cpl_Array is also rn_TaskArray *)
    bootProc  -: ProcessId;          (* private ptr to msgport of boot fs        *)
    shellSegment * : e.BPTR;         (* seglist for Shell (for NewShell)         *)
    flags * : y.SET32;               (* dos flags *)
  END;

CONST
(* RootNode.flags *)
  wildStar * = 24;
  private1 * = 1;

TYPE

(* ONLY to be allocated by DOS! *)
  CliProcList * = RECORD [NO_DESCRIPTOR]
        minnode * : e.MinNode;
        first * : LONGINT;      (* number of first entry in array *)
        array * : POINTER TO ARRAY 1FFFFFFFH OF ProcessId;
                             (* [0] is max number of CLI's in this entry (n)
                              * [1] is CPTR to process id of CLI cpl_First
                              * [n] is CPTR to process id of CLI cpl_First+n-1
                              *)
  END;

  DosInfo * = RECORD [NO_DESCRIPTOR]
    mcName * : BSTR;           (* Network name of this machine; currently 0 *)
    devInfo * : DevInfoPtr;    (* Device List                               *)
    devices * : e.BPTR;        (* Currently zero                            *)
    handlers * : e.BPTR;       (* Currently zero                            *)
    nethand  * : ProcessId;          (* Network handler processid; currently zero *)
    devLock * : e.SignalSemaphore;   (* do NOT access directly! *)
    entryLock * : e.SignalSemaphore; (* do NOT access directly! *)
    deleteLock * : e.SignalSemaphore;(* do NOT access directly! *)
  END;


(* structure for the Dos resident list.  Do NOT allocate these, use       *)
(* AddSegment(), and heed the warnings in the autodocs!                   *)

  Segment * = RECORD [NO_DESCRIPTOR]
    next * : e.BPTR;
    uc * : LONGINT;
    seg * : e.BPTR;
    name * : ARRAY 4 OF CHAR;     (* actually the first 4 chars of BSTR name *)
  END;

CONST

  cmdSystem   * = -1;
  cmdInternal * = -2;
  cmdDisabled * = -999;


TYPE

  PathLock    * = RECORD [NO_DESCRIPTOR]
                    next * : PathLockPtr;
                    lock * : FileLockPtr;
                  END;

(* DOS Processes started from the CLI via RUN or NEWCLI have this additional
 * set to data associated with them *)

  CommandLineInterface * = RECORD [NO_DESCRIPTOR]
    result2        * : LONGINT;       (* Value of IoErr from last command        *)
    setName        * : BSTR;          (* Name of current directory               *)
    commandDir     * : PathLockPtr;   (* Head of the path locklist               *)
    returnCode     * : LONGINT;       (* Return code from last command           *)
    commandName    * : BSTR;          (* Name of current command                 *)
    failLevel      * : LONGINT;       (* Fail level (set by FAILAT)              *)
    prompt         * : BSTR;          (* Current prompt (set by PROMPT)          *)
    standardInput  * : FileHandlePtr; (* Default (terminal) CLI input            *)
    currentInput   * : FileHandlePtr; (* Current CLI input                       *)
    commandFile    * : BSTR;          (* Name of EXECUTE command file            *)
    interactive    * : LONGINT;       (* Boolean; True if prompts required       *)
    background     * : LONGINT;       (* Boolean; True if CLI created by RUN     *)
    currentOutput  * : FileHandlePtr; (* Current CLI output                      *)
    defaultStack   * : LONGINT;       (* Stack size to be obtained in long words *)
    standardOutput * : FileHandlePtr; (* Default (terminal) CLI output           *)
    module         * : e.BPTR;        (* SegList of currently loaded command     *)


  END;

(* This structure can take on different values depending on whether it is
 * a device, an assigned directory, or a volume.  Below is the structure
 * reflecting volumes only.  Following that is the structure representing
 * only devices. Following that is the unioned structure representing all
 * the values
 *)

  DosListNode * = RECORD [NO_DESCRIPTOR] END; (* Dummy to make the following STRUCTs compatible *)

(* structure representing a volume *)

  DeviceList * = RECORD [NO_DESCRIPTOR]
    next       * : DeviceListPtr;  (* bptr to next device list *)
    type       * : LONGINT;        (* see DLT below *)
    task       * : ProcessId;      (* ptr to handler task *)
    lock       * : FileLockPtr;    (* not for volumes *)
    volumeDate * : Date;           (* creation date *)
    lockList   * : FileLockPtr;    (* outstanding locks *)
    diskType   * : LONGINT;        (* 'DOS', etc *)
    unused     * : LONGINT;
    name       * : BSTR;           (* bptr to bcpl name *)
  END;

(* device structure (same as the DeviceNode structure in filehandler.h) *)

  DevInfo * = RECORD [NO_DESCRIPTOR]
    next      * : DevInfoPtr;
    type      * : LONGINT;
    task      * : ProcessId;
    lock      * : FileLockPtr;
    handler   * : BSTR;
    stackSize * : LONGINT;
    priority  * : LONGINT;
    startup   * : FileSysStartupMsgPtr;
    segList   * : e.BPTR;
    globVec   * : e.BPTR;
    name      * : BSTR;
  END;

(* combined structure for devices, assigned directories, volumes *)

  DosList * = RECORD [NO_DESCRIPTOR]
    next      * : DevInfoPtr;
    type      * : LONGINT;
    task      * : ProcessId;
    lock      * : FileLockPtr;

    assignName* : e.LSTRPTR;      (* name for non-or-late-binding assign *)
    list      * : AssignListPtr;  (* for multi-directory assigns (regular) *)
    unused    * : ARRAY 4 OF LONGINT;
    name      * : BSTR;
  END;

(* structure used for multi-directory assigns. AllocVec()ed. *)

  AssignList * = RECORD [NO_DESCRIPTOR]
    next * : AssignListPtr;
    lock * : FileLockPtr;
  END;

CONST

(* definitions for DosList.type *)
  device      * = 0;
  directory   * = 1;       (* assign *)
  volume      * = 2;
  late        * = 3;       (* late-binding assign *)
  nonBinding  * = 4;       (* non-binding assign *)
  private     * = -1;      (* for internal use only *)

TYPE

(* structure return by GetDeviceProc() *)
  DevProc * = RECORD [NO_DESCRIPTOR]
    port * : e.MsgPortPtr;
    lock * : FileLockPtr;
    flags * : y.SET32;
    devNode : DosListNodePtr;    (* DON'T TOUCH OR USE! *)
  END;

CONST

(* definitions for DevProc.flags *)
  unLock  * = 0;
  assign  * = 1;

(* Flags to be passed to LockDosList(), etc *)
  devices   * = 2;
  volumes   * = 3;
  assigns   * = 4;
  entry     * = 5;
  ldDelete  * = 6;

(* you MUST specify one of read or write *)
  dosListRead * = 0;
  dosListWrite * = 1;

(* actually all but entry (which is used for internal locking) *)
  all * = {devices,volumes,assigns};

TYPE

(* a lock structure, as returned by Lock() or DupLock() *)
  FileLock * = RECORD [NO_DESCRIPTOR]
    link   * : FileLockPtr;   (* bcpl pointer to next lock *)
    key    * : LONGINT;       (* disk block number *)
    access * : LONGINT;       (* exclusive or shared *)
    task   * : ProcessId;     (* handler task's port *)
    volume * : DeviceListPtr; (* bptr to DLT_VOLUME DosList entry *)
  END;

CONST

(* error report types for ErrorReport() *)
  reportStream * = 0;      (* a stream *)
  reportTask   * = 1;      (* a process - unused *)
  reportLock   * = 2;      (* a lock *)
  reportVolume * = 3;      (* a volume node *)
  reportInsert * = 4;      (* please insert volume *)

(* Special error codes for ErrorReport() *)
  diskError  * = 296;     (* Read/write error *)
  abortBusy  * = 288;     (* You MUST replace... *)

(* types for initial packets to shells from run/newcli/execute/system. *)
(* For shell-writers only *)
  runExecute         * = -1;
  runSystem          * = -2;
  runSystemAsynch    * = -3;

(* Types for FileInfoBlock.dirEntryType. NOTE that both USERDIR and ROOT are  *)
(* directories, and that directory/file checks should use <0 and >=0.    *)
(* This is not necessarily exhaustive!  Some handlers may use other      *)
(* values as needed, though <0 and >=0 should remain as supported as     *)
(* possible.                                                             *)
  root       * = 1;
  userDir    * = 2;
  softLink   * = 3;       (* looks like dir, but may point to a file! *)
  linkDir    * = 4;       (* hard link to dir *)
  file       * = -3;      (* must be negative for FIB! *)
  linkFile   * = -4;      (* hard link to file *)


(* hunk types *)
  hunkUnit       * = 999;
  hunkName       * = 1000;
  hunkCode       * = 1001;
  hunkData       * = 1002;
  hunkBSS        * = 1003;
  hunkReloc32    * = 1004;
  hunkAbsReloc32 * = hunkReloc32;
  hunkReloc16    * = 1005;
  hunkRelReloc16 * = hunkReloc16;
  hunkReloc8     * = 1006;
  hunkRelReloc8  * = hunkReloc8;
  hunkExt        * = 1007;
  hunkSymbol     * = 1008;
  hunkDebug      * = 1009;
  hunkEnd        * = 1010;
  hunkHeader     * = 1011;

  hunkOverlay    * = 1013;
  hunkBreak      * = 1014;

  hunkDRel32     * = 1015;
  hunkDRel16     * = 1016;
  hunkDRel8      * = 1017;

  hunkLib        * = 1018;
  hunkIndex      * = 1019;

(*
 * Note: V37 LoadSeg uses 1015 (HUNK_DREL32) by mistake.  This will continue
 * to be supported in future versions, since HUNK_DREL32 is illegal in load files
 * anyways.  Future versions will support both 1015 and 1020, though anything
 * that should be usable under V37 should use 1015.
 *)
  hunkReloc32Short * = 1020;

(* see ext_xxx below.  New for V39 (note that LoadSeg only handles RELRELOC32).*)
  hunkRelReloc32   * = 1021;
  hunkAbsReloc16   * = 1022;

(*
 * Any hunks that have the HUNKB_ADVISORY bit set will be ignored if they
 * aren't understood.  When ignored, they're treated like HUNK_DEBUG hunks.
 * NOTE: this handling of HUNKB_ADVISORY started as of V39 dos.library!  If
 * lading such executables is attempted under <V39 dos, it will fail with a
 * bad hunk type.
 *)
  hunkBAdvisory    * = 29;
  hunkBChip        * = 30;
  hunkBFast        * = 31;


(* hunk_ext sub-types *)
  extSymb        * = 0;       (* symbol table *)
  extDef         * = 1;       (* relocatable definition *)
  extAbs         * = 2;       (* Absolute definition *)
  extRes         * = 3;       (* no longer supported *)
  extRef32       * = 129;     (* 32 bit reference to symbol *)
  extAbsRef32    * = extRef32;
  extCommon      * = 130;     (* 32 bit reference to COMMON block *)
  extAbsCommon   * = extCommon;
  extRef16       * = 131;     (* 16 bit reference to symbol *)
  extRelRef16    * = extRef16;
  extRef8        * = 132;     (*  8 bit reference to symbol *)
  extRelRef8     * = extRef8;
  extDExt32      * = 133;     (* 32 bit data releative reference *)
  extDExt16      * = 134;     (* 16 bit data releative reference *)
  extDExt8       * = 135;     (*  8 bit data releative reference *)

(* These are to support some of the '020 and up modes that are rarely used *)
  extRelRef32    * = 136;     (* 32 bit PC-relative reference to symbol *)
  extRelCommon   * = 137;     (* 32 bit PC-relative reference to COMMON block *)

(* for completeness... All 680x0's support this *)
  extAbsRef16    * = 138;     (* 16 bit absolute reference to symbol *)

(* this only exists on '020's and above, in the (d8,An,Xn) address mode *)
  extAbsRef8     * = 139;     (* 8 bit absolute reference to symbol *)


(*****************************************************************************)
(* definitions for the System() call *)

  sysDummy       * = u.user + 32;
  sysInput       * = sysDummy + 1;      (* specifies the input filehandle  *)
  sysOutput      * = sysDummy + 2;      (* specifies the output filehandle *)
  sysAsynch      * = sysDummy + 3;      (* run asynch, close input/output on exit(!) *)
  sysUserShell   * = sysDummy + 4;      (* send to user shell instead of boot shell *)
  sysCustomShell * = sysDummy + 5;      (* send to a specific shell (data is name) *)


(*****************************************************************************)
(* definitions for the CreateNewProc() call *)
(* you MUST specify one of NP_Seglist or NP_Entry.  All else is optional. *)

  npDummy        * = u.user + 1000;
  npSeglist      * = npDummy + 1; (* seglist of code to run for the process  *)
  npFreeSeglist  * = npDummy + 2; (* free seglist on exit - only valid for   *)
                                  (* for NP_Seglist.  Default is TRUE.       *)
  npEntry        * = npDummy + 3; (* entry point to run - mutually exclusive *)
                                  (* with NP_Seglist! *)
  npInput        * = npDummy + 4; (* filehandle - default is Open("NIL:"...) *)
  npOutput       * = npDummy + 5; (* filehandle - default is Open("NIL:"...) *)
  npCloseInput   * = npDummy + 6; (* close input filehandle on exit          *)
                                  (* default TRUE                            *)
  npCloseOutput  * = npDummy + 7; (* close output filehandle on exit         *)
                                  (* default TRUE                            *)
  npError        * = npDummy + 8; (* filehandle - default is Open("NIL:"...) *)
  npCloseError   * = npDummy + 9; (* close error filehandle on exit          *)
                                  (* default TRUE                            *)
  npCurrentDir   * = npDummy + 10; (* lock - default is parent's current dir  *)
  npStackSize    * = npDummy + 11; (* stacksize for process - default 4000    *)
  npName         * = npDummy + 12; (* name for process - default "New Process"*)
  npPriority     * = npDummy + 13; (* priority - default same as parent       *)
  npConsoleTask  * = npDummy + 14; (* consoletask - default same as parent    *)
  npWindowPtr    * = npDummy + 15; (* window ptr - default is same as parent  *)
  npHomeDir      * = npDummy + 16; (* home directory - default curr home dir  *)
  npCopyVars     * = npDummy + 17; (* boolean to copy local vars-default TRUE *)
  npCli          * = npDummy + 18; (* create cli structure - default FALSE    *)
  npPath         * = npDummy + 19; (* path - default is copy of parents path  *)
                                   (* only valid if a cli process!    *)
  npCommandName  * = npDummy + 20; (* commandname - valid only for CLI        *)
  npArguments    * = npDummy + 21; (* cstring of arguments - passed with str  *)
                                   (* in a0, length in d0.  (copied and freed *)
                                   (* on exit.  Default is empty string.      *)
                                   (* NOTE: not operational until 2.04 - see  *)
                                   (* BIX/TechNotes for more info/workarounds *)
                                   (* NOTE: in 2.0, it DIDN'T pass "" - the   *)
                                   (* registers were random.                  *)
(* FIX! should this be only for cli's? *)
  npNotifyOnDeath * = npDummy + 22; (* notify parent on death - default FALSE  *)
                                    (* Not functional yet. *)
  npSynchronous  * = npDummy + 23; (* don't return until process finishes -   *)
                                   (* default FALSE.                          *)
                                   (* Not functional yet. *)
  npExitCode     * = npDummy + 24; (* code to be called on process exit       *)
  npExitData     * = npDummy + 25; (* optional argument for NP_EndCode rtn -  *)
                                   (* default NULL                            *)


(*****************************************************************************)
(* tags for AllocDosObject *)

  adoDummy       * = u.user + 2000;
  adoFHMode      * = adoDummy + 1;
                                (* for type DOS_FILEHANDLE only            *)
                                (* sets up FH for mode specified.
                                   This can make a big difference for buffered
                                   files.                                  *)
        (* The following are for DOS_CLI *)
        (* If you do not specify these, dos will use it's preferred values *)
        (* which may change from release to release.  The BPTRs to these   *)
        (* will be set up correctly for you.  Everything will be zero,     *)
        (* except cli_FailLevel (10) and cli_Background (DOSTRUE).         *)
        (* NOTE: you may also use these 4 tags with CreateNewProc.         *)

  adoDirLen      * = adoDummy + 2; (* size in bytes for current dir buffer    *)
  adoCommNameLen * = adoDummy + 3; (* size in bytes for command name buffer   *)
  adoCommFileLen * = adoDummy + 4; (* size in bytes for command file buffer   *)
  adoPromptLen   * = adoDummy + 5; (* size in bytes for the prompt buffer     *)

(*****************************************************************************)
(* tags for NewLoadSeg *)
(* no tags are defined yet for NewLoadSeg *)

(* NOTE: V37 dos.library, when doing ExAll() emulation, and V37 filesystems  *)
(* will return an error if passed ED_OWNER.  If you get ERROR_BAD_NUMBER,    *)
(* retry with ED_COMMENT to get everything but owner info.  All filesystems  *)
(* supporting ExAll() must support through ED_COMMENT, and must check Type   *)
(* and return ERROR_BAD_NUMBER if they don't support the type.                     *)

(* values that can be passed for what data you want from ExAll() *)
(* each higher value includes those below it (numerically)       *)
(* you MUST chose one of these values *)
  name        * = 1;
  type        * = 2;
  size        * = 3;
  protection  * = 4;
  date        * = 5;
  comment     * = 6;
  owner       * = 7;

TYPE

(*
 *   Structure in which exall results are returned in.  Note that only the
 *   fields asked for will exist!
 *)

  ExAllData * = RECORD [NO_DESCRIPTOR]
        next * : ExAllDataPtr;
        name * : e.LSTRPTR;
        type * : LONGINT;
        size * : LONGINT;
        prot * : y.SET32;
        days * : LONGINT;
        mins * : LONGINT;
        ticks    * : LONGINT;
        comment  * : e.LSTRPTR;  (* strings will be after last used field *)
        ownerUID * : INTEGER;    (* new for V39 *)
        ownerGID * : INTEGER;
  END;

(*
 *   Control structure passed to ExAll.  Unused fields MUST be initialized to
 *   0, expecially eac_LastKey.
 *
 *   eac_MatchFunc is a hook (see utility.library documentation for usage)
 *   It should return true if the entry is to returned, false if it is to be
 *   ignored.
 *
 *   This structure MUST be allocated by AllocDosObject()!
 *)

  ExAllControl * = RECORD [NO_DESCRIPTOR]
    entries     * : LONGINT;    (* number of entries returned in buffer      *)
    lastKey     * : LONGINT;    (* Don't touch inbetween linked ExAll calls! *)
    matchString * : e.LSTRPTR;  (* wildcard string for pattern match or NULL *)
    matchFunc   * : u.HookPtr;  (* optional private wildcard function        *)
  END;


(* The disk "environment" is a longword array that describes the
 * disk geometry.  It is variable sized, with the length at the beginning.
 * Here are the constants for a standard geometry.
 *)

  DosEnvec * = RECORD [NO_DESCRIPTOR]
    tableSize      * : LONGINT; (* size of Environment vector *)
    sizeBlock      * : LONGINT; (* in longwords: standard value is 128 *)
    secOrg         * : LONGINT; (* not used; must be 0 *)
    surfaces       * : LONGINT; (* # of heads (surfaces). drive specific *)
    sectorPerBlock * : LONGINT; (* not used; must be 1 *)
    blocksPerTrack * : LONGINT; (* blocks per track. drive specific *)
    reserved       * : LONGINT; (* DOS reserved blocks at start of partition. *)
    preAlloc       * : LONGINT; (* DOS reserved blocks at end of partition *)
    interleave     * : LONGINT; (* usually 0 *)
    lowCyl         * : LONGINT; (* starting cylinder. typically 0 *)
    highCyl        * : LONGINT; (* max cylinder. drive specific *)
    numBuffers     * : LONGINT; (* Initial # DOS of buffers.  *)
    bufMemType     * : LONGINT; (* type of mem to allocate for buffers *)
    maxTransfer    * : LONGINT; (* Max number of bytes to transfer at a time *)
    mask           * : y.SET32; (* Address Mask to block out certain memory *)
    bootPri        * : LONGINT; (* Boot priority for autoboot *)
    dosType        * : LONGINT; (* ASCII (HEX) string showing filesystem type;
                                 * 0X444F5300 is old filesystem,
                                 * 0X444F5301 is fast file system *)
    baud           * : LONGINT; (* Baud rate for serial handler *)
    control        * : LONGINT; (* Control word for handler/filesystem *)
    bootBlocks     * : LONGINT; (* Number of blocks containing boot code *)
  END;

CONST

(* these are the offsets into the array *)
(* DE_TABLESIZE is set to the number of longwords in the table minus 1 *)

  tableSize    * = 0;       (* minimum value is 11 (includes NumBuffers) *)
  sizeBlock    * = 1;       (* in longwords: standard value is 128 *)
  secOrg       * = 2;       (* not used; must be 0 *)
  numHeads     * = 3;       (* # of heads (surfaces). drive specific *)
  secsPerBlk   * = 4;       (* not used; must be 1 *)
  blksPerTrack * = 5;       (* blocks per track. drive specific *)
  reservedBlks * = 6;       (* unavailable blocks at start.  usually 2 *)
  preFac       * = 7;       (* not used; must be 0 *)
  interLeave   * = 8;       (* usually 0 *)
  lowCyl       * = 9;       (* starting cylinder. typically 0 *)
  upperCyl     * = 10;      (* max cylinder.  drive specific *)
  numBuffers   * = 11;      (* starting # of buffers.  typically 5 *)
  memBufType   * = 12;      (* type of mem to allocate for buffers. *)
  bufMemType   * = 12;      (* same as above, better name
                             * 1 is public, 3 is chip, 5 is fast *)
  maxTransfer  * = 13;      (* Max number bytes to transfer at a time *)
  mask         * = 14;      (* Address Mask to block out certain memory *)
  bootPri      * = 15;      (* Boot priority for autoboot *)
  dosType      * = 16;      (* ASCII (HEX) string showing filesystem type;
                             * 0X444F5300 is old filesystem,
                             * 0X444F5301 is fast file system *)
  baud         * = 17;      (* Baud rate for serial handler *)
  control      * = 18;      (* Control word for handler/filesystem *)
  bootBlocks   * = 19;      (* Number of blocks containing boot code *)

TYPE

(* The file system startup message is linked into a device node's startup
** field.  It contains a pointer to the above environment, plus the
** information needed to do an exec OpenDevice().
*)
  FileSysStartupMsg * = RECORD [NO_DESCRIPTOR]
    unit    * : LONGINT;     (* exec unit number for this device *)
    device  * : BSTR;        (* null terminated bstring to the device name *)
    environ * : DosEnvecPtr; (* ptr to environment table (see above) *)
    flags   * : y.SET32;     (* flags for OpenDevice() *)
  END;


(* The include file "libraries/dosextens.h" has a DeviceList structure.
 * The "device list" can have one of three different things linked onto
 * it.  Dosextens defines the structure for a volume.  DLT_DIRECTORY
 * is for an assigned directory.  The following structure is for
 * a dos "device" (DLT_DEVICE).
*)

  DeviceNode * = RECORD [NO_DESCRIPTOR]
    next      * : DeviceNodePtr;        (* singly linked list *)
    type      * : LONGINT;              (* always 0 for dos "devices" *)
    task      * : ProcessId;            (* standard dos "task" field.  If this is
                                         * null when the node is accesses, a task
                                         * will be started up *)
    lock      * : FileLockPtr;          (* not used for devices -- leave null *)
    handler   * : BSTR;                 (* filename to loadseg (if seglist is null) *)
    stackSize * : LONGINT;              (* stacksize to use when starting task *)
    priority  * : LONGINT;              (* task priority when starting task *)
    startup   * : FileSysStartupMsgPtr; (* startup msg: FileSysStartupMsg for disks *)
    segList   * : e.BPTR;               (* code to run to start new task (if necessary).
                                         * if null then dn_Handler will be loaded. *)
    globalVec * : e.BPTR;               (* BCPL global vector to use when starting
                                         * a task.  -1 means that dn_SegList is not
                                         * for a bcpl program, so the dos won't
                                         * try and construct one.  0 tell the
                                         * dos that you obey BCPL linkage rules,
                                         * and that it should construct a global
                                         * vector for you.
                                         *)
    name      * : BSTR;                 (* the node name, e.g. '\3','D','F','3' *)
  END;

CONST

(* use of Class and code is discouraged for the time being - we might want to
   change things *)
(* --- NotifyMessage Class ------------------------------------------------ *)
  class  * = 40000000H;

(* --- NotifyMessage Codes ------------------------------------------------ *)
  code   * = 1234H;

TYPE

(* Sent to the application if SEND_MESSAGE is specified.                    *)

  NotifyMessage * = RECORD [NO_DESCRIPTOR]
    message * : e.Message;
    class       * : LONGINT;
    code        * : INTEGER;
    nReq        * : NotifyRequestPtr;      (* don't modify the request! *)
    doNotTouch    : LONGINT;               (* like it says!  For use by handlers *)
    doNotTouch2   : LONGINT;               (* dito *)
  END;

(* Do not modify or reuse the notifyrequest while active.                   *)
(* note: the first LONG of nr_Data has the length transfered                *)

  NotifyRequest * = RECORD [NO_DESCRIPTOR]
    name * : e.LSTRPTR;
    fullName * : e.LSTRPTR;          (* set by dos - don't touch *)
    userData * : e.APTR;             (* for applications use *)
    flags * : y.SET32;

    task * : e.TaskPtr;              (* could also be: port * : e.MsgPortPtr *)
    signalNum * : SHORTINT;
    pad1,pad2,pad3: SHORTINT;

    reserved * : ARRAY 4 OF LONGINT; (* leave 0 for now *)

    (* internal use by handlers *)
    msgCount * : LONGINT;            (* # of outstanding msgs *)
    handler  * : e.MsgPortPtr;       (* handler sent to (for EndNotify) *)
  END;

CONST

(* --- NotifyRequest.flags ------------------------------------------------ *)


  sendMessage     * = 0;
  sendSignal      * = 1;
  waitReply       * = 3;
  notifyInitial   * = 4;

(* do NOT set or remove MAGIC!  Only for use by handlers! *)
  magic           * = 31;

(* Flags reserved for private use by the handler: *)
  handlerFlags    * = {16..31};

TYPE

(**********************************************************************
 *
 * The CSource data structure defines the input source for "ReadItem()"
 * as well as the ReadArgs call.  It is a publicly defined structure
 * which may be used by applications which use code that follows the
 * conventions defined for access.
 *
 * When passed to the dos.library functions, the value passed as
 * struct *CSource is defined as follows:
 *      if ( CSource == 0)      Use buffered IO "ReadChar()" as data source
 *      else                    Use CSource for input character stream
 *
 * The following two pseudo-code routines define how the CSource structure
 * is used:
 *
 * long CS_ReadChar( struct CSource *CSource )
 * {
 *      if ( CSource == 0 )     return ReadChar();
 *      if ( CSource->CurChr >= CSource->Length )       return ENDSTREAMCHAR;
 *      return CSource->Buffer[ CSource->CurChr++ ];
 * }
 *
 * BOOL CS_UnReadChar( struct CSource *CSource )
 * {
 *      if ( CSource == 0 )     return UnReadChar();
 *      if ( CSource->CurChr <= 0 )     return FALSE;
 *      CSource->CurChr--;
 *      return TRUE;
 * }
 *
 * To initialize a struct CSource, you set CSource->CS_Buffer to
 * a string which is used as the data source, and set CS_Length to
 * the number of characters in the string.  Normally CS_CurChr should
 * be initialized to ZERO, or left as it was from prior use as
 * a CSource.
 *
 **********************************************************************)

  CSource * = RECORD [NO_DESCRIPTOR]
    buffer * : e.LSTRPTR;
    length * : LONGINT;
    curChr * : LONGINT;
  END;

(**********************************************************************
 *
 * The RDArgs data structure is the input parameter passed to the DOS
 * ReadArgs() function call.
 *
 * The RDA_Source structure is a CSource as defined above;
 * if RDA_Source.CS_Buffer is non-null, RDA_Source is used as the input
 * character stream to parse, else the input comes from the buffered STDIN
 * calls ReadChar/UnReadChar.
 *
 * RDA_DAList is a private address which is used internally to track
 * allocations which are freed by FreeArgs().  This MUST be initialized
 * to NULL prior to the first call to ReadArgs().
 *
 * The RDA_Buffer and RDA_BufSiz fields allow the application to supply
 * a fixed-size buffer in which to store the parsed data.  This allows
 * the application to pre-allocate a buffer rather than requiring buffer
 * space to be allocated.  If either RDA_Buffer or RDA_BufSiz is NULL,
 * the application has not supplied a buffer.
 *
 * RDA_ExtHelp is a text string which will be displayed instead of the
 * template string, if the user is prompted for input.
 *
 * RDA_Flags bits control how ReadArgs() works.  The flag bits are
 * defined below.  Defaults are initialized to ZERO.
 *
 **********************************************************************)

  RDArgs * = RECORD [NO_DESCRIPTOR]
    source  * : CSource;       (* Select input source *)
    daList  * : LONGINT;       (* PRIVATE. must be initiaized to 0 *)
    buffer  * : e.LSTRPTR;     (* Optional string parsing space. *)
    bufSiz  * : LONGINT;       (* Size of RDA_Buffer (0..n) *)
    extHelp * : e.LSTRPTR;     (* Optional extended help *)
    flags   * : y.SET32;       (* Flags for any required control *)
  END;

CONST

(* RDArgs.flags *)
  stdIn    * = 0;       (* Use "STDIN" rather than "COMMAND LINE" *)
  noAlloc  * = 1;       (* If set, do not allocate extra string space.*)
  noPrompt * = 2;       (* Disable reprompting for string input. *)

(**********************************************************************
 * Maximum number of template keywords which can be in a template passed
 * to ReadArgs(). IMPLEMENTOR NOTE - must be a multiple of 4.
 **********************************************************************)
  maxTemplateItems * = 100;

(**********************************************************************
 * Maximum number of MULTIARG items returned by ReadArgs(), before
 * an ERROR_LINE_TOO_LONG.  These two limitations are due to stack
 * usage.  Applications should allow "a lot" of stack to use ReadArgs().
 **********************************************************************)
  maxMultiArgs * = 128;

TYPE
(*
 * use an extension of this and pass it to ReadArgs()
 * use one entry (see definitions below) for every template keyword
 * according to it's type.
 *
 * NOTE: This has been introduced to improof type safety since somebody
 *       tried to pass a POINTER TO ARRAY OF CHAR, what totaly confused the
 *       garbage collector.
 *)

  ArgsStruct * = RECORD [NO_DESCRIPTOR] END;

  (* these are UNTRACED 'cause allocated by DOS *)
  ArgLong        * = POINTER TO ARRAY 1 OF LONGINT;   (* /N *)
  ArgLongArray   * = POINTER TO ARRAY maxMultiArgs OF ArgLong;   (* /M/N*)
  ArgBool        * = e.LONGBOOL;   (* /S, /T *)
  ArgString      * = e.LSTRPTR;    (* /K, or nothing *)
  ArgStringArray * = POINTER TO ARRAY maxMultiArgs OF ArgString; (* /K/M, /M *)


CONST
(* Modes for LockRecord/LockRecords() *)
  recExclusive       * = 0;
  recExclusiveImmed  * = 1;
  recShared          * = 2;
  recSharedImmed     * = 3;

TYPE

(* struct to be passed to LockRecords()/UnLockRecords() *)

  RecordLock * = RECORD [NO_DESCRIPTOR]
    fh     * : FileHandlePtr; (* filehandle *)
    offset * : LONGINT;       (* offset in file *)
    lenght * : LONGINT;       (* length of file to be locked *)
    mode   * : LONGINT;       (* Type of lock *)
  END;

CONST

(* types for SetVBuf *)
  bufLine     * = 0;      (* flush on \n, etc *)
  bufFull     * = 1;      (* never flush except when needed *)
  bufNone     * = 2;      (* no buffering *)


(* the structure in the pr_LocalVars list *)
(* Do NOT allocate yourself, use SetVar()!!! This structure may grow in *)
(* future releases!  The list should be left in alphabetical order, and *)
(* may have multiple entries with the same name but different types.    *)

TYPE
  LocalVar * = RECORD [NO_DESCRIPTOR]
    node * :  e.Node;
    flags * : y.SET16;
    value * : e.LSTRPTR;
    len   * : LONGINT;
  END;

(*
 * The lv_Flags bits are available to the application.  The unused
 * lv_Node.ln_Pri bits are reserved for system use.
 *)

CONST

(* definitions for LocalVar.node.type: *)
  var        * = 0;       (* an variable *)
  alias      * = 1;       (* an alias    *)
(* to be or'ed into type: *)
  ingnore    * = -80H;    (* ignore this entry on GetVar, etc *)

(* definitions of flags passed to GetVar()/SetVar()/DeleteVar() *)
(* bit defs to be OR'ed with the type: *)
(* item will be treated as a single line of text unless BINARY_VAR is used *)
  globalOnly      * = 8;
  localOnly       * = 9;
  binaryVar       * = 10;             (* treat variable as binary *)
  dontNullTerm    * = 11;      (* only with GVF_BINARY_VAR *)

(* this is only supported in >= V39 dos.  V37 dos ignores this. *)
(* this causes SetVar to affect ENVARC: as well as ENV:.      *)
  saveVar         * = 12;      (* only with GVF_GLOBAL_VAR *)

TYPE
  OwnerInfo * = RECORD [NO_DESCRIPTOR] (* dummy for better access on SetOwner etc.*)
    uid *: INTEGER;
    gid *: INTEGER;
  END;

VAR
  dos* ["_DOSBase"], base* ["_DOSBase"]: DosLibraryPtr;   (* synonyms *)

PROCEDURE Open          *(name		: ARRAY OF CHAR;
                          accessMode	: LONGINT): FileHandlePtr;
PROCEDURE Close         *(file		: FileHandlePtr): BOOLEAN;
PROCEDURE OldClose      *(file		: FileHandlePtr);      (* Version < 36 *)
PROCEDURE Read          *(file		: FileHandlePtr;
                          buffer	: ARRAY OF y.BYTE;
                          length	: LONGINT): LONGINT;
PROCEDURE Write         *(file		: FileHandlePtr;
                          buffer	: ARRAY OF y.BYTE;
                          length	: LONGINT): LONGINT;
PROCEDURE Input         *(): FileHandlePtr;
PROCEDURE Output        *(): FileHandlePtr;
PROCEDURE Seek          *(file		: FileHandlePtr;
                          position	: LONGINT;
                          offset	: LONGINT): LONGINT;
PROCEDURE DeleteFile    *(name		: ARRAY OF CHAR): BOOLEAN;
PROCEDURE Rename        *(oldName	: ARRAY OF CHAR;
                          newName	: ARRAY OF CHAR): BOOLEAN;
PROCEDURE Lock          *(name		: ARRAY OF CHAR;
                          type		: LONGINT): FileLockPtr;
PROCEDURE UnLock        *(lock		: FileLockPtr);
PROCEDURE DupLock       *(lock		: FileLockPtr): FileLockPtr;
PROCEDURE Examine       *(lock		: FileLockPtr;
                          VAR info	: FileInfoBlock): BOOLEAN;
PROCEDURE ExNext        *(lock		: FileLockPtr;
                          VAR info	: FileInfoBlock): BOOLEAN;
PROCEDURE Info          *(lock		: FileLockPtr;
                          VAR info	: InfoData): BOOLEAN;
PROCEDURE CreateDir     *(name		: ARRAY OF CHAR): FileLockPtr;
PROCEDURE CurrentDir    *(lock		: FileLockPtr): FileLockPtr;
PROCEDURE IoErr         *(): LONGINT;
PROCEDURE CreateProc    *(name		: ARRAY OF CHAR;
                          pri		: LONGINT;
                          segList	: e.BPTR;
                          stackSize	: LONGINT): ProcessId;
PROCEDURE Exit          *(returnCode	: LONGINT);
PROCEDURE LoadSeg       *(name		: ARRAY OF CHAR): e.BPTR;
PROCEDURE UnLoadSeg     *(segList	: e.BPTR);
PROCEDURE DeviceProc    *(name		: ARRAY OF CHAR): ProcessId;
PROCEDURE SetComment    *(name		: ARRAY OF CHAR;
                          comment	: ARRAY OF CHAR): BOOLEAN;
PROCEDURE SetProtection *(name		: ARRAY OF CHAR;
                          protect	: y.SET32): BOOLEAN;
PROCEDURE DateStamp     *(VAR date	: Date);
PROCEDURE Delay         *(timeout	: LONGINT);
PROCEDURE WaitForChar   *(file		: FileHandlePtr;
                          timeout	: LONGINT): BOOLEAN;
PROCEDURE ParentDir     *(lock		: FileLockPtr): FileLockPtr;
PROCEDURE IsInteractive *(file		: FileHandlePtr): BOOLEAN;
PROCEDURE Execute       *(string	: ARRAY OF CHAR;
                          file		: FileHandlePtr;
                          file2		: FileHandlePtr): BOOLEAN;

(* ---   functions in V36 or higher (Release 2.0)    --- *)

(*      DOS Object creation/deletion *)
PROCEDURE AllocDosObject     *(type	: LONGINT;
                               tags	: ARRAY OF u.TagItem): e.APTR;
(*
PROCEDURE (*["AllocDosObject"]*) AllocDosObjectTags
			     *(type	: LONGINT;
                               ...): e.APTR;
*)
PROCEDURE FreeDosObject	     *(type	: LONGINT;
                               ptr	: e.APTR);
(*      Packet Level routines *)
PROCEDURE DoPkt0        *(port		: ProcessId;
                          action	: LONGINT): LONGINT;
PROCEDURE DoPkt1        *(port		: ProcessId;
                          action	: LONGINT;
                          arg1		: LONGINT): LONGINT;
PROCEDURE DoPkt2        *(port		: ProcessId;
                          action	: LONGINT;
                          arg1		: LONGINT;
                          arg2		: LONGINT): LONGINT;
PROCEDURE DoPkt3        *(port		: ProcessId;
                          action	: LONGINT;
                          arg1		: LONGINT;
                          arg2		: LONGINT;
                          arg3		: LONGINT): LONGINT;
PROCEDURE DoPkt4        *(port		: ProcessId;
                          action	: LONGINT;
                          arg1		: LONGINT;
                          arg2		: LONGINT;
                          arg3		: LONGINT;
                          arg4		: LONGINT): LONGINT;
PROCEDURE DoPkt         *(port		: ProcessId;
                          action	: LONGINT;
                          arg1		: LONGINT;
                          arg2		: LONGINT;
                          arg3		: LONGINT;
                          arg4		: LONGINT;
                          arg5		: LONGINT): LONGINT;
PROCEDURE SendPkt       *(VAR dp	: DosPacket;
                          port		: ProcessId;
                          replyport	: e.MsgPortPtr);
PROCEDURE WaitPkt       *(): DosPacketPtr;
PROCEDURE ReplyPkt      *(dp		: DosPacketPtr;
                          res1		: LONGINT;
                          res2		: LONGINT);
PROCEDURE AbortPkt      *(port		: ProcessId;
                          pkt		: DosPacketPtr);
(*      Record Locking *)
PROCEDURE LockRecord    *(fh		: FileHandlePtr;
                          offset	: LONGINT;
                          length	: LONGINT;
                          mode		: LONGINT;
                          timeout	: LONGINT): BOOLEAN;
PROCEDURE LockRecords   *(recArray	: RecordLockPtr;
                          timeout	: LONGINT): BOOLEAN;
PROCEDURE UnLockRecord  *(fh		: FileHandlePtr;
                          offset	: LONGINT;
                          length	: LONGINT): BOOLEAN;
PROCEDURE UnLockRecords *(recArray	: RecordLockPtr): BOOLEAN;
(*      Buffered File I/O *)
PROCEDURE SelectInput   *(fh		: FileHandlePtr): FileHandlePtr;
PROCEDURE SelectOutput  *(fh		: FileHandlePtr): FileHandlePtr;
PROCEDURE FGetC         *(fh		: FileHandlePtr): LONGINT;
PROCEDURE FPutC         *(fh		: FileHandlePtr;
                          ch		: LONGINT): LONGINT;
PROCEDURE UnGetC        *(fh		: FileHandlePtr;
                          character	: LONGINT): LONGINT;
PROCEDURE FRead         *(fh		: FileHandlePtr;
                          block		: ARRAY OF y.BYTE;
                          blocklen	: LONGINT;
                          number	: LONGINT): LONGINT;
PROCEDURE FWrite        *(fh		: FileHandlePtr;
                          block		: ARRAY OF y.BYTE;
                          blocklen	: LONGINT;
                          number	: LONGINT): LONGINT;
PROCEDURE FGets         *(fh		: FileHandlePtr;
                          VAR buf	: ARRAY OF CHAR;
                          buflen	: LONGINT): e.APTR;
(* NOTE: result of FPuts has inverted logic: TRUE means failture *)
PROCEDURE FPuts         *(fh		: FileHandlePtr;
                          str		: ARRAY OF CHAR): BOOLEAN; (* inverted logic!! *)
PROCEDURE VFWritef      *(fh		: FileHandlePtr;
                          format	: ARRAY OF CHAR;
                          argarray	: ARRAY OF y.BYTE): LONGINT;
(*
PROCEDURE FWritef       *(fh		: FileHandlePtr;
                          format	: ARRAY OF CHAR;
                          ...): LONGINT;
*)
PROCEDURE VFPrintf      *(fh		: FileHandlePtr;
                          format	: ARRAY OF CHAR;
                          argarray	: ARRAY OF e.APTR): LONGINT;
(*
PROCEDURE (*["VFPrintf"]*) FPrintf
		       *(fh		: FileHandlePtr;
                         format		: ARRAY OF CHAR;
                         ...): LONGINT;
*)
PROCEDURE Flush         *(fh		: FileHandlePtr): BOOLEAN;
PROCEDURE SetVBuf       *(fh		: FileHandlePtr;
                          VAR buff	: ARRAY OF CHAR;
                          type		: LONGINT;
                          size		: LONGINT): LONGINT;
(*      DOS Object Management *)
PROCEDURE DupLockFromFH *(fh		: FileHandlePtr): FileLockPtr;
PROCEDURE OpenFromLock  *(lock		: FileLockPtr): FileHandlePtr;
PROCEDURE ParentOfFH    *(fh		: FileHandlePtr): FileLockPtr;
PROCEDURE ExamineFH     *(fh		: FileHandlePtr;
                          VAR fib	: FileInfoBlock): BOOLEAN;
PROCEDURE SetFileDate   *(name		: ARRAY OF CHAR;
                          date		: Date): BOOLEAN;
PROCEDURE NameFromLock  *(lock		: FileLockPtr;
                          VAR buffer	: ARRAY OF CHAR;
                          len		: LONGINT): BOOLEAN;
PROCEDURE NameFromFH    *(fh		: FileHandlePtr;
                          VAR buffer	: ARRAY OF CHAR;
                          len		: LONGINT): BOOLEAN;
PROCEDURE SplitName     *(name		: ARRAY OF CHAR;
                          seperator	: CHAR;
                          buf		: ARRAY OF CHAR;
                          oldpos	: LONGINT;
                          size		: LONGINT): INTEGER;
PROCEDURE SameLock      *(lock1		: FileLockPtr;
                          lock2		: FileLockPtr): INTEGER;
PROCEDURE SetMode       *(fh		: FileHandlePtr;
                          mode		: LONGINT): BOOLEAN;
PROCEDURE ExAll         *(lock		: FileLockPtr;
                          buffer	: ARRAY OF y.BYTE;
                          size		: LONGINT;
                          data		: LONGINT;
                          ctrl		: ExAllControlPtr): BOOLEAN;
PROCEDURE ReadLink      *(port		: ProcessId;
                          lock		: FileLockPtr;
                          path		: ARRAY OF CHAR;
                          buffer	: ARRAY OF CHAR;
                          size		: LONGINT): LONGINT;
PROCEDURE MakeLink      *(name		: ARRAY OF CHAR;
                          dest		: LONGINT;
                          soft		: LONGINT): LONGINT;
PROCEDURE ChangeMode    *(type		: LONGINT; (* must be changeFH *)
                          fh		: FileHandlePtr;
                          newmode	: LONGINT): BOOLEAN;
PROCEDURE (*["ChangeMode"]*) ChangeModeLock
			*(type		: LONGINT; (* must be changeLock *)
                          lock		: FileLockPtr;
                          newmode	: LONGINT): BOOLEAN;
PROCEDURE SetFileSize   *(fh		: FileHandlePtr;
                          pos		: LONGINT;
                          mode		: LONGINT): LONGINT;
(*      Error Handling *)
PROCEDURE SetIoErr      *(result	: LONGINT): LONGINT;
PROCEDURE Fault         *(code		: LONGINT;
                          header	: ARRAY OF CHAR;
                          VAR buffer	: ARRAY OF CHAR;
                          len		: LONGINT): LONGINT;
PROCEDURE PrintFault    *(code		: LONGINT;
                          header	: ARRAY OF CHAR): BOOLEAN;
PROCEDURE ErrorReport   *(code		: LONGINT;
                          type		: LONGINT;   (* should be reportVolume *)
                          arg1		: e.APTR;
                          device	: ProcessId): LONGINT;
(*----
PROCEDURE ["ErrorReport"] ErrorReportDevice*(code		: LONGINT;
                          type		: LONGINT;   (* should be reportVolume *)
                          arg1		: DeviceListAPtr;
                          device	: ProcessId): LONGINT;
PROCEDURE ["ErrorReport"] ErrorReportLock*(code		: LONGINT;
                           type		: LONGINT;   (* should be reportLock *)
                           arg1		: FileLockPtr;
                           device	: ProcessId): LONGINT;
PROCEDURE ["ErrorReport"] ErrorReportFH *(code		: LONGINT;
                          type		: LONGINT;   (* should be reportStream *)
                          arg1		: FileHandlePtr;
                          device	: ProcessId): LONGINT;
----*)
PROCEDURE Requester     *(s1		: ARRAY OF CHAR;
                          s2		: ARRAY OF CHAR;
                          s3		: ARRAY OF CHAR;
                          flags		: y.SET32): LONGINT;
(*      Process Management *)
PROCEDURE Cli           	*(): CommandLineInterfaceAPtr;
PROCEDURE CreateNewProc 	*(tags		: ARRAY OF u.TagItem): ProcessPtr;
(*PROCEDURE CreateNewProcTags	*(...): ProcessPtr;*)
PROCEDURE RunCommand    	*(seg		: e.BPTR;
                                  stack		: LONGINT;
                                  paramptr	: ARRAY OF CHAR;
                                  paramlen	: LONGINT): LONGINT;
PROCEDURE GetConsoleTask*(): ProcessId;
PROCEDURE SetConsoleTask*(task		: ProcessId): ProcessId;
PROCEDURE GetFileSysTask*(): ProcessId;
PROCEDURE SetFileSysTask*(task		: ProcessId): ProcessId;
PROCEDURE GetArgStr     *(): e.LSTRPTR;
PROCEDURE SetArgStr     *(string	: ARRAY OF CHAR): e.LSTRPTR;
PROCEDURE FindCliProc   *(num		: LONGINT): ProcessPtr;
PROCEDURE MaxCli        *(): LONGINT;
PROCEDURE SetCurrentDirName*(name	: ARRAY OF CHAR): BOOLEAN;
PROCEDURE GetCurrentDirName*(VAR buf	: ARRAY OF CHAR;
                             len	: LONGINT): BOOLEAN;
PROCEDURE SetProgramName*(name		: ARRAY OF CHAR): BOOLEAN;
PROCEDURE GetProgramName*(VAR buf	: ARRAY OF CHAR;
                          len		: LONGINT): BOOLEAN;
PROCEDURE SetPrompt     *(name		: ARRAY OF CHAR): BOOLEAN;
PROCEDURE GetPrompt     *(VAR buf	: ARRAY OF CHAR;
                          len		: LONGINT): BOOLEAN;
PROCEDURE SetProgramDir *(lock		: FileLockPtr): FileLockPtr;
PROCEDURE GetProgramDir *(): FileLockPtr;
(*      Device List Management *)
PROCEDURE System        *(command	: ARRAY OF CHAR;
                          tags		: ARRAY OF u.TagItem): LONGINT;
(*
PROCEDURE (*["System"]*) SystemTags
			*(command	: ARRAY OF CHAR;
                          ...): LONGINT;
*)
PROCEDURE AssignLock    *(name		: ARRAY OF CHAR;
                          lock		: FileLockPtr): BOOLEAN;
PROCEDURE AssignLate    *(name		: ARRAY OF CHAR;
                          path		: ARRAY OF CHAR): BOOLEAN;
PROCEDURE AssignPath    *(name		: ARRAY OF CHAR;
                          path		: ARRAY OF CHAR): BOOLEAN;
PROCEDURE AssignAdd     *(name		: ARRAY OF CHAR;
                          lock		: FileLockPtr): BOOLEAN;
PROCEDURE RemAssignList *(name		: ARRAY OF CHAR;
                          lock		: FileLockPtr): LONGINT;
PROCEDURE GetDeviceProc *(name		: ARRAY OF CHAR;
                          dp		: DevProcPtr): DevProcPtr;
PROCEDURE FreeDeviceProc*(dp		: DevProcPtr);
PROCEDURE LockDosList   *(flags		: y.SET32): DosListNodePtr;
PROCEDURE UnLockDosList *(flags		: y.SET32);
PROCEDURE AttemptLockDosList*(flags	: y.SET32): DosListNodePtr;
PROCEDURE RemDosEntry   *(dlist		: DosListNodePtr): BOOLEAN;
PROCEDURE AddDosEntry   *(dlist		: DosListNodePtr): DosListNodePtr;
PROCEDURE FindDosEntry  *(dlist		: DosListNodePtr;
                          name		: ARRAY OF CHAR;
                          flags		: y.SET32): DosListNodePtr;
PROCEDURE NextDosEntry  *(dlist		: DosListNodePtr;
                          flags		: y.SET32): DosListNodePtr;
PROCEDURE MakeDosEntry  *(name		: ARRAY OF CHAR;
                          type		: LONGINT): DosListNodePtr;
PROCEDURE FreeDosEntry  *(dlist		: DosListNodePtr);
PROCEDURE IsFileSystem  *(name		: ARRAY OF CHAR): BOOLEAN;
(*      Handler Interface *)
PROCEDURE Format        *(filesystem	: ARRAY OF CHAR;
                          volumename	: ARRAY OF CHAR;
                          dostype	: LONGINT): BOOLEAN;
PROCEDURE Relabel       *(drive		: ARRAY OF CHAR;
                          newname	: ARRAY OF CHAR): BOOLEAN;
PROCEDURE Inhibit       *(name		: ARRAY OF CHAR;
                          onoff		: LONGINT): BOOLEAN;
PROCEDURE AddBuffers    *(name		: ARRAY OF CHAR;
                          number	: LONGINT): LONGINT;
(*      Date, Time Routines *)
PROCEDURE CompareDates  *(date1		: Date;
                          date2		: Date): LONGINT;
PROCEDURE DateToStr     *(VAR dt	: DateTime): BOOLEAN;
PROCEDURE StrToDate     *(VAR dt	: DateTime): BOOLEAN;
(*      Image Management *)
PROCEDURE InternalLoadSeg*(fh		: FileHandlePtr;
                           table	: e.BPTR;
                           funcarray	: e.APTR;
                           VAR stack	: LONGINT): e.BPTR;
PROCEDURE InternalUnLoadSeg*(seglist	: e.BPTR;
                             freefunc	: e.PROC): BOOLEAN;
PROCEDURE NewLoadSeg    *(file		: ARRAY OF CHAR;
                          tags		: ARRAY OF u.TagItem): e.BPTR;
(*
PROCEDURE (*["NewLoadSeg"]*) NewLoadSegTags
			*(file		: ARRAY OF CHAR;
                          ...): e.BPTR;
*)
PROCEDURE AddSegment    *(name		: ARRAY OF CHAR;
                          seg		: e.BPTR;
                          system	: LONGINT): BOOLEAN;
PROCEDURE FindSegment   *(name		: ARRAY OF CHAR;
                          seg		: SegmentPtr;
                          system	: LONGINT): SegmentPtr;
PROCEDURE RemSegment    *(seg		: SegmentPtr): BOOLEAN;
(*      Command Support *)
PROCEDURE CheckSignal   *(mask		: y.SET32): y.SET32;
(*----
PROCEDURE ["ReadArgs"] OldReadArgs
			*(template	: ARRAY OF CHAR;
                          VAR array	: ARRAY OF y.BYTE;
                          args		: RDArgsPtr): RDArgsPtr;
----*)
PROCEDURE ReadArgs      *(template	: ARRAY OF CHAR;
                          VAR array	: ArgsStruct;
                          args		: RDArgsPtr): RDArgsPtr;
PROCEDURE FindArg       *(template	: ARRAY OF CHAR;
                          keyword	: ARRAY OF CHAR): LONGINT;
PROCEDURE ReadItem      *(VAR name	: ARRAY OF CHAR;
                          maxchars	: LONGINT;
                          cSrc		: CSourcePtr): LONGINT;
PROCEDURE StrToLong     *(string	: ARRAY OF CHAR;
                          VAR value	: LONGINT): LONGINT;
PROCEDURE MatchFirst    *(pat		: ARRAY OF CHAR;
                          VAR anchor	: AnchorPath): LONGINT;
PROCEDURE MatchNext     *(VAR anchor	: AnchorPath): LONGINT;
PROCEDURE MatchEnd      *(VAR anchor	: AnchorPath);
PROCEDURE ParsePattern  *(pat		: ARRAY OF CHAR;
                          VAR buf	: ARRAY OF CHAR;
                          buflen	: LONGINT): INTEGER;
PROCEDURE MatchPattern  *(pat		: ARRAY OF CHAR;
                          str		: ARRAY OF CHAR): BOOLEAN;
PROCEDURE FreeArgs      *(args		: RDArgsPtr);
PROCEDURE FilePart      *(path		: ARRAY OF CHAR): e.LSTRPTR;
PROCEDURE PathPart      *(path		: ARRAY OF CHAR): e.APTR;
PROCEDURE AddPart       *(VAR dir	: ARRAY OF CHAR;
                          filename	: ARRAY OF CHAR;
                          size		: LONGINT): BOOLEAN;
(*      Notification *)
PROCEDURE StartNotify   *(VAR notify	: NotifyRequest): BOOLEAN;
PROCEDURE EndNotify     *(VAR nofify	: NotifyRequest);
(*      Environment Variable functions *)
PROCEDURE SetVar        *(name		: ARRAY OF CHAR;
                          buffer	: ARRAY OF CHAR;
                          size		: LONGINT;
                          flags		: y.SET32): BOOLEAN;
PROCEDURE GetVar        *(name		: ARRAY OF CHAR;
                          VAR buffer	: ARRAY OF CHAR;
                          size		: LONGINT;
                          flags		: y.SET32): LONGINT;
PROCEDURE DeleteVar     *(name		: ARRAY OF CHAR;
                          flags		: y.SET32): BOOLEAN;
PROCEDURE FindVar       *(name		: ARRAY OF CHAR;
                          type		: y.SET32): LocalVarPtr;
PROCEDURE CliInit       *(VAR dp	: DosPacket): LONGINT;
PROCEDURE CliInitNewcli *(VAR dp	: DosPacket): LONGINT;
PROCEDURE CliInitRun    *(VAR dp	: DosPacket): LONGINT;
PROCEDURE WriteChars    *(buf		: ARRAY OF CHAR;
                          buflen	: LONGINT): LONGINT;
PROCEDURE PutStr        *(str		: ARRAY OF CHAR): LONGINT;
PROCEDURE VPrintf       *(format	: ARRAY OF CHAR;
                          ...): LONGINT;
PROCEDURE (*["VPrintf"]*) Printf
		    	*(format	: ARRAY OF CHAR;
                          ...); (* result is ignored *)
(*PROCEDURE ["VPrintf"] PrintF
		    	*(format	: ARRAY OF CHAR;
			  ...): LONGINT;*)
(* these were unimplemented until dos 36.147 *)
PROCEDURE ParsePatternNoCase*(pat	: ARRAY OF CHAR;
                              VAR buf	: ARRAY OF CHAR;
                              len	: LONGINT): INTEGER;
PROCEDURE MatchPatternNoCase*(pat	: ARRAY OF CHAR;
                              str	: ARRAY OF CHAR): BOOLEAN;
(* this was added for V37 dos, returned 0 before then. *)
PROCEDURE SameDevice    *(lock1		: FileLockPtr;
                          lock2		: FileLockPtr): BOOLEAN;

(* NOTE: the following entries did NOT exist before ks 36.303 (2.02) *)
(* If you are going to use them, open dos.library with version 37 *)

(* These calls were added for V39 dos: *)
PROCEDURE ExAllEnd      *(lock		: FileLockPtr;
                          buffer	: ARRAY OF y.BYTE;
                          size		: LONGINT;
                          data		: LONGINT;
                          ctrl		: ExAllControlPtr);
PROCEDURE SetOwner      *(name		: ARRAY OF CHAR;
                          ownerInfo	: OwnerInfo): BOOLEAN;




(*----------

(* $OvflChk- $RangeChk- $StackChk- $NilChk- $ReturnChk- $CaseChk- *)

PROCEDURE ReadChar*(): CHAR;
VAR c: LONGINT;
BEGIN
  c := FGetC(Input()); IF (c<0) OR (c>255) THEN c := 0 END; RETURN CHR(c);
END ReadChar;


PROCEDURE WriteChar*(c{2}: CHAR): LONGINT;
BEGIN RETURN FPutC(Output(),ORD(c)) END WriteChar;


PROCEDURE UnReadChar*(c{2}: CHAR): LONGINT;
BEGIN RETURN UnGetC(Input(),ORD(c)); END UnReadChar;

(* next one is inefficient *)

PROCEDURE ReadChars*(VAR buf: ARRAY OF y.BYTE; num: LONGINT): LONGINT;
BEGIN RETURN FRead(Input(),buf,1,num); END ReadChars;

PROCEDURE ReadLn*(VAR buf: ARRAY OF CHAR; len: LONGINT): e.APTR;
BEGIN RETURN FGets(Input(),buf,len); END ReadLn;

PROCEDURE WriteStr*(s: ARRAY OF CHAR): BOOLEAN; (* $CopyArrays- *)
BEGIN RETURN FPuts(Output(),s); END WriteStr;

PROCEDURE VWritef*(format: ARRAY OF CHAR; argv: ARRAY OF y.BYTE): LONGINT;
(* $CopyArrays- *)
BEGIN RETURN VFWritef(Output(),format,argv); END VWritef;

(*
 * The following procedures are implemented for to avoid using SYSTEM within
 * Oberon programs.
 *)

(*
 * Use this to convert a ProcessId (eg. WBStartup.process) to a ProcessPtr.
 *)
PROCEDURE ProcessIdToProcess*(id{8}: ProcessId): ProcessPtr;
BEGIN RETURN y.VAL(ProcessPtr,y.VAL(LONGINT,id)-SIZE(e.Task)); END ProcessIdToProcess;

(*
 * Use this to get a Process' ProcessId, ie. a pointer to its MsgPort.
 *)
PROCEDURE ProcessToProcessId*(proc{8}: ProcessPtr): ProcessId;
BEGIN RETURN y.ADR(proc.msgPort); END ProcessToProcessId;

BEGIN
  dos :=  e.OpenLibrary(dosName,33);
  IF dos = NIL THEN HALT(fail) END;
  base := dos;

CLOSE
  IF dos#NIL THEN e.CloseLibrary(dos) END;

----*)

END Dos.

