/* 
 * File:   CMUI_Boopsi.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 30 listopada 2015, 18:45
 */

#include "CMUI_Boopsi.h"

CMUI_Boopsi::CMUI_Boopsi()
: CMUI_Gadget() {
}

CMUI_Boopsi::CMUI_Boopsi(TagItem* tags)
: CMUI_Gadget() {
    object = MUI_NewObjectA(MUIC_Boopsi, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Boopsi object\n");
#endif
}

CMUI_Boopsi::CMUI_Boopsi(Tag tag1, ...)
: CMUI_Gadget() {
    object = MUI_NewObjectA(MUIC_Boopsi, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Boopsi object\n");
#endif
}

CMUI_Boopsi::CMUI_Boopsi(Object* obj)
: CMUI_Gadget() {
    object = obj;
}

CMUI_Boopsi& CMUI_Boopsi::operator=(Object* obj) {
    object = obj;
    return *this;
}

struct IClass * CMUI_Boopsi::Class(void) const {
    return (struct IClass *) MGetAttr(MUIA_Boopsi_Class);
}

void CMUI_Boopsi::SetClass(struct IClass * value) {
    SetAttr(MUIA_Boopsi_Class, (IPTR) value);
}

char * CMUI_Boopsi::ClassID(void) const {
    return (char *) MGetAttr(MUIA_Boopsi_ClassID);
}

void CMUI_Boopsi::SetClassID(char * value) {
    SetAttr(MUIA_Boopsi_ClassID, (IPTR) value);
}

IPTR CMUI_Boopsi::MaxHeight(void) const {
    return (IPTR) MGetAttr(MUIA_Boopsi_MaxHeight);
}

void CMUI_Boopsi::SetMaxHeight(IPTR value) {
    SetAttr(MUIA_Boopsi_MaxHeight, (IPTR) value);
}

IPTR CMUI_Boopsi::MaxWidth(void) const {
    return (IPTR) MGetAttr(MUIA_Boopsi_MaxWidth);
}

void CMUI_Boopsi::SetMaxWidth(IPTR value) {
    SetAttr(MUIA_Boopsi_MaxWidth, (IPTR) value);
}

IPTR CMUI_Boopsi::MinHeight(void) const {
    return (IPTR) MGetAttr(MUIA_Boopsi_MinHeight);
}

void CMUI_Boopsi::SetMinHeight(IPTR value) {
    SetAttr(MUIA_Boopsi_MinHeight, (IPTR) value);
}

IPTR CMUI_Boopsi::MinWidth(void) const {
    return (IPTR) MGetAttr(MUIA_Boopsi_MinWidth);
}

void CMUI_Boopsi::SetMinWidth(IPTR value) {
    SetAttr(MUIA_Boopsi_MinWidth, (IPTR) value);
}

Object * CMUI_Boopsi::MBoopsiObject(void) const {
    return (Object *) MGetAttr(MUIA_Boopsi_Object);
}

IPTR CMUI_Boopsi::TagDrawInfo(void) const {
    return (IPTR) MGetAttr(MUIA_Boopsi_TagDrawInfo);
}

void CMUI_Boopsi::SetTagDrawInfo(IPTR value) {
    SetAttr(MUIA_Boopsi_TagDrawInfo, (IPTR) value);
}

IPTR CMUI_Boopsi::TagScreen(void) const {
    return (IPTR) MGetAttr(MUIA_Boopsi_TagScreen);
}

void CMUI_Boopsi::SetTagScreen(IPTR value) {
    SetAttr(MUIA_Boopsi_TagScreen, (IPTR) value);
}

IPTR CMUI_Boopsi::TagWindow(void) const {
    return (IPTR) MGetAttr(MUIA_Boopsi_TagWindow);
}

void CMUI_Boopsi::SetTagWindow(IPTR value) {
    SetAttr(MUIA_Boopsi_TagWindow, (IPTR) value);
}
