/* 
 * File:   CMUI_Coloradjust.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 3 grudnia 2015, 22:08
 */

#include "CMUI_Coloradjust.h"

CMUI_Coloradjust::CMUI_Coloradjust()
: CMUI_Group() {
}

CMUI_Coloradjust::CMUI_Coloradjust(TagItem* tags)
: CMUI_Group() {
    object = MUI_NewObjectA(MUIC_Coloradjust, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Coloradjust object\n");
#endif
}

CMUI_Coloradjust::CMUI_Coloradjust(Tag tag1, ...)
: CMUI_Group() {
    object = MUI_NewObjectA(MUIC_Coloradjust, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Coloradjust object\n");
#endif
}

CMUI_Coloradjust& CMUI_Coloradjust::operator=(Object* obj) {
    object = obj;
    return *this;
}

CMUI_Coloradjust::CMUI_Coloradjust(Object* obj)
: CMUI_Group() {
    object = obj;
}

IPTR CMUI_Coloradjust::Blue(void) const {
    return (IPTR) MGetAttr(MUIA_Coloradjust_Blue);
}

void CMUI_Coloradjust::SetBlue(IPTR value) {
    SetAttr(MUIA_Coloradjust_Blue, (IPTR) value);
}

IPTR CMUI_Coloradjust::Green(void) const {
    return (IPTR) MGetAttr(MUIA_Coloradjust_Green);
}

void CMUI_Coloradjust::SetGreen(IPTR value) {
    SetAttr(MUIA_Coloradjust_Green, (IPTR) value);
}

IPTR CMUI_Coloradjust::ModeID(void) const {
    return (IPTR) MGetAttr(MUIA_Coloradjust_ModeID);
}

void CMUI_Coloradjust::SetModeID(IPTR value) {
    SetAttr(MUIA_Coloradjust_ModeID, (IPTR) value);
}

IPTR CMUI_Coloradjust::Red(void) const {
    return (IPTR) MGetAttr(MUIA_Coloradjust_Red);
}

void CMUI_Coloradjust::SetRed(IPTR value) {
    SetAttr(MUIA_Coloradjust_Red, (IPTR) value);
}

IPTR * CMUI_Coloradjust::RGB(void) const {
    return (IPTR *) MGetAttr(MUIA_Coloradjust_RGB);
}

void CMUI_Coloradjust::SetRGB(IPTR * value) {
    SetAttr(MUIA_Coloradjust_RGB, (IPTR) value);
}
