/* 
 * File:   CMUI_Colorfield.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 30 listopada 2015, 21:08
 */

#include "CMUI_Colorfield.h"

CMUI_Colorfield::CMUI_Colorfield()
: CMUI_Area() {
}

CMUI_Colorfield::CMUI_Colorfield(TagItem* tags)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_Colorfield, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Colorfield object\n");
#endif
}

CMUI_Colorfield::CMUI_Colorfield(Tag tag1, ...)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_Colorfield, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Colorfield object\n");
#endif
}

CMUI_Colorfield::CMUI_Colorfield(Object* obj)
: CMUI_Area() {
    object = obj;
}

CMUI_Colorfield& CMUI_Colorfield::operator=(Object* obj) {
    object = obj;
    return *this;
}

IPTR CMUI_Colorfield::Blue (void) const
{
	 return (IPTR)MGetAttr (MUIA_Colorfield_Blue);
}

 void CMUI_Colorfield::SetBlue (IPTR value)
{
	 SetAttr (MUIA_Colorfield_Blue, (IPTR)value);
}

 IPTR CMUI_Colorfield::Green (void) const
{
	 return (IPTR)MGetAttr (MUIA_Colorfield_Green);
}

 void CMUI_Colorfield::SetGreen (IPTR value)
{
	 SetAttr (MUIA_Colorfield_Green, (IPTR)value);
}

 IPTR CMUI_Colorfield::Pen (void) const
{
	 return (IPTR)MGetAttr (MUIA_Colorfield_Pen);
}

 IPTR CMUI_Colorfield::Red (void) const
{
	 return (IPTR)MGetAttr (MUIA_Colorfield_Red);
}

 void CMUI_Colorfield::SetRed (IPTR value)
{
	 SetAttr (MUIA_Colorfield_Red, (IPTR)value);
}

 IPTR * CMUI_Colorfield::RGB (void) const
{
	 return (IPTR *)MGetAttr (MUIA_Colorfield_RGB);
}

 void CMUI_Colorfield::SetRGB (IPTR * value)
{
	 SetAttr (MUIA_Colorfield_RGB, (IPTR)value);
}
