/* 
 * File:   CMUI_Dirlist.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 30 listopada 2015, 21:31
 */

#include "CMUI_Dirlist.h"

CMUI_Dirlist::CMUI_Dirlist()
: CMUI_List() {
}

CMUI_Dirlist::CMUI_Dirlist(TagItem* tags)
: CMUI_List() {
    object = MUI_NewObjectA(MUIC_Dirlist, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Dirlist object\n");
#endif
}

CMUI_Dirlist::CMUI_Dirlist(Tag tag1, ...)
: CMUI_List() {
    object = MUI_NewObjectA(MUIC_Dirlist, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Dirlist object\n");
#endif
}

CMUI_Dirlist::CMUI_Dirlist(Object* obj)
: CMUI_List() {
    object = obj;
}

CMUI_Dirlist& CMUI_Dirlist::operator=(Object* obj) {
    object = obj;
    return *this;
}

 void CMUI_Dirlist::SetAcceptPattern (STRPTR value)
{
	 SetAttr (MUIA_Dirlist_AcceptPattern, (IPTR)value);
}

 STRPTR CMUI_Dirlist::Directory (void) const
{
	 return (STRPTR)MGetAttr (MUIA_Dirlist_Directory);
}

 void CMUI_Dirlist::SetDirectory (STRPTR value)
{
	 SetAttr (MUIA_Dirlist_Directory, (IPTR)value);
}

 void CMUI_Dirlist::SetDrawersOnly (BOOL value)
{
	 SetAttr (MUIA_Dirlist_DrawersOnly, (IPTR)value);
}

 void CMUI_Dirlist::SetFilesOnly (BOOL value)
{
	 SetAttr (MUIA_Dirlist_FilesOnly, (IPTR)value);
}

 void CMUI_Dirlist::SetFilterDrawers (BOOL value)
{
	 SetAttr (MUIA_Dirlist_FilterDrawers, (IPTR)value);
}

 void CMUI_Dirlist::SetFilterHook (struct Hook * value)
{
	 SetAttr (MUIA_Dirlist_FilterHook, (IPTR)value);
}

 void CMUI_Dirlist::SetMultiSelDirs (BOOL value)
{
	 SetAttr (MUIA_Dirlist_MultiSelDirs, (IPTR)value);
}

 LONG CMUI_Dirlist::NumBytes (void) const
{
	 return (LONG)MGetAttr (MUIA_Dirlist_NumBytes);
}

 LONG CMUI_Dirlist::NumDrawers (void) const
{
	 return (LONG)MGetAttr (MUIA_Dirlist_NumDrawers);
}

 LONG CMUI_Dirlist::NumFiles (void) const
{
	 return (LONG)MGetAttr (MUIA_Dirlist_NumFiles);
}

 STRPTR CMUI_Dirlist::Path (void) const
{
	 return (STRPTR)MGetAttr (MUIA_Dirlist_Path);
}

 void CMUI_Dirlist::SetRejectIcons (BOOL value)
{
	 SetAttr (MUIA_Dirlist_RejectIcons, (IPTR)value);
}

 void CMUI_Dirlist::SetRejectPattern (STRPTR value)
{
	 SetAttr (MUIA_Dirlist_RejectPattern, (IPTR)value);
}

 void CMUI_Dirlist::SetSortDirs (LONG value)
{
	 SetAttr (MUIA_Dirlist_SortDirs, (IPTR)value);
}

 void CMUI_Dirlist::SetSortHighLow (BOOL value)
{
	 SetAttr (MUIA_Dirlist_SortHighLow, (IPTR)value);
}

 void CMUI_Dirlist::SetSortType (LONG value)
{
	 SetAttr (MUIA_Dirlist_SortType, (IPTR)value);
}

 LONG CMUI_Dirlist::Status (void) const
{
	 return (LONG)MGetAttr (MUIA_Dirlist_Status);
}

 IPTR CMUI_Dirlist::ReRead (void)
{
	return MDoMethod (MUIM_Dirlist_ReRead);
}
