/* 
 * File:   CMUI_Group.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 2 grudnia 2015, 22:10
 */

#include "CMUI_Group.h"

CMUI_Group::CMUI_Group()
: CMUI_Area() {
}

CMUI_Group::CMUI_Group(TagItem* tags)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_Group, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Group object\n");
#endif
}

CMUI_Group::CMUI_Group(Tag tag1, ...)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_Group, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Group object\n");
#endif
}

/* Adds a new object object to the group */

CMUI_Group::CMUI_Group(Object* obj)
: CMUI_Area() {
    object = obj;
}

CMUI_Group& CMUI_Group::operator=(Object* obj) {
    object = obj;
    return *this;
}

/* Removes an object from the group */

void CMUI_Group::RemObject(Object* obj) {
    MDoMethod(OM_REMMEMBER, obj);
}

LONG CMUI_Group::ActivePage(void) const {
    return (LONG) MGetAttr(MUIA_Group_ActivePage);
}

void CMUI_Group::SetActivePage(LONG value) {
    SetAttr(MUIA_Group_ActivePage, (IPTR) value);
}

struct List * CMUI_Group::ChildList(void) const {
    return (struct List *) MGetAttr(MUIA_Group_ChildList);
}

void CMUI_Group::SetColumns(LONG value) {
    SetAttr(MUIA_Group_Columns, (IPTR) value);
}

LONG CMUI_Group::HorizSpacing(void) const {
    return (LONG) MGetAttr(MUIA_Group_HorizSpacing);
}

void CMUI_Group::SetHorizSpacing(LONG value) {
    SetAttr(MUIA_Group_HorizSpacing, (IPTR) value);
}

void CMUI_Group::SetRows(LONG value) {
    SetAttr(MUIA_Group_Rows, (IPTR) value);
}

void CMUI_Group::SetSpacing(LONG value) {
    SetAttr(MUIA_Group_Spacing, (IPTR) value);
}

LONG CMUI_Group::VertSpacing(void) const {
    return (LONG) MGetAttr(MUIA_Group_VertSpacing);
}

void CMUI_Group::SetVertSpacing(LONG value) {
    SetAttr(MUIA_Group_VertSpacing, (IPTR) value);
}

IPTR CMUI_Group::ExitChange(void) {
    return MDoMethod(MUIM_Group_ExitChange);
}

IPTR CMUI_Group::InitChange(void) {
    return MDoMethod(MUIM_Group_InitChange);
}

IPTR CMUI_Group::Sort(StartVarArgs sva, Object * obj, ...) {
    sva.methodID = MUIM_Group_Sort;
    return MDoMethodA((Msg) & sva);
}
