/* 
 * File:   CMUI_Listview.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 3 grudnia 2015, 21:17
 */

#include "CMUI_Listview.h"

CMUI_Listview::CMUI_Listview()
: CMUI_List() {
}

CMUI_Listview::CMUI_Listview(TagItem* tags)
: CMUI_List() {
#ifdef MUIPP_DEBUG
    _CheckTagsSpecified("CMUI_Listview", tags, MUIA_Listview_List, "MUIA_Listview_List", TAG_DONE);
#endif
    object = MUI_NewObjectA(MUIC_Listview, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Listview object\n");
#endif
}

CMUI_Listview::CMUI_Listview(Tag tag1, ...)
: CMUI_List() {
#ifdef MUIPP_DEBUG
    _CheckTagsSpecified("CMUI_Listview", (struct TagItem *) &tag1, MUIA_Listview_List, "MUIA_Listview_List", TAG_DONE);
#endif
    object = MUI_NewObjectA(MUIC_Listview, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Listview object\n");
#endif
}

CMUI_Listview::CMUI_Listview(Object* obj)
: CMUI_List() {
    object = obj;
}

CMUI_Listview& CMUI_Listview::operator=(Object* obj) {
    object = obj;
    return *this;
}

LONG CMUI_Listview::ActivePage(void) const {
    return (LONG) MGetAttr(MUIA_Group_ActivePage);
}

void CMUI_Listview::SetActivePage(LONG value) {
    SetAttr(MUIA_Group_ActivePage, (IPTR) value);
}

struct List * CMUI_Listview::ChildList(void) const {
    return (struct List *) MGetAttr(MUIA_Group_ChildList);
}

void CMUI_Listview::SetColumns(LONG value) {
    SetAttr(MUIA_Group_Columns, (IPTR) value);
}

LONG CMUI_Listview::HorizSpacing(void) const {
    return (LONG) MGetAttr(MUIA_Group_HorizSpacing);
}

void CMUI_Listview::SetHorizSpacing(LONG value) {
    SetAttr(MUIA_Group_HorizSpacing, (IPTR) value);
}

void CMUI_Listview::SetRows(LONG value) {
    SetAttr(MUIA_Group_Rows, (IPTR) value);
}

void CMUI_Listview::SetSpacing(LONG value) {
    SetAttr(MUIA_Group_Spacing, (IPTR) value);
}

LONG CMUI_Listview::VertSpacing(void) const {
    return (LONG) MGetAttr(MUIA_Group_VertSpacing);
}

void CMUI_Listview::SetVertSpacing(LONG value) {
    SetAttr(MUIA_Group_VertSpacing, (IPTR) value);
}

IPTR CMUI_Listview::ExitChange(void) {
    return MDoMethod(MUIM_Group_ExitChange);
}

IPTR CMUI_Listview::InitChange(void) {
    return MDoMethod(MUIM_Group_InitChange);
}

IPTR CMUI_Listview::Sort(StartVarArgs sva, Object * obj, ...) {
    sva.methodID = MUIM_Group_Sort;
    return MDoMethodA((Msg) & sva);
}

LONG CMUI_Listview::ClickColumn(void) const {
    return (LONG) MGetAttr(MUIA_Listview_ClickColumn);
}

LONG CMUI_Listview::DefClickColumn(void) const {
    return (LONG) MGetAttr(MUIA_Listview_DefClickColumn);
}

void CMUI_Listview::SetDefClickColumn(LONG value) {
    SetAttr(MUIA_Listview_DefClickColumn, (IPTR) value);
}

BOOL CMUI_Listview::MDoubleClick(void) const {
    return (BOOL) MGetAttr(MUIA_Listview_DoubleClick);
}

LONG CMUI_Listview::DragType(void) const {
    return (LONG) MGetAttr(MUIA_Listview_DragType);
}

void CMUI_Listview::SetDragType(LONG value) {
    SetAttr(MUIA_Listview_DragType, (IPTR) value);
}

Object * CMUI_Listview::List(void) const {
    return (Object *) MGetAttr(MUIA_Listview_List);
}

BOOL CMUI_Listview::SelectChange(void) const {
    return (BOOL) MGetAttr(MUIA_Listview_SelectChange);
}
