/* 
 * File:   CMUI_Menuitem.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 29 listopada 2015, 19:38
 */

#include "CMUI_Menuitem.h"

CMUI_Menuitem::CMUI_Menuitem()
: CMUI_Family() {
}

CMUI_Menuitem::CMUI_Menuitem(TagItem* tags)
: CMUI_Family() {
    object = MUI_NewObjectA(MUIC_Menuitem, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Menuitem object\n");
#endif
}

CMUI_Menuitem::CMUI_Menuitem(Tag tag1, ...)
: CMUI_Family() {
    object = MUI_NewObjectA(MUIC_Menuitem, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Menuitem object\n");
#endif
}

CMUI_Menuitem::CMUI_Menuitem(Object* obj)
: CMUI_Family() {
    object = obj;
}

CMUI_Menuitem::CMUI_Menuitem(STRPTR label, STRPTR shortcut, IPTR flags, IPTR data)
: CMUI_Family() {
    object = MUI_MakeObject(MUIO_Menuitem, label, shortcut, flags, data);
}

CMUI_Menuitem& CMUI_Menuitem::operator=(Object* obj) {
    object = obj;
    return *this;
}

BOOL CMUI_Menuitem::Checked(void) const {
    return (BOOL) MGetAttr(MUIA_Menuitem_Checked);
}

void CMUI_Menuitem::SetChecked(BOOL value) {
    SetAttr(MUIA_Menuitem_Checked, (IPTR) value);
}

BOOL CMUI_Menuitem::Checkit(void) const {
    return (BOOL) MGetAttr(MUIA_Menuitem_Checkit);
}

void CMUI_Menuitem::SetCheckit(BOOL value) {
    SetAttr(MUIA_Menuitem_Checkit, (IPTR) value);
}

BOOL CMUI_Menuitem::CommandString(void) const {
    return (BOOL) MGetAttr(MUIA_Menuitem_CommandString);
}

void CMUI_Menuitem::SetCommandString(BOOL value) {
    SetAttr(MUIA_Menuitem_CommandString, (IPTR) value);
}

BOOL CMUI_Menuitem::Enabled(void) const {
    return (BOOL) MGetAttr(MUIA_Menuitem_Enabled);
}

void CMUI_Menuitem::SetEnabled(BOOL value) {
    SetAttr(MUIA_Menuitem_Enabled, (IPTR) value);
}

LONG CMUI_Menuitem::Exclude(void) const {
    return (LONG) MGetAttr(MUIA_Menuitem_Exclude);
}

void CMUI_Menuitem::SetExclude(LONG value) {
    SetAttr(MUIA_Menuitem_Exclude, (IPTR) value);
}

STRPTR CMUI_Menuitem::Shortcut(void) const {
    return (STRPTR) MGetAttr(MUIA_Menuitem_Shortcut);
}

void CMUI_Menuitem::SetShortcut(STRPTR value) {
    SetAttr(MUIA_Menuitem_Shortcut, (IPTR) value);
}

STRPTR CMUI_Menuitem::Title(void) const {
    return (STRPTR) MGetAttr(MUIA_Menuitem_Title);
}

void CMUI_Menuitem::SetTitle(STRPTR value) {
    SetAttr(MUIA_Menuitem_Title, (IPTR) value);
}

BOOL CMUI_Menuitem::Toggle(void) const {
    return (BOOL) MGetAttr(MUIA_Menuitem_Toggle);
}

void CMUI_Menuitem::SetToggle(BOOL value) {
    SetAttr(MUIA_Menuitem_Toggle, (IPTR) value);
}

struct MenuItem * CMUI_Menuitem::Trigger(void) const {
    return (struct MenuItem *) MGetAttr(MUIA_Menuitem_Trigger);
}
