/* 
 * File:   CMUI_Menuitem.h
 * Author: Piotr Hoppe
 *
 * Created on 29 listopada 2015, 19:38
 */

#ifndef CMUI_MENUITEM_H
#define	CMUI_MENUITEM_H

#include <libraries/muiplus/CMUI_Family.h>

/***************************************************************************
 **                      CMUI_Menuitem class definition                      
 ***************************************************************************/

class CMUI_Menuitem : public CMUI_Family {
public:
    CMUI_Menuitem(void);
    CMUI_Menuitem(struct TagItem *tags);
    CMUI_Menuitem(Tag tag1, ...);
    CMUI_Menuitem(Object * obj);
    CMUI_Menuitem(STRPTR label, STRPTR shortcut, IPTR flags, IPTR data);
    CMUI_Menuitem & operator=(Object * obj);

    BOOL Checked(void) const;
    void SetChecked(BOOL value);
    BOOL Checkit(void) const;
    void SetCheckit(BOOL value);
    BOOL CommandString(void) const;
    void SetCommandString(BOOL value);
    BOOL Enabled(void) const;
    void SetEnabled(BOOL value);
    LONG Exclude(void) const;
    void SetExclude(LONG value);
    STRPTR Shortcut(void) const;
    void SetShortcut(STRPTR value);
    STRPTR Title(void) const;
    void SetTitle(STRPTR value);
    BOOL Toggle(void) const;
    void SetToggle(BOOL value);
    struct MenuItem * Trigger(void) const;
};


#endif	/* CMUI_MENUITEM_H */

