/* 
 * File:   CMUI_Notify.cpp
 * Author: piotr
 * 
 * Created on 11 listopada 2015, 21:12
 */

#include "CMUI_Notify.h"

CMUI_Notify::CMUI_Notify() : CMUI_Object() {
}

Object * CMUI_Notify::MApplicationObject(void) const {
    return (Object *) MGetAttr(MUIA_ApplicationObject);
}

struct AppMessage * CMUI_Notify::AppMessage(void) const {
    return (struct AppMessage *) MGetAttr(MUIA_AppMessage);
}

LONG CMUI_Notify::HelpLine(void) const {
    return (LONG) MGetAttr(MUIA_HelpLine);
}

void CMUI_Notify::SetHelpLine(LONG value) {
    SetAttr(MUIA_HelpLine, (IPTR) value);
}

STRPTR CMUI_Notify::HelpNode(void) const {
    return (STRPTR) MGetAttr(MUIA_HelpNode);
}

void CMUI_Notify::SetHelpNode(STRPTR value) {
    SetAttr(MUIA_HelpNode, (IPTR) value);
}

void CMUI_Notify::SetNoNotify(BOOL value) {
    SetAttr(MUIA_NoNotify, (IPTR) value);
}

IPTR CMUI_Notify::ObjectID(void) const {
    return (IPTR) MGetAttr(MUIA_ObjectID);
}

void CMUI_Notify::SetObjectID(IPTR value) {
    SetAttr(MUIA_ObjectID, (IPTR) value);
}

Object * CMUI_Notify::Parent(void) const {
    return (Object *) MGetAttr(MUIA_Parent);
}

LONG CMUI_Notify::Revision(void) const {
    return (LONG) MGetAttr(MUIA_Revision);
}

IPTR CMUI_Notify::UserData(void) const {
    return (IPTR) MGetAttr(MUIA_UserData);
}

void CMUI_Notify::SetUserData(IPTR value) {
    SetAttr(MUIA_UserData, (IPTR) value);
}

LONG CMUI_Notify::Version(void) const {
    return (LONG) MGetAttr(MUIA_Version);
}

IPTR CMUI_Notify::MCallHook(StartVarArgs sva, struct Hook * Hook, IPTR param1, ...) {
    sva.methodID = MUIM_CallHook;
    return MDoMethodA((Msg) & sva);
}

IPTR CMUI_Notify::Export(Object * dataspace) {
    return MDoMethod(MUIM_Export, dataspace);
}

IPTR CMUI_Notify::FindUData(IPTR udata) {
    return MDoMethod(MUIM_FindUData, udata);
}

IPTR CMUI_Notify::GetConfigItem(IPTR id, IPTR * storage) {
    return MDoMethod(MUIM_GetConfigItem, id, storage);
}

IPTR CMUI_Notify::GetUData(IPTR udata, IPTR attr, IPTR * storage) {
    return MDoMethod(MUIM_GetUData, udata, attr, storage);
}

IPTR CMUI_Notify::Import(Object * dataspace) {
    return MDoMethod(MUIM_Import, dataspace);
}

IPTR CMUI_Notify::KillNotify(IPTR TrigAttr) {
    return MDoMethod(MUIM_KillNotify, TrigAttr);
}

IPTR CMUI_Notify::KillNotifyObj(IPTR TrigAttr, Object * dest) {
    return MDoMethod(MUIM_KillNotifyObj, TrigAttr, dest);
}

IPTR CMUI_Notify::MultiSet(StartVarArgs sva, IPTR attr, IPTR val, APTR obj, ...) {
    sva.methodID = MUIM_MultiSet;
    return MDoMethodA((Msg) & sva);
}

IPTR CMUI_Notify::NoNotifySet(StartVarArgs sva, IPTR attr, char * format, IPTR val, ...) {
    sva.methodID = MUIM_NoNotifySet;
    return MDoMethodA((Msg) & sva);
}

IPTR CMUI_Notify::Notify(StartVarArgs sva, IPTR TrigAttr, IPTR TrigVal, APTR DestObj, IPTR FollowParams, ...) {
    sva.methodID = MUIM_Notify;
    return MDoMethodA((Msg) & sva);
}

IPTR CMUI_Notify::Set(IPTR attr, IPTR val) {
    return MDoMethod(MUIM_Set, attr, val);
}

IPTR CMUI_Notify::SetAsString(StartVarArgs sva, IPTR attr, char * format, IPTR val, ...) {
    sva.methodID = MUIM_SetAsString;
    return MDoMethodA((Msg) & sva);
}

IPTR CMUI_Notify::SetUData(IPTR udata, IPTR attr, IPTR val) {
    return MDoMethod(MUIM_SetUData, udata, attr, val);
}

IPTR CMUI_Notify::SetUDataOnce(IPTR udata, IPTR attr, IPTR val) {
    return MDoMethod(MUIM_SetUDataOnce, udata, attr, val);
}

IPTR CMUI_Notify::WriteLong(IPTR val, IPTR * memory) {
    return MDoMethod(MUIM_WriteLong, val, memory);
}

IPTR CMUI_Notify::WriteString(char * str, char * memory) {
    return MDoMethod(MUIM_WriteString, str, memory);
}
