/* 
 * File:   CMUI_Palette.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 3 grudnia 2015, 22:11
 */

#include "CMUI_Palette.h"

CMUI_Palette::CMUI_Palette()
: CMUI_Group() {
}

CMUI_Palette::CMUI_Palette(TagItem* tags)
: CMUI_Group() {
    object = MUI_NewObjectA(MUIC_Palette, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Palette object\n");
#endif
}

CMUI_Palette::CMUI_Palette(Tag tag1, ...)
: CMUI_Group() {
    object = MUI_NewObjectA(MUIC_Palette, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Palette object\n");
#endif
}

CMUI_Palette::CMUI_Palette(Object* obj)
: CMUI_Group() {
    object = obj;
}

CMUI_Palette& CMUI_Palette::operator=(Object* obj) {
    object = obj;
    return *this;
}

struct MUI_Palette_Entry * CMUI_Palette::Entries(void) const {
    return (struct MUI_Palette_Entry *) MGetAttr(MUIA_Palette_Entries);
}

BOOL CMUI_Palette::Groupable(void) const {
    return (BOOL) MGetAttr(MUIA_Palette_Groupable);
}

void CMUI_Palette::SetGroupable(BOOL value) {
    SetAttr(MUIA_Palette_Groupable, (IPTR) value);
}

char ** CMUI_Palette::Names(void) const {
    return (char **) MGetAttr(MUIA_Palette_Names);
}

void CMUI_Palette::SetNames(char ** value) {
    SetAttr(MUIA_Palette_Names, (IPTR) value);
}
