/* 
 * File:   CMUI_Pendisplay.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 2 grudnia 2015, 21:54
 */

#include "CMUI_Pendisplay.h"

CMUI_Pendisplay::CMUI_Pendisplay()
: CMUI_Area() {
}

CMUI_Pendisplay::CMUI_Pendisplay(TagItem* tags)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_Pendisplay, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Pendisplay object\n");
#endif
}

CMUI_Pendisplay::CMUI_Pendisplay(Tag tag1, ...)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_Pendisplay, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Pendisplay object\n");
#endif
}

CMUI_Pendisplay::CMUI_Pendisplay(Object* obj)
: CMUI_Area() {
    object = obj;
}

CMUI_Pendisplay& CMUI_Pendisplay::operator=(Object* obj) {
    object = obj;
    return *this;
}

Object * CMUI_Pendisplay::Pen(void) const {
    return (Object *) MGetAttr(MUIA_Pendisplay_Pen);
}

Object * CMUI_Pendisplay::Reference(void) const {
    return (Object *) MGetAttr(MUIA_Pendisplay_Reference);
}

void CMUI_Pendisplay::SetReference(Object * value) {
    SetAttr(MUIA_Pendisplay_Reference, (IPTR) value);
}

struct MUI_RGBcolor * CMUI_Pendisplay::RGBcolor(void) const {
    return (struct MUI_RGBcolor *) MGetAttr(MUIA_Pendisplay_RGBcolor);
}

void CMUI_Pendisplay::SetRGBcolor(struct MUI_RGBcolor * value) {
    SetAttr(MUIA_Pendisplay_RGBcolor, (IPTR) value);
}

struct MUI_PenSpec * CMUI_Pendisplay::Spec(void) const {
    return (struct MUI_PenSpec *) MGetAttr(MUIA_Pendisplay_Spec);
}

void CMUI_Pendisplay::SetSpec(struct MUI_PenSpec * value) {
    SetAttr(MUIA_Pendisplay_Spec, (IPTR) value);
}

IPTR CMUI_Pendisplay::SetColormap(LONG colormap) {
    return MDoMethod(MUIM_Pendisplay_SetColormap, colormap);
}

IPTR CMUI_Pendisplay::SetMUIPen(LONG muipen) {
    return MDoMethod(MUIM_Pendisplay_SetMUIPen, muipen);
}

IPTR CMUI_Pendisplay::SetRGB(IPTR red, IPTR green, IPTR blue) {
    return MDoMethod(MUIM_Pendisplay_SetRGB, red, green, blue);
}
