/* 
 * File:   CMUI_Popobject.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 3 grudnia 2015, 22:19
 */

#include "CMUI_Popobject.h"

CMUI_Popobject::CMUI_Popobject()
: CMUI_Popstring() {
}

CMUI_Popobject::CMUI_Popobject(TagItem* tags)
: CMUI_Popstring() {
    object = MUI_NewObjectA(MUIC_Popobject, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Popobject object\n");
#endif
}

CMUI_Popobject::CMUI_Popobject(Tag tag1, ...)
: CMUI_Popstring() {
    object = MUI_NewObjectA(MUIC_Popobject, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Popobject object\n");
#endif
}

CMUI_Popobject::CMUI_Popobject(Object* obj)
: CMUI_Popstring() {
    object = obj;
}

CMUI_Popobject& CMUI_Popobject::operator=(Object* obj) {
    object = obj;
    return *this;
}

BOOL CMUI_Popobject::Follow(void) const {
    return (BOOL) MGetAttr(MUIA_Popobject_Follow);
}

void CMUI_Popobject::SetFollow(BOOL value) {
    SetAttr(MUIA_Popobject_Follow, (IPTR) value);
}

BOOL CMUI_Popobject::Light(void) const {
    return (BOOL) MGetAttr(MUIA_Popobject_Light);
}

void CMUI_Popobject::SetLight(BOOL value) {
    SetAttr(MUIA_Popobject_Light, (IPTR) value);
}

Object * CMUI_Popobject::PopObject(void) const {
    return (Object *) MGetAttr(MUIA_Popobject_Object);
}

struct Hook * CMUI_Popobject::ObjStrHook(void) const {
    return (struct Hook *) MGetAttr(MUIA_Popobject_ObjStrHook);
}

void CMUI_Popobject::SetObjStrHook(struct Hook * value) {
    SetAttr(MUIA_Popobject_ObjStrHook, (IPTR) value);
}

struct Hook * CMUI_Popobject::StrObjHook(void) const {
    return (struct Hook *) MGetAttr(MUIA_Popobject_StrObjHook);
}

void CMUI_Popobject::SetStrObjHook(struct Hook * value) {
    SetAttr(MUIA_Popobject_StrObjHook, (IPTR) value);
}

BOOL CMUI_Popobject::Volatile(void) const {
    return (BOOL) MGetAttr(MUIA_Popobject_Volatile);
}

void CMUI_Popobject::SetVolatile(BOOL value) {
    SetAttr(MUIA_Popobject_Volatile, (IPTR) value);
}

struct Hook * CMUI_Popobject::WindowHook(void) const {
    return (struct Hook *) MGetAttr(MUIA_Popobject_WindowHook);
}

void CMUI_Popobject::SetWindowHook(struct Hook * value) {
    SetAttr(MUIA_Popobject_WindowHook, (IPTR) value);
}
