/* 
 * File:   CMUI_Popstring.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 3 grudnia 2015, 22:15
 */

#include "CMUI_Popstring.h"

CMUI_Popstring::CMUI_Popstring()
: CMUI_Group() {
}

CMUI_Popstring::CMUI_Popstring(TagItem* tags)
: CMUI_Group() {
    object = MUI_NewObjectA(MUIC_Popstring, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Popstring object\n");
#endif
}

CMUI_Popstring::CMUI_Popstring(Tag tag1, ...)
: CMUI_Group() {
    object = MUI_NewObjectA(MUIC_Popstring, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Popstring object\n");
#endif
}

CMUI_Popstring::CMUI_Popstring(Object* obj)
: CMUI_Group() {
    object = obj;
}

CMUI_Popstring& CMUI_Popstring::operator=(Object* obj) {
    object = obj;
    return *this;
}

Object * CMUI_Popstring::Button(void) const {
    return (Object *) MGetAttr(MUIA_Popstring_Button);
}

struct Hook * CMUI_Popstring::CloseHook(void) const {
    return (struct Hook *) MGetAttr(MUIA_Popstring_CloseHook);
}

void CMUI_Popstring::SetCloseHook(struct Hook * value) {
    SetAttr(MUIA_Popstring_CloseHook, (IPTR) value);
}

struct Hook * CMUI_Popstring::OpenHook(void) const {
    return (struct Hook *) MGetAttr(MUIA_Popstring_OpenHook);
}

void CMUI_Popstring::SetOpenHook(struct Hook * value) {
    SetAttr(MUIA_Popstring_OpenHook, (IPTR) value);
}

Object * CMUI_Popstring::String(void) const {
    return (Object *) MGetAttr(MUIA_Popstring_String);
}

BOOL CMUI_Popstring::Toggle(void) const {
    return (BOOL) MGetAttr(MUIA_Popstring_Toggle);
}

void CMUI_Popstring::SetToggle(BOOL value) {
    SetAttr(MUIA_Popstring_Toggle, (IPTR) value);
}

IPTR CMUI_Popstring::Close(LONG result) {
    return MDoMethod(MUIM_Popstring_Close, result);
}

IPTR CMUI_Popstring::Open(void) {
    return MDoMethod(MUIM_Popstring_Open);
}
