/* 
 * File:   CMUI_Prop.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 30 listopada 2015, 18:51
 */

#include "CMUI_Prop.h"

CMUI_Prop::CMUI_Prop()
: CMUI_Gadget() {
}

CMUI_Prop::CMUI_Prop(TagItem* tags)
: CMUI_Gadget() {
    object = MUI_NewObjectA(MUIC_Prop, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Prop object\n");
#endif
}

CMUI_Prop::CMUI_Prop(Tag tag1, ...)
: CMUI_Gadget() {
    object = MUI_NewObjectA(MUIC_Prop, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Prop object\n");
#endif
}

CMUI_Prop::CMUI_Prop(Object* obj)
: CMUI_Gadget() {
    object = obj;
}

CMUI_Prop& CMUI_Prop::operator=(Object* obj) {
    object = obj;
    return *this;
}

LONG CMUI_Prop::Entries(void) const {
    return (LONG) MGetAttr(MUIA_Prop_Entries);
}

void CMUI_Prop::SetEntries(LONG value) {
    SetAttr(MUIA_Prop_Entries, (IPTR) value);
}

LONG CMUI_Prop::First(void) const {
    return (LONG) MGetAttr(MUIA_Prop_First);
}

void CMUI_Prop::SetFirst(LONG value) {
    SetAttr(MUIA_Prop_First, (IPTR) value);
}

BOOL CMUI_Prop::Horiz(void) const {
    return (BOOL) MGetAttr(MUIA_Prop_Horiz);
}

BOOL CMUI_Prop::Slider(void) const {
    return (BOOL) MGetAttr(MUIA_Prop_Slider);
}

void CMUI_Prop::SetSlider(BOOL value) {
    SetAttr(MUIA_Prop_Slider, (IPTR) value);
}

LONG CMUI_Prop::Visible(void) const {
    return (LONG) MGetAttr(MUIA_Prop_Visible);
}

void CMUI_Prop::SetVisible(LONG value) {
    SetAttr(MUIA_Prop_Visible, (IPTR) value);
}

IPTR CMUI_Prop::Decrease(LONG amount) {
    return MDoMethod(MUIM_Prop_Decrease, amount);
}

IPTR CMUI_Prop::Increase(LONG amount) {
    return MDoMethod(MUIM_Prop_Increase, amount);
}
