/* 
 * File:   CMUI_Radio.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 3 grudnia 2015, 22:00
 */

#include "CMUI_Radio.h"

CMUI_Radio::CMUI_Radio()
: CMUI_Group() {
}

CMUI_Radio::CMUI_Radio(TagItem* tags)
: CMUI_Group() {
    object = MUI_NewObjectA(MUIC_Radio, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Radio object\n");
#endif
}

CMUI_Radio::CMUI_Radio(Tag tag1, ...)
: CMUI_Group() {
    object = MUI_NewObjectA(MUIC_Radio, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Radio object\n");
#endif
}

CMUI_Radio::CMUI_Radio(Object* obj)
: CMUI_Group() {
    object = obj;
}

CMUI_Radio::CMUI_Radio(STRPTR label, STRPTR* entries)
: CMUI_Group() {
    object = MUI_MakeObject(MUIO_Radio, label, entries);
}

CMUI_Radio& CMUI_Radio::operator=(Object* obj) {
    object = obj;
    return *this;
}

LONG CMUI_Radio::Active(void) const {
    return (LONG) MGetAttr(MUIA_Radio_Active);
}

void CMUI_Radio::SetActive(LONG value) {
    SetAttr(MUIA_Radio_Active, (IPTR) value);
}
