/* 
 * File:   CMUI_Register.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 2 grudnia 2015, 23:03
 */

#include "CMUI_Register.h"

CMUI_Register::CMUI_Register()
: CMUI_Group() {
}

CMUI_Register::CMUI_Register(TagItem* tags)
: CMUI_Group() {
    object = MUI_NewObjectA(MUIC_Register, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Register object\n");
#endif
}

CMUI_Register::CMUI_Register(Tag tag1, ...)
: CMUI_Group() {
    object = MUI_NewObjectA(MUIC_Register, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Register object\n");
#endif
}

CMUI_Register::CMUI_Register(Object* obj)
: CMUI_Group() {
    object = obj;
}

CMUI_Register& CMUI_Register::operator=(Object* obj) {
    object = obj;
    return *this;
}

BOOL CMUI_Register::Frame(void) const {
    return (BOOL) MGetAttr(MUIA_Register_Frame);
}

STRPTR * CMUI_Register::Titles(void) const {
    return (STRPTR *) MGetAttr(MUIA_Register_Titles);
}
