/* 
 * File:   CMUI_Scale.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 30 listopada 2015, 21:02
 */

#include "CMUI_Scale.h"

CMUI_Scale::CMUI_Scale()
: CMUI_Area() {
}

CMUI_Scale::CMUI_Scale(TagItem* tags)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_Scale, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Scale object\n");
#endif
}

CMUI_Scale::CMUI_Scale(Tag tag1, ...)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_Scale, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Scale object\n");
#endif
}

CMUI_Scale::CMUI_Scale(Object* obj)
: CMUI_Area() {
    object = obj;
}

CMUI_Scale& CMUI_Scale::operator=(Object* obj) {
    object = obj;
    return *this;
}

BOOL CMUI_Scale::Horiz(void) const {
    return (BOOL) MGetAttr(MUIA_Scale_Horiz);
}

void CMUI_Scale::SetHoriz(BOOL value) {
    SetAttr(MUIA_Scale_Horiz, (IPTR) value);
}
