/* 
 * File:   CMUI_Scrollgroup.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 3 grudnia 2015, 21:03
 */

#include "CMUI_Scrollgroup.h"

CMUI_Scrollgroup::CMUI_Scrollgroup()
: CMUI_Group() {
}

CMUI_Scrollgroup::CMUI_Scrollgroup(TagItem* tags)
: CMUI_Group() {
    object = MUI_NewObjectA(MUIC_Scrollgroup, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Scrollgroup object\n");
#endif
}

CMUI_Scrollgroup::CMUI_Scrollgroup(Tag tag1, ...)
: CMUI_Group() {
    object = MUI_NewObjectA(MUIC_Scrollgroup, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Scrollgroup object\n");
#endif
}

CMUI_Scrollgroup::CMUI_Scrollgroup(Object* obj)
: CMUI_Group() {
    object = obj;
}

CMUI_Scrollgroup& CMUI_Scrollgroup::operator=(Object* obj) {
    object = obj;
    return *this;
}

Object * CMUI_Scrollgroup::Contents(void) const {
    return (Object *) MGetAttr(MUIA_Scrollgroup_Contents);
}

Object * CMUI_Scrollgroup::HorizBar(void) const {
    return (Object *) MGetAttr(MUIA_Scrollgroup_HorizBar);
}

Object * CMUI_Scrollgroup::VertBar(void) const {
    return (Object *) MGetAttr(MUIA_Scrollgroup_VertBar);
}
