/* 
 * File:   CMUI_String.h
 * Author: Piotr Hoppe
 *
 * Created on 30 listopada 2015, 18:28
 */

#ifndef CMUI_STRING_H
#define CMUI_STRING_H

#include "CMUI_Gadget.h"

/***************************************************************************
 **                       CMUI_String class definition                       
 ***************************************************************************/

class CMUI_String : public CMUI_Gadget {
public:
    CMUI_String(void);
    CMUI_String(struct TagItem *tags);
    CMUI_String(Tag tag1, ...);
    CMUI_String(Object * obj);
    CMUI_String(STRPTR label, LONG maxlen);
    CMUI_String & operator=(Object * obj);

    // These operators allow CMUI_String object to be treated like const char *

    operator const char * ();
    operator IPTR();
    CMUI_String & operator=(const char *contents);
    CMUI_String & operator=(IPTR contents);
    STRPTR Accept(void) const;
    void SetAccept(STRPTR value);
    STRPTR Acknowledge(void) const;
    BOOL AdvanceOnCR(void) const;
    void SetAdvanceOnCR(BOOL value);
    Object * AttachedList(void) const;
    void SetAttachedList(Object * value);
    LONG BufferPos(void) const;
    void SetBufferPos(LONG value);
    STRPTR Contents(void) const;
    void SetContents(STRPTR value);
    LONG DisplayPos(void) const;
    void SetDisplayPos(LONG value);
    struct Hook * EditHook(void) const;
    void MSetEditHook(struct Hook * value);
    LONG Format(void) const;
    IPTR Integer(void) const;
    void SetInteger(IPTR value);
    BOOL LonelyEditHook(void) const;
    void SetLonelyEditHook(BOOL value);
    LONG MaxLen(void) const;
    STRPTR Reject(void) const;
    void SetReject(STRPTR value);
    BOOL Secret(void) const;
};

#endif /* CMUI_STRING_H */

