/* 
 * File:   CMUI_Window.h
 * Author: Piotr Hoppe
 *
 * Created on 26 listopada 2015, 21:03
 */

#ifndef CMUI_WINDOW_H
#define CMUI_WINDOW_H

#include <libraries/muiplus/CMUI_Notify.h>
#include <proto/intuition.h>

class CMUI_Window : public CMUI_Notify {
public:
    CMUI_Window(void);
    CMUI_Window(struct TagItem *tags);
    CMUI_Window(Tag tag1, ...);
    CMUI_Window(Object * obj);
    CMUI_Window & operator=(Object * obj);

    BOOL Activate(void) const;
    void SetActivate(BOOL value);
    Object * ActiveObject(void) const;
    void SetActiveObject(Object * value);
    LONG AltHeight(void) const;
    LONG AltLeftEdge(void) const;
    LONG AltTopEdge(void) const;
    LONG AltWidth(void) const;
    BOOL CloseRequest(void) const;
    Object * DefaultObject(void) const;
    void SetDefaultObject(Object * value);
    BOOL FancyDrawing(void) const;
    void SetFancyDrawing(BOOL value);
    LONG Height(void) const;
    IPTR ID(void) const;
    void SetID(IPTR value);
    struct InputEvent * InputEvent(void) const;
    BOOL IsSubWindow(void) const;
    void SetIsSubWindow(BOOL value);
    LONG LeftEdge(void) const;
    IPTR MenuAction(void) const;
    void SetMenuAction(IPTR value);
    Object * Menustrip(void) const;
    Object * MouseObject(void) const;
    void SetNoMenus(BOOL value);
    BOOL Open(void) const;
    void SetOpen(BOOL value);
    STRPTR PublicScreen(void) const;
    void SetPublicScreen(STRPTR value);
    void SetRefWindow(Object * value);
    Object * RootObject(void) const;
    void SetRootObject(Object * value);
    struct Screen * Screen(void) const;
    void SetScreen(struct Screen * value);
    STRPTR ScreenTitle(void) const;
    void SetScreenTitle(STRPTR value);
    BOOL Sleep(void) const;
    void SetSleep(BOOL value);
    STRPTR Title(void) const;
    void SetTitle(STRPTR value);
    LONG TopEdge(void) const;
    BOOL UseBottomBorderScroller(void) const;
    void SetUseBottomBorderScroller(BOOL value);
    BOOL UseLeftBorderScroller(void) const;
    void SetUseLeftBorderScroller(BOOL value);
    BOOL UseRightBorderScroller(void) const;
    void SetUseRightBorderScroller(BOOL value);
    LONG Width(void) const;
    struct Window * Window(void) const;
    IPTR AddEventHandler(struct MUI_EventHandlerNode * ehnode);
    IPTR RemEventHandler(struct MUI_EventHandlerNode * ehnode);
    IPTR MScreenToBack(void);
    IPTR MScreenToFront(void);
    IPTR Snapshot(LONG flags);
    IPTR ToBack(void);
    IPTR ToFront(void);
#ifdef MUI_OBSOLETE
    IPTR GetMenuCheck(IPTR MenuID);
    IPTR GetMenuState(IPTR MenuID);
    IPTR SetCycleChain(StartVarArgs sva, Object * obj, ...);
    IPTR SetMenuCheck(IPTR MenuID, LONG stat);
    IPTR SetMenuState(IPTR MenuID, LONG stat);

#endif /* MUI_OBSOLETE */
};

#endif /* CMUI_WINDOW_H */

