
/* 
 * File:   CMUI_NListview.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 13 grudnia 2015, 20:47
 */

#include "CMUI_NListview.h"

CMUI_NListview::CMUI_NListview()
: CMUI_NList() {
}

CMUI_NListview::CMUI_NListview(TagItem* tags)
: CMUI_NList() {
    object = MUI_NewObjectA(MUIC_NListview, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_NListview object\n");
#endif
}

CMUI_NListview::CMUI_NListview(Tag tag1, ...)
: CMUI_NList() {
    object = MUI_NewObjectA(MUIC_NListview, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_NListview object\n");
#endif
}

CMUI_NListview::CMUI_NListview(Object* obj)
: CMUI_NList() {
    object = obj;
}

CMUI_NListview& CMUI_NListview::operator=(Object* obj) {
    object = obj;
    return *this;
}

LONG CMUI_NListview::ActivePage(void) const {
    return (LONG) MGetAttr(MUIA_Group_ActivePage);
}

void CMUI_NListview::SetActivePage(LONG value) {
    SetAttr(MUIA_Group_ActivePage, (IPTR) value);
}

struct List * CMUI_NListview::ChildList(void) const {
    return (struct List *) MGetAttr(MUIA_Group_ChildList);
}

void CMUI_NListview::SetColumns(LONG value) {
    SetAttr(MUIA_Group_Columns, (IPTR) value);
}

LONG CMUI_NListview::HorizSpacing(void) const {
    return (LONG) MGetAttr(MUIA_Group_HorizSpacing);
}

void CMUI_NListview::SetHorizSpacing(LONG value) {
    SetAttr(MUIA_Group_HorizSpacing, (IPTR) value);
}

void CMUI_NListview::SetRows(LONG value) {
    SetAttr(MUIA_Group_Rows, (IPTR) value);
}

void CMUI_NListview::SetSpacing(LONG value) {
    SetAttr(MUIA_Group_Spacing, (IPTR) value);
}

LONG CMUI_NListview::VertSpacing(void) const {
    return (LONG) MGetAttr(MUIA_Group_VertSpacing);
}

void CMUI_NListview::SetVertSpacing(LONG value) {
    SetAttr(MUIA_Group_VertSpacing, (IPTR) value);
}

IPTR CMUI_NListview::ExitChange(void) {
    return MDoMethod(MUIM_Group_ExitChange);
}

IPTR CMUI_NListview::InitChange(void) {
    return MDoMethod(MUIM_Group_InitChange);
}

IPTR CMUI_NListview::Sort(StartVarArgs sva, Object * obj, ...) {
    sva.methodID = MUIM_Group_Sort;
    return MDoMethodA((Msg) & sva);
}

Object * CMUI_NListview::Horiz_ScrollBar(void) const {
    return (Object *) MGetAttr(MUIA_NListview_Horiz_ScrollBar);
}

void CMUI_NListview::SetHoriz_ScrollBar(Object * value) {
    SetAttr(MUIA_NListview_Horiz_ScrollBar, (IPTR) value);
}

Object * CMUI_NListview::NList(void) const {
    return (Object *) MGetAttr(MUIA_NListview_NList);
}

Object * CMUI_NListview::Vert_ScrollBar(void) const {
    return (Object *) MGetAttr(MUIA_NListview_Vert_ScrollBar);
}

void CMUI_NListview::SetVert_ScrollBar(Object * value) {
    SetAttr(MUIA_NListview_Vert_ScrollBar, (IPTR) value);
}
