/* 
 * File:   CTMUI_NList.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 14 grudnia 2015, 23:16
 */

#include "CTMUI_NList.h"

template<typename Type>
CTMUI_NList<Type>::CTMUI_NList()
: CMUI_Area() {
}

template<typename Type>
CTMUI_NList<Type>::CTMUI_NList(Tag tag1, ...)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_NList, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CTMUI_NList object\n");
#endif
}

template<typename Type>
CTMUI_NList<Type>::CTMUI_NList(Object* obj)
: CMUI_Area() {
    object = obj;
}

template<typename Type>
CTMUI_NList<Type>& CTMUI_NList<Type>::operator=(Object* obj) {
    object = obj;
    return *this;
}

// By overloading the [] operator you can treat lists like arrays

template<typename Type>
Type& CTMUI_NList<Type>::operator[](LONG pos) {
    Type * entry;
    MDoMethod(MUIM_NList_GetEntry, pos, &entry);
#ifdef MUIPP_DEBUG
    if (entry == NULL)
        _MUIPPError("Index into CTMUI_NList is out of range:\n"
        "Index = %d, length = %d\n",
        (int) pos,
        (int) MGetAttr(MUIA_NList_Entries));
#endif
    return *entry;
}

// This method is a convienient alternative to the Entries attribute

template <class Type> LONG CTMUI_NList<Type>::Length(void) const {
    return (LONG) MGetAttr(MUIA_NList_Entries);
}

// This method can be used to retrieve the number of selected entries
// in a list

template <class Type> IPTR CTMUI_NList<Type>::NumSelected(void) {
    IPTR numSelected;
    MDoMethod(MUIM_NList_Select, MUIV_NList_Select_All, MUIV_NList_Select_Ask, &numSelected);
    return numSelected;
}

// These methods can be used as shortcuts for inserting objects into lists

template <class Type> void CTMUI_NList<Type>::AddHead(Type * entry) {
    MDoMethod(MUIM_NList_InsertSingle, entry, MUIV_NList_Insert_Top);
}

template <class Type> void CTMUI_NList<Type>::AddHead(Type & entry) {
    MDoMethod(MUIM_NList_InsertSingle, &entry, MUIV_NList_Insert_Top);
}

template <class Type> void CTMUI_NList<Type>::AddTail(Type * entry) {
    MDoMethod(MUIM_NList_InsertSingle, entry, MUIV_NList_Insert_Bottom);
}

template <class Type> void CTMUI_NList<Type>::AddTail(Type & entry) {
    MDoMethod(MUIM_NList_InsertSingle, &entry, MUIV_NList_Insert_Bottom);
}

template <class Type> void CTMUI_NList<Type>::InsertTop(Type * entry) {
    MDoMethod(MUIM_NList_InsertSingle, entry, MUIV_NList_Insert_Top);
}

template <class Type> void CTMUI_NList<Type>::InsertTop(Type & entry) {
    MDoMethod(MUIM_NList_InsertSingle, &entry, MUIV_NList_Insert_Top);
}

template <class Type> void CTMUI_NList<Type>::InsertBottom(Type * entry) {
    MDoMethod(MUIM_NList_InsertSingle, entry, MUIV_NList_Insert_Bottom);
}

template <class Type> void CTMUI_NList<Type>::InsertBottom(Type & entry) {
    MDoMethod(MUIM_NList_InsertSingle, &entry, MUIV_NList_Insert_Bottom);
}

template <class Type> void CTMUI_NList<Type>::InsertSorted(Type * entry) {
    MDoMethod(MUIM_NList_InsertSingle, entry, MUIV_NList_Insert_Sorted);
}

template <class Type> void CTMUI_NList<Type>::InsertSorted(Type & entry) {
    MDoMethod(MUIM_NList_InsertSingle, &entry, MUIV_NList_Insert_Sorted);
}

template <class Type> void CTMUI_NList<Type>::InsertActive(Type * entry) {
    MDoMethod(MUIM_NList_InsertSingle, entry, MUIV_NList_Insert_Active);
}

template <class Type> void CTMUI_NList<Type>::InsertActive(Type & entry) {
    MDoMethod(MUIM_NList_InsertSingle, &entry, MUIV_NList_Insert_Active);
}

template <class Type> LONG CTMUI_NList<Type>::Active(void) const {
    return (LONG) MGetAttr(MUIA_NList_Active);
}

template <class Type> void CTMUI_NList<Type>::SetActive(LONG value) {
    SetAttr(MUIA_NList_Active, (IPTR) value);
}

template <class Type> void CTMUI_NList<Type>::SetAutoCopyToClip(BOOL value) {
    SetAttr(MUIA_NList_AutoCopyToClip, (IPTR) value);
}

template <class Type> BOOL CTMUI_NList<Type>::AutoVisible(void) const {
    return (BOOL) MGetAttr(MUIA_NList_AutoVisible);
}

template <class Type> void CTMUI_NList<Type>::SetAutoVisible(BOOL value) {
    SetAttr(MUIA_NList_AutoVisible, (IPTR) value);
}

template <class Type> LONG CTMUI_NList<Type>::ClickColumn(void) const {
    return (LONG) MGetAttr(MUIA_NList_ClickColumn);
}

template <class Type> void CTMUI_NList<Type>::SetCompareHook(struct Hook * value) {
    SetAttr(MUIA_NList_CompareHook, (IPTR) value);
}

template <class Type> void CTMUI_NList<Type>::SetConstructHook(struct Hook * value) {
    SetAttr(MUIA_NList_ConstructHook, (IPTR) value);
}

template <class Type> void CTMUI_NList<Type>::SetCopyColumnToClipHook(struct Hook * value) {
    SetAttr(MUIA_NList_CopyColumnToClipHook, (IPTR) value);
}

template <class Type> void CTMUI_NList<Type>::SetCopyEntryToClipHook(struct Hook * value) {
    SetAttr(MUIA_NList_CopyEntryToClipHook, (IPTR) value);
}

template <class Type> void CTMUI_NList<Type>::SetDefaultObjectOnClick(BOOL value) {
    SetAttr(MUIA_NList_DefaultObjectOnClick, (IPTR) value);
}

template <class Type> LONG CTMUI_NList<Type>::DefClickColumn(void) const {
    return (LONG) MGetAttr(MUIA_NList_DefClickColumn);
}

template <class Type> void CTMUI_NList<Type>::SetDefClickColumn(LONG value) {
    SetAttr(MUIA_NList_DefClickColumn, (IPTR) value);
}

template <class Type> void CTMUI_NList<Type>::SetDestructHook(struct Hook * value) {
    SetAttr(MUIA_NList_DestructHook, (IPTR) value);
}

template <class Type> void CTMUI_NList<Type>::SetDisplayHook(struct Hook * value) {
    SetAttr(MUIA_NList_DisplayHook, (IPTR) value);
}

template <class Type> void CTMUI_NList<Type>::SetDisplayRecall(BOOL value) {
    SetAttr(MUIA_NList_DisplayRecall, (IPTR) value);
}

template <class Type> BOOL CTMUI_NList<Type>::MDoubleClick(void) const {
    return (BOOL) MGetAttr(MUIA_NList_DoubleClick);
}

template <class Type> BOOL CTMUI_NList<Type>::DragSortable(void) const {
    return (BOOL) MGetAttr(MUIA_NList_DragSortable);
}

template <class Type> void CTMUI_NList<Type>::SetDragSortable(BOOL value) {
    SetAttr(MUIA_NList_DragSortable, (IPTR) value);
}

template <class Type> LONG CTMUI_NList<Type>::DragType(void) const {
    return (LONG) MGetAttr(MUIA_NList_DragType);
}

template <class Type> void CTMUI_NList<Type>::SetDragType(LONG value) {
    SetAttr(MUIA_NList_DragType, (IPTR) value);
}

template <class Type> LONG CTMUI_NList<Type>::DropMark(void) const {
    return (LONG) MGetAttr(MUIA_List_DropMark);
}

template <class Type> LONG CTMUI_NList<Type>::Entries(void) const {
    return (LONG) MGetAttr(MUIA_NList_Entries);
}

template <class Type> BOOL CTMUI_NList<Type>::EntryValueDependent(void) const {
    return (BOOL) MGetAttr(MUIA_NList_EntryValueDependent);
}

template <class Type> void CTMUI_NList<Type>::SetEntryValueDependent(BOOL value) {
    SetAttr(MUIA_NList_EntryValueDependent, (IPTR) value);
}

template <class Type> LONG CTMUI_NList<Type>::First(void) const {
    return (LONG) MGetAttr(MUIA_NList_First);
}

template <class Type> void CTMUI_NList<Type>::SetFirst(LONG value) {
    SetAttr(MUIA_NList_First, (IPTR) value);
}

template <class Type> STRPTR CTMUI_NList<Type>::Format(void) const {
    return (STRPTR) MGetAttr(MUIA_NList_Format);
}

template <class Type> void CTMUI_NList<Type>::SetFormat(STRPTR value) {
    SetAttr(MUIA_NList_Format, (IPTR) value);
}

template <class Type> LONG CTMUI_NList<Type>::HorizDeltaFactor(void) const {
    return (LONG) MGetAttr(MUIA_NList_HorizDeltaFactor);
}

template <class Type> LONG CTMUI_NList<Type>::Horiz_Entries(void) const {
    return (LONG) MGetAttr(MUIA_NList_Horiz_Entries);
}

template <class Type> LONG CTMUI_NList<Type>::Horiz_First(void) const {
    return (LONG) MGetAttr(MUIA_NList_Horiz_First);
}

template <class Type> void CTMUI_NList<Type>::SetHoriz_First(LONG value) {
    SetAttr(MUIA_NList_Horiz_First, (IPTR) value);
}

template <class Type> LONG CTMUI_NList<Type>::Horiz_Visible(void) const {
    return (LONG) MGetAttr(MUIA_NList_Horiz_Visible);
}

template <class Type> BOOL CTMUI_NList<Type>::Input(void) const {
    return (BOOL) MGetAttr(MUIA_NList_Input);
}

template <class Type> void CTMUI_NList<Type>::SetInput(BOOL value) {
    SetAttr(MUIA_NList_Input, (IPTR) value);
}

template <class Type> LONG CTMUI_NList<Type>::InsertPosition(void) const {
    return (LONG) MGetAttr(MUIA_NList_InsertPosition);
}

template <class Type> void CTMUI_NList<Type>::SetKeepActive(Object * value) {
    SetAttr(MUIA_NList_KeepActive, (IPTR) value);
}

template <class Type> void CTMUI_NList<Type>::SetMakeActive(Object * value) {
    SetAttr(MUIA_NList_MakeActive, (IPTR) value);
}

template <class Type> void CTMUI_NList<Type>::SetMinLineHeight(LONG value) {
    SetAttr(MUIA_NList_MinLineHeight, (IPTR) value);
}

template <class Type> BOOL CTMUI_NList<Type>::MultiClick(void) const {
    return (BOOL) MGetAttr(MUIA_NList_MultiClick);
}

template <class Type> void CTMUI_NList<Type>::SetMultiTestHook(struct Hook * value) {
    SetAttr(MUIA_NList_MultiTestHook, (IPTR) value);
}

template <class Type> APTR CTMUI_NList<Type>::PrivateData(void) const {
    return (APTR) MGetAttr(MUIA_NList_PrivateData);
}

template <class Type> void CTMUI_NList<Type>::SetPrivateData(APTR value) {
    SetAttr(MUIA_NList_PrivateData, (IPTR) value);
}

template <class Type> LONG CTMUI_NList<Type>::Prop_Entries(void) const {
    return (LONG) MGetAttr(MUIA_NList_Prop_Entries);
}

template <class Type> LONG CTMUI_NList<Type>::Prop_First(void) const {
    return (LONG) MGetAttr(MUIA_NList_Prop_First);
}

template <class Type> void CTMUI_NList<Type>::SetProp_First(LONG value) {
    SetAttr(MUIA_NList_Prop_First, (IPTR) value);
}

template <class Type> LONG CTMUI_NList<Type>::Prop_Visible(void) const {
    return (LONG) MGetAttr(MUIA_NList_Prop_Visible);
}

template <class Type> void CTMUI_NList<Type>::SetQuiet(BOOL value) {
    SetAttr(MUIA_NList_Quiet, (IPTR) value);
}

template <class Type> BOOL CTMUI_NList<Type>::ShowDropMarks(void) const {
    return (BOOL) MGetAttr(MUIA_NList_ShowDropMarks);
}

template <class Type> void CTMUI_NList<Type>::SetShowDropMarks(BOOL value) {
    SetAttr(MUIA_NList_ShowDropMarks, (IPTR) value);
}

template <class Type> char * CTMUI_NList<Type>::SkipChars(void) const {
    return (char *) MGetAttr(MUIA_NList_SkipChars);
}

template <class Type> void CTMUI_NList<Type>::SetSkipChars(char * value) {
    SetAttr(MUIA_NList_SkipChars, (IPTR) value);
}

template <class Type> IPTR CTMUI_NList<Type>::TabSize(void) const {
    return (IPTR) MGetAttr(MUIA_NList_TabSize);
}

template <class Type> void CTMUI_NList<Type>::SetTabSize(IPTR value) {
    SetAttr(MUIA_NList_TabSize, (IPTR) value);
}

template <class Type> char * CTMUI_NList<Type>::Title(void) const {
    return (char *) MGetAttr(MUIA_NList_Title);
}

template <class Type> void CTMUI_NList<Type>::SetTitle(char * value) {
    SetAttr(MUIA_NList_Title, (IPTR) value);
}

template <class Type> BOOL CTMUI_NList<Type>::TitleSeparator(void) const {
    return (BOOL) MGetAttr(MUIA_NList_TitleSeparator);
}

template <class Type> void CTMUI_NList<Type>::SetTitleSeparator(BOOL value) {
    SetAttr(MUIA_NList_TitleSeparator, (IPTR) value);
}

template <class Type> void CTMUI_NList<Type>::SetTypeSelect(LONG value) {
    SetAttr(MUIA_NList_TypeSelect, (IPTR) value);
}

template <class Type> LONG CTMUI_NList<Type>::VertDeltaFactor(void) const {
    return (LONG) MGetAttr(MUIA_NList_VertDeltaFactor);
}

template <class Type> LONG CTMUI_NList<Type>::Visible(void) const {
    return (LONG) MGetAttr(MUIA_NList_Visible);
}

template <class Type> LONG CTMUI_NList<Type>::TitleBackground(void) const {
    return (LONG) MGetAttr(MUIA_NList_TitleBackground);
}

template <class Type> void CTMUI_NList<Type>::SetTitleBackground(LONG value) {
    SetAttr(MUIA_NList_TitleBackground, (IPTR) value);
}

template <class Type> LONG CTMUI_NList<Type>::TitlePen(void) const {
    return (LONG) MGetAttr(MUIA_NList_TitlePen);
}

template <class Type> void CTMUI_NList<Type>::SetTitlePen(LONG value) {
    SetAttr(MUIA_NList_TitlePen, (IPTR) value);
}

template <class Type> IPTR CTMUI_NList<Type>::Clear(void) {
    return MDoMethod(MUIM_NList_Clear);
}

template <class Type> IPTR CTMUI_NList<Type>::CopyToClip(LONG pos, IPTR clipnum) {
    return MDoMethod(MUIM_NList_CopyToClip, pos, clipnum);
}

template <class Type> IPTR CTMUI_NList<Type>::CreateImage(Object * imgobj, IPTR flags) {
    return MDoMethod(MUIM_NList_CreateImage, imgobj, flags);
}

template <class Type> IPTR CTMUI_NList<Type>::DeleteImage(APTR listimg) {
    return MDoMethod(MUIM_NList_DeleteImage, listimg);
}

template <class Type> IPTR CTMUI_NList<Type>::Exchange(LONG pos1, LONG pos2) {
    return MDoMethod(MUIM_NList_Exchange, pos1, pos2);
}

template <class Type> IPTR CTMUI_NList<Type>::GetEntry(LONG pos, Type * * entry) {
    return MDoMethod(MUIM_NList_GetEntry, pos, entry);
}

template <class Type> IPTR CTMUI_NList<Type>::GetEntryInfo(struct MUI_NList_GetEntryInfo * res) {
    return MDoMethod(MUIM_NList_GetEntryInfo, res);
}

template <class Type> IPTR CTMUI_NList<Type>::Insert(Type * * entries, LONG count, LONG pos) {
    return MDoMethod(MUIM_NList_Insert, entries, count, pos);
}

template <class Type> IPTR CTMUI_NList<Type>::InsertSingle(Type * entry, LONG pos) {
    return MDoMethod(MUIM_NList_InsertSingle, entry, pos);
}

template <class Type> IPTR CTMUI_NList<Type>::InsertSingleWrap(void) {
    return MDoMethod(MUIM_NList_InsertSingleWrap);
}

template <class Type> IPTR CTMUI_NList<Type>::InsertWrap(Type * * entries) {
    return MDoMethod(MUIM_NList_InsertWrap, entries);
}

template <class Type> IPTR CTMUI_NList<Type>::Jump(LONG pos) {
    return MDoMethod(MUIM_NList_Jump, pos);
}

template <class Type> IPTR CTMUI_NList<Type>::Move(LONG from, LONG to) {
    return MDoMethod(MUIM_NList_Move, from, to);
}

template <class Type> IPTR CTMUI_NList<Type>::NextSelected(LONG * pos) {
    return MDoMethod(MUIM_NList_NextSelected, pos);
}

template <class Type> IPTR CTMUI_NList<Type>::Redraw(LONG pos) {
    return MDoMethod(MUIM_NList_Redraw, pos);
}

template <class Type> IPTR CTMUI_NList<Type>::Remove(LONG pos) {
    return MDoMethod(MUIM_NList_Remove, pos);
}

template <class Type> IPTR CTMUI_NList<Type>::ReplaceSingle(LONG pos, LONG seltype, LONG * state) {
    return MDoMethod(MUIM_NList_ReplaceSingle, pos, seltype, state);
}

template <class Type> IPTR CTMUI_NList<Type>::Sort(void) {
    return MDoMethod(MUIM_NList_Sort);
}

template <class Type> IPTR CTMUI_NList<Type>::TestPos(LONG x, LONG y, struct MUI_NList_TestPos_Result * res) {
    return MDoMethod(MUIM_NList_TestPos, x, y, res);
}

template <class Type> IPTR CTMUI_NList<Type>::UseImage(Object * obj, IPTR imgnum, IPTR flags) {
    return MDoMethod(MUIM_NList_UseImage, obj, imgnum, flags);
}
