
/* 
 * File:   CTMUI_NListview.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 15 grudnia 2015, 00:11
 */

#include "CTMUI_NListview.h"

template<typename Type>
LONG CTMUI_NListview<Type>::ActivePage() const {
    return (LONG) this->MGetAttr(MUIA_Group_ActivePage);
}

template<typename Type>
CTMUI_NListview<Type>::CTMUI_NListview()
: CTMUI_NList<Type> () {
}

template<typename Type>
CTMUI_NListview<Type>::CTMUI_NListview(Tag tag1, ...)
: CTMUI_NList<Type> () {
    this->object = MUI_NewObjectA(MUIC_NListview, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (this->object == NULL)
        _MUIPPWarning("Could not create a CTMUI_NListview object\n");
#endif
}

template<typename Type>
CTMUI_NListview<Type>::CTMUI_NListview(Object* obj)
: CTMUI_NList<Type> () {
    this->object = obj;
}

template<typename Type>
List* CTMUI_NListview<Type>::ChildList() const {
    return (struct List *) this->MGetAttr(MUIA_Group_ChildList);
}

template<typename Type>
IPTR CTMUI_NListview<Type>::ExitChange() {
    return this->MDoMethod(MUIM_Group_ExitChange);
}

template<typename Type>
LONG CTMUI_NListview<Type>::HorizSpacing() const {
    return (LONG) this->MGetAttr(MUIA_Group_HorizSpacing);
}

template<typename Type>
Object* CTMUI_NListview<Type>::Horiz_ScrollBar() const {
    return (Object *) this->MGetAttr(MUIA_NListview_Horiz_ScrollBar);
}

template<typename Type>
IPTR CTMUI_NListview<Type>::InitChange() {
    return this->MDoMethod(MUIM_Group_InitChange);
}

template<typename Type>
Object* CTMUI_NListview<Type>::NList() const {
    return (Object *) this->MGetAttr(MUIA_NListview_NList);
}

template<typename Type>
void CTMUI_NListview<Type>::SetActivePage(LONG value) {
    this->SetAttr(MUIA_Group_ActivePage, (IPTR) value);
}

template<typename Type>
void CTMUI_NListview<Type>::SetColumns(LONG value) {
    this->SetAttr(MUIA_Group_Columns, (IPTR) value);
}

template<typename Type>
void CTMUI_NListview<Type>::SetHorizSpacing(LONG value) {
    this->SetAttr(MUIA_Group_HorizSpacing, (IPTR) value);
}

template<typename Type>
void CTMUI_NListview<Type>::SetHoriz_ScrollBar(Object* value) {
    this->SetAttr(MUIA_NListview_Horiz_ScrollBar, (IPTR) value);
}

template<typename Type>
void CTMUI_NListview<Type>::SetRows(LONG value) {
    this->SetAttr(MUIA_Group_Rows, (IPTR) value);
}

template<typename Type>
void CTMUI_NListview<Type>::SetSpacing(LONG value) {
    this->SetAttr(MUIA_Group_Spacing, (IPTR) value);
}

template<typename Type>
void CTMUI_NListview<Type>::SetVertSpacing(LONG value) {
    this->SetAttr(MUIA_Group_VertSpacing, (IPTR) value);
}

template<typename Type>
void CTMUI_NListview<Type>::SetVert_ScrollBar(Object* value) {
    this->SetAttr(MUIA_NListview_Vert_ScrollBar, (IPTR) value);
}

template<typename Type>
IPTR CTMUI_NListview<Type>::Sort(StartVarArgs sva, Object* obj, ...) {
    sva.methodID = MUIM_Group_Sort;
    return this->MDoMethodA((Msg) & sva);
}

template<typename Type>
LONG CTMUI_NListview<Type>::VertSpacing() const {
    return (LONG) this->MGetAttr(MUIA_Group_VertSpacing);
}

template<typename Type>
Object* CTMUI_NListview<Type>::Vert_ScrollBar() const {
    return (Object *) this->MGetAttr(MUIA_NListview_Vert_ScrollBar);
}

template<typename Type>
CTMUI_NListview<Type>& CTMUI_NListview<Type>::operator=(Object* obj) {
    this->object = obj;
    return *this;
}
