# FFT_All_Math.py
# Recursive Fast Fourier Transform for ANY Python Version from 1.4.0 to
# 3.13.0, as of 17-10-2024, on all platforms, without modification...
# $VER (C)2024_B.Walker_G0LCU,_FFT_All_Math.py_Version_1.00.00._CC0_Licence.
# Designed entirely around Python 1.4.0 for a STOCK AMIGA A1200(HD), minimum.

# The only modules and variables required for this DEMO.
import sys
# The builtin 'math' module IS needed, see below.
import math

PI = 3.141592653589793

# ******************************** FFT Begin. *******************************
# ************* Ensure 'import math' is used for these to work. *************
# ************ This class is required to create a complex pair. *************
# * This could be called C for short but left as is for understandability. **
class Complex_Pair:
	def __init__(self, Real=float(0), Imag=float(0)):
		# 'float()' is added below to ensure a floating point 'type'
		# but they are not absolutely necessary
		self.Real=float(Real)
		self.Imag=float(Imag)
		return
# * Recursive Fast Fourier Transform function using the math library only. ** 
def FFT(Complex_Array, Complex_Out, LENGTH=0, STEP=1):
	i=0
	JUMP=STEP*2
	if STEP<LENGTH:
		# Divide. Evens first......
		FFT(Complex_Out, Complex_Array, LENGTH, JUMP)
		# ......Odds next......
		FFT(Complex_Out[STEP:], Complex_Array[STEP:], LENGTH, JUMP)
		# ......and Conquer.
		while i<LENGTH:
			Complex_Pair.Real=math.cos(-PI*i/LENGTH)*Complex_Out[i+STEP].Real-math.sin(-PI*i/LENGTH)*Complex_Out[i+STEP].Imag
			Complex_Pair.Imag=math.sin(-PI*i/LENGTH)*Complex_Out[i+STEP].Real+math.cos(-PI*i/LENGTH)*Complex_Out[i+STEP].Imag
			Complex_Array[int(i/2)].Real=Complex_Out[i].Real+Complex_Pair.Real
			Complex_Array[int((i+LENGTH)/2)].Real=Complex_Out[i].Real-Complex_Pair.Real
			Complex_Array[int(i/2)].Imag=Complex_Out[i].Imag+Complex_Pair.Imag
			Complex_Array[int((i+LENGTH)/2)].Imag=Complex_Out[i].Imag-Complex_Pair.Imag
			i=i+JUMP
	return
# ************** Recursive Fast Fourier TransFor function end. **************
# ********************************* FFT End. ********************************

# ***************************************************************************
# ******************************* HOW TO USE:- ******************************
# Create two identical lists of complex pair values, RADIX 2 in size...
# Name one as 'Complex_Array' and the other as 'Complex_Out'.
# Shorten Complex_Pair to make life more simple. The Class above could be
# shotened to C but left as is so that it is understandable.
C=Complex_Pair
Complex_Array=[C(1,0), C(1,0), C(1,0), C(1,0), C(1,0), C(1,0), C(0,0), C(0,0), C(0,0), C(0,0), C(0,0), C(0,0), C(1,0), C(0.5,0), C(0.5,0), C(0.5,0)]
Complex_Out=[C(1,0), C(1,0), C(1,0), C(1,0), C(1,0), C(1,0), C(0,0), C(0,0), C(0,0), C(0,0), C(0,0), C(0,0), C(1,0), C(0.5,0), C(0.5,0), C(0.5,0)]
#
# ******* These are the same as above but with Complex_Pair left in. ********
#Complex_Array=[Complex_Pair(1.0, 0.0), Complex_Pair(1.0, 0.0), Complex_Pair(1.0, 0.0), Complex_Pair(1.0, 0.0), Complex_Pair(1.0, 0.0), Complex_Pair(1.0, 0.0), Complex_Pair(0.0, 0.0), Complex_Pair(0.0, 0.0), Complex_Pair(0.0, 0.0), Complex_Pair(0.0, 0.0), Complex_Pair(0.0, 0.0), Complex_Pair(0.0, 0.0), Complex_Pair(1.0, 0.0), Complex_Pair(0.5, 0.0), Complex_Pair(0.5, 0.0), Complex_Pair(0.5, 0.0)]
#
#Complex_Out=[Complex_Pair(1.0, 0.0), Complex_Pair(1.0, 0.0), Complex_Pair(1.0, 0.0), Complex_Pair(1.0, 0.0), Complex_Pair(1.0, 0.0), Complex_Pair(1.0, 0.0), Complex_Pair(0.0, 0.0), Complex_Pair(0.0, 0.0), Complex_Pair(0.0, 0.0), Complex_Pair(0.0, 0.0), Complex_Pair(0.0, 0.0), Complex_Pair(0.0, 0.0), Complex_Pair(1.0, 0.0), Complex_Pair(0.5, 0.0), Complex_Pair(0.5, 0.0), Complex_Pair(0.5, 0.0)]
# ***************************************************************************

LENGTH=len(Complex_Array)

# Ensure the arrays are RADIX 2, (powers of 2), in size and the same length!
if LENGTH&(LENGTH-1)!=0:
	print("Power of 2 ERROR!")
	print("Padding or cropping is required to the nearest power of 2 elements.")
	print("Exiting with a return code of 1!")
	sys.exit(1)

FFT(Complex_Array, Complex_Out, LENGTH)
# ***************************************************************************

# *********** Just a printout to the screen to show the results! ************
print("\nFFT array values to 10 decimal places:-")
print("     Real:	Imaginary:")
for i in range(0,LENGTH,1):
	# Use 'j' in the results instead of 'i' to remove confusion.
	if Complex_Array[i].Imag>=0.0:
		print("(%.10f+%.10fj)" %(Complex_Array[i].Real, Complex_Array[i].Imag))
	else:
		print("(%.10f-%.10fj)" %(Complex_Array[i].Real, abs(Complex_Array[i].Imag)))
# Also a printout of the absolute values!
print("\nAbsolute values to 5 places of decimals:")
for i in range(0,LENGTH,1):
	print("%.5f " % abs(math.sqrt(Complex_Array[i].Real*Complex_Array[i].Real+Complex_Array[i].Imag*Complex_Array[i].Imag)))
print("")

sys.exit(0)

# ***************************************************************************
# What to expect on screen...
#
# FFT array values to 10 decimal places:-
#      Real:	Imaginary:
# (8.5000000000+0.0000000000j)
# (3.6378211867-1.9307144055j)
# (-1.7071067812-0.5000000000j)
# (0.0514252105-0.2414680083j)
# (1.5000000000-1.0000000000j)
# (-0.1727455541+0.4656387729j)
# (-0.2928932188+0.5000000000j)
# (0.4834991568-1.2236076244j)
# (0.5000000000+0.0000000000j)
# (0.4834991568+1.2236076244j)
# (-0.2928932188-0.5000000000j)
# (-0.1727455541-0.4656387729j)
# (1.5000000000+1.0000000000j)
# (0.0514252105+0.2414680083j)
# (-1.7071067812+0.5000000000j)
# (3.6378211867+1.9307144055j)
#
# Absolute values to 5 places of decimals:
# 8.50000 
# 4.11842 
# 1.77882 
# 0.24688 
# 1.80278 
# 0.49665 
# 0.57947 
# 1.31567 
# 0.50000 
# 1.31567 
# 0.57947 
# 0.49665 
# 1.80278 
# 0.24688 
# 1.77882 
# 4.11842 
# ***************************************************************************

