#ifdef __amigaos4__
    #define __USE_INLINE__ // define this as early as possible
#endif
#ifdef __AROS__
    #define chip
    #define __chip
    #define far
#endif

#include <proto/graphics.h>
#include <proto/intuition.h>

#include <exec/types.h>
#include <intuition/intuition.h>

#include <stdlib.h>        // size_t

#include "shared.h"
#include "amiga.h"
#include "ww.h"

EXPORT UBYTE          remapit[16];

IMPORT FLAG           customscreen,
                      gotpen[16],
                      morphos;
IMPORT ULONG          WindowWidth,
                      WindowHeight;
IMPORT int            xoffset, yoffset;
IMPORT struct Image   About,
                      Background1,
                      Background2,
                      Logo,
                      Squares;
IMPORT struct Window *MainWindowPtr,
                     *HelpWindowPtr;
IMPORT struct Screen* ScreenPtr;
IMPORT UWORD          OriginalSquaresData[ARRAYSIZE + 1][SQUAREY * DEPTH];
IMPORT UWORD          OCSColours[16];
IMPORT UWORD         *AboutData,
                     *Background1Data,
                     *Background2Data,
                     *BoingData[6],
                     *LogoData,
                     *SquaresData[ARRAYSIZE + 1];

EXPORT UWORD OriginalLogoData[8360] = {
  0xF000,0x0000,0x0078,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xF000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0000,0x0078,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x000F,0xFFFF,0xFFFF,0xFC00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0300,0x0078,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0010,0x000F,0xFFFF,0xFFFF,0xFE00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0FC0,0x0078,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xFFFF,0xFFFF,0xFE00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x1FE0,0x0078,0x0000,0x0000,0x0000,0x0000,0x000F,0xFFFF,0xFC08,0x001F,0xFFFF,0xFFFF,0xFF00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x3FF0,0x0078,0x0000,0x0000,0x0000,0x0000,0x000F,0xFFFF,0xFE0C,0x001F,0xFFFF,0xFFFF,0xFF80,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x3B70,0x0078,0x0000,0x0000,0x0000,0x0000,0x000F,0xFFFF,0xFF0E,0x001F,0xFFFF,0xFFFF,0xFFC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x3FF0,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x000E,0x001F,0xE001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x1FE0,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x000E,0x001F,0xE001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x000E,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x000E,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x000E,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x000E,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x000E,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x007E,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x003E,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x001E,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x000E,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x0002,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x039C,0x0000,0x0000,0x001F,0xC007,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x030C,0x0000,0x0000,0x001F,0xC00F,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF800,0x0780,0x00F8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xC00E,0xDC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFC00,0x0780,0x01F8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xC00F,0xFC00,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFFFF,0xFFFF,0xFFF8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xC007,0xF800,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x7FFF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xC003,0xF000,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x7FFF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xC000,0xC000,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x1FFF,0xFFFF,0xFFC0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xC000,0x0000,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xC000,0x0000,0x1FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x000F,0xC000,0x0000,0x0FC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xC000,0x0000,0x07C0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xC000,0x0000,0x03C0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0001,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xE000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xF000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0001,0xFFFF,0xFFFF,0x7000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0000,0x0078,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xF800,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF800,0x0000,0x007C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x000F,0xFFFF,0xFFFF,0xF800,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFC00,0x0300,0x007E,0x0000,0x0800,0x0000,0x0080,0x0000,0x0000,0x0000,0x000F,0xFFFF,0xFFFF,0x7000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x0FC0,0x007F,0x0000,0x1BFF,0xFFFF,0xC000,0x0000,0x0000,0x0000,0x001F,0xC000,0x0003,0xF000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x1FE0,0x007F,0x0000,0x1BFF,0xFFFF,0xF040,0x0000,0x0000,0x0000,0x001F,0x0000,0x0003,0xE000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x3FF0,0x007F,0x0000,0x07FF,0xFFFF,0xF060,0x0000,0x0000,0x0000,0x001F,0x0000,0x0001,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x3B70,0x007F,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x3FF0,0x007F,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x1FF0,0x007F,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x001F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x001F,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x001F,0xFFFF,0xFFFF,0xE000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x000F,0xFFFF,0xFFFF,0xF000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x000F,0xFFFF,0xFFFF,0xFC00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFC00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x0FFF,0xFFFF,0xF870,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFE00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x3FFF,0xFFFF,0xF870,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3E00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x3FFF,0xFFFF,0xF870,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3E00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x7E00,0x0000,0x0070,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x7800,0x0000,0x0070,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x7800,0x0000,0x0070,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x7000,0x0000,0x0070,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x7000,0x0000,0x0070,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x7000,0x0000,0x0070,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x7000,0x0000,0x0070,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x7000,0x0000,0x0070,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x7000,0x0000,0x0070,0x039C,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x007F,0x0000,0x7000,0x0000,0x0070,0x030C,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x00FF,0x0000,0x3000,0x0000,0x0070,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3E00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x07F0,0x01FF,0x0000,0x3000,0x0000,0x0070,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7E00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFFFF,0xFFFF,0xFFFF,0x0000,0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x001F,0xFFFF,0xFFFF,0xFE00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x7FFF,0xFFFF,0xFFFF,0x0000,0x0000,0x0000,0x00F0,0x0000,0x0000,0x0000,0x001F,0xFFFF,0xFFFF,0xFC00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x7FFF,0xFFFF,0xFFFF,0x0000,0x0000,0x0000,0x00F0,0x0000,0x0000,0x0000,0x001F,0xFFFF,0xFFFF,0xFC00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x3FFF,0xFFFF,0xFFFF,0x0000,0x0000,0x0000,0x03F0,0x0000,0x0000,0x0000,0x001F,0xFFFF,0xFFFF,0xF000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0FFF,0xFFFF,0xFFFE,0x0000,0x7FFF,0xFFFF,0xFFE0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x07FF,0xFFFF,0xFFFE,0x0000,0x3FFF,0xFFFF,0xFFE0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x03FF,0xFFFF,0xFFF8,0x0000,0x1FFF,0xFFFF,0xFF80,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  /* Plane 1 */
  0xF000,0x0300,0x0078,0x0000,0xFFFF,0xFFFF,0xFC00,0x00FF,0xFFFF,0xFF80,0x0003,0xFFFF,0xFFFF,0xF000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF800,0x0300,0x007C,0x0003,0xFFFF,0xFFFF,0xFF00,0x00FF,0xFFFF,0xFFE0,0x000F,0xFFFF,0xFFFF,0xFC00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFC00,0x0300,0x007E,0x0003,0xFFFF,0xFFFF,0xFF00,0x00FF,0xFFFF,0xFFE0,0x000F,0xFFFF,0xFFFF,0xFE00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x0FC0,0x007F,0x0007,0xFFFF,0xFFFF,0xFF80,0x00FF,0xFFFF,0xFFF0,0x001F,0xFFFF,0xFFFF,0xFE00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xFE00,0x1FE0,0x007F,0x0007,0xE000,0x0000,0x1F80,0x00F0,0x0000,0x03F0,0x001F,0xFFFF,0xFFFF,0xFF00,0x0000,0x0FFF,0xFFFF,0xFF80,0x0000,
  0xFE00,0x3FF0,0x007F,0x0007,0xC000,0x0000,0x0F80,0x00F0,0x0000,0x01F0,0x001F,0xFFFF,0xFFFF,0xFF80,0x0000,0x1FFF,0xFFFF,0xFFC0,0x0000,
  0xFE00,0x3B70,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x00F0,0x001F,0xFFFF,0xFFFF,0xFFC0,0x0000,0x3FFF,0xFFFF,0xFFE0,0x0000,
  0xFE00,0x3FF0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x00F0,0x001F,0xE001,0xFC00,0x1FC0,0x0000,0x7FFF,0xFFFF,0xFFF0,0x0000,
  0xFE00,0x1FF0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x00F0,0x001F,0xE001,0xFC00,0x1FC0,0x0000,0xFFFF,0xFFFF,0xFFF8,0x0000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x00F0,0x001F,0xC001,0xFC00,0x1FC0,0x0001,0xFFC0,0x0000,0x1FFC,0x0000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x00F0,0x001F,0xC001,0xFC00,0x1FC0,0x0003,0xFF80,0x0000,0x0FFE,0x0000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x00F0,0x001F,0xC001,0xFC00,0x1FC0,0x0007,0xFF00,0x0000,0x07FF,0x0000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x00F0,0x001F,0xC001,0xFC00,0x1FC0,0x000F,0xFE00,0x0000,0x03FF,0x8000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x00F0,0x001F,0xC001,0xFC00,0x1FC0,0x001F,0xFC00,0x0000,0x01FF,0xC000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x003F,0xF800,0x0000,0x00FF,0xE000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x007F,0xF000,0x0000,0x007F,0xF000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x007F,0xE000,0x0000,0x003F,0xF000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x007F,0xC000,0x0000,0x001F,0xF000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x007F,0x8000,0x0000,0x000F,0xF000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x007F,0x8000,0x0000,0x000F,0xF000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x007F,0x8000,0x0000,0x000F,0xF000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x003F,0x8000,0x0000,0x000F,0xE000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x003F,0x8000,0x0000,0x000F,0xE000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x003F,0xC000,0x0000,0x000F,0xE000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x003F,0xC000,0x0000,0x001F,0xE000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x003F,0xC000,0x0000,0x001F,0xE000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x003F,0xC000,0x0000,0x001F,0xE000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x003F,0xC000,0x0000,0x001F,0xE000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x001F,0xC000,0x0000,0x001F,0xE000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x001F,0xC000,0x0000,0x001F,0xC000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x001F,0xC000,0x0000,0x001F,0xC000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x001F,0xE000,0x0000,0x001F,0xC000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x001F,0xE000,0x0000,0x003F,0xC000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x001F,0xE000,0x0000,0x003F,0xC000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x001F,0xE000,0x0000,0x003F,0xC000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x03FC,0x0000,0x0000,0x001F,0xC001,0xFC00,0x1FC0,0x001F,0xE000,0x0000,0x003F,0xC000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x07FE,0x0000,0x0000,0x001F,0xC007,0xFC00,0x1FC0,0x000F,0xE000,0x0000,0x003F,0xC000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x076E,0x0000,0x0000,0x001F,0xC00F,0xFC00,0x1FC0,0x000F,0xE000,0x0000,0x003F,0x8000,
  0xFE00,0x07F0,0x00FF,0x0007,0xC000,0x0000,0x0F80,0x07FE,0x0000,0x0000,0x001F,0xC00E,0xDC00,0x1FC0,0x000F,0xF000,0x0000,0x003F,0x8000,
  0xFE00,0x07F0,0x01FF,0x0007,0xE000,0x0000,0x1F80,0x03FC,0x0000,0x0000,0x001F,0xC00F,0xFC00,0x1FC0,0x000F,0xF000,0x0000,0x003F,0x8000,
  0xFFFF,0xFFFF,0xFFFF,0x0007,0xFFFF,0xFFFF,0xFF80,0x01F8,0x0000,0x0000,0x001F,0xC007,0xF800,0x1FC0,0x000F,0xF000,0x0000,0x007F,0x8000,
  0x7FFF,0xFFFF,0xFFFF,0x0003,0xFFFF,0xFFFF,0xFF00,0x0060,0x0000,0x0000,0x001F,0xC003,0xF000,0x1FC0,0x000F,0xF000,0x0000,0x007F,0x8000,
  0x7FFF,0xFFFF,0xFFFF,0x0003,0xFFFF,0xFFFF,0xFF00,0x0060,0x0000,0x0000,0x001F,0xC000,0xC000,0x1FC0,0x000F,0xF000,0x0000,0x007F,0x8000,
  0x1FFF,0xFFFF,0xFFFF,0x0001,0xFFFF,0xFFFF,0xFC00,0x0060,0x0000,0x0000,0x001F,0xC000,0xC000,0x1FC0,0x0007,0xF000,0x0000,0x007F,0x8000,
  0x0FFF,0xFFFF,0xFFFE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xC000,0xC000,0x1FC0,0x0007,0xF000,0x0000,0x007F,0x8000,
  0x07FF,0xFFFF,0xFFFE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x000F,0xC000,0x0000,0x0FC0,0x0007,0xF000,0x0000,0x007F,0x0000,
  0x03FF,0xFFFF,0xFFF8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xC000,0x0000,0x07C0,0x0007,0xF800,0x0000,0x007F,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xC000,0x0000,0x03C0,0x0007,0xF800,0x0000,0x00FF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xF800,0x0000,0x00FF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xF800,0x0000,0x00FF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xFFFF,0xFFFF,0xFFFF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFFF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFFE,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFFE,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFFE,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFFE,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00FF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00FF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0001,0xC000,0x0000,0x0000,0x0000,0x00FF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x7C00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xE000,0x0000,0x0000,0x0000,0x00FF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0xFC00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xF000,0x0000,0x0000,0x0000,0x00FF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0xEFFF,0xFFFF,0xF800,0x00FF,0xFFFF,0xFF00,0x0001,0xFFFF,0xFFFF,0x7000,0x0000,0x0000,0x0000,0x007F,0x0000,
  0xF000,0x0300,0x0078,0x0007,0xFFFF,0xFFFF,0xFC00,0x00FF,0xFFFF,0xFF80,0x0003,0xFFFF,0xFFFF,0xFE00,0x0000,0x0000,0x0000,0x007F,0x0000,
  0xF800,0x0300,0x007C,0x0007,0xFFFF,0xFFFF,0xFF00,0x00FF,0xFFFF,0xFFE0,0x000F,0xFFFF,0xFFFF,0xFE00,0x0000,0x0000,0x0000,0x007F,0x8000,
  0xFC00,0x0300,0x007E,0x0000,0xEFFF,0xFFFF,0xFF00,0x00FF,0xFFFF,0xFFE0,0x000F,0xFFFF,0xFFFF,0x7000,0x0000,0x0000,0x0000,0x007F,0x8000,
  0xFE00,0x0FC0,0x007F,0x0000,0xFC00,0x0000,0x3F80,0x00F0,0x0000,0x07F0,0x001F,0xFFFF,0xFFFF,0xF000,0x0000,0x0000,0x0000,0x007F,0x8000,
  0xFE00,0x1FE0,0x007F,0x0000,0x7C00,0x0000,0x0F80,0x00F0,0x0000,0x01F0,0x001F,0xFFFF,0xFFFF,0xE000,0x0000,0x0000,0x0000,0x007F,0x8000,
  0xFE00,0x3FF0,0x007F,0x0000,0x3800,0x0000,0x0F80,0x00F0,0x0000,0x01F0,0x001F,0xFFFF,0xFFFF,0xC000,0x0000,0x0000,0x0000,0x007F,0x8000,
  0xFE00,0x3B70,0x007F,0x0000,0x0000,0x0000,0x0780,0x00F0,0x0000,0x00F0,0x001F,0xF800,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0x8000,
  0xFE00,0x3FF0,0x007F,0x0000,0x0000,0x0000,0x0780,0x00F0,0x0000,0x00F0,0x001F,0xE000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0x8000,
  0xFE00,0x1FF0,0x007F,0x0000,0x0000,0x0000,0x0780,0x00F0,0x0000,0x00F0,0x001F,0xE000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xC000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0780,0x00F0,0x0000,0x00F0,0x001F,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xC000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0780,0x00F0,0x0000,0x00F0,0x001F,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xC000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0780,0x00F0,0x0000,0x00F0,0x001F,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xC000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0780,0x00F0,0x0000,0x00F0,0x001F,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xC000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0780,0x00F0,0x0000,0x00F0,0x001F,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xC000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xC000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xC000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xE000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xE000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xE000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xE000,
  0xFE00,0x07F0,0x007F,0x0000,0x0000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x001F,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xE000,
  0xFE00,0x07F0,0x007F,0x0000,0x7FFF,0xFFFF,0xFF80,0x00F0,0x0000,0x0000,0x001F,0xFFFF,0xFFFF,0xE000,0x0000,0x0000,0x0000,0x000F,0xE000,
  0xFE00,0x07F0,0x007F,0x0000,0xFFFF,0xFFFF,0xFF80,0x00F0,0x0000,0x0000,0x000F,0xFFFF,0xFFFF,0xF000,0x0000,0x0000,0x0000,0x000F,0xE000,
  0xFE00,0x07F0,0x007F,0x0003,0xFFFF,0xFFFF,0xFF80,0x00F0,0x0000,0x0000,0x000F,0xFFFF,0xFFFF,0xFC00,0x0000,0x0000,0x0000,0x000F,0xF000,
  0xFE00,0x07F0,0x007F,0x0003,0xFFFF,0xFFFF,0xFF80,0x00F0,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFC00,0x0000,0x0000,0x0000,0x000F,0xF000,
  0xFE00,0x07F0,0x007F,0x0007,0xF000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x0001,0xFFFF,0xFFFF,0xFE00,0x0000,0x0000,0x0000,0x000F,0xF000,
  0xFE00,0x07F0,0x007F,0x0007,0xC000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x0000,0xFFFF,0xFFFF,0xFF00,0x0001,0x8000,0x0000,0x001F,0xF000,
  0xFE00,0x07F0,0x007F,0x0007,0xC000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x0000,0x7FFF,0xFFFF,0xFF80,0x0007,0xC000,0x0000,0x003F,0xF000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x1FC0,0x001F,0xE000,0x0000,0x007F,0xF000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x1FC0,0x007F,0xF000,0x0000,0x00FF,0xE000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x1FC0,0x003F,0xF800,0x0000,0x01FF,0xC000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x1FC0,0x001F,0xFC00,0x0000,0x03FF,0x8000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x1FC0,0x000F,0xFE00,0x0000,0x07FF,0x0000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x1FC0,0x0007,0xFF00,0x0000,0x0FFE,0x0000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x00F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x1FC0,0x0003,0xFFFF,0xFFFF,0xFFFC,0x0000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x03FC,0x0000,0x0000,0x0000,0x0000,0x0000,0x1FC0,0x0001,0xFFFF,0xFFFF,0xFFF8,0x0000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x07FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x1FC0,0x0000,0xFFFF,0xFFFF,0xFFF0,0x0000,
  0xFE00,0x07F0,0x007F,0x0007,0x8000,0x0000,0x0780,0x076E,0x0000,0x0000,0x0000,0x0000,0x0000,0x1FC0,0x0000,0x7FFF,0xFFFF,0xFFE0,0x0000,
  0xFE00,0x07F0,0x00FF,0x0007,0xC000,0x0000,0x0F80,0x07FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x3FC0,0x0000,0x3FFF,0xFFFF,0xFFC0,0x0000,
  0xFE00,0x07F0,0x01FF,0x0007,0xC000,0x0000,0x0F80,0x03FC,0x0000,0x0000,0x0000,0x0000,0x0000,0x7FC0,0x0000,0x1FFF,0xFFFF,0xFF80,0x0000,
  0xFFFF,0xFFFF,0xFFFF,0x0007,0xFFFF,0xFFFF,0xFF80,0x01F8,0x0000,0x0000,0x001F,0xFFFF,0xFFFF,0xFFC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x7FFF,0xFFFF,0xFFFF,0x0003,0xFFFF,0xFFFF,0xFF00,0x0060,0x0000,0x0000,0x001F,0xFFFF,0xFFFF,0xFFC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x7FFF,0xFFFF,0xFFFF,0x0003,0xFFFF,0xFFFF,0xFF00,0x0060,0x0000,0x0000,0x001F,0xFFFF,0xFFFF,0xFFC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x3FFF,0xFFFF,0xFFFF,0x0000,0xFFFF,0xFFFF,0xFC00,0x0060,0x0000,0x0000,0x001F,0xFFFF,0xFFFF,0xFFC0,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0FFF,0xFFFF,0xFFFE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x000F,0xFFFF,0xFFFF,0xFF80,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x07FF,0xFFFF,0xFFFE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xFFFF,0xFFFF,0xFF80,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x03FF,0xFFFF,0xFFF8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFE00,0x0000,0x0000,0x0000,0x0000,0x0000,
  /* Plane 2 */
  0xF000,0x0000,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FF,0xFFFF,0xFF80,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0000,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FF,0xFFFF,0xFFE0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0300,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x0FC0,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0xF000,0x1FE0,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FF,0xFFFF,0xFFF8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0FFF,0xFFFF,0xFF80,0x0000,
  0xF000,0x3FF0,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FF,0xFFFF,0xFFFC,0x0000,0x0000,0x0000,0x0000,0x0000,0x1FFF,0xFFFF,0xFFC0,0x0000,
  0xF000,0x3B70,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FF,0xFFFF,0xFFFE,0x0000,0x0000,0x0000,0x0000,0x0000,0x3FFF,0xFFFF,0xFFE0,0x0000,
  0xF000,0x3FF0,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x7FFF,0xFFFF,0xFFF0,0x0000,
  0xF000,0x1FE0,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0xFFFF,0xFFFF,0xFFF8,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0001,0xFFFF,0xFFFF,0xFFFC,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFFE,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0007,0xFFFF,0xFFFF,0xFFFF,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x000F,0xFFE0,0x0000,0x03FF,0x8000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x001F,0xFFC0,0x0000,0x01FF,0xC000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x007E,0x0000,0x0000,0x0000,0x0000,0x003F,0xFF80,0x0000,0x00FF,0xE000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x003E,0x0000,0x0000,0x0000,0x0000,0x007F,0xFF00,0x0000,0x007F,0xF000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x007F,0xFE00,0x0000,0x003F,0xF800,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x007F,0xFC00,0x0000,0x001F,0xFC00,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x007F,0xF800,0x0000,0x000F,0xFE00,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x007F,0xF000,0x0000,0x000F,0xFE00,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x007F,0xF000,0x0000,0x000F,0xFE00,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xF000,0x0000,0x000F,0xFE00,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xF000,0x0000,0x000F,0xFE00,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xF000,0x0000,0x000F,0xFE00,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xF000,0x0000,0x001F,0xFC00,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xF000,0x0000,0x001F,0xFC00,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xF800,0x0000,0x001F,0xFC00,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xF800,0x0000,0x001F,0xFC00,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xF800,0x0000,0x001F,0xFC00,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xF800,0x0000,0x001F,0xFC00,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xF800,0x0000,0x001F,0xFC00,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xF800,0x0000,0x001F,0xFC00,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xF800,0x0000,0x003F,0xF800,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xF800,0x0000,0x003F,0xF800,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xFC00,0x0000,0x003F,0xF800,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x03FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xFC00,0x0000,0x003F,0xF800,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x07FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x000F,0xFC00,0x0000,0x003F,0xF800,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x076E,0x0000,0x0000,0x0000,0x0007,0x3800,0x0000,0x000F,0xFC00,0x0000,0x003F,0xF800,
  0xF800,0x0780,0x00F8,0x0000,0x0000,0x0000,0x0000,0x07FE,0x0000,0x0000,0x0000,0x0006,0x1800,0x0000,0x000F,0xFC00,0x0000,0x003F,0xF800,
  0xFC00,0x0780,0x01F8,0x0000,0x0000,0x0000,0x0000,0x03FC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x000F,0xFC00,0x0000,0x003F,0xF800,
  0xFFFF,0xFFFF,0xFFF8,0x0000,0x0000,0x0000,0x0000,0x01F8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x000F,0xFC00,0x0000,0x007F,0xF000,
  0x7FFF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x0000,0x0060,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x000F,0xFE00,0x0000,0x007F,0xF000,
  0x7FFF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x000F,0xFE00,0x0000,0x007F,0xF000,
  0x3FFF,0xFFFF,0xFFC0,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC000,0x0000,0x0007,0xFE00,0x0000,0x007F,0xF000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC000,0x0000,0x0007,0xFE00,0x0000,0x007F,0xF000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xFE00,0x0000,0x007F,0xF000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xFE00,0x0000,0x007F,0xF000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xFE00,0x0000,0x00FF,0xF000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xFE00,0x0000,0x00FF,0xE000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xFF00,0x0000,0x00FF,0xE000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xFFFF,0xFFFF,0xFFFF,0xE000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFFF,0xE000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFFF,0xE000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFFF,0xE000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFFF,0xE000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFFF,0xC000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0001,0xFFFF,0xFFFF,0xFFFF,0xC000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFFFF,0xFFFF,0xFFFF,0xC000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7FFF,0xFFFF,0xFFFF,0xC000,
  0x0000,0x0000,0x0000,0x0000,0x3800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0001,0xC000,0x0000,0x0000,0x0000,0x00FF,0xC000,
  0x0000,0x0000,0x0000,0x0000,0x7C00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xE000,0x0000,0x0000,0x0000,0x00FF,0xE000,
  0x0000,0x0000,0x0000,0x0000,0xFC00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xF000,0x0000,0x0000,0x0000,0x00FF,0xE000,
  0x0000,0x0000,0x0000,0x0000,0xEFFF,0xFFFF,0xF800,0x0000,0x0000,0x0000,0x0001,0xFFFF,0xFFFF,0x7000,0x0000,0x0000,0x0000,0x007F,0xE000,
  0x0000,0x0300,0x0000,0x0001,0xFFFF,0xFFFF,0xFC00,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xF800,0x0000,0x0000,0x0000,0x007F,0xE000,
  0x0000,0x0300,0x0000,0x0001,0xFFFF,0xFFFF,0xFF00,0x0000,0x0000,0x0000,0x000F,0xFFFF,0xFFFF,0xF800,0x0000,0x0000,0x0000,0x007F,0xE000,
  0x0000,0x0000,0x0000,0x0000,0xEFFF,0xFFFF,0xFF80,0x0000,0x0000,0x0000,0x000F,0xFFFF,0xFFFF,0x7000,0x0000,0x0000,0x0000,0x007F,0xE000,
  0x0000,0x0000,0x0000,0x0000,0xFFFF,0xFFFF,0xFF80,0x0000,0x0000,0x0000,0x001F,0xC000,0x0003,0xF000,0x0000,0x0000,0x0000,0x007F,0xE000,
  0x0000,0x0000,0x0000,0x0000,0x7FFF,0xFFFF,0xFFC0,0x0000,0x0000,0x0000,0x001F,0x0000,0x0003,0xE000,0x0000,0x0000,0x0000,0x007F,0xF000,
  0x0000,0x0000,0x0000,0x0000,0x3FFF,0xFFFF,0xFFE0,0x0000,0x0000,0x0000,0x001F,0x0000,0x0001,0xC000,0x0000,0x0000,0x0000,0x007F,0xF000,
  0x0000,0x1860,0x0000,0x0000,0x0000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xF000,
  0x0000,0x1CE0,0x0000,0x0000,0x0000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xF000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xF000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xF000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xF000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xF800,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xF800,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xF800,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xF800,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xF800,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xF800,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xF800,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xF800,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xFC00,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001F,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xFC00,
  0x0000,0x0000,0x0000,0x0000,0x7FFF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x001F,0xFFFF,0xFFFF,0xE000,0x0000,0x0000,0x0000,0x000F,0xFC00,
  0x0000,0x0000,0x0000,0x0000,0xFFFF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x000F,0xFFFF,0xFFFF,0xF000,0x0000,0x0000,0x0000,0x000F,0xFC00,
  0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x000F,0xFFFF,0xFFFF,0xFC00,0x0000,0x0000,0x0000,0x000F,0xFC00,
  0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x0007,0xFFFF,0xFFFF,0xFE00,0x0000,0x0000,0x0000,0x000F,0xFC00,
  0x0000,0x0000,0x0000,0x0007,0xFFFF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFE00,0x0000,0x0000,0x0000,0x000F,0xFC00,
  0x0000,0x0000,0x0000,0x0007,0xFFFF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3E00,0x0001,0x8000,0x0000,0x001F,0xFE00,
  0x0000,0x0000,0x0000,0x0007,0xFFFF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3E00,0x0007,0xC000,0x0000,0x003F,0xFE00,
  0x0000,0x0000,0x0000,0x0007,0xFE00,0x0000,0x07F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x001F,0xE000,0x0000,0x007F,0xFE00,
  0x0000,0x0000,0x0000,0x0007,0xF800,0x0000,0x07F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x007F,0xF000,0x0000,0x00FF,0xFC00,
  0x0000,0x0000,0x0000,0x0007,0xF800,0x0000,0x07F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x003F,0xF800,0x0000,0x01FF,0xF800,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x001F,0xFC00,0x0000,0x03FF,0xF000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x000F,0xFE00,0x0000,0x07FF,0xE000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x0007,0xFF00,0x0000,0x0FFF,0xC000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x0003,0xFFFF,0xFFFF,0xFFFF,0x8000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x0001,0xFFFF,0xFFFF,0xFFFF,0x0000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x039C,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x0000,0xFFFF,0xFFFF,0xFFFE,0x0000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x030C,0x0000,0x0000,0x0000,0x0000,0x0000,0x1E00,0x0000,0x7FFF,0xFFFF,0xFFFC,0x0000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x0FF0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3E00,0x0000,0x3FFF,0xFFFF,0xFFF8,0x0000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x0FF0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7E00,0x0000,0x1FFF,0xFFFF,0xFFF0,0x0000,
  0x0000,0x0000,0x0000,0x0007,0xFFFF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x001F,0xFFFF,0xFFFF,0xFE00,0x0000,0x0FFF,0xFFFF,0xFFE0,0x0000,
  0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x001F,0xFFFF,0xFFFF,0xFC00,0x0000,0x07FF,0xFFFF,0xFFC0,0x0000,
  0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFF0,0x0060,0x0000,0x0000,0x001F,0xFFFF,0xFFFF,0xFC00,0x0000,0x03FF,0xFFFF,0xFF80,0x0000,
  0x0000,0x0000,0x0000,0x0001,0xFFFF,0xFFFF,0xFFF0,0x0060,0x0000,0x0000,0x001F,0xFFFF,0xFFFF,0xF000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x7FFF,0xFFFF,0xFFE0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x3FFF,0xFFFF,0xFFE0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x1FFF,0xFFFF,0xFF80,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  /* Plane 3 */
  0x0000,0x0300,0x0000,0x0000,0xFFFF,0xFFFF,0xFC00,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xF000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0300,0x0000,0x0003,0xFFFF,0xFFFF,0xFF00,0x0000,0x0000,0x0000,0x000F,0xFFFF,0xFFFF,0xFC00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFF80,0x0000,0x0000,0x0000,0x000F,0xFFFF,0xFFFF,0xFC00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0007,0xFFFF,0xFFFF,0xFF80,0x0000,0x0000,0x0000,0x001F,0xFFFF,0xFFFF,0xFE00,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0007,0xFFFF,0xFFFF,0xFFC0,0x0000,0x0000,0x0000,0x001F,0x8001,0xE000,0x7E00,0x0000,0x0FFF,0xFFFF,0xFF80,0x0000,
  0x0000,0x0000,0x0000,0x0007,0xFFFF,0xFFFF,0xFFE0,0x0000,0x0000,0x0000,0x001F,0x0001,0xE000,0x3E00,0x0000,0x1FFF,0xFFFF,0xFFC0,0x0000,
  0x0000,0x1860,0x0000,0x0007,0xFFFF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x0000,0x3FFF,0xFFFF,0xFFE0,0x0000,
  0x0000,0x1CE0,0x0000,0x0007,0xFC00,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x0000,0x7FFF,0xFFFF,0xFFF0,0x0000,
  0x0000,0x0000,0x0000,0x0007,0xF800,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x0000,0xFFFF,0xFFFF,0xFFF8,0x0000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x0001,0xFFC0,0x0000,0x1FFC,0x0000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x0003,0xFF80,0x0000,0x0FFE,0x0000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x0007,0xFF00,0x0000,0x07FF,0x0000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x000F,0xFE00,0x0000,0x03FF,0x8000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x001F,0xFC00,0x0000,0x01FF,0xC000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x003F,0xF800,0x0000,0x00FF,0xE000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x007F,0xF000,0x0000,0x007F,0xF000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x007F,0xE000,0x0000,0x003F,0xF000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x007F,0xC000,0x0000,0x001F,0xF000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x007F,0x8000,0x0000,0x000F,0xF000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x007F,0x8000,0x0000,0x000F,0xF000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x007F,0x8000,0x0000,0x000F,0xF000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x003F,0x8000,0x0000,0x000F,0xE000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x003F,0x8000,0x0000,0x000F,0xE000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x003F,0xC000,0x0000,0x000F,0xE000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x003F,0xC000,0x0000,0x001F,0xE000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x003F,0xC000,0x0000,0x001F,0xE000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x003F,0xC000,0x0000,0x001F,0xE000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x003F,0xC000,0x0000,0x001F,0xE000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x001F,0xC000,0x0000,0x001F,0xE000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x001F,0xC000,0x0000,0x001F,0xC000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x001F,0xC000,0x0000,0x001F,0xC000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x001F,0xE000,0x0000,0x001F,0xC000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x001F,0xE000,0x0000,0x003F,0xC000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x001F,0xE000,0x0000,0x003F,0xC000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x001F,0xE000,0x0000,0x003F,0xC000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x0000,0x0000,0x0000,0x001E,0x0001,0xE000,0x1E00,0x001F,0xE000,0x0000,0x003F,0xC000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x039C,0x0000,0x0000,0x001E,0x0007,0xF800,0x1E00,0x000F,0xE000,0x0000,0x003F,0xC000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x07F0,0x030C,0x0000,0x0000,0x001E,0x000F,0xFC00,0x1E00,0x000F,0xE000,0x0000,0x003F,0x8000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x0FF0,0x0000,0x0000,0x0000,0x001E,0x000E,0xDC00,0x1E00,0x000F,0xF000,0x0000,0x003F,0x8000,
  0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x1FF0,0x0000,0x0000,0x0000,0x001E,0x000F,0xFC00,0x1E00,0x000F,0xF000,0x0000,0x003F,0x8000,
  0x0000,0x0000,0x0000,0x0007,0xFFFF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x001E,0x0007,0xF800,0x1E00,0x000F,0xF000,0x0000,0x007F,0x8000,
  0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x001E,0x0003,0xF000,0x1E00,0x000F,0xF000,0x0000,0x007F,0x8000,
  0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFF0,0x0060,0x0000,0x0000,0x001E,0x0000,0xC000,0x1E00,0x000F,0xF000,0x0000,0x007F,0x8000,
  0x2000,0x0000,0x0000,0x0000,0xFFFF,0xFFFF,0xFFF0,0x0060,0x0000,0x0000,0x001E,0x0000,0x0000,0x1E00,0x0007,0xF000,0x0000,0x007F,0x8000,
  0x0000,0x0000,0x0000,0x0000,0x7FFF,0xFFFF,0xFFE0,0x0000,0x0000,0x0000,0x001E,0x0000,0x0000,0x1E00,0x0007,0xF000,0x0000,0x007F,0x8000,
  0x0000,0x0000,0x0000,0x0000,0x3FFF,0xFFFF,0xFFE0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xF000,0x0000,0x007F,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x1FFF,0xFFFF,0xFF80,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xF800,0x0000,0x007F,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xF800,0x0000,0x00FF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xF800,0x0000,0x00FF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xF800,0x0000,0x00FF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xFFFF,0xFFFF,0xFFFF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFFF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFFE,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFFE,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFFE,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFFE,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0001,0xFFFF,0xFFFF,0xFFFE,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFFFF,0xFFFF,0xFFFF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7FFF,0xFFFF,0xFFFF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00FF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0000,0x00FF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x1800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0000,0x00FF,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0800,0x0000,0x0000,0x00FF,0xFFFF,0xFF00,0x0000,0x0000,0x0001,0x0000,0x0000,0x0000,0x0000,0x007F,0x0000,
  0xF000,0x0000,0x0078,0x0006,0x0000,0x0000,0x0000,0x00FF,0xFFFF,0xFF80,0x0000,0x0000,0x0000,0x0600,0x0000,0x0000,0x0000,0x007F,0x0000,
  0xF000,0x0000,0x0078,0x0006,0x0000,0x0000,0x0000,0x00FF,0xFFFF,0xFFE0,0x0000,0x0000,0x0000,0x0600,0x0000,0x0000,0x0000,0x007F,0x8000,
  0xF000,0x0300,0x0078,0x0000,0x0800,0x0000,0x0000,0x00FF,0xFFFF,0xFFF0,0x0000,0x0000,0x0001,0x0000,0x0000,0x0000,0x0000,0x007F,0x8000,
  0xF000,0x0FC0,0x0078,0x0000,0x1800,0x0000,0x0000,0x00FF,0xFFFF,0xFFF0,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0000,0x007F,0x8000,
  0xF000,0x1FE0,0x0078,0x0000,0x1800,0x0000,0x0000,0x00FF,0xFFFF,0xFFF8,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0000,0x007F,0x8000,
  0xF000,0x3FF0,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FF,0xFFFF,0xFFFC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x007F,0x8000,
  0xF000,0x3B70,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0x8000,
  0xF000,0x3FF0,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0x8000,
  0xF000,0x1FE0,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xC000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xC000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xC000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xC000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xC000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xC000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x007E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xC000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x003E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xC000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x001E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xE000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xE000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xE000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xE000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xE000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x000F,0xE000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x000F,0xE000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x000F,0xF000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0004,0x0000,0x0000,0x0200,0x0000,0x0000,0x0000,0x000F,0xF000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x000F,0xF000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0001,0x8000,0x0000,0x001F,0xF000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xC000,0x0000,0x003F,0xF000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xE000,0x0000,0x007F,0xF000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x007F,0xF000,0x0000,0x00FF,0xE000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003F,0xF800,0x0000,0x01FF,0xC000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001F,0xFC00,0x0000,0x03FF,0x8000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x000F,0xFE00,0x0000,0x07FF,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0007,0xFF00,0x0000,0x0FFE,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x00FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFFF,0xFFFF,0xFFFC,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x03FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0001,0xFFFF,0xFFFF,0xFFF8,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x07FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFFFF,0xFFFF,0xFFF0,0x0000,
  0xF000,0x0780,0x0078,0x0000,0x0000,0x0000,0x0000,0x076E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7FFF,0xFFFF,0xFFE0,0x0000,
  0xF800,0x0780,0x00F8,0x0000,0x0000,0x0000,0x0000,0x07FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3FFF,0xFFFF,0xFFC0,0x0000,
  0xFC00,0x0780,0x01F8,0x0000,0x0000,0x0000,0x0000,0x03FC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1FFF,0xFFFF,0xFF80,0x0000,
  0xFFFF,0xFFFF,0xFFF8,0x0000,0x0000,0x0000,0x0000,0x01F8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x7FFF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x0000,0x0060,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x7FFF,0xFFFF,0xFFF0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x1FFF,0xFFFF,0xFFC0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

EXPORT UWORD chip OriginalBackground1Data[256] = {
  /* Plane 0 */
  0x8080,0x8080,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x8080,0x8080,
  0x4141,0x4141,
  0x8080,0x8080,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x8080,0x8080,
  0x4141,0x4141,
  0x8080,0x8080,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x8080,0x8080,
  0x4141,0x4141,
  0x8080,0x8080,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x8080,0x8080,
  0x4141,0x4141,
  /* Plane 1 */
  0x0080,0x0080,
  0x0000,0x0000,
  0x0800,0x0800,
  0x1400,0x1400,
  0x0800,0x0800,
  0x0000,0x0000,
  0x8000,0x8000,
  0x4001,0x4001,
  0x8000,0x8000,
  0x0000,0x0000,
  0x0008,0x0008,
  0x0014,0x0014,
  0x0008,0x0008,
  0x0000,0x0000,
  0x0080,0x0080,
  0x0140,0x0140,
  0x0080,0x0080,
  0x0000,0x0000,
  0x0800,0x0800,
  0x1400,0x1400,
  0x0800,0x0800,
  0x0000,0x0000,
  0x8000,0x8000,
  0x4001,0x4001,
  0x8000,0x8000,
  0x0000,0x0000,
  0x0008,0x0008,
  0x0014,0x0014,
  0x0008,0x0008,
  0x0000,0x0000,
  0x0080,0x0080,
  0x0140,0x0140,
  /* Plane 2 */
  0xFF7F,0xFF7F,
  0xFFFF,0xFFFF,
  0xF7F7,0xF7F7,
  0xE3E3,0xE3E3,
  0xF7F7,0xF7F7,
  0xFFFF,0xFFFF,
  0x7FFF,0x7FFF,
  0x3F7E,0x3F7E,
  0x7FFF,0x7FFF,
  0xFFFF,0xFFFF,
  0xF7F7,0xF7F7,
  0xE3E3,0xE3E3,
  0xF7F7,0xF7F7,
  0xFFFF,0xFFFF,
  0xFF7F,0xFF7F,
  0x7E3F,0x7E3F,
  0xFF7F,0xFF7F,
  0xFFFF,0xFFFF,
  0xF7F7,0xF7F7,
  0xE3E3,0xE3E3,
  0xF7F7,0xF7F7,
  0xFFFF,0xFFFF,
  0x7FFF,0x7FFF,
  0x3F7E,0x3F7E,
  0x7FFF,0x7FFF,
  0xFFFF,0xFFFF,
  0xF7F7,0xF7F7,
  0xE3E3,0xE3E3,
  0xF7F7,0xF7F7,
  0xFFFF,0xFFFF,
  0xFF7F,0xFF7F,
  0x7E3F,0x7E3F,
  /* Plane 3 */
  0x7F7F,0x7F7F,
  0xFFFF,0xFFFF,
  0xF7FF,0xF7FF,
  0xE3F7,0xE3F7,
  0xF7FF,0xF7FF,
  0xFFFF,0xFFFF,
  0x7F7F,0x7F7F,
  0x3E3E,0x3E3E,
  0x7F7F,0x7F7F,
  0xFFFF,0xFFFF,
  0xFFF7,0xFFF7,
  0xF7E3,0xF7E3,
  0xFFF7,0xFFF7,
  0xFFFF,0xFFFF,
  0x7F7F,0x7F7F,
  0x3E3E,0x3E3E,
  0x7F7F,0x7F7F,
  0xFFFF,0xFFFF,
  0xF7FF,0xF7FF,
  0xE3F7,0xE3F7,
  0xF7FF,0xF7FF,
  0xFFFF,0xFFFF,
  0x7F7F,0x7F7F,
  0x3E3E,0x3E3E,
  0x7F7F,0x7F7F,
  0xFFFF,0xFFFF,
  0xFFF7,0xFFF7,
  0xF7E3,0xF7E3,
  0xFFF7,0xFFF7,
  0xFFFF,0xFFFF,
  0x7F7F,0x7F7F,
  0x3E3E,0x3E3E
}, OriginalBackground2Data[192] = {
  /* Plane 0 */
  0x8080,0x8080,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x8080,0x8080,
  0x4141,0x4141,
  0x8080,0x8080,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x8080,0x8080,
  0x4141,0x4141,
  0x8080,0x8080,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x0000,0x0000,
  0x8080,0x8080,
  0x4141,0x4141,
  /* Plane 1 */
  0x0080,0x0080,
  0x0000,0x0000,
  0x0800,0x0800,
  0x1400,0x1400,
  0x0800,0x0800,
  0x0000,0x0000,
  0x8000,0x8000,
  0x4001,0x4001,
  0x8000,0x8000,
  0x0000,0x0000,
  0x0008,0x0008,
  0x0014,0x0014,
  0x0008,0x0008,
  0x0000,0x0000,
  0x0080,0x0080,
  0x0140,0x0140,
  0x0080,0x0080,
  0x0000,0x0000,
  0x0800,0x0800,
  0x1400,0x1400,
  0x0800,0x0800,
  0x0000,0x0000,
  0x8000,0x8000,
  0x4001,0x4001,
  /* Plane 2 */
  0xFF7F,0xFF7F,
  0xFFFF,0xFFFF,
  0xF7F7,0xF7F7,
  0xE3E3,0xE3E3,
  0xF7F7,0xF7F7,
  0xFFFF,0xFFFF,
  0x7FFF,0x7FFF,
  0x3F7E,0x3F7E,
  0x7FFF,0x7FFF,
  0xFFFF,0xFFFF,
  0xF7F7,0xF7F7,
  0xE3E3,0xE3E3,
  0xF7F7,0xF7F7,
  0xFFFF,0xFFFF,
  0xFF7F,0xFF7F,
  0x7E3F,0x7E3F,
  0xFF7F,0xFF7F,
  0xFFFF,0xFFFF,
  0xF7F7,0xF7F7,
  0xE3E3,0xE3E3,
  0xF7F7,0xF7F7,
  0xFFFF,0xFFFF,
  0x7FFF,0x7FFF,
  0x3F7E,0x3F7E,
  /* Plane 3 */
  0x7F7F,0x7F7F,
  0xFFFF,0xFFFF,
  0xF7FF,0xF7FF,
  0xE3F7,0xE3F7,
  0xF7FF,0xF7FF,
  0xFFFF,0xFFFF,
  0x7F7F,0x7F7F,
  0x3E3E,0x3E3E,
  0x7F7F,0x7F7F,
  0xFFFF,0xFFFF,
  0xFFF7,0xFFF7,
  0xF7E3,0xF7E3,
  0xFFF7,0xFFF7,
  0xFFFF,0xFFFF,
  0x7F7F,0x7F7F,
  0x3E3E,0x3E3E,
  0x7F7F,0x7F7F,
  0xFFFF,0xFFFF,
  0xF7FF,0xF7FF,
  0xE3F7,0xE3F7,
  0xF7FF,0xF7FF,
  0xFFFF,0xFFFF,
  0x7F7F,0x7F7F,
  0x3E3E,0x3E3E
};

MODULE UWORD OriginalBoingData[6][200] = {
{ 0x0023,0x0000, // A
  0x004E,0x3000,
  0x00E3,0x3A00,
  0x03C3,0xC900,
  0x0787,0x8780,
  0x108F,0x8700,
  0x31F7,0x8790,
  0x61F0,0x4790,
  0x63E0,0xFB90,
  0x43E0,0xF848,
  0x3BC0,0xF870,
  0x3801,0xF870,
  0x383D,0xF070,
  0x387E,0x1070,
  0x387C,0x0EE0,
  0xD87C,0x1F10,
  0x467C,0x1E10,
  0x479C,0x1E30,
  0x6787,0x3E20,
  0x0787,0xCC60,
  0x0F0F,0x8700,
  0x048F,0x0E00,
  0x0277,0x1C00,
  0x0161,0xD800,
  0x0027,0x2000,
  /* Plane 1 */
  0x003F,0xE000,
  0x01FF,0xFC00,
  0x07FF,0xFF00,
  0x0FFF,0xFF80,
  0x1FFF,0xFFC0,
  0x3FFF,0xFFE0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFE0,
  0x3FFF,0xFFE0,
  0x1FFF,0xFFC0,
  0x0FFF,0xFF80,
  0x07FF,0xFE00,
  0x01FF,0xFC00,
  0x003F,0xE000,
  /* Plane 2 */
  0x0023,0x0000,
  0x004E,0x3000,
  0x00E3,0x3A00,
  0x03C3,0xC900,
  0x0787,0x8780,
  0x108F,0x8700,
  0x31F7,0x8790,
  0x61F0,0x4790,
  0x63E0,0xFB90,
  0x43E0,0xF848,
  0x3BC0,0xF870,
  0x3801,0xF870,
  0x383D,0xF070,
  0x387E,0x1070,
  0x387C,0x0EE0,
  0xD87C,0x1F10,
  0x467C,0x1E10,
  0x479C,0x1E30,
  0x6787,0x3E20,
  0x0787,0xCC60,
  0x0F0F,0x8700,
  0x048F,0x0E00,
  0x0277,0x1C00,
  0x0161,0xD800,
  0x0027,0x2000,
  /* Plane 3 */
  0x003F,0xE000,
  0x01FF,0xFC00,
  0x07FF,0xFF00,
  0x0FFF,0xFF80,
  0x1FFF,0xFFC0,
  0x3FFF,0xFFE0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFE0,
  0x3FFF,0xFFE0,
  0x1FFF,0xFFC0,
  0x0FFF,0xFF80,
  0x07FF,0xFE00,
  0x01FF,0xFC00,
  0x003F,0xE000
},
{ 0x0031,0x8000, // B
  0x0107,0x1800,
  0x00F0,0x1900,
  0x09E1,0xEC80,
  0x13C1,0xE340,
  0x1803,0xE380,
  0x387B,0xC390,
  0x30F8,0x01D0,
  0x70F8,0x3DC0,
  0xE1F0,0x3E08,
  0x9DF0,0x7C30,
  0x9E30,0x7C30,
  0x9E1C,0x7C30,
  0x1C1F,0x9C30,
  0x1C1F,0x0630,
  0x7C1F,0x0780,
  0x623F,0x0790,
  0x63DE,0x0F10,
  0x23C1,0x0F20,
  0x33C3,0xEE20,
  0x0BC3,0xC380,
  0x0647,0xC700,
  0x023F,0x8E00,
  0x0130,0xF800,
  0x0033,0x8000,
  /* Plane 1 */
  0x003F,0xE000,
  0x01FF,0xFC00,
  0x07FF,0xFF00,
  0x0FFF,0xFF80,
  0x1FFF,0xFFC0,
  0x3FFF,0xFFE0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFE0,
  0x3FFF,0xFFE0,
  0x1FFF,0xFFC0,
  0x0FFF,0xFF80,
  0x07FF,0xFE00,
  0x01FF,0xFC00,
  0x003F,0xE000,
  /* Plane 2 */
  0x0031,0x8000,
  0x0107,0x1800,
  0x00F0,0x1900,
  0x09E1,0xEC80,
  0x13C1,0xE340,
  0x1803,0xE380,
  0x387B,0xC390,
  0x30F8,0x01D0,
  0x70F8,0x3DC0,
  0xE1F0,0x3E08,
  0x9DF0,0x7C30,
  0x9E30,0x7C30,
  0x9E1C,0x7C30,
  0x1C1F,0x9C30,
  0x1C1F,0x0630,
  0x7C1F,0x0780,
  0x623F,0x0790,
  0x63DE,0x0F10,
  0x23C1,0x0F20,
  0x33C3,0xEE20,
  0x0BC3,0xC380,
  0x0647,0xC700,
  0x023F,0x8E00,
  0x0130,0xF800,
  0x0033,0x8000,
  /* Plane 3 */
  0x003F,0xE000,
  0x01FF,0xFC00,
  0x07FF,0xFF00,
  0x0FFF,0xFF80,
  0x1FFF,0xFFC0,
  0x3FFF,0xFFE0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFE0,
  0x3FFF,0xFFE0,
  0x1FFF,0xFFC0,
  0x0FFF,0xFF80,
  0x07FF,0xFE00,
  0x01FF,0xFC00,
  0x003F,0xE000
},
{ 0x0019,0xC000, // C
  0x0103,0x8800,
  0x0278,0x8D00,
  0x0CF0,0xFE80,
  0x11F0,0xF140,
  0x0E60,0xF1E0,
  0x1C39,0xF0C0,
  0x1C3E,0x30C0,
  0x387E,0x0CE0,
  0xF87C,0x1F28,
  0x8C7C,0x1F18,
  0x8F3C,0x1F18,
  0x8F06,0x1E18,
  0x8F07,0xDE18,
  0x8F07,0xC018,
  0x6E0F,0xC1C0,
  0x300F,0x83C0,
  0x31EF,0x8390,
  0x31F0,0x8780,
  0x11E0,0xF720,
  0x11E1,0xF1C0,
  0x0B61,0xE300,
  0x071B,0xC600,
  0x0138,0x6C00,
  0x0031,0x8000,
  /* Plane 1 */
  0x003F,0xE000,
  0x01FF,0xFC00,
  0x07FF,0xFF00,
  0x0FFF,0xFF80,
  0x1FFF,0xFFC0,
  0x3FFF,0xFFE0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFE0,
  0x3FFF,0xFFE0,
  0x1FFF,0xFFC0,
  0x0FFF,0xFF80,
  0x07FF,0xFE00,
  0x01FF,0xFC00,
  0x003F,0xE000,
  /* Plane 2 */
  0x0019,0xC000,
  0x0103,0x8800,
  0x0278,0x8D00,
  0x0CF0,0xFE80,
  0x11F0,0xF140,
  0x0E60,0xF1E0,
  0x1C39,0xF0C0,
  0x1C3E,0x30C0,
  0x387E,0x0CE0,
  0xF87C,0x1F28,
  0x8C7C,0x1F18,
  0x8F3C,0x1F18,
  0x8F06,0x1E18,
  0x8F07,0xDE18,
  0x8F07,0xC018,
  0x6E0F,0xC1C0,
  0x300F,0x83C0,
  0x31EF,0x8390,
  0x31F0,0x8780,
  0x11E0,0xF720,
  0x11E1,0xF1C0,
  0x0B61,0xE300,
  0x071B,0xC600,
  0x0138,0x6C00,
  0x0031,0x8000,
  /* Plane 3 */
  0x003F,0xE000,
  0x01FF,0xFC00,
  0x07FF,0xFF00,
  0x0FFF,0xFF80,
  0x1FFF,0xFFC0,
  0x3FFF,0xFFE0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFE0,
  0x3FFF,0xFFE0,
  0x1FFF,0xFFC0,
  0x0FFF,0xFF80,
  0x07FF,0xFE00,
  0x01FF,0xFC00,
  0x003F,0xE000
},
{ 0x001C,0xE000, // D
  0x01B1,0xCC00,
  0x031C,0xC500,
  0x0C3C,0x3680,
  0x1878,0x7840,
  0x2F70,0x78E0,
  0x0E08,0x7860,
  0x1E0F,0xB860,
  0x1C1F,0x0460,
  0xBC1F,0x07B0,
  0xC43F,0x0788,
  0xC7FE,0x0788,
  0xC7C0,0x0F88,
  0xC781,0xEF88,
  0xC783,0xF118,
  0x2783,0xE0E8,
  0x3983,0xE1E0,
  0x3863,0xE1C0,
  0x1878,0xC1C0,
  0x3878,0x3380,
  0x10F0,0x78C0,
  0x0B70,0xF180,
  0x0588,0xE200,
  0x009E,0x2400,
  0x0018,0xC000,
  /* Plane 1 */
  0x003F,0xE000,
  0x01FF,0xFC00,
  0x07FF,0xFF00,
  0x0FFF,0xFF80,
  0x1FFF,0xFFC0,
  0x3FFF,0xFFE0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFE0,
  0x3FFF,0xFFE0,
  0x1FFF,0xFFC0,
  0x0FFF,0xFF80,
  0x07FF,0xFE00,
  0x01FF,0xFC00,
  0x003F,0xE000,
  /* Plane 2 */
  0x001C,0xE000,
  0x01B1,0xCC00,
  0x031C,0xC500,
  0x0C3C,0x3680,
  0x1878,0x7840,
  0x2F70,0x78E0,
  0x0E08,0x7860,
  0x1E0F,0xB860,
  0x1C1F,0x0460,
  0xBC1F,0x07B0,
  0xC43F,0x0788,
  0xC7FE,0x0788,
  0xC7C0,0x0F88,
  0xC781,0xEF88,
  0xC783,0xF118,
  0x2783,0xE0E8,
  0x3983,0xE1E0,
  0x3863,0xE1C0,
  0x1878,0xC1C0,
  0x3878,0x3380,
  0x10F0,0x78C0,
  0x0B70,0xF180,
  0x0588,0xE200,
  0x009E,0x2400,
  0x0018,0xC000,
  /* Plane 3 */
  0x003F,0xE000,
  0x01FF,0xFC00,
  0x07FF,0xFF00,
  0x0FFF,0xFF80,
  0x1FFF,0xFFC0,
  0x3FFF,0xFFE0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFE0,
  0x3FFF,0xFFE0,
  0x1FFF,0xFFC0,
  0x0FFF,0xFF80,
  0x07FF,0xFE00,
  0x01FF,0xFC00,
  0x003F,0xE000
},
{ 0x000E,0x6000, // E
  0x00F8,0xE400,
  0x030F,0xE600,
  0x061E,0x1300,
  0x0C3E,0x1C80,
  0x27FC,0x1C60,
  0x0784,0x3C60,
  0x4F07,0xFE20,
  0x0F07,0xC230,
  0x1E0F,0xC1F0,
  0x620F,0x83C8,
  0x61CF,0x83C8,
  0x61E1,0x83C8,
  0x63E0,0x63C8,
  0x63E0,0xF9C8,
  0x03E0,0xF878,
  0x1DC0,0xF860,
  0x1C21,0xF0E0,
  0x5C3E,0xF0C0,
  0x0C3C,0x11C0,
  0x143C,0x3C40,
  0x09B8,0x3880,
  0x05C0,0x7000,
  0x00CF,0x0400,
  0x000C,0x6000,
  /* Plane 1 */
  0x003F,0xE000,
  0x01FF,0xFC00,
  0x07FF,0xFF00,
  0x0FFF,0xFF80,
  0x1FFF,0xFFC0,
  0x3FFF,0xFFE0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFE0,
  0x3FFF,0xFFE0,
  0x1FFF,0xFFC0,
  0x0FFF,0xFF80,
  0x07FF,0xFE00,
  0x01FF,0xFC00,
  0x003F,0xE000,
  /* Plane 2 */
  0x000E,0x6000,
  0x00F8,0xE400,
  0x030F,0xE600,
  0x061E,0x1300,
  0x0C3E,0x1C80,
  0x27FC,0x1C60,
  0x0784,0x3C60,
  0x4F07,0xFE20,
  0x0F07,0xC230,
  0x1E0F,0xC1F0,
  0x620F,0x83C8,
  0x61CF,0x83C8,
  0x61E1,0x83C8,
  0x63E0,0x63C8,
  0x63E0,0xF9C8,
  0x03E0,0xF878,
  0x1DC0,0xF860,
  0x1C21,0xF0E0,
  0x5C3E,0xF0C0,
  0x0C3C,0x11C0,
  0x143C,0x3C40,
  0x09B8,0x3880,
  0x05C0,0x7000,
  0x00CF,0x0400,
  0x000C,0x6000,
  /* Plane 3 */
  0x003F,0xE000,
  0x01FF,0xFC00,
  0x07FF,0xFF00,
  0x0FFF,0xFF80,
  0x1FFF,0xFFC0,
  0x3FFF,0xFFE0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFE0,
  0x3FFF,0xFFE0,
  0x1FFF,0xFFC0,
  0x0FFF,0xFF80,
  0x07FF,0xFE00,
  0x01FF,0xFC00,
  0x003F,0xE000
},
{ 0x0026,0x2000, // F
  0x00FC,0x7400,
  0x0187,0x7200,
  0x030F,0x0100,
  0x0E0F,0x0E80,
  0x319F,0x0E00,
  0x23C6,0x0F30,
  0x63C1,0xCF30,
  0x4781,0xF310,
  0x0783,0xE0D0,
  0x7383,0xE0E0,
  0x70C3,0xE0E0,
  0x70F9,0xE1E0,
  0x70F8,0x21E0,
  0x70F8,0x3FE0,
  0x91F0,0x3E38,
  0x4FF0,0x7C30,
  0x4E10,0x7C60,
  0x4E0F,0x7860,
  0x2E1F,0x08C0,
  0x0E1E,0x0E00,
  0x049E,0x1C80,
  0x00E4,0x3800,
  0x00C7,0x9000,
  0x000E,0x6000,
  /* Plane 1 */
  0x003F,0xE000,
  0x01FF,0xFC00,
  0x07FF,0xFF00,
  0x0FFF,0xFF80,
  0x1FFF,0xFFC0,
  0x3FFF,0xFFE0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFE0,
  0x3FFF,0xFFE0,
  0x1FFF,0xFFC0,
  0x0FFF,0xFF80,
  0x07FF,0xFE00,
  0x01FF,0xFC00,
  0x003F,0xE000,
  /* Plane 2 */
  0x0026,0x2000,
  0x00FC,0x7400,
  0x0187,0x7200,
  0x030F,0x0100,
  0x0E0F,0x0E80,
  0x319F,0x0E00,
  0x23C6,0x0F30,
  0x63C1,0xCF30,
  0x4781,0xF310,
  0x0783,0xE0D0,
  0x7383,0xE0E0,
  0x70C3,0xE0E0,
  0x70F9,0xE1E0,
  0x70F8,0x21E0,
  0x70F8,0x3FE0,
  0x91F0,0x3E38,
  0x4FF0,0x7C30,
  0x4E10,0x7C60,
  0x4E0F,0x7860,
  0x2E1F,0x08C0,
  0x0E1E,0x0E00,
  0x049E,0x1C80,
  0x00E4,0x3800,
  0x00C7,0x9000,
  0x000E,0x6000,
  /* Plane 3 */
  0x003F,0xE000,
  0x01FF,0xFC00,
  0x07FF,0xFF00,
  0x0FFF,0xFF80,
  0x1FFF,0xFFC0,
  0x3FFF,0xFFE0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0xFFFF,0xFFF8,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFF0,
  0x7FFF,0xFFE0,
  0x3FFF,0xFFE0,
  0x1FFF,0xFFC0,
  0x0FFF,0xFF80,
  0x07FF,0xFE00,
  0x01FF,0xFC00,
  0x003F,0xE000
}
};

EXPORT UWORD OriginalAboutData[114 * ABOUTDEPTH] =
{ 0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0400,
  0x3C0F,0x0001,0xFEC0,
  0x3C0F,0x0000,0x0400,
  0x1E1E,0x0000,0x1100,
  0x1E1E,0x0000,0x2480,
  0x003C,0x0000,0x0400,
  0x003C,0x0000,0x0000,
  0x0078,0x0000,0x0000,
  0x0078,0x0000,0x0000,
  0x00F0,0x0000,0x0000,
  0x00F0,0x0000,0x0000,
  0x01E0,0x0000,0x0000,
  0x01E0,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0E3B,0x91E3,0x8880,
  0x1124,0x9224,0x4C80,
  0x1124,0x9204,0x4C80,
  0x1F24,0x9207,0xCA80,
  0x1124,0x9264,0x4980,
  0x1124,0x9224,0x4980,
  0x1120,0x91E4,0x4880,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  /* Plane 1 */
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0001,0xE000,0x0000,
  0x0001,0xE000,0x0000,
  0x0003,0xC000,0x0400,
  0x0003,0xC000,0x2480,
  0x0007,0x8000,0x1100,
  0x0007,0x8000,0x0400,
  0x0000,0x0000,0x1EC0,
  0x0000,0x0000,0x0400,
  0x0000,0x0000,0x0100,
  0x0000,0x0000,0x0080,
  0x0F00,0x0000,0x0000,
  0x0F00,0x0000,0x0000,
  0x07F8,0x0000,0x0000,
  0x07F8,0x0000,0x0000,
  0x03F0,0x0000,0x0000,
  0x03F0,0x0000,0x0000,
  0x01E0,0x0000,0x0000,
  0x01E0,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0E3B,0x91E3,0x8880,
  0x1124,0x9224,0x4C80,
  0x1124,0x9204,0x4C80,
  0x1F24,0x9207,0xCA80,
  0x1124,0x9264,0x4980,
  0x1124,0x9224,0x4980,
  0x1120,0x91E4,0x4880,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  /* Plane 2 */
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0400,0x0000,
  0x0000,0x0400,0x0000,
  0x0000,0x0E00,0x0000,
  0x0000,0x0E00,0x0000,
  0x0000,0x0F00,0x0000,
  0x0000,0x0F00,0x0000,
  0x0000,0x0780,0x0400,
  0x0000,0x0780,0x2400,
  0x0000,0x03C0,0x1000,
  0x0000,0x03C0,0x0400,
  0x3C0F,0xFFFE,0x1E00,
  0x3C0F,0xFFE0,0x0400,
  0x1E1F,0xE0F0,0x1100,
  0x1E1F,0xF0F0,0x2480,
  0x0F3C,0x7C78,0x0400,
  0x0F3C,0x1E78,0x0000,
  0x0780,0x07BC,0x0000,
  0x0000,0x03FC,0x0000,
  0x0000,0x00FE,0x0000,
  0x0000,0x007E,0x0000,
  0x0000,0x001F,0x0000,
  0x0000,0x000F,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0E3B,0x91E3,0x8880,
  0x1124,0x9224,0x4C80,
  0x1124,0x9204,0x4C80,
  0x1F24,0x9207,0xCA80,
  0x1124,0x9264,0x4980,
  0x1124,0x9224,0x4980,
  0x1120,0x91E4,0x4880,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  /* Plane 3 */
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x3800,0x0000,
  0x0000,0x3800,0x0000,
  0x0000,0x7800,0x0000,
  0x0000,0x7800,0x0000,
  0x0000,0xF000,0x0000,
  0x0000,0xF000,0x0000,
  0x0001,0xE000,0x0000,
  0x0001,0xE000,0x0000,
  0x0003,0xC000,0x0000,
  0x0003,0xC000,0x2080,
  0x0007,0x8000,0x1100,
  0x0007,0x8000,0x0400,
  0x000F,0x0000,0x1EC0,
  0x000F,0x0000,0x0400,
  0x001E,0x0000,0x1000,
  0x001E,0x0000,0x2000,
  0x003C,0x0000,0x0000,
  0x003C,0x0000,0x0000,
  0x0078,0x0000,0x0000,
  0x0078,0x0000,0x0000,
  0x00F0,0x0000,0x0000,
  0x00F0,0x0000,0x0000,
  0x01E0,0x0000,0x0000,
  0x01E0,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,
  0x0E3B,0x91E3,0x8880,
  0x1124,0x9224,0x4C80,
  0x1124,0x9204,0x4C80,
  0x1F24,0x9207,0xCA80,
  0x1124,0x9264,0x4980,
  0x1124,0x9224,0x4980,
  0x1120,0x91E4,0x4880,
  0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000
};

EXPORT struct Image About =
{   0, 0,
    44, 38, 4,
    NULL,
    0xFF, 0x0,
    NULL
}, Boing =
{   0, 0,
    29, 25, 4,
    NULL,
    0xFF, 0x0,
    NULL
}, Logo =
{   0, 0,
    295, 110, 4,
    NULL,
    0xFF, 0x0,
    NULL
}, Background1 =
{   0, 0,
    32, 32, 4,
    NULL,
    0xFF, 0x0,
    NULL
}, Background2 =
{   0, 0,
    32, 24, 4,
    NULL,
    0xFF, 0x0,
    NULL
};

MODULE void remapimage(struct Image* image, UWORD* imagedata1, UWORD* imagedata2);

EXPORT void drawlogo(void)
{   SetAPen(MainWindowPtr->RPort, remapit[BLACK]);
    RectFill
    (   MainWindowPtr->RPort,
        CENTREXPIXEL - (Logo.Width / 2) - 8,
        YSTART - 8,
        CENTREXPIXEL + (Logo.Width / 2) + 8,
        YSTART + 8 + Logo.Height
    );
    DrawImage
    (   MainWindowPtr->RPort,
        &Logo,
        CENTREXPIXEL - (Logo.Width / 2),
        YSTART
    );
}

EXPORT void drawboing(void)
{   PERSIST UBYTE boingframe = 0;

    Boing.ImageData = BoingData[boingframe++];
    DrawImage
    (   MainWindowPtr->RPort,
        &Boing,
        CENTREXPIXEL - 77,
        YSTART + 11
    );
    if (boingframe > 5)
    {   boingframe = 0;
}   }

#if defined(__AROS__) && (AROS_BIG_ENDIAN == 0)
EXPORT void gfx_swap_byteorder(void)
{   swap_byteorder((UWORD*) OriginalLogoData,        sizeof(OriginalLogoData)        / 2);
    swap_byteorder((UWORD*) OriginalBoingData,       sizeof(OriginalBoingData)       / 2);
    swap_byteorder((UWORD*) OriginalAboutData,       sizeof(OriginalAboutData)       / 2);
    swap_byteorder((UWORD*) OriginalBackground1Data, sizeof(OriginalBackground1Data) / 2);
    swap_byteorder((UWORD*) OriginalBackground2Data, sizeof(OriginalBackground2Data) / 2);
}
#endif

EXPORT void remap(void)
{   int   i, j;
    LONG  result;
    ULONG red, green, blue;

    if (customscreen)
    {   for (i = 0; i < 16; i++)
        {   remapit[i] = i;
        }

        for (i = 0; i <= ARRAYSIZE; i++)
        {   for (j = 0; j < SQUAREY * DEPTH; j++)
            {   SquaresData[i][j] = OriginalSquaresData[i][j];
        }   }
     // Squares.Depth     = 4;
        Squares.PlanePick = 0x0F;

        for (i = 0; i < 8360; i++)
        {   LogoData[i] = OriginalLogoData[i];
        }
     // Logo.Depth      = 4;
        Logo.PlanePick  = 0x0F;

        for (i = 0; i < 6; i++)
        {   for (j = 0; j < 200; j++)
            {   BoingData[i][j] = OriginalBoingData[i][j];
        }   }
     // Boing.Depth     = 4;
        Boing.PlanePick = 0x0F;

        for (i = 0; i < 114 * ABOUTDEPTH; i++)
        {   AboutData[i] = OriginalAboutData[i];
        }
     // About.Depth     = ABOUTDEPTH;
        About.PlanePick = ABOUTDEPTHMASK;

        for (i = 0; i < 256; i++)
        {   Background1Data[i] = OriginalBackground1Data[i];
        }
     // Background1.Depth     = 4;
        Background1.PlanePick = 0x0F;

        for (i = 0; i < 192; i++)
        {   Background2Data[i] = OriginalBackground2Data[i];
        }
     // Background2.Depth     = 4;
        Background2.PlanePick = 0x0F;

        return;
    } // implied else

    for (i = 0; i < 16; i++)
    {   red   =  (OCSColours[i] & 0x0F00) >> 8; // $0000000r
        green =  (OCSColours[i] & 0x00F0) >> 4;
        blue  =  (OCSColours[i] & 0x000F)     ;
        red   |= (red   <<  4);                 // $000000rr
        green |= (green <<  4);
        blue  |= (blue  <<  4);
        red   |= (red   <<  8);                 // $0000rrrr
        green |= (green <<  8);
        blue  |= (blue  <<  8);
        red   |= (red   << 16);                 // $rrrrrrrr
        green |= (green << 16);
        blue  |= (blue  << 16);

        result = ObtainBestPen
        (   ScreenPtr->ViewPort.ColorMap,
            red,
            green,
            blue,
            OBP_Precision, PRECISION_IMAGE,
        TAG_DONE);
        if (result == -1)
        {   remapit[i] = FindColor
            (   ScreenPtr->ViewPort.ColorMap,
                red,
                green,
                blue,
                -1
            );
        } else
        {   gotpen[i] = TRUE;
            remapit[i] = result;
    }   }

    for (i = 0; i <= ARRAYSIZE; i++)
    {   remapimage(&Squares,         OriginalSquaresData[i],     SquaresData[i]);
    }
    remapimage(    &Logo,               OriginalLogoData   ,        LogoData   );
    for (i = 0; i < 6; i++)
    {   remapimage(&Boing,             OriginalBoingData[i],       BoingData[i]);
    }
    remapimage(    &About,             OriginalAboutData   ,       AboutData   );
    remapimage(    &Background1, OriginalBackground1Data   , Background1Data   );
    remapimage(    &Background2, OriginalBackground2Data   , Background2Data   );

    // must be done after remapimage()
    Squares.Depth     =
    Logo.Depth        =
    Boing.Depth       =
    About.Depth       =
    Background1.Depth =
    Background2.Depth = 8;
}

MODULE void remapimage(struct Image* image, UWORD* imagedata1, UWORD* imagedata2)
{   int   colour,
          height,
          plane,
          planes,
          wordwidth,
          x1, x2,
          y1;
    UWORD thebit;

    wordwidth  = image->Width / 16;
    if (image->Width % 16) wordwidth++;
    height     = image->Height;
    planes     = image->Depth;

    for (y1 = 0; y1 < height; y1++)
    {   for (x1 = 0; x1 < wordwidth; x1++)
        {   for (x2 = 0; x2 <= 15; x2++)
            {   // get the colour of this pixel
                colour = 0;
#ifdef __AROS__
                thebit = (x2 < 8) ? (128 >> x2) : (32768 >> (x2 - 8));
#else
                thebit = 32768 >> x2;
#endif
                for (plane = 0; plane < planes; plane++)
                {   if (imagedata1[(((height * plane) + y1) * wordwidth) + x1] & thebit)
                    {   colour |= 1 << plane;
                }   }

                // now remap it
                colour = remapit[colour];

                // and set it
                for (plane = 0; plane < 8; plane++)
                {   if (colour & (1 << plane))
                    {   imagedata2[(((height * plane) + y1) * wordwidth) + x1] |= thebit;
}   }   }   }   }   }
