#include <stdlib.h>                  // size_t

#ifdef AMIGA
    #include "shared.h"
    #include "amiga.h"
#endif
#include "ww.h"

#ifdef AMIGA
    #include <graphics/gfx.h>            /* PLANEPTR */
    #include <intuition/intuitionbase.h> /* struct IntuitionBase */

    #include <proto/intuition.h>
#endif

// IMPORT struct IntuitionBase* IntuitionBase;
IMPORT struct Window*        MainWindowPtr;
IMPORT SWORD                 fieldx, fieldy;
IMPORT FLAG                  engraved,
                             superturbo;
IMPORT UBYTE                 engraving;
IMPORT SBYTE                 a;
IMPORT int                   xoffset,
                             yoffset;
IMPORT UWORD*                SquaresData[ARRAYSIZE + 1];

EXPORT UWORD OriginalSquaresData[ARRAYSIZE + 1][SQUAREY * DEPTH] = {
{ // AFFIXER
  0,
  0,
  896,
  59328,
  58688,
  59328,
  4064,
  2976,
  7088,
  7280,
  8176,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  59072,
  58432,
  57344,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  36848,
  61424,
  60784,
  65520,
  65520,
  64432,
  64432,
  64624,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  4080,
  61424,
  60784,
  65520,
  32752,
  31664,
  31664,
  31856,
  32752,
  32752
},
{ 0, // AMMO
  0,
  512,
  1792,
  1792,
  1792,
  1792,
  1792,
  1792,
  1792,
  3968,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ 0, // ARMOUR
  0,
  3968,
  3968,
  8128,
  4160,
  4160,
  8128,
  8128,
  8128,
  8128,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  61552,
  61552,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  28784,
  28784,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ 0x0000, // AUTOJUMP
  0x0000,
  0x0000,
  0x0600,
  0x0900,
  0x1180,
  0x1080,
  0x22D0,
  0x21E0,
  0x20C0,
  0x4000,
  0x4000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // AUTOTURN
  0x0000,
  0x2020,
  0x7070,
  0x28A0,
  0x0500,
  0x0500,
  0x0500,
  0x0500,
  0x0500,
  0x0500,
  0x0500,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // BACKWARDS
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0700,
  0x1740,
  0x2720,
  0x4710,
  0x0700,
  0x0700,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0200,
  0x0000,
  0x0500,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // BONUS
  0,
  0,
  64,
  64,
  64,
  128,
  128,
  128,
  2304,
  1280,
  768,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // BRAKES
  0x0000,
  0x0000,
  0x0000,
  0x18C0,
  0x38E0,
  0x3060,
  0x3060,
  0x3060,
  0x38E0,
  0x18C0,
  0x0000,
  0x0000,
  // Plane 1
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  // Plane 3
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // CUTTER
  0,
  4368,
  8736,
  30576,
  8736,
  17472,
  0,
  4368,
  8736,
  30576,
  8736,
  17472,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ 0x0F80, // CYCLONE_O
  0x3060,
  0x18C0,
  0x0F40,
  0x0580,
  0x0280,
  0x0780,
  0x0B00,
  0x0600,
  0x0280,
  0x0700,
  0x0200,
  /* Plane 1 */
  0x0000,
  0x0F80,
  0x0700,
  0x0080,
  0x0A00,
  0x0140,
  0x0000,
  0x0400,
  0x0000,
  0x0100,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0F80,
  0x7070,
  0x78F0,
  0x7F70,
  0x75F0,
  0x7EB0,
  0x7FF0,
  0x7BF0,
  0x7FF0,
  0x7EF0,
  0x7FF0,
  0x7FF0
},
{ // ENCLOSER
  6144,
  6144,
  6144,
  65472,
  65472,
  8128,
  8128,
  8128,
  8128,
  8128,
  8128,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  6144,
  32752,
  32752,
  65520,
  65520,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ 0x0000, // FORWARDS
  0x0000,
  0x0000,
  0x4010,
  0x2020,
  0x1040,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0200,
  0x0000,
  0x0500,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GLOW
  0,
  0,
  1536,
  8064,
  16320,
  32736,
  30432,
  32736,
  16320,
  3840,
  3840,
  3840,
  /* Plane 1 */
  1536,
  1536,
  0,
  0,
  0,
  0,
  12480,
  14784,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  63984,
  63984,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  1536,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ 0x0000, // GRABBER
  0x0000,
  0x2800,
  0x1800,
  0x3800,
  0x0000,
  0x0200,
  0x0000,
  0x00E0,
  0x00C0,
  0x00A0,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x28A0,
  0x18C0,
  0x38E0,
  0x0000,
  0x0200,
  0x0000,
  0x38E0,
  0x18C0,
  0x28A0,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFF50,
  0xFF30,
  0xFF10,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF10,
  0xFF30,
  0xFF50,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x57F0,
  0x67F0,
  0x47F0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x47F0,
  0x67F0,
  0x57F0,
  0x7FF0
},
{ 0x0000, // GRENADE
  0x0000,
  0x1000,
  0x38E0,
  0x3910,
  0x3900,
  0x3900,
  0x3B80,
  0x3FC0,
  0x3FC0,
  0x7F80,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0010,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF10,
  0xFEF0,
  0xFEF0,
  0xFEF0,
  0xFC70,
  0xF830,
  0xF830,
  0xFC70,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7F10,
  0x7EF0,
  0x7EF0,
  0x7EF0,
  0x7C70,
  0x7830,
  0x7830,
  0x7C70,
  0x7FF0
},
{ // GROWER
  0,
  512,
  1920,
  2624,
  4608,
  4608,
  3968,
  576,
  576,
  4736,
  3840,
  512,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // ICE
  0,
  0,
  2016,
  2144,
  8096,
  4256,
  4256,
  4256,
  4288,
  8064,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  2016,
  4064,
  8160,
  8160,
  8160,
  8160,
  8128,
  8064,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  30832,
  32688,
  28848,
  28848,
  28848,
  28912,
  32752,
  32752,
  32752
},
{ // LIGHTNING
  0,
  0,
  512,
  1024,
  1024,
  2048,
  3840,
  256,
  512,
  512,
  1024,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ 0x0000, // MINIBOMB
  0x0000,
  0x0000,
  0x01C0,
  0x0220,
  0x0200,
  0x0200,
  0x0700,
  0x0F80,
  0x0F80,
  0x0700,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFE30,
  0xFDF0,
  0xFDF0,
  0xFDF0,
  0xF8F0,
  0xF070,
  0xF070,
  0xF8F0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7E30,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x78F0,
  0x7070,
  0x7070,
  0x78F0,
  0x7FF0
},
{ // MINIHEALER
  0,
  0,
  0,
  3456,
  8128,
  8128,
  3968,
  1792,
  512,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // MINIPULSE
  0,
  0,
  1280,
  4160,
  0,
  8736,
  1792,
  8736,
  0,
  4160,
  1280,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // MISSILE
  0,
  0,
  0,
  512,
  512,
  512,
  8128,
  512,
  512,
  512,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // MULTIPLIER
  0,
  0,
  0,
  224,
  272,
  17424,
  10336,
  4224,
  10496,
  17904,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65248,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32480,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // PROTECTOR
  0,
  1536,
  3840,
  8064,
  16320,
  32736,
  32736,
  16320,
  8064,
  3840,
  1536,
  0,
  /* Plane 1 */
  0,
  512,
  768,
  896,
  960,
  992,
  31744,
  15360,
  7168,
  3072,
  1024,
  0,
  /* Plane 2 */
  65520,
  65008,
  64752,
  64624,
  64560,
  64528,
  33776,
  50160,
  58352,
  62448,
  64496,
  65520,
  /* Plane 3 */
  0,
  31728,
  29680,
  25584,
  17392,
  1008,
  31760,
  31792,
  31856,
  31984,
  32240,
  32752
},
{ // PROTECTOR
  0,
  0,
  1792,
  3968,
  2688,
  3968,
  8128,
  5952,
  14176,
  14560,
  16352,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  3456,
  2176,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  64240,
  65520,
  65520,
  63344,
  63344,
  63728,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  31472,
  32752,
  32752,
  30576,
  30576,
  30960,
  32752,
  32752
},
{ // PUSHER
  0,
  0,
  992,
  992,
  992,
  992,
  3040,
  4096,
  16352,
  4096,
  2048,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  64528,
  64528,
  64528,
  64528,
  64528,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  31760,
  31760,
  31760,
  31760,
  31760,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // REMNANT
  0,
  0,
  4096,
  14336,
  15328,
  15328,
  15328,
  15328,
  15328,
  14336,
  31744,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  64528,
  64528,
  64528,
  64528,
  64528,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  31760,
  31760,
  31760,
  31760,
  31760,
  32752,
  32752,
  32752
},
{ // SIDESHOT
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x7770,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0200,
  0x0000,
  0x0500,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // SLAYER
  0,
  0,
  512,
  4672,
  3968,
  3968,
  16352,
  3968,
  3968,
  4672,
  512,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // SLOWER
  3840,
  16256,
  16864,
  31728,
  30224,
  28592,
  16752,
  15888,
  4064,
  1792,
  512,
  512,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  49648,
  64496,
  62992,
  61360,
  49520,
  65040,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  3840,
  32752,
  16880,
  31728,
  30224,
  28592,
  16752,
  32272,
  32752,
  32752,
  32752,
  32752
},
{ 0x0000, // SUPERBOMB
  0x0F00,
  0x0000,
  0x0600,
  0x3FC0,
  0x7FE0,
  0x1680,
  0xB2D0,
  0xB4D0,
  0x36C0,
  0x3FC0,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0F00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF9F0,
  0xC030,
  0x8010,
  0x0000,
  0x0000,
  0x0000,
  0x8010,
  0xC030,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x79F0,
  0x79F0,
  0x4030,
  0x0010,
  0x0000,
  0x0000,
  0x0000,
  0x0010,
  0x4030,
  0x7FF0
},
{ // SUPERHEALER
  0,
  0,
  6336,
  15840,
  15840,
  16352,
  8128,
  8128,
  3968,
  1792,
  512,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ 0x0000, // SUPERPULSE
  0x4510,
  0x2520,
  0x1040,
  0x0000,
  0x6230,
  0x0700,
  0x6230,
  0x0000,
  0x1040,
  0x2520,
  0x4510,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
},
{ 0, // SWITCHER
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ 0x0000, // TAMER
  0x0000,
  0x0000,
  0x0200,
  0x6300,
  0x3FE0,
  0x3FB0,
  0x3FC0,
  0x6000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x00C0,
  0x0080,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFB0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FB0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
},
{ // TREASURE
  0,
  0,
  30784,
  64736,
  64848,
  8512,
  8416,
  8272,
  8528,
  10464,
  4160,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  65520,
  65520,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // UMBRELLA
  0,
  0,
  512,
  6848,
  9504,
  9504,
  512,
  512,
  512,
  576,
  384,
  0,
  /* Plane 1 */
  0,
  0,
  1280,
  1280,
  6848,
  6848,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  64240,
  64240,
  58672,
  58672,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Number 1
  0,
  0,
  512,
  1536,
  512,
  512,
  512,
  512,
  512,
  512,
  1792,
  0,
  /* Plane 1 */
  0,
  0,
  512,
  1536,
  512,
  512,
  512,
  512,
  512,
  512,
  1792,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Number 2
  0,
  0,
  1792,
  2176,
  128,
  128,
  256,
  512,
  1024,
  2048,
  3968,
  0,
  /* Plane 1 */
  0,
  0,
  1792,
  2176,
  128,
  128,
  256,
  512,
  1024,
  2048,
  3968,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Number 3
  0,
  0,
  1792,
  2176,
  128,
  128,
  1792,
  128,
  128,
  2176,
  1792,
  0,
  /* Plane 1 */
  0,
  0,
  1792,
  2176,
  128,
  128,
  1792,
  128,
  128,
  2176,
  1792,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Number 4
  0,
  0,
  128,
  384,
  640,
  640,
  1152,
  4032,
  128,
  128,
  128,
  0,
  /* Plane 1 */
  0,
  0,
  128,
  384,
  640,
  640,
  1152,
  4032,
  128,
  128,
  128,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Number 5
  0,
  0,
  3968,
  2048,
  2048,
  2048,
  3840,
  128,
  128,
  128,
  3840,
  0,
  /* Plane 1 */
  0,
  0,
  3968,
  2048,
  2048,
  2048,
  3840,
  128,
  128,
  128,
  3840,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ 0x0000, // Number 6
  0x0000,
  0x0700,
  0x0880,
  0x0800,
  0x0800,
  0x0F00,
  0x0880,
  0x0880,
  0x0880,
  0x0700,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0700,
  0x0880,
  0x0800,
  0x0800,
  0x0F00,
  0x0880,
  0x0880,
  0x0880,
  0x0700,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // Number 7
  0,
  0,
  3968,
  128,
  128,
  256,
  256,
  256,
  512,
  512,
  512,
  0,
  /* Plane 1 */
  0,
  0,
  3968,
  128,
  128,
  256,
  256,
  256,
  512,
  512,
  512,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Number 8
  0,
  0,
  1792,
  2176,
  2176,
  2176,
  1792,
  2176,
  2176,
  2176,
  1792,
  0,
  /* Plane 1 */
  0,
  0,
  1792,
  2176,
  2176,
  2176,
  1792,
  2176,
  2176,
  2176,
  1792,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ 0x0000, // Number 9
  0x0000,
  0x0700,
  0x0880,
  0x0880,
  0x0880,
  0x0780,
  0x0080,
  0x0080,
  0x0880,
  0x0700,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0700,
  0x0880,
  0x0880,
  0x0880,
  0x0780,
  0x0080,
  0x0080,
  0x0880,
  0x0700,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // EMPTY
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ 0x0000, // SILVER
  0x0000,
  0x0000,
  0x0200,
  0x0700,
  0x0F80,
  0x1FC0,
  0x0F80,
  0x0700,
  0x0200,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0200,
  0x0700,
  0x0200,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xF8F0,
  0xF270,
  0xE730,
  0xF270,
  0xF8F0,
  0xFDF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7DF0,
  0x78F0,
  0x7070,
  0x6230,
  0x4710,
  0x6230,
  0x7070,
  0x78F0,
  0x7DF0,
  0x7FF0
},
{ 0x0000, // GOLD
  0x0000,
  0x0200,
  0x0700,
  0x0F80,
  0x1FC0,
  0x3FE0,
  0x1FC0,
  0x0F80,
  0x0700,
  0x0200,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0200,
  0x0700,
  0x0F80,
  0x1FC0,
  0x3FE0,
  0x1FC0,
  0x0F80,
  0x0700,
  0x0200,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xF8F0,
  0xF070,
  0xE230,
  0xC710,
  0xE230,
  0xF070,
  0xF8F0,
  0xFDF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7DF0,
  0x7AF0,
  0x7770,
  0x6FB0,
  0x5FD0,
  0x6FB0,
  0x7770,
  0x7AF0,
  0x7DF0,
  0x7FF0
},
{ 0x0000, // DYNAMITE
  0x0000,
  0x0180,
  0x0200,
  0x0200,
  0x0200,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0880,
  0x0F80,
  0x0F80,
  0x0F80,
  0x0F80,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFE70,
  0xFDF0,
  0xFDF0,
  0xF8F0,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7E70,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // WOOD
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0xFFE0, // STONE
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0010,
  0x0010,
  0x0010,
  0x0010,
  0x0010,
  0x0010,
  0x0010,
  0x0010,
  0x0010,
  0x0010,
  0x0010,
  0x7FF0,
  /* Plane 3 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000
},
{ // METAL
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  /* Plane 3 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0
},
{ 0x0000, // FROST
  0x5200,
  0x0AE0,
  0x4F80,
  0x7330,
  0x57E0,
  0x2C80,
  0x4C80,
  0x63F0,
  0x1580,
  0x7360,
  0x4C10,
  /* Plane 1 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x5200,
  0x0AE0,
  0x4F80,
  0x7330,
  0x57E0,
  0x2C80,
  0x4C80,
  0x63F0,
  0x1580,
  0x7360,
  0x4C10
},
{ // SLIME
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  9504,
  5440,
  3968,
  16352,
  3968,
  16352,
  3968,
  5440,
  9504,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // TELEPORT
  0,
  32752,
  32752,
  24624,
  24624,
  24624,
  24624,
  24624,
  24624,
  24624,
  32752,
  32752,
  /* Plane 1 */
  0,
  32752,
  16400,
  16400,
  16400,
  16400,
  16400,
  16400,
  16400,
  16400,
  16400,
  32752,
  /* Plane 2 */
  65520,
  65520,
  49168,
  57296,
  57296,
  55504,
  55504,
  55504,
  57296,
  57296,
  49168,
  65520,
  /* Plane 3 */
  0,
  32752,
  16400,
  16400,
  20368,
  18576,
  18576,
  18576,
  20368,
  16400,
  16400,
  32752
},
{ 0x0000, // ARROWUP
  0x0000,
  0x0200,
  0x0700,
  0x0F80,
  0x1740,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xF8F0,
  0xF070,
  0xE8B0,
  0xF8F0,
  0xF8F0,
  0xF8F0,
  0xF8F0,
  0xF8F0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7DF0,
  0x78F0,
  0x7070,
  0x68B0,
  0x78F0,
  0x78F0,
  0x78F0,
  0x78F0,
  0x78F0,
  0x7FF0
},
{ 0x0000, // ARROWDOWN
  0x0000,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  0x1740,
  0x0F80,
  0x0700,
  0x0200,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xF8F0,
  0xF8F0,
  0xF8F0,
  0xF8F0,
  0xF8F0,
  0xE8B0,
  0xF070,
  0xF8F0,
  0xFDF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x78F0,
  0x78F0,
  0x78F0,
  0x78F0,
  0x78F0,
  0x68B0,
  0x7070,
  0x78F0,
  0x7DF0,
  0x7FF0
},
{ // START
  0,
  512,
  1792,
  1792,
  4672,
  12896,
  32752,
  12896,
  4672,
  1792,
  1792,
  512,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65008,
  63728,
  63728,
  60848,
  52624,
  32768,
  52624,
  60848,
  63728,
  63728,
  65008,
  /* Plane 3 */
  0,
  32240,
  30960,
  30960,
  28080,
  19856,
  0,
  19856,
  28080,
  30960,
  30960,
  32240
},
{ // Green Arrow
  0x0000,
  0x0000,
  0x0000,
  0x0400,
  0x0800,
  0x1FE0,
  0x3FE0,
  0x1FE0,
  0x0800,
  0x0400,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0400,
  0x0800,
  0x1FE0,
  0x3FE0,
  0x1FE0,
  0x0800,
  0x0400,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x8000,
  0x8000,
  0x8000,
  0x8400,
  0x8800,
  0x9FE0,
  0xBFE0,
  0x9FE0,
  0x8800,
  0x8400,
  0x8000,
  0x8000,
  /* Plane 3 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000
},
{ // Red Arrow
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0400,
  0x0800,
  0x1FE0,
  0x3FE0,
  0x1FE0,
  0x0800,
  0x0400,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  /* Plane 3 */
  0x0000,
  0x0000,
  0x0000,
  0x0400,
  0x0800,
  0x1FE0,
  0x3FE0,
  0x1FE0,
  0x0800,
  0x0400,
  0x0000,
  0x0000
},
{ // Blue Arrow
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0400,
  0x0800,
  0x1FE0,
  0x3FE0,
  0x1FE0,
  0x0800,
  0x0400,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x8000,
  0x8000,
  0x8000,
  0x8400,
  0x8800,
  0x9FE0,
  0xBFE0,
  0x9FE0,
  0x8800,
  0x8400,
  0x8000,
  0x8000,
  /* Plane 3 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000
},
{ // Yellow Arrow
  0x0000,
  0x0000,
  0x0000,
  0x0400,
  0x0800,
  0x1FE0,
  0x3FE0,
  0x1FE0,
  0x0800,
  0x0400,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0400,
  0x0800,
  0x1FE0,
  0x3FE0,
  0x1FE0,
  0x0800,
  0x0400,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  /* Plane 3 */
  0x0000,
  0x0000,
  0x0000,
  0x0400,
  0x0800,
  0x1FE0,
  0x3FE0,
  0x1FE0,
  0x0800,
  0x0400,
  0x0000,
  0x0000
},
{ // Green Rain
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1280,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  512,
  512,
  512,
  1792,
  1792,
  1792,
  3968,
  3968,
  512,
  0,
  /* Plane 2 */
  65520,
  65520,
  65008,
  65008,
  65008,
  63728,
  63728,
  63728,
  61552,
  62832,
  63728,
  65520,
  /* Plane 3 */
  0,
  32752,
  32240,
  32240,
  32240,
  30960,
  30960,
  30960,
  28784,
  30064,
  30960,
  32752
},
{ // Red Rain
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1280,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1280,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65008,
  65008,
  65008,
  63728,
  63728,
  63728,
  61552,
  62832,
  63728,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  31472,
  32752
},
{ // Blue Rain
  0,
  0,
  512,
  512,
  512,
  1792,
  1792,
  1792,
  3968,
  3968,
  512,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1280,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  64240,
  65520,
  /* Plane 3 */
  0,
  32752,
  32240,
  32240,
  32240,
  30960,
  30960,
  30960,
  28784,
  30064,
  30960,
  32752
},
{ // Yellow Rain
  0,
  0,
  512,
  512,
  512,
  1792,
  1792,
  1792,
  3968,
  3968,
  512,
  0,
  /* Plane 1 */
  0,
  0,
  512,
  512,
  512,
  1792,
  1792,
  1792,
  3968,
  3968,
  512,
  0,
  /* Plane 2 */
  65520,
  65520,
  65008,
  65008,
  65008,
  63728,
  63728,
  63728,
  61552,
  62832,
  63728,
  65520,
  /* Plane 3 */
  0,
  32752,
  32240,
  32240,
  32240,
  30960,
  30960,
  30960,
  28784,
  30064,
  30960,
  32752
},
{ // Green Missile
  // Frame 0
  0,
  0,
  0,
  0,
  0,
  512,
  1792,
  512,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  512,
  512,
  512,
  8128,
  512,
  512,
  512,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65008,
  65008,
  65520,
  59184,
  65520,
  65008,
  65008,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32240,
  32240,
  32240,
  25136,
  32240,
  32240,
  32240,
  32752,
  32752
},
{ // Red Missile
  // Frame 0
  0,
  0,
  0,
  0,
  0,
  0,
  512,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  512,
  1792,
  512,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65008,
  65008,
  65008,
  57904,
  65008,
  65008,
  65008,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Blue Missile
  // Frame 0
  0,
  0,
  0,
  512,
  512,
  0,
  6848,
  0,
  512,
  512,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  512,
  1792,
  512,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32240,
  32240,
  32240,
  25136,
  32240,
  32240,
  32240,
  32752,
  32752
},
{ // Yellow Missile
  // Frame 0
  0,
  0,
  0,
  512,
  512,
  512,
  8128,
  512,
  512,
  512,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  512,
  512,
  512,
  8128,
  512,
  512,
  512,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65008,
  65008,
  65008,
  57904,
  65008,
  65008,
  65008,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32240,
  32240,
  32752,
  26416,
  32752,
  32240,
  32240,
  32752,
  32752
},
{ // Green Protector
  0,
  0,
  1792,
  3968,
  2688,
  3968,
  8128,
  5952,
  14176,
  14560,
  16352,
  0,
  /* Plane 1 */
  0,
  0,
  1792,
  3968,
  2688,
  3968,
  8128,
  5952,
  14176,
  14560,
  16352,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  64240,
  65520,
  65520,
  63344,
  63344,
  63728,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  30960,
  32240,
  30960,
  28784,
  24624,
  24624,
  16400,
  16400,
  16400,
  32752
},
{ // Red Protector
  0,
  0,
  0,
  3456,
  2176,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  1792,
  3968,
  2688,
  3968,
  8128,
  5952,
  14176,
  14560,
  16352,
  0,
  /* Plane 2 */
  65520,
  65520,
  63728,
  65008,
  63728,
  61552,
  57392,
  57392,
  49168,
  49168,
  49168,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  31472,
  32752,
  32752,
  30576,
  30576,
  30960,
  32752,
  32752
},
{ // Blue Protector
  0,
  0,
  0,
  3456,
  2176,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  1792,
  3968,
  2688,
  3968,
  8128,
  5952,
  14176,
  14560,
  16352,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  64240,
  65520,
  65520,
  63344,
  63344,
  63728,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  30960,
  32240,
  30960,
  28784,
  24624,
  24624,
  16400,
  16400,
  16400,
  32752
},
{ // Yellow Protector
  0,
  0,
  1792,
  3968,
  2688,
  3968,
  8128,
  5952,
  14176,
  14560,
  16352,
  0,
  /* Plane 1 */
  0,
  0,
  1792,
  3968,
  2688,
  3968,
  8128,
  5952,
  14176,
  14560,
  16352,
  0,
  /* Plane 2 */
  65520,
  65520,
  63728,
  65008,
  63728,
  61552,
  57392,
  57392,
  49168,
  49168,
  49168,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  31472,
  32752,
  32752,
  30576,
  30576,
  30960,
  32752,
  32752
},
{ 0, // Green Tail
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 2 */
  65520,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  /* Plane 3 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0
},
{ // Red Tail
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Blue Tail
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0
},
{ // Yellow Tail
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 1 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 2 */
  65520,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  /* Plane 3 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0
},
{ 0, // Green Glow
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 1 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0
},
{ // Red Glow
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 2 */
  65520,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Blue Glow
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0
},
{ // Yellow Glow
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 1 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 2 */
  65520,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Green Fire
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  512,
  1792,
  1792,
  1792,
  1792,
  1792,
  1792,
  1792,
  3968,
  0,
  /* Plane 2 */
  65520,
  65520,
  65008,
  63728,
  63728,
  63728,
  63728,
  63728,
  63728,
  63728,
  61552,
  65520,
  /* Plane 3 */
  0,
  32752,
  32240,
  30960,
  30960,
  30960,
  30960,
  30960,
  30960,
  30960,
  28784,
  32752
},
{ // Red Fire
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65008,
  63728,
  63728,
  63728,
  63728,
  63728,
  63728,
  63728,
  61552,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Blue Fire
  0,
  0,
  512,
  1792,
  1792,
  1792,
  1792,
  1792,
  1792,
  1792,
  3968,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32240,
  30960,
  30960,
  30960,
  30960,
  30960,
  30960,
  30960,
  28784,
  32752
},
{ // Yellow Fire
  0,
  0,
  512,
  1792,
  1792,
  1792,
  1792,
  1792,
  1792,
  1792,
  3968,
  0,
  /* Plane 1 */
  0,
  0,
  512,
  1792,
  1792,
  1792,
  1792,
  1792,
  1792,
  1792,
  3968,
  0,
  /* Plane 2 */
  65520,
  65520,
  65008,
  63728,
  63728,
  63728,
  63728,
  63728,
  63728,
  63728,
  61552,
  65520,
  /* Plane 3 */
  0,
  32752,
  32240,
  30960,
  30960,
  30960,
  30960,
  30960,
  30960,
  30960,
  28784,
  32752
},
{ // Green Grave
  512,
  512,
  3968,
  512,
  512,
  512,
  1792,
  3968,
  3968,
  3968,
  3968,
  3968,
  /* Plane 1 */
  512,
  512,
  3968,
  512,
  512,
  512,
  1792,
  3968,
  3968,
  3968,
  3968,
  3968,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32240,
  28784,
  32240,
  32240,
  32240,
  30960,
  28784,
  28784,
  28784,
  28784,
  28784
},
{ // Red Grave
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  512,
  512,
  3968,
  512,
  512,
  512,
  1792,
  3968,
  3968,
  3968,
  3968,
  3968,
  /* Plane 2 */
  65008,
  65008,
  61552,
  65008,
  65008,
  65008,
  63728,
  61552,
  61552,
  61552,
  61552,
  61552,
  /* Plane 3 */
  512,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Blue Grave
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  512,
  512,
  3968,
  512,
  512,
  512,
  1792,
  3968,
  3968,
  3968,
  3968,
  3968,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32240,
  28784,
  32240,
  32240,
  32240,
  30960,
  28784,
  28784,
  28784,
  28784,
  28784
},
{ // Yellow Grave
  512,
  512,
  3968,
  512,
  512,
  512,
  1792,
  3968,
  3968,
  3968,
  3968,
  3968,
  /* Plane 1 */
  512,
  512,
  3968,
  512,
  512,
  512,
  1792,
  3968,
  3968,
  3968,
  3968,
  3968,
  /* Plane 2 */
  65008,
  65008,
  61552,
  65008,
  65008,
  65008,
  63728,
  61552,
  61552,
  61552,
  61552,
  61552,
  /* Plane 3 */
  512,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Green Pain
  0,
  0,
  12384,
  14560,
  7616,
  3968,
  1792,
  3968,
  7616,
  14560,
  12384,
  0,
  /* Plane 1 */
  0,
  0,
  12384,
  14560,
  7616,
  3968,
  1792,
  3968,
  7616,
  14560,
  12384,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  20368,
  18192,
  25136,
  28784,
  30960,
  28784,
  25136,
  18192,
  20368,
  32752
},
{ // Red Pain
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  12384,
  14560,
  7616,
  3968,
  1792,
  3968,
  7616,
  14560,
  12384,
  0,
  /* Plane 2 */
  65520,
  65520,
  53136,
  50960,
  57904,
  61552,
  63728,
  61552,
  57904,
  50960,
  53136,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Blue Pain
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  12384,
  14560,
  7616,
  3968,
  1792,
  3968,
  7616,
  14560,
  12384,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  20368,
  18192,
  25136,
  28784,
  30960,
  28784,
  25136,
  18192,
  20368,
  32752
},
{ // Yellow Pain
  0,
  0,
  12384,
  14560,
  7616,
  3968,
  1792,
  3968,
  7616,
  14560,
  12384,
  0,
  /* Plane 1 */
  0,
  0,
  12384,
  14560,
  7616,
  3968,
  1792,
  3968,
  7616,
  14560,
  12384,
  0,
  /* Plane 2 */
  65520,
  65520,
  53136,
  50960,
  57904,
  61552,
  63728,
  61552,
  57904,
  50960,
  53136,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Green Head
  0,
  0,
  0,
  0,
  0,
  0,
  12480,
  14784,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  1536,
  1536,
  1536,
  8064,
  16320,
  32736,
  30432,
  32736,
  16320,
  3840,
  3840,
  3840,
  /* Plane 2 */
  63984,
  63984,
  63984,
  57456,
  49200,
  32784,
  45264,
  47568,
  49200,
  61680,
  61680,
  61680,
  /* Plane 3 */
  1536,
  32752,
  31216,
  24688,
  16432,
  16,
  12496,
  14800,
  16432,
  28912,
  28912,
  28912
},
{ // Red Head
  0,
  0,
  0,
  0,
  0,
  0,
  12480,
  14784,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  1536,
  1536,
  0,
  0,
  0,
  0,
  12480,
  14784,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  63984,
  57456,
  49200,
  32784,
  45264,
  47568,
  49200,
  61680,
  61680,
  61680,
  /* Plane 3 */
  0,
  31216,
  32752,
  32752,
  32752,
  32752,
  30448,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Blue Head
  0,
  0,
  1536,
  8064,
  16320,
  32736,
  30432,
  32736,
  16320,
  3840,
  3840,
  3840,
  /* Plane 1 */
  1536,
  1536,
  0,
  0,
  0,
  0,
  12480,
  14784,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  63984,
  63984,
  65520,
  65520,
  65520,
  65520,
  63216,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  1536,
  32752,
  31216,
  24688,
  16432,
  16,
  12496,
  14800,
  16432,
  28912,
  28912,
  28912
},
{ // Yellow Head
  0,
  0,
  1536,
  8064,
  16320,
  32736,
  30432,
  32736,
  16320,
  3840,
  3840,
  3840,
  /* Plane 1 */
  1536,
  1536,
  1536,
  8064,
  16320,
  32736,
  30432,
  32736,
  16320,
  3840,
  3840,
  3840,
  /* Plane 2 */
  65520,
  65520,
  63984,
  57456,
  49200,
  32784,
  45264,
  47568,
  49200,
  61680,
  61680,
  61680,
  /* Plane 3 */
  0,
  31216,
  31216,
  24688,
  16432,
  16,
  12496,
  14800,
  16432,
  28912,
  28912,
  28912
},
{ 0x0000, // Green Cherry
  0x0000,
  0x0200,
  0x0500,
  0x0500,
  0x0880,
  0x1040,
  0x18C0,
  0x3DE0,
  0x3DE0,
  0x18C0,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0200,
  0x0500,
  0x0500,
  0x0880,
  0x1040,
  0x18C0,
  0x3DE0,
  0x3DE0,
  0x18C0,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7DF0,
  0x7AF0,
  0x7AF0,
  0x7770,
  0x6FB0,
  0x6730,
  0x4210,
  0x4210,
  0x6730,
  0x7FF0
},
{ 0x0000, // Red Cherry
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0200,
  0x0500,
  0x0500,
  0x0880,
  0x1040,
  0x18C0,
  0x3DE0,
  0x3DE0,
  0x18C0,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xFAF0,
  0xFAF0,
  0xF770,
  0xEFB0,
  0xE730,
  0xC210,
  0xC210,
  0xE730,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // Blue Cherry
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0200,
  0x0500,
  0x0500,
  0x0880,
  0x1040,
  0x18C0,
  0x3DE0,
  0x3DE0,
  0x18C0,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7DF0,
  0x7AF0,
  0x7AF0,
  0x7770,
  0x6FB0,
  0x6730,
  0x4210,
  0x4210,
  0x6730,
  0x7FF0
},
{ 0x0000, // Yellow Cherry
  0x0000,
  0x0200,
  0x0500,
  0x0500,
  0x0880,
  0x1040,
  0x18C0,
  0x3DE0,
  0x3DE0,
  0x18C0,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0200,
  0x0500,
  0x0500,
  0x0880,
  0x1040,
  0x18C0,
  0x3DE0,
  0x3DE0,
  0x18C0,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xFAF0,
  0xFAF0,
  0xF770,
  0xEFB0,
  0xE730,
  0xC210,
  0xC210,
  0xE730,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // Green Flower
  0x0000,
  0x0200,
  0x1740,
  0x0A80,
  0x1740,
  0x3FE0,
  0x1740,
  0x0A80,
  0x1740,
  0x0200,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0200,
  0x1740,
  0x0A80,
  0x1740,
  0x3FE0,
  0x1740,
  0x0A80,
  0x1740,
  0x0200,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7DF0,
  0x68B0,
  0x7570,
  0x68B0,
  0x4210,
  0x68B0,
  0x7570,
  0x68B0,
  0x7DF0,
  0x7FF0
},
{ 0x0000, // Red Flower
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0200,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0200,
  0x1740,
  0x0A80,
  0x1740,
  0x3FE0,
  0x1740,
  0x0A80,
  0x1740,
  0x0200,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xE8B0,
  0xF570,
  0xE8B0,
  0xC210,
  0xE8B0,
  0xF570,
  0xE8B0,
  0xFDF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // Blue Flower
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0200,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0200,
  0x1740,
  0x0A80,
  0x1740,
  0x3FE0,
  0x1740,
  0x0A80,
  0x1740,
  0x0200,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7DF0,
  0x68B0,
  0x7570,
  0x68B0,
  0x4210,
  0x68B0,
  0x7570,
  0x68B0,
  0x7DF0,
  0x7FF0
},
{ 0x0000, // Yellow Flower
  0x0000,
  0x0200,
  0x1740,
  0x0A80,
  0x1740,
  0x3FE0,
  0x1740,
  0x0A80,
  0x1740,
  0x0200,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0200,
  0x1740,
  0x0A80,
  0x1740,
  0x3FE0,
  0x1740,
  0x0A80,
  0x1740,
  0x0200,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xE8B0,
  0xF570,
  0xE8B0,
  0xC210,
  0xE8B0,
  0xF570,
  0xE8B0,
  0xFDF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x000F, // Green Banana
  0x000F,
  0x060F,
  0x030F,
  0x030F,
  0x038F,
  0x018F,
  0x038F,
  0x030F,
  0x030F,
  0x060F,
  0x000F,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0600,
  0x0300,
  0x0300,
  0x0380,
  0x0180,
  0x0380,
  0x0300,
  0x0300,
  0x0600,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x79FF,
  0x7CFF,
  0x7CFF,
  0x7C7F,
  0x7E7F,
  0x7C7F,
  0x7CFF,
  0x7CFF,
  0x79FF,
  0x7FFF
},
{ 0x000F, // Red Banana
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0600,
  0x0300,
  0x0300,
  0x0380,
  0x0180,
  0x0380,
  0x0300,
  0x0300,
  0x0600,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xF9F0,
  0xFCF0,
  0xFCF0,
  0xFC70,
  0xFE70,
  0xFC70,
  0xFCF0,
  0xFCF0,
  0xF9F0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF
},
{ 0x000F, // Blue Banana
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0600,
  0x0300,
  0x0300,
  0x0380,
  0x0180,
  0x0380,
  0x0300,
  0x0300,
  0x0600,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x79FF,
  0x7CFF,
  0x7CFF,
  0x7C7F,
  0x7E7F,
  0x7C7F,
  0x7CFF,
  0x7CFF,
  0x79FF,
  0x7FFF
},
{ 0x000F, // Yellow Banana
  0x000F,
  0x060F,
  0x030F,
  0x030F,
  0x038F,
  0x018F,
  0x038F,
  0x030F,
  0x030F,
  0x060F,
  0x000F,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0600,
  0x0300,
  0x0300,
  0x0380,
  0x0180,
  0x0380,
  0x0300,
  0x0300,
  0x0600,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xF9F0,
  0xFCF0,
  0xFCF0,
  0xFC70,
  0xFE70,
  0xFC70,
  0xFCF0,
  0xFCF0,
  0xF9F0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF
},
{ 0xFFF0, // FIRSTFRUIT (1. Apple)
  0xFC70,
  0xF9F0,
  0xE070,
  0xC030,
  0xC030,
  0xC030,
  0xC030,
  0xE070,
  0xF0F0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xFC70,
  0xF9F0,
  0xE070,
  0xC030,
  0xC030,
  0xC030,
  0xC030,
  0xE070,
  0xF0F0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFC70,
  0xF9F0,
  0xF9F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 2. Orange
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xF0F0,
  0xE070,
  0xC030,
  0xC030,
  0xC030,
  0xC030,
  0xE070,
  0xF0F0,
  0xFFF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFF10, // 3. Carrot
  0xFEC0,
  0xFFA0,
  0xFF60,
  0xFFE0,
  0xFFD0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFCF0,
  0xF870,
  0xF870,
  0xF0F0,
  0xE1F0,
  0xC3F0,
  0x8FF0,
  0x9FF0,
  0xFFF0,
  /* Plane 2 */
  0xFF10,
  0xFEC0,
  0xFFA0,
  0xFF60,
  0xFFE0,
  0xFFD0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xFF10,
  0xFEC0,
  0xFFA0,
  0xFF60,
  0xFFE0,
  0xFFD0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 4. Lemon
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF9F0,
  0xE070,
  0xC030,
  0xC030,
  0xE070,
  0xF9F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 5. Radish
  0xFFF0,
  0xFAF0,
  0xF570,
  0xF8F0,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF8F0,
  0xFDF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFAF0,
  0xF570,
  0xF8F0,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF8F0,
  0xFDF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xFAF0,
  0xF570,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 6. Pineapple
  0xFDF0,
  0xE530,
  0xF8F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFAF0,
  0xF570,
  0xFAF0,
  0xF570,
  0xFAF0,
  0xF570,
  0xFAF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xFDF0,
  0xE530,
  0xF8F0,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF8F0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFDF0,
  0xE530,
  0xF8F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 7. Lime
  0xFFF0,
  0xFFF0,
  0xF9F0,
  0xE070,
  0xC030,
  0xC030,
  0xE070,
  0xF9F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF9F0,
  0xE070,
  0xC030,
  0xC030,
  0xE070,
  0xF9F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF9F0,
  0xE070,
  0xC030,
  0xC030,
  0xE070,
  0xF9F0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 8. Passionfruit
  0xFFF0,
  0xFFF0,
  0xF9F0,
  0xF0F0,
  0xE070,
  0xE070,
  0xF0F0,
  0xF9F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 9. Watermelon
  0xFFF0,
  0x0010,
  0x0010,
  0x0010,
  0x8030,
  0x8030,
  0xC070,
  0xE0F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xEEF0,
  0xFBF0,
  0xEEF0,
  0xFBF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0x0010,
  0x0010,
  0x0010,
  0x8030,
  0x8030,
  0xC070,
  0xE0F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0x7FD0,
  0x6ED0,
  0x3B90,
  0xAEB0,
  0x9B30,
  0xCE70,
  0xE0F0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 10. Coconut
  0xFFF0,
  0xFBF0,
  0xF2F0,
  0xFCF0,
  0xF7F0,
  0xE7F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xF070,
  0xE030,
  0xC010,
  0xC010,
  0xC010,
  0xC010,
  0xC010,
  0xE030,
  0xF070,
  0xFFF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xF070,
  0xE030,
  0xC010,
  0xC010,
  0xC010,
  0xC010,
  0xC010,
  0xE030,
  0xF070,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xFBF0,
  0xF2F0,
  0xFCF0,
  0xF7F0,
  0xE7F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 11. Pear
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xF8F0,
  0xF8F0,
  0xF8F0,
  0xF8F0,
  0xF070,
  0xF070,
  0xF070,
  0xF8F0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 12. Corn
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xF8F0,
  0xF8F0,
  0xF8F0,
  0xFDF0,
  0xFDF0,
  0xFDF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF770,
  0xEAB0,
  0xFAF0,
  0xFAF0,
  0xFDF0,
  0xFDF0,
  0xFFF0
},
{ 0xFFF0, // 13. Blackberry
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFAF0,
  0xF070,
  0xF070,
  0xF070,
  0xF8F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFAF0,
  0xF070,
  0xF070,
  0xF070,
  0xF8F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF8F0,
  0xF070,
  0xF070,
  0xF070,
  0xF8F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF8F0,
  0xF070,
  0xF070,
  0xF070,
  0xF8F0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 14. Blueberry
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFAF0,
  0xF070,
  0xF070,
  0xF070,
  0xF8F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF8F0,
  0xF070,
  0xF070,
  0xF070,
  0xF8F0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 15. Strawberry
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFAF0,
  0xE030,
  0xF570,
  0xE030,
  0xEAB0,
  0xF070,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF270,
  0xE030,
  0xE030,
  0xE030,
  0xE030,
  0xF070,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xFDF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 16.
  0xFFF0,
  0xF6F0,
  0xF6F0,
  0xF6F0,
  0xF6F0,
  0xF6F0,
  0xF6F0,
  0xF6F0,
  0xF6F0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xF6F0,
  0xF6F0,
  0xF6F0,
  0xF6F0,
  0xF6F0,
  0xF6F0,
  0xF6F0,
  0xF6F0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xF0F0,
  0xF0F0,
  0xF0F0,
  0xF0F0,
  0xF0F0,
  0xF0F0,
  0xF0F0,
  0xF0F0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 17.
  0xFFF0,
  0xF9F0,
  0xF9F0,
  0xF0F0,
  0xF0F0,
  0xE070,
  0xE070,
  0xE070,
  0xF0F0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 18.
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xF8F0,
  0xF8F0,
  0xF8F0,
  0xF8F0,
  0xF8F0,
  0xF8F0,
  0xFDF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xF8F0,
  0xF8F0,
  0xF8F0,
  0xF8F0,
  0xF8F0,
  0xF8F0,
  0xFDF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 19.
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xF8F0,
  0xE030,
  0xE030,
  0xC010,
  0xC010,
  0xC010,
  0xC010,
  0xE030,
  0xE030,
  0xF8F0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 20. Lettuce
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xF0F0,
  0xC930,
  0xC930,
  0xE670,
  0xE070,
  0xE070,
  0xF0F0,
  0xF0F0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 21. Soft drink
  0xF8F0,
  0xF770,
  0xF270,
  0xF470,
  0xF270,
  0xF470,
  0xF270,
  0xF470,
  0xF270,
  0xF8F0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xF8F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xF8F0,
  0xF070,
  0xF270,
  0xF470,
  0xF270,
  0xF470,
  0xF270,
  0xF470,
  0xF270,
  0xF8F0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xF8F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 22. Pizza
  0xCFF0,
  0xC3F0,
  0xE5F0,
  0xE8F0,
  0xF330,
  0xF4B0,
  0xF070,
  0xFDF0,
  0xF9F0,
  0xFBF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFD0,
  0xFF90,
  0xFF30,
  0xFE70,
  0xFCF0,
  0xFDF0,
  /* Plane 2 */
  0xFFF0,
  0xCFF0,
  0xC3F0,
  0xE1F0,
  0xE0F0,
  0xF030,
  0xF030,
  0xF070,
  0xF8F0,
  0xF9F0,
  0xFBF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 23. Fries
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xEAB0,
  0xE030,
  0xE530,
  0xFAF0,
  0xFAF0,
  0xF070,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFAF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xEDB0,
  0xF570,
  0xF570,
  0xF570,
  0xE030,
  0xE030,
  0xE030,
  0xF070,
  0xF070,
  0xF070,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 24. Ice cream
  0xFDF0,
  0xFAF0,
  0xFAF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xFDF0,
  0xFAF0,
  0xFAF0,
  0xF770,
  0xF070,
  0xF070,
  0xF8F0,
  0xF8F0,
  0xF8F0,
  0xFDF0,
  0xFDF0,
  /* Plane 2 */
  0xFFF0,
  0xFDF0,
  0xFAF0,
  0xFAF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFDF0,
  0xFAF0,
  0xFAF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ 0xFFF0, // 25. Hamburger (LASTFRUIT)
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF9F0,
  0x8010,
  0x8010,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 1 */
  0xFFF0,
  0xC030,
  0x8010,
  0x8010,
  0xFFF0,
  0xFFF0,
  0x8010,
  0x8010,
  0x8010,
  0x8010,
  0xC030,
  0xFFF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x8910,
  0x8010,
  0x8010,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x8010,
  0xF9F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0
},
{ // MUSIC
  0,
  2016,
  1056,
  2016,
  1056,
  1056,
  1056,
  7392,
  15840,
  15840,
  6336,
  0,
  /* Plane 1 */
  0,
  2016,
  1056,
  2016,
  1056,
  1056,
  1056,
  7392,
  15840,
  15840,
  6336,
  0,
  /* Plane 2 */
  0,
  2016,
  1056,
  2016,
  1056,
  1056,
  1056,
  7392,
  15840,
  15840,
  6336,
  0,
  /* Plane 3 */
  0,
  2016,
  1056,
  2016,
  1056,
  1056,
  1056,
  7392,
  15840,
  15840,
  6336,
  0
},
{ // FX
  0,
  0,
  31264,
  16704,
  16704,
  16512,
  30848,
  16704,
  16704,
  16928,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  31264,
  16704,
  16704,
  16512,
  30848,
  16704,
  16704,
  16928,
  0,
  0,
  /* Plane 2 */
  0,
  0,
  31264,
  16704,
  16704,
  16512,
  30848,
  16704,
  16704,
  16928,
  0,
  0,
  /* Plane 3 */
  0,
  0,
  31264,
  16704,
  16704,
  16512,
  30848,
  16704,
  16704,
  16928,
  0,
  0
},
{ // ALL
  0x0000,
  0x0000,
  0x0000,
  0x0400,
  0x0800,
  0x1FE0,
  0x3FE0,
  0x1FE0,
  0x0800,
  0x0400,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0400,
  0x0800,
  0x1FE0,
  0x3FE0,
  0x1FE0,
  0x0800,
  0x0400,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x8000,
  0x8000,
  0x8000,
  0x8400,
  0x8800,
  0x9FE0,
  0xBFE0,
  0x9FE0,
  0x8800,
  0x8400,
  0x8000,
  0x8000,
  /* Plane 3 */
  0x0000,
  0x0000,
  0x0000,
  0x0400,
  0x0800,
  0x1FE0,
  0x3FE0,
  0x1FE0,
  0x0800,
  0x0400,
  0x0000,
  0x0000
},
{ 0x0000, // BLACKARROW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  0x8000,
  /* Plane 3 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000
},
{ // BLACKENED
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 3 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0
},
{ // WHITENED
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 1 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520
},
{ 0x0000, // BIRD
  0x0000, // Frame 1
  0x0000,
  0x0000,
  0x0000,
  0x0500,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x4010,
  0x3060,
  0x0F80,
  0x0500,
  0x0200,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7DF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // BIRD
  0x0000, // Frame 2
  0x0000,
  0x0000,
  0x0000,
  0x0500,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x3060,
  0x4F90,
  0x0500,
  0x0200,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7DF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // BIRD
  0x0000, // Frame 3
  0x0000,
  0x0000,
  0x0000,
  0x0500,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0F80,
  0x3560,
  0x4210,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7DF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // BIRD
  0x0000, // Frame 4
  0x0000,
  0x0000,
  0x0000,
  0x0500,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0F80,
  0x1540,
  0x2220,
  0x4010,
  0x4010,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7DF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // BULLRIGHT
  0x0000,
  0x0000,
  0x0000,
  0x0030,
  0x0040,
  0x0020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0030,
  0x0740,
  0x0FE0,
  0x3FE0,
  0x7FF0,
  0x3FC0,
  0x3080,
  0x2080,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFE0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FE0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // DOGAWAKENING
  0x0000,
  0x0000,
  0x0000,
  0x0020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0020,
  0x0040,
  0x60E0,
  0x43E0,
  0x7FF0,
  0x3FC0,
  0x3FC0,
  0x1B80,
  0x1080,
  0x1080,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFD0,
  0xFFB0,
  0x9F30,
  0xBC00,
  0x8080,
  0xC070,
  0xC030,
  0xE470,
  0xEF70,
  0xEF70,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FE0,
  0x7F70,
  0x7FB0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // DOGDORMANT
  0x0000,
  0x0020,
  0x0040,
  0x60E0,
  0x43E0,
  0x7F70,
  0x3F80,
  0x3FC0,
  0x1B80,
  0x1080,
  0x1080,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0020,
  0x0000,
  0x0080,
  0x0040,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFD0,
  0xFFB0,
  0x9F30,
  0xBC00,
  0x8080,
  0xC070,
  0xC030,
  0xE470,
  0xEF70,
  0xEF70,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FD0,
  0x7FB0,
  0x1F30,
  0x3C00,
  0x0000,
  0x4030,
  0x4030,
  0x6470,
  0x6F70,
  0x6F70
},
{ 0x0000, // FROGRIGHT
  0x0000,
  0x0000,
  0x0000,
  0x0180,
  0x03C0,
  0x07F0,
  0x0FE0,
  0x1FC0,
  0x1F80,
  0x3880,
  0x3CC0,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0180,
  0x03C0,
  0x07F0,
  0x0FE0,
  0x1FC0,
  0x1F80,
  0x3880,
  0x3CC0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7E70,
  0x7C70,
  0x7800,
  0x7010,
  0x6030,
  0x6070,
  0x4770,
  0x4330
},
{ 0x0000, // FROGMOUTHLEFT
  0x0000,
  0x0000,
  0x1800,
  0x7C00,
  0x1E00,
  0x0F00,
  0x1F80,
  0x7FC0,
  0x0FC0,
  0x08E0,
  0x19E0,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x1800,
  0x7C00,
  0xFE00,
  0xFF00,
  0xFF80,
  0x7FC0,
  0x0FC0,
  0x08E0,
  0x19E0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x6FF0,
  0x03F0,
  0xE1F0,
  0xF0F0,
  0xE070,
  0x0030,
  0x7030,
  0x7710,
  0x6610
},
{ 0x0000, // FROGMOUTHRIGHT
  0x0000,
  0x0000,
  0x00C0,
  0x01F0,
  0x03C0,
  0x0780,
  0x0FC0,
  0x1FF0,
  0x1F80,
  0x3880,
  0x3CC0,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x00C0,
  0x01F0,
  0x03F0,
  0x07F0,
  0x0FF0,
  0x1FF0,
  0x1F80,
  0x3880,
  0x3CC0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FB0,
  0x7E00,
  0x7C30,
  0x7870,
  0x7030,
  0x6000,
  0x6070,
  0x4770,
  0x4330
},
{ 0, // FROGTONGUE
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  65520,
  65520,
  65520,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  65520,
  65520,
  65520,
  32752,
  32752,
  32752,
  32752
},
{ // Green Missile
  // Frame 1
  0,
  0,
  0,
  0,
  0,
  512,
  1792,
  512,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  256,
  256,
  6656,
  1792,
  704,
  1024,
  1024,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65264,
  65264,
  59376,
  65520,
  65328,
  64496,
  64496,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32496,
  32496,
  26096,
  31472,
  32048,
  31728,
  31728,
  32752,
  32752
},
{ // Green Missile
  // Frame 2
  0,
  0,
  0,
  0,
  0,
  1280,
  512,
  1280,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  128,
  4352,
  3328,
  512,
  1408,
  1088,
  2048,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65392,
  61168,
  63472,
  65520,
  65392,
  64432,
  63472,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32624,
  28400,
  29424,
  32752,
  31344,
  31664,
  30704,
  32752,
  32752
},
{ // Green Missile
  // Frame 3
  0,
  0,
  0,
  0,
  0,
  1280,
  512,
  1280,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  4160,
  2176,
  1280,
  512,
  1280,
  2176,
  4160,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  61360,
  63344,
  65520,
  65520,
  65520,
  63344,
  61360,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  28592,
  30576,
  31472,
  32752,
  31472,
  30576,
  28592,
  32752,
  32752
},
{ 0, // Green Missile
  0, // Frame 4
  0,
  0,
  0,
  1280,
  512,
  1280,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  2048,
  1088,
  1408,
  512,
  3328,
  4352,
  128,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  63472,
  64432,
  65392,
  65520,
  63472,
  61168,
  65392,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  30704,
  31664,
  31344,
  32752,
  29424,
  28400,
  32624,
  32752,
  32752
},
{ // Green Missile
  // Frame 5
  0,
  0,
  0,
  0,
  0,
  512,
  1792,
  512,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  1024,
  1024,
  704,
  1792,
  6656,
  256,
  256,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  64496,
  64496,
  65328,
  65520,
  59376,
  65264,
  65264,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  31728,
  31728,
  32048,
  31472,
  26096,
  32496,
  32496,
  32752,
  32752
},
{ // Red Missile
  // Frame 1
  0,
  0,
  0,
  0,
  0,
  0,
  512,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  512,
  1792,
  512,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65264,
  65264,
  58864,
  64240,
  64816,
  64496,
  64496,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Red Missile
  // Frame 2
  0,
  0,
  0,
  0,
  0,
  0,
  512,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  1280,
  512,
  1280,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65392,
  61168,
  62192,
  65520,
  64112,
  64432,
  63472,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Red Missile
  // Frame 3
  0,
  0,
  0,
  0,
  0,
  0,
  512,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  1280,
  512,
  1280,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  61360,
  63344,
  64240,
  65520,
  64240,
  63344,
  61360,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Red Missile
  // Frame 4
  0,
  0,
  0,
  0,
  0,
  0,
  512,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  1280,
  512,
  1280,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  63472,
  64432,
  64112,
  65520,
  62192,
  61168,
  65392,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Red Missile
  // Frame 5
  0,
  0,
  0,
  0,
  0,
  0,
  512,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  512,
  1792,
  512,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  64496,
  64496,
  64816,
  64240,
  58864,
  65264,
  65264,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // Blue Missile
  // Frame 1
  0,
  0,
  0,
  256,
  256,
  6144,
  512,
  192,
  1024,
  1024,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  512,
  1792,
  512,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32496,
  32496,
  26096,
  31472,
  32048,
  31728,
  31728,
  32752,
  32752
},
{ // Blue Missile
  // Frame 2
  0,
  0,
  0,
  128,
  4352,
  2048,
  512,
  128,
  1088,
  2048,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  1280,
  512,
  1280,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32624,
  28400,
  29424,
  32752,
  31344,
  31664,
  30704,
  32752,
  32752
},
{ // Blue Missile
  // Frame 3
  0,
  0,
  0,
  4160,
  2176,
  0,
  512,
  0,
  2176,
  4160,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  1280,
  512,
  1280,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  28592,
  30576,
  31472,
  32752,
  31472,
  30576,
  28592,
  32752,
  32752
},
{ // Blue Missile
  // Frame 4
  0,
  0,
  0,
  2048,
  1088,
  128,
  512,
  2048,
  4352,
  128,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  1280,
  512,
  1280,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  30704,
  31664,
  31344,
  32752,
  29424,
  28400,
  32624,
  32752,
  32752
},
{ // Blue Missile
  // Frame 5
  0,
  0,
  0,
  1024,
  1024,
  192,
  512,
  6144,
  256,
  256,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  512,
  1792,
  512,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  31728,
  31728,
  32048,
  31472,
  26096,
  32496,
  32496,
  32752,
  32752
},
{ // Yellow Missile
  // Frame 1
  0,
  0,
  0,
  256,
  256,
  6656,
  1792,
  704,
  1024,
  1024,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  256,
  256,
  6656,
  1792,
  704,
  1024,
  1024,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65264,
  65264,
  58864,
  64240,
  64816,
  64496,
  64496,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32496,
  32496,
  26608,
  32752,
  32560,
  31728,
  31728,
  32752,
  32752
},
{ // Yellow Missile
  // Frame 2
  0,
  0,
  0,
  128,
  4352,
  3328,
  512,
  1408,
  1088,
  2048,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  128,
  4352,
  3328,
  512,
  1408,
  1088,
  2048,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65392,
  61168,
  62192,
  65520,
  64112,
  64432,
  63472,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32624,
  28400,
  30704,
  32752,
  32624,
  31664,
  30704,
  32752,
  32752
},
{ // Yellow Missile
  // Frame 3
  0,
  0,
  0,
  4160,
  2176,
  1280,
  512,
  1280,
  2176,
  4160,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  4160,
  2176,
  1280,
  512,
  1280,
  2176,
  4160,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  61360,
  63344,
  64240,
  65520,
  64240,
  63344,
  61360,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  28592,
  30576,
  32752,
  32752,
  32752,
  30576,
  28592,
  32752,
  32752
},
{ // Yellow Missile
  // Frame 4
  0,
  0,
  0,
  2048,
  1088,
  1408,
  512,
  3328,
  4352,
  128,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  2048,
  1088,
  1408,
  512,
  3328,
  4352,
  128,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  63472,
  64432,
  64112,
  65520,
  62192,
  61168,
  65392,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  30704,
  31664,
  32624,
  32752,
  30704,
  28400,
  32624,
  32752,
  32752
},
{ // Yellow Missile
  // Frame 5
  0,
  0,
  0,
  1024,
  1024,
  704,
  1792,
  6656,
  256,
  256,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  1024,
  1024,
  704,
  1792,
  6656,
  256,
  256,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  64496,
  64496,
  64816,
  64240,
  58864,
  65264,
  65264,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  31728,
  31728,
  32560,
  32752,
  26608,
  32496,
  32496,
  32752,
  32752
},
{ 0x0000, // RABBITRIGHT
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0100,
  0x0180,
  0x00C0,
  0x0E60,
  0x1F60,
  0x3FF0,
  0x7FF0,
  0x7FC0,
  0x3C80,
  0x1880,
  0x1EE0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFE0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FE0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0, // CLOCK
  0,
  1280,
  7616,
  7616,
  15840,
  15840,
  16096,
  8000,
  8064,
  1792,
  0,
  /* Plane 1 */
  0,
  0,
  1280,
  7616,
  7616,
  15840,
  15840,
  16096,
  8000,
  8064,
  1792,
  0,
  /* Plane 2 */
  65520,
  63728,
  65008,
  65008,
  65008,
  65008,
  65008,
  65264,
  65392,
  65456,
  65520,
  65520,
  /* Plane 3 */
  0,
  30960,
  32240,
  32240,
  32240,
  32240,
  32240,
  32496,
  32624,
  32688,
  32752,
  32752
},
{ 0x0000, // FIRSTORB
  0x0000,
  0x0000,
  0x0700,
  0x0F80,
  0x1FC0,
  0x1AC0,
  0x1FC0,
  0x0D80,
  0x0700,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0700,
  0x0F80,
  0x1FC0,
  0x1AC0,
  0x1FC0,
  0x0D80,
  0x0700,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFAF0,
  0xFFF0,
  0xFDF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x78F0,
  0x7070,
  0x6DB0,
  0x68B0,
  0x6030,
  0x7070,
  0x78F0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // FIRSTORB + 1
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0D80,
  0x0880,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0700,
  0x0F80,
  0x1FC0,
  0x1AC0,
  0x1FC0,
  0x0D80,
  0x0700,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF8F0,
  0xF070,
  0xEDB0,
  0xE8B0,
  0xE030,
  0xF070,
  0xF8F0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7AF0,
  0x7FF0,
  0x7DF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // FIRSTORB + 2
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0D80,
  0x0880,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0700,
  0x0F80,
  0x1FC0,
  0x1AC0,
  0x1FC0,
  0x0D80,
  0x0700,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFAF0,
  0xFFF0,
  0xFDF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x78F0,
  0x7070,
  0x6DB0,
  0x68B0,
  0x6030,
  0x7070,
  0x78F0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // FIRSTORB + 3
  0x0000,
  0x0000,
  0x0700,
  0x0F80,
  0x1FC0,
  0x1AC0,
  0x1FC0,
  0x0D80,
  0x0700,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0700,
  0x0F80,
  0x1FC0,
  0x1AC0,
  0x1FC0,
  0x0D80,
  0x0700,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF8F0,
  0xF070,
  0xEDB0,
  0xE8B0,
  0xE030,
  0xF070,
  0xF8F0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7AF0,
  0x7FF0,
  0x7DF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // BOTH
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 3 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0
},
{ 0x0000, // FIRSTREVNUMBER (reversed `1')
  0x7FF0,
  0x7DF0,
  0x79F0,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x78F0,
  0x7FF0,
  /* Plane 1 */
  0x0000,
  0x7FF0,
  0x7DF0,
  0x79F0,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x78F0,
  0x7FF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xF9F0,
  0xFDF0,
  0xFDF0,
  0xFDF0,
  0xFDF0,
  0xFDF0,
  0xFDF0,
  0xF8F0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7DF0,
  0x79F0,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x78F0,
  0x7FF0
},
{ 0x0000, // reversed `2'
  0x7FF0,
  0x78F0,
  0x7770,
  0x7F70,
  0x7F70,
  0x7EF0,
  0x7DF0,
  0x7BF0,
  0x77F0,
  0x7070,
  0x7FF0,
  /* Plane 1 */
  0x0000,
  0x7FF0,
  0x78F0,
  0x7770,
  0x7F70,
  0x7F70,
  0x7EF0,
  0x7DF0,
  0x7BF0,
  0x77F0,
  0x7070,
  0x7FF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xF8F0,
  0xF770,
  0xFF70,
  0xFF70,
  0xFEF0,
  0xFDF0,
  0xFBF0,
  0xF7F0,
  0xF070,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x78F0,
  0x7770,
  0x7F70,
  0x7F70,
  0x7EF0,
  0x7DF0,
  0x7BF0,
  0x77F0,
  0x7070,
  0x7FF0
},
{ 0x0000, // reversed `3'
  0x7FF0,
  0x78F0,
  0x7770,
  0x7F70,
  0x7F70,
  0x78F0,
  0x7F70,
  0x7F70,
  0x7770,
  0x78F0,
  0x7FF0,
  /* Plane 1 */
  0x0000,
  0x7FF0,
  0x78F0,
  0x7770,
  0x7F70,
  0x7F70,
  0x78F0,
  0x7F70,
  0x7F70,
  0x7770,
  0x78F0,
  0x7FF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xF8F0,
  0xF770,
  0xFF70,
  0xFF70,
  0xF8F0,
  0xFF70,
  0xFF70,
  0xF770,
  0xF8F0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x78F0,
  0x7770,
  0x7F70,
  0x7F70,
  0x78F0,
  0x7F70,
  0x7F70,
  0x7770,
  0x78F0,
  0x7FF0
},
{ 0x0000, // reversed `4'
  0x7FF0,
  0x7F70,
  0x7E70,
  0x7D70,
  0x7D70,
  0x7B70,
  0x7030,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7FF0,
  /* Plane 1 */
  0x0000,
  0x7FF0,
  0x7F70,
  0x7E70,
  0x7D70,
  0x7D70,
  0x7B70,
  0x7030,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7FF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFF70,
  0xFE70,
  0xFD70,
  0xFD70,
  0xFB70,
  0xF030,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7F70,
  0x7E70,
  0x7D70,
  0x7D70,
  0x7B70,
  0x7030,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7FF0
},
{ 0x0000, // reversed `5'
  0x7FF0,
  0x7070,
  0x77F0,
  0x77F0,
  0x77F0,
  0x70F0,
  0x7F70,
  0x7F70,
  0x7F70,
  0x70F0,
  0x7FF0,
  /* Plane 1 */
  0x0000,
  0x7FF0,
  0x7070,
  0x77F0,
  0x77F0,
  0x77F0,
  0x70F0,
  0x7F70,
  0x7F70,
  0x7F70,
  0x70F0,
  0x7FF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xF070,
  0xF7F0,
  0xF7F0,
  0xF7F0,
  0xF0F0,
  0xFF70,
  0xFF70,
  0xFF70,
  0xF0F0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7070,
  0x77F0,
  0x77F0,
  0x77F0,
  0x70F0,
  0x7F70,
  0x7F70,
  0x7F70,
  0x70F0,
  0x7FF0
},
{ 0x0000, // reversed `6'
  0x7FF0,
  0x78F0,
  0x7770,
  0x77F0,
  0x77F0,
  0x70F0,
  0x7770,
  0x7770,
  0x7770,
  0x78F0,
  0x7FF0,
  /* Plane 1 */
  0x0000,
  0x7FF0,
  0x78F0,
  0x7770,
  0x77F0,
  0x77F0,
  0x70F0,
  0x7770,
  0x7770,
  0x7770,
  0x78F0,
  0x7FF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xF8F0,
  0xF770,
  0xF7F0,
  0xF7F0,
  0xF0F0,
  0xF770,
  0xF770,
  0xF770,
  0xF8F0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x78F0,
  0x7770,
  0x77F0,
  0x77F0,
  0x70F0,
  0x7770,
  0x7770,
  0x7770,
  0x78F0,
  0x7FF0
},
{ 0x0000, // reversed `7'
  0x7FF0,
  0x7070,
  0x7F70,
  0x7F70,
  0x7EF0,
  0x7EF0,
  0x7EF0,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x7FF0,
  /* Plane 1 */
  0x0000,
  0x7FF0,
  0x7070,
  0x7F70,
  0x7F70,
  0x7EF0,
  0x7EF0,
  0x7EF0,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x7FF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xF070,
  0xFF70,
  0xFF70,
  0xFEF0,
  0xFEF0,
  0xFEF0,
  0xFDF0,
  0xFDF0,
  0xFDF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7070,
  0x7F70,
  0x7F70,
  0x7EF0,
  0x7EF0,
  0x7EF0,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x7FF0
},
{ 0x0000, // reversed `8'
  0x7FF0,
  0x78F0,
  0x7770,
  0x7770,
  0x7770,
  0x78F0,
  0x7770,
  0x7770,
  0x7770,
  0x78F0,
  0x7FF0,
  /* Plane 1 */
  0x0000,
  0x7FF0,
  0x78F0,
  0x7770,
  0x7770,
  0x7770,
  0x78F0,
  0x7770,
  0x7770,
  0x7770,
  0x78F0,
  0x7FF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xF8F0,
  0xF770,
  0xF770,
  0xF770,
  0xF8F0,
  0xF770,
  0xF770,
  0xF770,
  0xF8F0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x78F0,
  0x7770,
  0x7770,
  0x7770,
  0x78F0,
  0x7770,
  0x7770,
  0x7770,
  0x78F0,
  0x7FF0
},
{ 0x0000, // LASTREVNUMBER (reversed `9')
  0x7FF0,
  0x78F0,
  0x7770,
  0x7770,
  0x7770,
  0x7870,
  0x7F70,
  0x7F70,
  0x7770,
  0x78F0,
  0x7FF0,
  /* Plane 1 */
  0x0000,
  0x7FF0,
  0x78F0,
  0x7770,
  0x7770,
  0x7770,
  0x7870,
  0x7F70,
  0x7F70,
  0x7770,
  0x78F0,
  0x7FF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xF8F0,
  0xF770,
  0xF770,
  0xF770,
  0xF870,
  0xFF70,
  0xFF70,
  0xF770,
  0xF8F0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x78F0,
  0x7770,
  0x7770,
  0x7770,
  0x7870,
  0x7F70,
  0x7F70,
  0x7770,
  0x78F0,
  0x7FF0
},
{ 0x0000, // CLUSTER
  0x0000,
  0x0000,
  0x0000,
  0x0700,
  0x0F80,
  0x0F80,
  0x0F80,
  0x0700,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0700,
  0x0F80,
  0x0F80,
  0x0F80,
  0x0700,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFB0,
  0xFFB0,
  0xFF30,
  0xFC70,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FB0,
  0x7FB0,
  0x7F30,
  0x7C70,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // SQUIDLEFT
  0x7800,
  0x7800,
  0x7800,
  0x7E00,
  0x0D00,
  0x0A80,
  0x0540,
  0x02B0,
  0x0150,
  0x00A0,
  0x00D0,
  /* Plane 1 */
  0x0000,
  0x7800,
  0x7800,
  0x7800,
  0x7E00,
  0x0D00,
  0x0A80,
  0x0540,
  0x02B0,
  0x0150,
  0x00A0,
  0x00D0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFBF0,
  0xFFF0,
  0xEFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7BF0,
  0x7FF0,
  0x6FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // SQUIDRIGHT
  0x00F0,
  0x00F0,
  0x00F0,
  0x03F0,
  0x0580,
  0x0A80,
  0x1500,
  0x6A00,
  0x5400,
  0x2800,
  0x5800,
  /* Plane 1 */
  0x0000,
  0x00F0,
  0x00F0,
  0x00F0,
  0x03F0,
  0x0580,
  0x0A80,
  0x1500,
  0x6A00,
  0x5400,
  0x2800,
  0x5800,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFEF0,
  0xFFF0,
  0xFFB0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7EF0,
  0x7FF0,
  0x7FB0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // 1st eel frame
  0x0000,
  0x0000,
  0x0000,
  0x0020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0020,
  0x1860,
  0x2580,
  0x4200,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // 2nd eel frame
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0010,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x00F0,
  0x7300,
  0x0C00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // 3rd eel frame
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x00C0,
  0x6160,
  0x1A00,
  0x0400,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // ANT
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x2000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0xC000,
  0x2000,
  0x1000,
  0x35E0,
  0x7FF0,
  0xF5E0,
  0x0520,
  0x0890,
  0x0890,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0xFFF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0xFFF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // BIRD (frame 0)
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0500,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x4010,
  0x4010,
  0x2020,
  0x1040,
  0x0F80,
  0x0500,
  0x0200,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7DF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // BULL (facing left)
  0x0000,
  0x0000,
  0x0000,
  0x6000,
  0x1000,
  0x2000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x6000,
  0x1700,
  0x3F80,
  0x3FE0,
  0x7FF0,
  0x1FE0,
  0x0860,
  0x0820,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xBFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x3FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // CAMEL
  0x0000,
  0x0000,
  0x0000,
  0x0020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0220,
  0x0730,
  0x0FA0,
  0x1FE0,
  0x3FE0,
  0x3FC0,
  0x1880,
  0x1080,
  0x1080,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // CLOUD
  0x0000,
  0x0000,
  0x0000,
  0x0300,
  0x37A0,
  0x7FF0,
  0x3BC0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFCF0,
  0xC850,
  0x8000,
  0xC430,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7CF0,
  0x4850,
  0x0000,
  0x4430,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // CYCLONE_C
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F80,
  0x3FE0,
  0x1FC0,
  0x0FC0,
  0x0F80,
  0x03C0,
  0x0780,
  0x0F00,
  0x0600,
  0x0380,
  0x0700,
  0x0200,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0F80,
  0x7070,
  0x78F0,
  0x7F70,
  0x75F0,
  0x7EB0,
  0x7FF0,
  0x7BF0,
  0x7FF0,
  0x7EF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // DOG (chasing)
  0x0000,
  0x0000,
  0x0000,
  0x0020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0020,
  0x0040,
  0x60E0,
  0x43E0,
  0x7FF0,
  0x3FC0,
  0x3FC0,
  0x1B80,
  0x1080,
  0x1080,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFE0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FE0,
  0x7F70,
  0x7FB0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // FISH
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x00C0,
  0x0080,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0200,
  0x4300,
  0x27C0,
  0x3FE0,
  0x1FB0,
  0x1FF0,
  0x3FE0,
  0x27C0,
  0x4200,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFB0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7EF0,
  0x7EB0,
  0x7EF0,
  0x7A70,
  0x7DB0,
  0x7FF0,
  0x7FF0
},
{ // FRAGMENT
  0,
  0,
  0,
  0,
  0,
  1792,
  1792,
  1792,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  1792,
  1792,
  1792,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65392,
  65392,
  64624,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32624,
  32624,
  31856,
  32752,
  32752,
  32752
},
{ 0x0000, // FROG (left)
  0x0000,
  0x0000,
  0x0000,
  0x0C00,
  0x1E00,
  0x7F00,
  0x3F80,
  0x1FC0,
  0x0FC0,
  0x08E0,
  0x19E0,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0C00,
  0x1E00,
  0x7F00,
  0x3F80,
  0x1FC0,
  0x0FC0,
  0x08E0,
  0x19E0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x73F0,
  0x71F0,
  0x00F0,
  0x4070,
  0x6030,
  0x7030,
  0x7710,
  0x6610
},
{ 0x0000, // GIRAFFE
  0x0020,
  0x0070,
  0x00C0,
  0x0180,
  0x0700,
  0x3E00,
  0x7C00,
  0x7C00,
  0x2400,
  0x2400,
  0x2400,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFD0,
  0xFFF0,
  0xFFF0,
  0xFF70,
  0xFAF0,
  0xD5F0,
  0xABF0,
  0xD7F0,
  0xFBF0,
  0xFFF0,
  0xDBF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // KANGAROO
  0x0000,
  0x0020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0040,
  0x0060,
  0x00F0,
  0x01C0,
  0x03C0,
  0x0FC0,
  0x1FA0,
  0x3F00,
  0x2C00,
  0x2800,
  0x4F80,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // MISSILE_C
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0200,
  0x0700,
  0x0200,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0200,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xFAF0,
  0xFDF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x6230,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // MONKEY
  0x0000,
  0x0000,
  0x0020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x3800,
  0x6E60,
  0x4070,
  0x4FF0,
  0x7FE0,
  0x3F80,
  0x1F80,
  0x1D40,
  0x3940,
  0x6D20,
  0x3080,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7F70,
  0x7FB0,
  0x77B0,
  0x73D0,
  0x7FF0
},
{ 0x0000, // MOUSE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x1080,
  0x39C0,
  0x1680,
  0x0F00,
  0x0660,
  0x0F10,
  0x1F90,
  0x1F90,
  0x0FE0,
  0x39C0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF6F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x76F0,
  0x7FF0,
  0x7F90,
  0x76E0,
  0x6F60,
  0x7FE0,
  0x7F10,
  0x7FF0
},
{ 0x0000, // OCTOPUS
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x2720,
  0x4F90,
  0x2FA0,
  0x2FA0,
  0x5FD0,
  0x3760,
  0x4D90,
  0x3560,
  0x4D90,
  0x18C0,
  0x3060,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF770,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7770,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // ORB
  0,
  0,
  0,
  0,
  0,
  3456,
  2176,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  1792,
  3968,
  8128,
  6848,
  8128,
  3968,
  1792,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  64240,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  31472,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ 0x0000, // OTTER
  0x0000,
  0x0A00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0A00,
  0x0E00,
  0x0A00,
  0x0E00,
  0x1F00,
  0x1F00,
  0x1F00,
  0x0E00,
  0x0F00,
  0x0F80,
  0x1FC0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFBF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7BF0,
  0x75F0,
  0x6EF0,
  0x6AF0,
  0x6AF0,
  0x7BF0,
  0x7AF0,
  0x7E70,
  0x7B30
},
{ 0x0000, // RABBIT (left)
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x2000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0400,
  0x0C00,
  0x1800,
  0x3380,
  0x37C0,
  0x7FE0,
  0x7FF0,
  0x1FF0,
  0x09E0,
  0x08C0,
  0x3BC0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xBFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x3FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RAIN
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0500,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0200,
  0x0200,
  0x0200,
  0x0700,
  0x0700,
  0x0700,
  0x0F80,
  0x0F80,
  0x0200,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFAF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7AF0,
  0x7FF0
},
{ 0x0000, // SALAMANDER
  0x0000,
  0x0500,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0200,
  0x0700,
  0x1740,
  0x0F80,
  0x0700,
  0x0700,
  0x0700,
  0x1740,
  0x4F80,
  0x4200,
  0x3C00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7AF0,
  0x7FF0,
  0x7AF0,
  0x7FF0,
  0x7AF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // SNAIL
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x2000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x4000,
  0x2000,
  0x1000,
  0x3780,
  0x7FC0,
  0x3FC0,
  0x1FC0,
  0x1FC0,
  0x0FE0,
  0x0FF0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7870,
  0x7330,
  0x74B0,
  0x70B0,
  0x73B0,
  0x7810,
  0x7FF0
},
{ 0x0000, // SPIDER
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x1040,
  0x28A0,
  0x4510,
  0x1FC0,
  0x2720,
  0x4F90,
  0x1240,
  0x2520,
  0x4890,
  0x1040,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFAF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7AF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // GOOSE
  0x1000,
  0x7000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0100,
  0x0100,
  0x0300,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x1040,
  0x30E0,
  0x11C0,
  0x1B80,
  0x0F00,
  0x0FE0,
  0x0FE0,
  0x06C0,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // HORSE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0030,
  0x0070,
  0x00D0,
  0x01F0,
  0x3FB0,
  0x7FB0,
  0x5F00,
  0x5F00,
  0x5900,
  0x1100,
  0x1100,
  /* Plane 2 */
  0xFFF0,
  0xFFE0,
  0xFFF0,
  0xFFD0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FE0,
  0x7FF0,
  0x7FD0,
  0x7FF0,
  0x7FF0,
  0x7FC0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // BEAR
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0F40,
  0x1FE0,
  0x3FE0,
  0x7FF0,
  0x7FE0,
  0x3F80,
  0x3100,
  0x3980,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFE0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FE0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // ELEPHANT
  0x0000,
  0x0C00,
  0x0C00,
  0x0C00,
  0x0C00,
  0x1800,
  0x6000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xF3F0,
  0xF3F0,
  0xE3F0,
  0xF3F0,
  0xE7F0,
  0x9FF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x6070,
  0x4010,
  0x4010,
  0x0010,
  0x0010,
  0x0000,
  0x2000,
  0x3390,
  0x5390,
  0x7390
},
{ 0x0000, // CHICKEN
  0x0000,
  0x0000,
  0x0000,
  0x1000,
  0x6000,
  0x0000,
  0x0000,
  0x0000,
  0x0200,
  0x0200,
  0x0700,
  /* Plane 1 */
  0x0000,
  0x3800,
  0x3800,
  0x3880,
  0x3CC0,
  0x1FE0,
  0x3FE0,
  0x1FC0,
  0x0F80,
  0x0500,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xC7F0,
  0xC7F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xDFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x6FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // ZEBRA
  0x0000,
  0x0020,
  0x0050,
  0x0170,
  0x1500,
  0x5520,
  0x1500,
  0x5500,
  0x0800,
  0x1100,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0010,
  0x0020,
  0x0050,
  0x0170,
  0x1500,
  0x5520,
  0x1500,
  0x5500,
  0x0800,
  0x1100,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFC0,
  0xFFA0,
  0xFF50,
  0xFF70,
  0xD540,
  0xD560,
  0xB5F0,
  0xF5F0,
  0xAEF0,
  0xFFF0,
  0xEEF0,
  /* Plane 3 */
  0x0000,
  0x7FC0,
  0x7FA0,
  0x7F50,
  0x7F70,
  0x5540,
  0x5560,
  0x35F0,
  0x75F0,
  0x2EF0,
  0x7FF0,
  0x6EF0
},
{ 0x0000, // RHINOCEROS
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0010,
  0x0010,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0040,
  0x1F90,
  0x3FF0,
  0x7FF0,
  0x7F80,
  0x3D80,
  0x1080,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFB0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FB0,
  0x7FF0,
  0x7FF0,
  0x77F0,
  0x7BF0,
  0x7FF0
},
{ 0x0000, // SNAKE
  0x0000,
  0x0000,
  0x0040,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x01C0,
  0x0260,
  0x0200,
  0x0100,
  0x0080,
  0x0080,
  0x0080,
  0x0300,
  0x1C00,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // PANDA
  0x0000,
  0x0000,
  0x0F00,
  0x1FA0,
  0x2ED0,
  0x0E70,
  0x0E60,
  0x0E00,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0F00,
  0x1FA0,
  0x2ED0,
  0x0E70,
  0x0E60,
  0x0E00,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFB0,
  0xFFB0,
  0xEED0,
  0x8E70,
  0x8E70,
  0xCE70,
  0xCEF0,
  0xC670,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FB0,
  0x7FB0,
  0x6ED0,
  0x0E70,
  0x0E70,
  0x4E70,
  0x4EF0,
  0x4670,
  0x7FF0
},
{ 0x0000, // EEL
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x1800,
  0x2420,
  0x4260,
  0x0180,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // BUTTERFLY
  0x18C0,
  0x0500,
  0x0200,
  0x0200,
  0x0200,
  0x0200,
  0x0200,
  0x0200,
  0x0200,
  0x0200,
  0x0200,
  /* Plane 1 */
  0x0000,
  0x18C0,
  0x0500,
  0x7270,
  0x7AF0,
  0x7FF0,
  0x1FC0,
  0x3FE0,
  0x3FE0,
  0x3FE0,
  0x1AC0,
  0x0200,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x6730,
  0x7AF0,
  0x7DF0,
  0x5DD0,
  0x6DB0,
  0x7DF0,
  0x7570,
  0x6530,
  0x6DB0,
  0x7DF0,
  0x7DF0
},
{ 0x0000, // KOALA
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0F80,
  0x3FE0,
  0x7570,
  0x3DE0,
  0x0F80,
  0x4F90,
  0x3FE0,
  0x1FC0,
  0x1FC0,
  0x0F80,
  0x0D80,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF570,
  0xFDF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x5FD0,
  0x1540,
  0x5DD0,
  0x7FF0,
  0x7070,
  0x7FF0,
  0x7FF0,
  0x6DB0,
  0x7770,
  0x7FF0
},
{ 0x0000, // SQUID
  0x0200,
  0x0700,
  0x0F80,
  0x0700,
  0x0700,
  0x0A80,
  0x0F80,
  0x2AA0,
  0x6AB0,
  0x2AA0,
  0x1AC0,
  /* Plane 1 */
  0x0000,
  0x0200,
  0x0700,
  0x0F80,
  0x0700,
  0x0700,
  0x0A80,
  0x0F80,
  0x2AA0,
  0x6AB0,
  0x2AA0,
  0x1AC0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFAF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7AF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // TURTLE
  0x0000,
  0x0000,
  0x0900,
  0x0000,
  0x0F00,
  0x1F80,
  0x1F80,
  0x1F80,
  0x1F80,
  0x0F00,
  0x0600,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0600,
  0x0F00,
  0x0600,
  0x6F60,
  0x7FE0,
  0x1F80,
  0x1F80,
  0x7FE0,
  0x6F60,
  0x0600,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x70F0,
  0x6070,
  0x6070,
  0x6070,
  0x6070,
  0x70F0,
  0x79F0
},
{ 0x0000, // LEMMING
  0x0600,
  0x0D00,
  0x0F80,
  0x0F00,
  0x0E00,
  0x1F00,
  0x0E00,
  0x0E00,
  0x0E00,
  0x0C00,
  0x0000,
/* Plane 1 */
  0x0000,
  0x0600,
  0x0D00,
  0x0F80,
  0x0F00,
  0x0000,
  0x1100,
  0x0000,
  0x0000,
  0x0180,
  0x0380,
  0x0000,
/* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFE70,
  0xFC70,
  0xFFF0,
/* Plane 3 */
  0x0000,
  0x79F0,
  0x75F0,
  0x77F0,
  0x77F0,
  0x71F0,
  0x71F0,
  0x71F0,
  0x71F0,
  0x71F0,
  0x73F0,
  0x7FF0
},
{ 0x0000, // PORCUPINE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x07C0,
  0x0FE0,
  0x0F80,
  0x0FE0,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x6D70,
  0x7570,
  0x4FF0,
  0x7FF0,
  0x4FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // TERMITE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0200,
  0x0700,
  0x0200,
  0x0200,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  0x0200,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // BAT (currently unused)
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0500,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0500,
  0x4710,
  0x6730,
  0x7FF0,
  0x1FC0,
  0x0200,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // FIRSTBANANAFRAME + 0
  0x0000,
  0x0040,
  0x0040,
  0x0040,
  0x00C0,
  0x0080,
  0x0180,
  0x0700,
  0x3C00,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0040,
  0x0040,
  0x0040,
  0x00C0,
  0x0080,
  0x0180,
  0x0700,
  0x3C00,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FB0,
  0x7FB0,
  0x7FB0,
  0x7F30,
  0x7F70,
  0x7E70,
  0x78F0,
  0x43F0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // FIRSTBANANAFRAME + 1
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x2020,
  0x3DE0,
  0x1FC0,
  0x0700,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x2020,
  0x3DE0,
  0x1FC0,
  0x0700,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x5FD0,
  0x4210,
  0x6030,
  0x78F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // FIRSTBANANAFRAME + 2
  0x0000,
  0x1000,
  0x1000,
  0x1000,
  0x1800,
  0x0800,
  0x0C00,
  0x0700,
  0x01E0,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x1000,
  0x1000,
  0x1000,
  0x1800,
  0x0800,
  0x0C00,
  0x0700,
  0x01E0,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x6FF0,
  0x6FF0,
  0x6FF0,
  0x67F0,
  0x77F0,
  0x73F0,
  0x78F0,
  0x7E10,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // FIRSTBANANAFRAME + 3
  0x0000,
  0x0300,
  0x0600,
  0x0600,
  0x0E00,
  0x0C00,
  0x0E00,
  0x0600,
  0x0600,
  0x0300,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0300,
  0x0600,
  0x0600,
  0x0E00,
  0x0C00,
  0x0E00,
  0x0600,
  0x0600,
  0x0300,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7CF0,
  0x79F0,
  0x79F0,
  0x71F0,
  0x73F0,
  0x71F0,
  0x79F0,
  0x79F0,
  0x7CF0,
  0x7FF0
},
{ 0x0000, // FIRSTBANANAFRAME + 4
  0x0000,
  0x0000,
  0x01E0,
  0x0700,
  0x0C00,
  0x0800,
  0x1800,
  0x1000,
  0x1000,
  0x1000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x01E0,
  0x0700,
  0x0C00,
  0x0800,
  0x1800,
  0x1000,
  0x1000,
  0x1000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7E10,
  0x78F0,
  0x73F0,
  0x77F0,
  0x67F0,
  0x6FF0,
  0x6FF0,
  0x6FF0,
  0x7FF0
},
{ 0x0000, // FIRSTBANANAFRAME + 5
  0x0000,
  0x0000,
  0x0000,
  0x0700,
  0x1FC0,
  0x3DE0,
  0x2020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0700,
  0x1FC0,
  0x3DE0,
  0x2020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x78F0,
  0x6030,
  0x4210,
  0x5FD0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // FIRSTBANANAFRAME + 6
  0x0000,
  0x0000,
  0x3C00,
  0x0700,
  0x0180,
  0x0080,
  0x00C0,
  0x0040,
  0x0040,
  0x0040,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x3C00,
  0x0700,
  0x0180,
  0x0080,
  0x00C0,
  0x0040,
  0x0040,
  0x0040,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x43F0,
  0x78F0,
  0x7E70,
  0x7F70,
  0x7F30,
  0x7FB0,
  0x7FB0,
  0x7FB0,
  0x7FF0
},
{ 0x0000, // FIRSTBANANAFRAME + 7
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0040,
  0x0040,
  0x0040,
  0x00C0,
  0x0080,
  0x0180,
  0x0700,
  0x3C00,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFB0,
  0xFFB0,
  0xFFB0,
  0xFF30,
  0xFF70,
  0xFE70,
  0xF8F0,
  0xC3F0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 8
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x2020,
  0x3DE0,
  0x1FC0,
  0x0700,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xDFD0,
  0xC210,
  0xE030,
  0xF8F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 9
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x1000,
  0x1000,
  0x1000,
  0x1800,
  0x0800,
  0x0C00,
  0x0700,
  0x01E0,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xEFF0,
  0xEFF0,
  0xEFF0,
  0xE7F0,
  0xF7F0,
  0xF3F0,
  0xF8F0,
  0xFE10,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 10
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0300,
  0x0600,
  0x0600,
  0x0E00,
  0x0C00,
  0x0E00,
  0x0600,
  0x0600,
  0x0300,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFCF0,
  0xF9F0,
  0xF9F0,
  0xF1F0,
  0xF3F0,
  0xF1F0,
  0xF9F0,
  0xF9F0,
  0xFCF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 11
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x01E0,
  0x0700,
  0x0C00,
  0x0800,
  0x1800,
  0x1000,
  0x1000,
  0x1000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFE10,
  0xF8F0,
  0xF3F0,
  0xF7F0,
  0xE7F0,
  0xEFF0,
  0xEFF0,
  0xEFF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 12
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0700,
  0x1FC0,
  0x3DE0,
  0x2020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF8F0,
  0xE030,
  0xC210,
  0xDFD0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 13
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x3C00,
  0x0700,
  0x0180,
  0x0080,
  0x00C0,
  0x0040,
  0x0040,
  0x0040,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xC3F0,
  0xF8F0,
  0xFE70,
  0xFF70,
  0xFF30,
  0xFFB0,
  0xFFB0,
  0xFFB0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 14
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0040,
  0x0040,
  0x0040,
  0x00C0,
  0x0080,
  0x0180,
  0x0700,
  0x3C00,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FBF,
  0x7FBF,
  0x7FBF,
  0x7F3F,
  0x7F7F,
  0x7E7F,
  0x78FF,
  0x43FF,
  0x7FFF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 15
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x2020,
  0x3DE0,
  0x1FC0,
  0x0700,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x5FDF,
  0x421F,
  0x603F,
  0x78FF,
  0x7FFF,
  0x7FFF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 16
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x1000,
  0x1000,
  0x1000,
  0x1800,
  0x0800,
  0x0C00,
  0x0700,
  0x01E0,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x6FFF,
  0x6FFF,
  0x6FFF,
  0x67FF,
  0x77FF,
  0x73FF,
  0x78FF,
  0x7E1F,
  0x7FFF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 17
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0300,
  0x0600,
  0x0600,
  0x0E00,
  0x0C00,
  0x0E00,
  0x0600,
  0x0600,
  0x0300,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7CFF,
  0x79FF,
  0x79FF,
  0x71FF,
  0x73FF,
  0x71FF,
  0x79FF,
  0x79FF,
  0x7CFF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 18
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x01E0,
  0x0700,
  0x0C00,
  0x0800,
  0x1800,
  0x1000,
  0x1000,
  0x1000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x7E1F,
  0x78FF,
  0x73FF,
  0x77FF,
  0x67FF,
  0x6FFF,
  0x6FFF,
  0x6FFF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 19
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0700,
  0x1FC0,
  0x3DE0,
  0x2020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x78FF,
  0x603F,
  0x421F,
  0x5FDF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 20
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x3C00,
  0x0700,
  0x0180,
  0x0080,
  0x00C0,
  0x0040,
  0x0040,
  0x0040,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x43FF,
  0x78FF,
  0x7E7F,
  0x7F7F,
  0x7F3F,
  0x7FBF,
  0x7FBF,
  0x7FBF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 21
  0x0000,
  0x0040,
  0x0040,
  0x0040,
  0x00C0,
  0x0080,
  0x0180,
  0x0700,
  0x3C00,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0040,
  0x0040,
  0x0040,
  0x00C0,
  0x0080,
  0x0180,
  0x0700,
  0x3C00,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFB0,
  0xFFB0,
  0xFFB0,
  0xFF30,
  0xFF70,
  0xFE70,
  0xF8F0,
  0xC3F0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 22
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x2020,
  0x3DE0,
  0x1FC0,
  0x0700,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x2020,
  0x3DE0,
  0x1FC0,
  0x0700,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xDFD0,
  0xC210,
  0xE030,
  0xF8F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 23
  0x0000,
  0x0300,
  0x0600,
  0x0600,
  0x0E00,
  0x0C00,
  0x0E00,
  0x0600,
  0x0600,
  0x0300,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0300,
  0x0600,
  0x0600,
  0x0E00,
  0x0C00,
  0x0E00,
  0x0600,
  0x0600,
  0x0300,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFCF0,
  0xF9F0,
  0xF9F0,
  0xF1F0,
  0xF3F0,
  0xF1F0,
  0xF9F0,
  0xF9F0,
  0xFCF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 24
  0x0000,
  0x0300,
  0x0600,
  0x0600,
  0x0E00,
  0x0C00,
  0x0E00,
  0x0600,
  0x0600,
  0x0300,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0300,
  0x0600,
  0x0600,
  0x0E00,
  0x0C00,
  0x0E00,
  0x0600,
  0x0600,
  0x0300,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFCF0,
  0xF9F0,
  0xF9F0,
  0xF1F0,
  0xF3F0,
  0xF1F0,
  0xF9F0,
  0xF9F0,
  0xFCF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 25
  0x0000,
  0x0000,
  0x01E0,
  0x0700,
  0x0C00,
  0x0800,
  0x1800,
  0x1000,
  0x1000,
  0x1000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x01E0,
  0x0700,
  0x0C00,
  0x0800,
  0x1800,
  0x1000,
  0x1000,
  0x1000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFE10,
  0xF8F0,
  0xF3F0,
  0xF7F0,
  0xE7F0,
  0xEFF0,
  0xEFF0,
  0xEFF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 26
  0x0000,
  0x0000,
  0x0000,
  0x0700,
  0x1FC0,
  0x3DE0,
  0x2020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0700,
  0x1FC0,
  0x3DE0,
  0x2020,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF8F0,
  0xE030,
  0xC210,
  0xDFD0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF
},
{ 0x0000, // FIRSTBANANAFRAME + 27
  0x0000, // LASTBANANAFRAME
  0x0000,
  0x3C00,
  0x0700,
  0x0180,
  0x0080,
  0x00C0,
  0x0040,
  0x0040,
  0x0040,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x3C00,
  0x0700,
  0x0180,
  0x0080,
  0x00C0,
  0x0040,
  0x0040,
  0x0040,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xC3F0,
  0xF8F0,
  0xFE70,
  0xFF70,
  0xFF30,
  0xFFB0,
  0xFFB0,
  0xFFB0,
  0xFFF0,
  /* Plane 3 */
  0x000F,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF,
  0x7FFF
},
{ 0x0000, // FIRSTTURTLEFRAME
  0x0000,
  0x0000,
  0x0000,
  0x0900,
  0x0F00,
  0x1F80,
  0x1F80,
  0x1F80,
  0x1F80,
  0x0F00,
  0x0600,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0600,
  0x0F00,
  0x6F60,
  0x7FE0,
  0x1F80,
  0x1F80,
  0x7FE0,
  0x6F60,
  0x0600,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x70F0,
  0x6070,
  0x6070,
  0x6070,
  0x6070,
  0x70F0,
  0x79F0
},
{ 0x0000, // FIRSTTURTLEFRAME + 1
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0F00,
  0x1F80,
  0x1F80,
  0x1F80,
  0x1F80,
  0x0F00,
  0x0600,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0600,
  0x6F60,
  0x7FE0,
  0x1F80,
  0x1F80,
  0x7FE0,
  0x6F60,
  0x0600,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x70F0,
  0x6070,
  0x6070,
  0x6070,
  0x6070,
  0x70F0,
  0x79F0
},
{ 0x0000, // FIRSTTURTLEFRAME + 2
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0F00,
  0x1F80,
  0x1F80,
  0x1F80,
  0x1F80,
  0x0F00,
  0x0600,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x6F60,
  0x7FE0,
  0x1F80,
  0x1F80,
  0x7FE0,
  0x6F60,
  0x0600,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x70F0,
  0x6070,
  0x6070,
  0x6070,
  0x6070,
  0x70F0,
  0x79F0
},
{ 0x0000, // LEMMINGLEFT
  0x0300,
  0x0580,
  0x0F80,
  0x0780,
  0x0380,
  0x07C0,
  0x0380,
  0x0380,
  0x0380,
  0x0180,
  0x0000,
/* Plane 1 */
  0x0000,
  0x0300,
  0x0580,
  0x0F80,
  0x0780,
  0x0000,
  0x0440,
  0x0000,
  0x0000,
  0x0C00,
  0x0E00,
  0x0000,
/* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFDF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF3F0,
  0xF1F0,
  0xFFF0,
/* Plane 3 */
  0x0000,
  0x7CF0,
  0x7D70,
  0x7F70,
  0x7F70,
  0x7C70,
  0x7C70,
  0x7C70,
  0x7C70,
  0x7C70,
  0x7E70,
  0x7FF0
},
{ 0, // Green 25
  0,
  0,
  0,
  6592,
  1280,
  2432,
  4160,
  7552,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  6592,
  1280,
  2432,
  4160,
  7552,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  63248,
  65008,
  64368,
  64976,
  61744,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  26160,
  29200,
  29808,
  27440,
  24656,
  28976,
  32752,
  32752
},
{ 0, // Red 25
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  6592,
  1280,
  2432,
  4160,
  7552,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  58928,
  61968,
  62576,
  60208,
  57424,
  61744,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  30480,
  32240,
  31600,
  32208,
  28976,
  32752,
  32752
},
{ 0, // Blue 25
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  6592,
  1280,
  2432,
  4160,
  7552,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  63248,
  65008,
  64368,
  64976,
  61744,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  26160,
  29200,
  29808,
  27440,
  24656,
  28976,
  32752,
  32752
},
{ 0, // Yellow 25
  0,
  0,
  0,
  6592,
  1280,
  2432,
  4160,
  7552,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  6592,
  1280,
  2432,
  4160,
  7552,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  58928,
  61968,
  62576,
  60208,
  57424,
  61744,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  30480,
  32240,
  31600,
  32208,
  28976,
  32752,
  32752
},
{ 0, // Green 50
  0,
  0,
  0,
  7296,
  4416,
  6464,
  1344,
  6272,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  7296,
  4416,
  6464,
  1344,
  6272,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  61936,
  65360,
  63312,
  64976,
  62384,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  25456,
  24752,
  26128,
  29200,
  25936,
  29616,
  32752,
  32752
},
{ 0, // Red 50
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  7296,
  4416,
  6464,
  1344,
  6272,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  58224,
  57520,
  58896,
  61968,
  58704,
  62384,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  29168,
  32592,
  30544,
  32208,
  29616,
  32752,
  32752
},
{ 0, // Blue 50
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  7296,
  4416,
  6464,
  1344,
  6272,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  61936,
  65360,
  63312,
  64976,
  62384,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  25456,
  24752,
  26128,
  29200,
  25936,
  29616,
  32752,
  32752
},
{ 0, // Yellow 50
  0,
  0,
  0,
  7296,
  4416,
  6464,
  1344,
  6272,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  7296,
  4416,
  6464,
  1344,
  6272,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  58224,
  57520,
  58896,
  61968,
  58704,
  62384,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  29168,
  32592,
  30544,
  32208,
  29616,
  32752,
  32752
},
{ 0, // Green 100
  0,
  0,
  0,
  8736,
  25936,
  9552,
  9552,
  29216,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  8736,
  25936,
  9552,
  9552,
  29216,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  61424,
  60752,
  60752,
  65392,
  50912,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  24016,
  2720,
  18432,
  18432,
  3408,
  18144,
  32752,
  32752
},
{ 0, // Red 100
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  8736,
  25936,
  9552,
  9552,
  29216,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  56784,
  35488,
  51200,
  51200,
  36176,
  50912,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  28656,
  27984,
  27984,
  32624,
  18144,
  32752,
  32752
},
{ 0, // Blue 100
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  8736,
  25936,
  9552,
  9552,
  29216,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  61424,
  60752,
  60752,
  65392,
  50912,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  24016,
  2720,
  18432,
  18432,
  3408,
  18144,
  32752,
  32752
},
{ 0, // Yellow 100
  0,
  0,
  0,
  8736,
  25936,
  9552,
  9552,
  29216,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  8736,
  25936,
  9552,
  9552,
  29216,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  56784,
  35488,
  51200,
  51200,
  36176,
  50912,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  28656,
  27984,
  27984,
  32624,
  18144,
  32752,
  32752
},
{ 0, // Green 200
  0,
  0,
  0,
  25120,
  5456,
  9552,
  17744,
  29216,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  25120,
  5456,
  9552,
  17744,
  29216,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  57328,
  62800,
  60752,
  65392,
  50912,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  7632,
  19104,
  20480,
  10240,
  3408,
  18144,
  32752,
  32752
},
{ 0, // Red 200
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  25120,
  5456,
  9552,
  17744,
  29216,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  40400,
  51872,
  53248,
  43008,
  36176,
  50912,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  24560,
  30032,
  27984,
  32624,
  18144,
  32752,
  32752,
},
{ 0, // Blue 200
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  25120,
  5456,
  9552,
  17744,
  29216,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  57328,
  62800,
  60752,
  65392,
  50912,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  7632,
  19104,
  20480,
  10240,
  3408,
  18144,
  32752,
  32752
},
{ 0, // Yellow 200
  0,
  0,
  0,
  25120,
  5456,
  9552,
  17744,
  29216,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  25120,
  5456,
  9552,
  17744,
  29216,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  40400,
  51872,
  53248,
  43008,
  36176,
  50912,
  65520,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  24560,
  30032,
  27984,
  32624,
  18144,
  32752,
  32752
},
{ 0x0000, // FIRSTPATTERN
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x6DB0,
  0x7FF0,
  0x7FF0,
  0x6DB0,
  0x7FF0,
  0x7FF0,
  0x6DB0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // FIRSTPATTERN + 1
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x6FF0,
  0x6FF0,
  0x6C00,
  0x6DF0,
  0x6DF0,
  0x6030,
  0x7DB0,
  0x7DB0,
  0x01B0,
  0x7FB0,
  0x7FB0
},
{ 0x0000, // FIRSTPATTERN + 2
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7DF0,
  0x7DF0,
  0x7DF0,
  0x78F0,
  0x7770,
  0x0700,
  0x7770,
  0x78F0,
  0x7DF0,
  0x7DF0,
  0x7DF0
},
{ 0x0000, // FIRSTPATTERN + 3
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x5FD0,
  0x7FF0,
  0x7070,
  0x7770,
  0x7770,
  0x7770,
  0x7070,
  0x7FF0,
  0x5FD0,
  0x7FF0
},
{ 0x0000, // FIRSTPATTERN + 4
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7DF0,
  0x7FF0,
  0x7FF0,
  0x6DB0,
  0x7FF0,
  0x7FF0,
  0x7DF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // FIRSTPATTERN + 5
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x6FB0,
  0x6FB0,
  0x0F80,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x0F80,
  0x6FB0,
  0x6FB0
},
{ 0x0000, // FIRSTPATTERN + 6
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7070,
  0x7AF0,
  0x7DF0,
  0x7AF0,
  0x7070,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // FIRSTPATTERN + 7
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x5550,
  0x3FE0,
  0x7FF0,
  0x3FE0,
  0x7FF0,
  0x3DE0,
  0x7FF0,
  0x3FE0,
  0x7FF0,
  0x3FE0,
  0x5550
},
{ 0x0000, // FIRSTPATTERN + 8
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x3AE0,
  0x5750,
  0x6FB0,
  0x5FD0,
  0x3FE0,
  0x7FF0,
  0x3FE0,
  0x5FD0,
  0x6FB0,
  0x5750,
  0x3AE0
},
{ 0x0000, // FIRSTPATTERN + 9
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x6FB0,
  0x5750,
  0x6FB0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x6FB0,
  0x5750,
  0x6FB0,
  0x7FF0
},
{ 0x0000, // FIRSTPATTERN + 10
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7BF0,
  0x7D70,
  0x78F0,
  0x75F0,
  0x7EF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // FIRSTPATTERN + 11
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7AF0,
  0x7070,
  0x6530,
  0x7270,
  0x6530,
  0x7070,
  0x7AF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // FIRSTPATTERN + 12
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7DF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x3FE0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7DF0
},
{ 0x0000, // FIRSTPATTERN + 13
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x6730,
  0x5FD0,
  0x5FD0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x5FD0,
  0x5FD0,
  0x6730,
  0x7FF0
},
{ 0x0000, // FIRSTPATTERN + 14
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7DF0,
  0x78F0,
  0x7DF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // FIRSTPATTERN + 15
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x78F0,
  0x7FF0,
  0x6FB0,
  0x6FB0,
  0x6FB0,
  0x7FF0,
  0x78F0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // FIRSTPATTERN + 16
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7EF0,
  0x7E70,
  0x7D70,
  0x7D70,
  0x7DB0,
  0x5830,
  0x5BB0,
  0x6BD0,
  0x73D0,
  0x7FF0
},
{ 0x0000, // FIRSTPATTERN + 17
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x5FD0,
  0x6DB0,
  0x7770,
  0x7AF0,
  0x6DB0,
  0x7AF0,
  0x7770,
  0x6DB0,
  0x5FD0,
  0x7FF0
},
{ 0x0000, // FIRSTPATTERN + 18
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7770,
  0x7270,
  0x7FF0,
  0x1FC0,
  0x5FD0,
  0x7FF0,
  0x5FD0,
  0x1FC0,
  0x7FF0,
  0x7270,
  0x7770
},
{ 0x0000, // FIRSTPATTERN + 19
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x78F0,
  0x7DF0,
  0x68B0,
  0x6230,
  0x68B0,
  0x7DF0,
  0x78F0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // FIRSTPATTERN + 20
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x6030,
  0x6FB0,
  0x6FB0,
  0x6DB0,
  0x6FB0,
  0x6FB0,
  0x6030,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // FIRSTPATTERN + 21 (LASTPATTERN)
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x78F0,
  0x7770,
  0x6AB0,
  0x6DB0,
  0x6AB0,
  0x7770,
  0x78F0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // GHOSTAFFIXER
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0000,
  0x0000,
  0x0380,
  0xE7C0,
  0xE540,
  0xE7C0,
  0x0FE0,
  0x0BA0,
  0x1BB0,
  0x1C70,
  0x1FF0,
  0x0000,
  /* Plane 3 */
  0x0000,
  0x0000,
  0x0380,
  0xE7C0,
  0xE540,
  0xE7C0,
  0x0FE0,
  0x0BA0,
  0x1BB0,
  0x1C70,
  0x1FF0,
  0x0000
},
{ 0x0000, // GHOSTARMOUR
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0000,
  0x0000,
  0x0F80,
  0x0F80,
  0x1FC0,
  0x1040,
  0x1040,
  0x1FC0,
  0x1FC0,
  0x1FC0,
  0x1FC0,
  0x0000,
  /* Plane 3 */
  0x0000,
  0x0000,
  0x0F80,
  0x0F80,
  0x1FC0,
  0x1040,
  0x1040,
  0x1FC0,
  0x1FC0,
  0x1FC0,
  0x1FC0,
  0x0000
},
{ 0x0000, // GHOSTAUTOFIRE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0000,
  0x0000,
  0x0000,
  0x0600,
  0x0900,
  0x1180,
  0x1080,
  0x22D0,
  0x21E0,
  0x20C0,
  0x4000,
  0x4000,
  /* Plane 3 */
  0x0000,
  0x0000,
  0x0000,
  0x0600,
  0x0900,
  0x1180,
  0x1080,
  0x22D0,
  0x21E0,
  0x20C0,
  0x4000,
  0x4000
},
{ 0x0000, // GHOSTBACKWARDS
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0200,
  0x0700,
  0x1240,
  0x2720,
  0x4710,
  0x0700,
  0x0700,
  /* Plane 3 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0200,
  0x0700,
  0x1240,
  0x2720,
  0x4710,
  0x0700,
  0x0700
},
{ 0x0000, // GHOSTCUTTER
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0000,
  0x1110,
  0x2220,
  0x7770,
  0x2220,
  0x4440,
  0x0000,
  0x1110,
  0x2220,
  0x7770,
  0x2220,
  0x4440,
  /* Plane 3 */
  0x0000,
  0x1110,
  0x2220,
  0x7770,
  0x2220,
  0x4440,
  0x0000,
  0x1110,
  0x2220,
  0x7770,
  0x2220,
  0x4440
},
{ 0x0000, // GHOSTENCLOSER
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x1800,
  0x1800,
  0x1800,
  0xFFC0,
  0xFFC0,
  0x1FC0,
  0x1FC0,
  0x1FC0,
  0x1FC0,
  0x1FC0,
  0x1FC0,
  0x0000,
  /* Plane 3 */
  0x1800,
  0x1800,
  0x1800,
  0xFFC0,
  0xFFC0,
  0x1FC0,
  0x1FC0,
  0x1FC0,
  0x1FC0,
  0x1FC0,
  0x1FC0,
  0x0000
},
{ 0x0000, // GHOSTFORWARDS
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0000,
  0x0000,
  0x0000,
  0x4010,
  0x2020,
  0x1240,
  0x0700,
  0x0200,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  /* Plane 3 */
  0x0000,
  0x0000,
  0x0000,
  0x4010,
  0x2020,
  0x1240,
  0x0700,
  0x0200,
  0x0700,
  0x0700,
  0x0700,
  0x0700
},
{ 0x0000, // GHOSTGLOW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0600,
  0x0600,
  0x0600,
  0x1F80,
  0x3FC0,
  0x7FE0,
  0x76E0,
  0x7FE0,
  0x3FC0,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 3 */
  0x0600,
  0x0600,
  0x0600,
  0x1F80,
  0x3FC0,
  0x7FE0,
  0x76E0,
  0x7FE0,
  0x3FC0,
  0x0F00,
  0x0F00,
  0x0F00
},
{ 0x0000, // GHOSTGRENADE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0000,
  0x0000,
  0x1000,
  0x38E0,
  0x3910,
  0x3900,
  0x3900,
  0x3B80,
  0x3FC0,
  0x3FC0,
  0x7F80,
  0x0000,
  /* Plane 3 */
  0x0000,
  0x0000,
  0x1000,
  0x38E0,
  0x3910,
  0x3900,
  0x3900,
  0x3B80,
  0x3FC0,
  0x3FC0,
  0x7F80,
  0x0000
},
{ 0x0000, // GHOSTPUSHER
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0000,
  0x0000,
  0x03E0,
  0x03E0,
  0x03E0,
  0x03E0,
  0x0BE0,
  0x1000,
  0x3FE0,
  0x1000,
  0x0800,
  0x0000,
  /* Plane 3 */
  0x0000,
  0x0000,
  0x03E0,
  0x03E0,
  0x03E0,
  0x03E0,
  0x0BE0,
  0x1000,
  0x3FE0,
  0x1000,
  0x0800,
  0x0000
},
{ 0x0000, // GHOSTREMNANTS
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0000,
  0x0000,
  0x1000,
  0x3800,
  0x3BE0,
  0x3BE0,
  0x3BE0,
  0x3BE0,
  0x3BE0,
  0x3800,
  0x7C00,
  0x0000,
  /* Plane 3 */
  0x0000,
  0x0000,
  0x1000,
  0x3800,
  0x3BE0,
  0x3BE0,
  0x3BE0,
  0x3BE0,
  0x3BE0,
  0x3800,
  0x7C00,
  0x0000
},
{ 0x0000, // GHOSTSIDESHOT
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0200,
  0x7770,
  0x0200,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  /* Plane 3 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0200,
  0x7770,
  0x0200,
  0x0700,
  0x0700,
  0x0700,
  0x0700
},
{ 0x0000, // GHOSTAUTOTURN
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0000,
  0x0000,
  0x2020,
  0x7070,
  0x28A0,
  0x0500,
  0x0500,
  0x0500,
  0x0500,
  0x0500,
  0x0500,
  0x0500,
  /* Plane 3 */
  0x0000,
  0x0000,
  0x2020,
  0x7070,
  0x28A0,
  0x0500,
  0x0500,
  0x0500,
  0x0500,
  0x0500,
  0x0500,
  0x0500
},
{ 0x0000, // BATTHREAD
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  0x0700,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0700,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GREENHEADUP
  0,
  0,
  0,
  0,
  0,
  0,
  12480,
  14784,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  1536,
  1536,
  1536,
  8064,
  16320,
  32736,
  30432,
  32736,
  16320,
  3840,
  3840,
  3840,
  /* Plane 2 */
  63984,
  63984,
  63984,
  57456,
  49200,
  32784,
  45264,
  47568,
  49200,
  61680,
  61680,
  61680,
  /* Plane 3 */
  1536,
  32752,
  31216,
  24688,
  16432,
  16,
  12496,
  14800,
  16432,
  28912,
  28912,
  28912
},
{ // GREENHEADDOWN
  0,
  0,
  0,
  0,
  14784,
  12480,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  3840,
  3840,
  3840,
  16320,
  32736,
  30432,
  32736,
  16320,
  8064,
  1536,
  1536,
  1536,
  /* Plane 2 */
  61680,
  61680,
  61680,
  49200,
  47568,
  45264,
  32784,
  49200,
  57456,
  63984,
  63984,
  63984,
  /* Plane 3 */
  0,
  28912,
  28912,
  16432,
  14800,
  12496,
  16,
  16432,
  24688,
  31216,
  32752,
  32752
},
{ // GREENHEADLEFT
  0,
  0,
  768,
  768,
  256,
  0,
  0,
  256,
  768,
  768,
  0,
  0,
  /* Plane 1 */
  0,
  1792,
  3968,
  8064,
  7664,
  65520,
  65520,
  7664,
  8064,
  3968,
  1792,
  0,
  /* Plane 2 */
  65520,
  63728,
  62320,
  58224,
  57600,
  0,
  0,
  57600,
  58224,
  62320,
  63728,
  65520,
  /* Plane 3 */
  0,
  30960,
  29552,
  25456,
  24832,
  49152,
  49152,
  24832,
  25456,
  29552,
  30960,
  32752
},
{ // GREENHEADRIGHT
  0,
  0,
  3072,
  3072,
  2048,
  0,
  0,
  2048,
  3072,
  3072,
  0,
  0,
  /* Plane 1 */
  0,
  3584,
  7936,
  8064,
  64384,
  65520,
  65520,
  64384,
  8064,
  7936,
  3584,
  0,
  /* Plane 2 */
  65520,
  61936,
  60656,
  60528,
  2160,
  0,
  0,
  2160,
  60528,
  60656,
  61936,
  65520,
  /* Plane 3 */
  0,
  29168,
  27888,
  27760,
  2160,
  48,
  48,
  2160,
  27760,
  27888,
  29168,
  32752
},
{ // GREENHEAD_NW
  0,
  0,
  1024,
  3072,
  4096,
  12288,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  49152,
  64512,
  30592,
  32704,
  24448,
  32640,
  16256,
  16320,
  16352,
  4592,
  240,
  112,
  /* Plane 2 */
  16368,
  1008,
  33904,
  35888,
  36976,
  45168,
  49264,
  49200,
  49168,
  60928,
  65280,
  65408,
  /* Plane 3 */
  49152,
  50160,
  1136,
  3120,
  4208,
  12400,
  16496,
  16432,
  16400,
  28160,
  32512,
  32640
},
{ // GREENHEAD_NE
  0,
  0,
  512,
  768,
  128,
  192,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  48,
  1008,
  7904,
  16352,
  8096,
  8160,
  8128,
  16320,
  32704,
  63616,
  61440,
  57344,
  /* Plane 2 */
  65472,
  64512,
  57872,
  49936,
  57488,
  57552,
  57392,
  49200,
  32816,
  1904,
  4080,
  8176,
  /* Plane 3 */
  48,
  31792,
  25104,
  17168,
  24720,
  24784,
  24624,
  16432,
  48,
  1904,
  4080,
  8176
},
{ // GREENHEAD_SW
  0,
  0,
  0,
  0,
  0,
  0,
  12288,
  4096,
  3072,
  1024,
  0,
  0,
  /* Plane 1 */
  112,
  240,
  4592,
  16352,
  16320,
  16256,
  32640,
  24448,
  32704,
  30592,
  64512,
  49152,
  /* Plane 2 */
  65408,
  65280,
  60928,
  49168,
  49200,
  49264,
  45168,
  36976,
  35888,
  33904,
  1008,
  16368,
  /* Plane 3 */
  0,
  32512,
  28160,
  16400,
  16432,
  16496,
  12400,
  4208,
  3120,
  1136,
  50160,
  65520
},
{ // GREENHEAD_SE
  0,
  0,
  0,
  0,
  0,
  0,
  192,
  128,
  768,
  512,
  0,
  0,
  /* Plane 1 */
  57344,
  61440,
  63616,
  32704,
  16320,
  8128,
  8160,
  8096,
  16352,
  7904,
  1008,
  48,
  /* Plane 2 */
  8176,
  4080,
  1904,
  32816,
  49200,
  57392,
  57552,
  57488,
  49936,
  57872,
  64512,
  65472,
  /* Plane 3 */
  0,
  4080,
  1904,
  48,
  16432,
  24624,
  24784,
  24720,
  17168,
  25104,
  31792,
  32752
},
{ // GREENGLOWUP
  0,
  0,
  1536,
  8064,
  16320,
  32736,
  30432,
  32736,
  16320,
  3840,
  3840,
  3840,
  /* Plane 1 */
  1536,
  1536,
  1536,
  8064,
  16320,
  32736,
  30432,
  32736,
  16320,
  3840,
  3840,
  3840,
  /* Plane 2 */
  63984,
  63984,
  65520,
  65520,
  65520,
  65520,
  63216,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  1536,
  32752,
  31216,
  24688,
  16432,
  16,
  12496,
  14800,
  16432,
  28912,
  28912,
  28912
},
{ // GREENGLOWDOWN
  3840,
  3840,
  3840,
  16320,
  32736,
  30432,
  32736,
  16320,
  8064,
  1536,
  0,
  0,
  /* Plane 1 */
  3840,
  3840,
  3840,
  16320,
  32736,
  30432,
  32736,
  16320,
  8064,
  1536,
  1536,
  1536,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  63216,
  65520,
  65520,
  65520,
  65520,
  63984,
  63984,
  /* Plane 3 */
  0,
  28912,
  28912,
  16432,
  14800,
  12496,
  16,
  16432,
  24688,
  31216,
  32752,
  32752
},
{ // GREENGLOWLEFT
  0,
  1792,
  3968,
  8064,
  7664,
  16368,
  16368,
  7664,
  8064,
  3968,
  1792,
  0,
  /* Plane 1 */
  0,
  1792,
  3968,
  8064,
  7664,
  65520,
  65520,
  7664,
  8064,
  3968,
  1792,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65008,
  16368,
  16368,
  65008,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  30960,
  29552,
  25456,
  24832,
  49152,
  49152,
  24832,
  25456,
  29552,
  30960,
  32752
},
{ // GREENGLOWRIGHT
  0,
  3584,
  7936,
  8064,
  64384,
  65472,
  65472,
  64384,
  8064,
  7936,
  3584,
  0,
  /* Plane 1 */
  0,
  3584,
  7936,
  8064,
  64384,
  65520,
  65520,
  64384,
  8064,
  7936,
  3584,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  64496,
  65472,
  65472,
  64496,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  29168,
  27888,
  27760,
  2160,
  48,
  48,
  2160,
  27760,
  27888,
  29168,
  32752
},
{ // GREENGLOW_NW
  0,
  15360,
  30592,
  32704,
  24448,
  32640,
  16256,
  16320,
  16352,
  4592,
  240,
  112,
  /* Plane 1 */
  49152,
  64512,
  30592,
  32704,
  24448,
  32640,
  16256,
  16320,
  16352,
  4592,
  240,
  112,
  /* Plane 2 */
  16368,
  16368,
  63472,
  65520,
  57328,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  49152,
  50160,
  1136,
  3120,
  4208,
  12400,
  16496,
  16432,
  16400,
  28160,
  32512,
  32640
},
{ // GREENGLOW_NE
  0,
  960,
  7904,
  16352,
  8096,
  8160,
  8128,
  16320,
  32704,
  63616,
  61440,
  57344,
  /* Plane 1 */
  48,
  1008,
  7904,
  16352,
  8096,
  8160,
  8128,
  16320,
  32704,
  63616,
  61440,
  57344,
  /* Plane 2 */
  65472,
  65472,
  65264,
  65520,
  65456,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  48,
  31792,
  25104,
  17168,
  24720,
  24784,
  24624,
  16432,
  48,
  1904,
  4080,
  8176
},
{ // GREENGLOW_SW
  112,
  240,
  4592,
  16352,
  16320,
  16256,
  32640,
  24448,
  32704,
  30592,
  15360,
  0,
  /* Plane 1 */
  112,
  240,
  4592,
  16352,
  16320,
  16256,
  32640,
  24448,
  32704,
  30592,
  64512,
  49152,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  57328,
  65520,
  63472,
  16368,
  16368,
  /* Plane 3 */
  0,
  32512,
  28160,
  16400,
  16432,
  16496,
  12400,
  4208,
  3120,
  1136,
  50160,
  65520
},
{ // GREENGLOW_SE
  57344,
  61440,
  63616,
  32704,
  16320,
  8128,
  8160,
  8096,
  16352,
  7904,
  960,
  0,
  /* Plane 1 */
  57344,
  61440,
  63616,
  32704,
  16320,
  8128,
  8160,
  8096,
  16352,
  7904,
  1008,
  48,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65456,
  65520,
  65264,
  65472,
  65472,
  /* Plane 3 */
  0,
  4080,
  1904,
  48,
  16432,
  24624,
  24784,
  24720,
  17168,
  25104,
  31792,
  32752
},
{ // REDHEADUP
  0,
  0,
  0,
  0,
  0,
  0,
  12480,
  14784,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  1536,
  1536,
  0,
  0,
  0,
  0,
  12480,
  14784,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  63984,
  57456,
  49200,
  32784,
  45264,
  47568,
  49200,
  61680,
  61680,
  61680,
  /* Plane 3 */
  0,
  31216,
  32752,
  32752,
  32752,
  32752,
  30448,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // REDHEADDOWN
  0,
  0,
  0,
  0,
  14784,
  12480,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  14784,
  12480,
  0,
  0,
  0,
  0,
  1536,
  1536,
  /* Plane 2 */
  61680,
  61680,
  61680,
  49200,
  47568,
  45264,
  32784,
  49200,
  57456,
  63984,
  65520,
  65520,
  /* Plane 3 */
  3840,
  32752,
  32752,
  32752,
  32752,
  30448,
  32752,
  32752,
  32752,
  32752,
  31216,
  31216
},
{ // REDHEADLEFT
  0,
  0,
  768,
  768,
  256,
  0,
  0,
  256,
  768,
  768,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  768,
  768,
  256,
  49152,
  49152,
  256,
  768,
  768,
  0,
  0,
  /* Plane 2 */
  65520,
  63728,
  62320,
  58224,
  57600,
  49152,
  49152,
  57600,
  58224,
  62320,
  63728,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32240,
  16368,
  16368,
  32240,
  32752,
  32752,
  32752,
  32752
},
{ // REDHEADRIGHT
  0,
  0,
  3072,
  3072,
  2048,
  0,
  0,
  2048,
  3072,
  3072,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  3072,
  3072,
  2048,
  48,
  48,
  2048,
  3072,
  3072,
  0,
  0,
  /* Plane 2 */
  65520,
  61936,
  60656,
  60528,
  2160,
  48,
  48,
  2160,
  60528,
  60656,
  61936,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  64496,
  65472,
  65472,
  64496,
  32752,
  32752,
  32752,
  32752
},
{ // REDHEAD_NW
  0,
  0,
  1024,
  3072,
  4096,
  12288,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  49152,
  49152,
  1024,
  3072,
  4096,
  12288,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  50160,
  33904,
  35888,
  36976,
  45168,
  49264,
  49200,
  49168,
  60928,
  65280,
  65408,
  /* Plane 3 */
  0,
  16368,
  30704,
  32752,
  24560,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // REDHEAD_NE
  0,
  0,
  512,
  768,
  128,
  192,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  48,
  48,
  512,
  768,
  128,
  192,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  64560,
  57872,
  49936,
  57488,
  57552,
  57392,
  49200,
  32816,
  1904,
  4080,
  8176,
  /* Plane 3 */
  0,
  32704,
  32496,
  32752,
  32688,
  32752,
  32752,
  32752,
  32752,
  65520,
  65520,
  65520
},
{ // REDHEAD_SW
  0,
  0,
  0,
  0,
  0,
  0,
  12288,
  4096,
  3072,
  1024,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  12288,
  4096,
  3072,
  1024,
  49152,
  49152,
  /* Plane 2 */
  65408,
  65280,
  60928,
  49168,
  49200,
  49264,
  45168,
  36976,
  35888,
  33904,
  50160,
  65520,
  /* Plane 3 */
  112,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  24560,
  32752,
  30704,
  16368,
  16368
},
{ // REDHEAD_SE
  0,
  0,
  0,
  0,
  0,
  0,
  192,
  128,
  768,
  512,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  192,
  128,
  768,
  512,
  48,
  48,
  /* Plane 2 */
  8176,
  4080,
  1904,
  32816,
  49200,
  57392,
  57552,
  57488,
  49936,
  57872,
  64560,
  65520,
  /* Plane 3 */
  57344,
  65520,
  65520,
  32752,
  32752,
  32752,
  32752,
  32688,
  32752,
  32496,
  32704,
  32704
},
{ // REDGLOWUP
  0,
  0,
  0,
  0,
  0,
  0,
  12480,
  14784,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  1536,
  1536,
  1536,
  8064,
  16320,
  32736,
  30432,
  32736,
  16320,
  3840,
  3840,
  3840,
  /* Plane 2 */
  65520,
  65520,
  63984,
  57456,
  49200,
  32784,
  45264,
  47568,
  49200,
  61680,
  61680,
  61680,
  /* Plane 3 */
  0,
  31216,
  32752,
  32752,
  32752,
  32752,
  30448,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // REDGLOWDOWN
  0,
  0,
  0,
  0,
  14784,
  12480,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  3840,
  3840,
  3840,
  16320,
  32736,
  30432,
  32736,
  16320,
  8064,
  1536,
  1536,
  1536,
  /* Plane 2 */
  61680,
  61680,
  61680,
  49200,
  47568,
  45264,
  32784,
  49200,
  57456,
  63984,
  65520,
  65520,
  /* Plane 3 */
  3840,
  32752,
  32752,
  32752,
  32752,
  30448,
  32752,
  32752,
  32752,
  32752,
  31216,
  31216
},
{ // REDGLOWLEFT
  0,
  0,
  768,
  768,
  256,
  0,
  0,
  256,
  768,
  768,
  0,
  0,
  /* Plane 1 */
  0,
  1792,
  3968,
  8064,
  7664,
  65520,
  65520,
  7664,
  8064,
  3968,
  1792,
  0,
  /* Plane 2 */
  65520,
  63728,
  62320,
  58224,
  57600,
  49152,
  49152,
  57600,
  58224,
  62320,
  63728,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32240,
  16368,
  16368,
  32240,
  32752,
  32752,
  32752,
  32752
},
{ // REDGLOWRIGHT
  0,
  0,
  3072,
  3072,
  2048,
  0,
  0,
  2048,
  3072,
  3072,
  0,
  0,
  /* Plane 1 */
  0,
  3584,
  7936,
  8064,
  64384,
  65520,
  65520,
  64384,
  8064,
  7936,
  3584,
  0,
  /* Plane 2 */
  65520,
  61936,
  60656,
  60528,
  2160,
  48,
  48,
  2160,
  60528,
  60656,
  61936,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  64496,
  65472,
  65472,
  64496,
  32752,
  32752,
  32752,
  32752
},
{ // REDGLOW_NW
  0,
  0,
  1024,
  3072,
  4096,
  12288,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  49152,
  64512,
  30592,
  32704,
  24448,
  32640,
  16256,
  16320,
  16352,
  4592,
  240,
  112,
  /* Plane 2 */
  65520,
  50160,
  33904,
  35888,
  36976,
  45168,
  49264,
  49200,
  49168,
  60928,
  65280,
  65408,
  /* Plane 3 */
  0,
  16368,
  30704,
  32752,
  24560,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // REDGLOW_NE
  0,
  0,
  512,
  768,
  128,
  192,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  48,
  1008,
  7904,
  16352,
  8096,
  8160,
  8128,
  16320,
  32704,
  63616,
  61440,
  57344,
  /* Plane 2 */
  65520,
  64560,
  57872,
  49936,
  57488,
  57552,
  57392,
  49200,
  32816,
  1904,
  4080,
  8176,
  /* Plane 3 */
  0,
  32704,
  32496,
  32752,
  32688,
  32752,
  32752,
  32752,
  32752,
  65520,
  65520,
  65520
},
{ // REDGLOW_SW
  0,
  0,
  0,
  0,
  0,
  0,
  12288,
  4096,
  3072,
  1024,
  0,
  0,
  /* Plane 1 */
  112,
  240,
  4592,
  16352,
  16320,
  16256,
  32640,
  24448,
  32704,
  30592,
  64512,
  49152,
  /* Plane 2 */
  65408,
  65280,
  60928,
  49168,
  49200,
  49264,
  45168,
  36976,
  35888,
  33904,
  50160,
  65520,
  /* Plane 3 */
  112,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  24560,
  32752,
  30704,
  16368,
  16368
},
{ // REDGLOW_SE
  0,
  0,
  0,
  0,
  0,
  0,
  192,
  128,
  768,
  512,
  0,
  0,
  /* Plane 1 */
  57344,
  61440,
  63616,
  32704,
  16320,
  8128,
  8160,
  8096,
  16352,
  7904,
  1008,
  48,
  /* Plane 2 */
  8176,
  4080,
  1904,
  32816,
  49200,
  57392,
  57552,
  57488,
  49936,
  57872,
  64560,
  65520,
  /* Plane 3 */
  57344,
  65520,
  65520,
  32752,
  32752,
  32752,
  32752,
  32688,
  32752,
  32496,
  32704,
  32704
},
{ // BLUEHEADUP
  0,
  0,
  1536,
  8064,
  16320,
  32736,
  30432,
  32736,
  16320,
  3840,
  3840,
  3840,
  /* Plane 1 */
  1536,
  1536,
  0,
  0,
  0,
  0,
  12480,
  14784,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  63984,
  63984,
  65520,
  65520,
  65520,
  65520,
  63216,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  1536,
  32752,
  31216,
  24688,
  16432,
  16,
  12496,
  14800,
  16432,
  28912,
  28912,
  28912
},
{ // BLUEHEADDOWN
  3840,
  3840,
  3840,
  16320,
  32736,
  30432,
  32736,
  16320,
  8064,
  1536,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  14784,
  12480,
  0,
  0,
  0,
  0,
  1536,
  1536,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  63216,
  65520,
  65520,
  65520,
  65520,
  63984,
  63984,
  /* Plane 3 */
  0,
  28912,
  28912,
  16432,
  14800,
  12496,
  16,
  16432,
  24688,
  31216,
  32752,
  32752
},
{ // BLUEHEADLEFT
  0,
  1792,
  3968,
  8064,
  7664,
  16368,
  16368,
  7664,
  8064,
  3968,
  1792,
  0,
  /* Plane 1 */
  0,
  0,
  768,
  768,
  256,
  49152,
  49152,
  256,
  768,
  768,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65008,
  16368,
  16368,
  65008,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  30960,
  29552,
  25456,
  24832,
  49152,
  49152,
  24832,
  25456,
  29552,
  30960,
  32752
},
{ // BLUEHEADRIGHT
  0,
  3584,
  7936,
  8064,
  64384,
  65472,
  65472,
  64384,
  8064,
  7936,
  3584,
  0,
  /* Plane 1 */
  0,
  0,
  3072,
  3072,
  2048,
  48,
  48,
  2048,
  3072,
  3072,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  64496,
  65472,
  65472,
  64496,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  29168,
  27888,
  27760,
  2160,
  48,
  48,
  2160,
  27760,
  27888,
  29168,
  32752
},
{ // BLUEHEAD_NW
  0,
  15360,
  30592,
  32704,
  24448,
  32640,
  16256,
  16320,
  16352,
  4592,
  240,
  112,
  /* Plane 1 */
  49152,
  49152,
  1024,
  3072,
  4096,
  12288,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  16368,
  16368,
  63472,
  65520,
  57328,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  49152,
  50160,
  1136,
  3120,
  4208,
  12400,
  16496,
  16432,
  16400,
  28160,
  32512,
  32640
},
{ // BLUEHEAD_NE
  0,
  960,
  7904,
  16352,
  8096,
  8160,
  8128,
  16320,
  32704,
  63616,
  61440,
  57344,
  /* Plane 1 */
  48,
  48,
  512,
  768,
  128,
  192,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65472,
  65472,
  65264,
  65520,
  65456,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  48,
  31792,
  25104,
  17168,
  24720,
  24784,
  24624,
  16432,
  48,
  1904,
  4080,
  8176
},
{ // BLUEHEAD_SW
  112,
  240,
  4592,
  16352,
  16320,
  16256,
  32640,
  24448,
  32704,
  30592,
  15360,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  12288,
  4096,
  3072,
  1024,
  49152,
  49152,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  57328,
  65520,
  63472,
  16368,
  16368,
  /* Plane 3 */
  0,
  32512,
  28160,
  16400,
  16432,
  16496,
  12400,
  4208,
  3120,
  1136,
  50160,
  65520
},
{ // BLUEHEAD_SE
  57344,
  61440,
  63616,
  32704,
  16320,
  8128,
  8160,
  8096,
  16352,
  7904,
  960,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  192,
  128,
  768,
  512,
  48,
  48,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65456,
  65520,
  65264,
  65472,
  65472,
  /* Plane 3 */
  0,
  4080,
  1904,
  48,
  16432,
  24624,
  24784,
  24720,
  17168,
  25104,
  31792,
  32752
},
{ // BLUEGLOWUP
  0,
  0,
  0,
  0,
  0,
  0,
  12480,
  14784,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  1536,
  1536,
  1536,
  8064,
  16320,
  32736,
  30432,
  32736,
  16320,
  3840,
  3840,
  3840,
  /* Plane 2 */
  63984,
  63984,
  65520,
  65520,
  65520,
  65520,
  63216,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  1536,
  32752,
  31216,
  24688,
  16432,
  16,
  12496,
  14800,
  16432,
  28912,
  28912,
  28912
},
{ // BLUEGLOWDOWN
  0,
  0,
  0,
  0,
  14784,
  12480,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  3840,
  3840,
  3840,
  16320,
  32736,
  30432,
  32736,
  16320,
  8064,
  1536,
  1536,
  1536,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  63216,
  65520,
  65520,
  65520,
  65520,
  63984,
  63984,
  /* Plane 3 */
  0,
  28912,
  28912,
  16432,
  14800,
  12496,
  16,
  16432,
  24688,
  31216,
  32752,
  32752
},
{ // BLUEGLOWLEFT
  0,
  0,
  768,
  768,
  256,
  0,
  0,
  256,
  768,
  768,
  0,
  0,
  /* Plane 1 */
  0,
  1792,
  3968,
  8064,
  7664,
  65520,
  65520,
  7664,
  8064,
  3968,
  1792,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65008,
  16368,
  16368,
  65008,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  30960,
  29552,
  25456,
  24832,
  49152,
  49152,
  24832,
  25456,
  29552,
  30960,
  32752
},
{ // BLUEGLOWRIGHT
  0,
  0,
  3072,
  3072,
  2048,
  0,
  0,
  2048,
  3072,
  3072,
  0,
  0,
  /* Plane 1 */
  0,
  3584,
  7936,
  8064,
  64384,
  65520,
  65520,
  64384,
  8064,
  7936,
  3584,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  64496,
  65472,
  65472,
  64496,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  29168,
  27888,
  27760,
  2160,
  48,
  48,
  2160,
  27760,
  27888,
  29168,
  32752
},
{ // BLUEGLOW_NW
  0,
  0,
  1024,
  3072,
  4096,
  12288,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  49152,
  64512,
  30592,
  32704,
  24448,
  32640,
  16256,
  16320,
  16352,
  4592,
  240,
  112,
  /* Plane 2 */
  16368,
  16368,
  63472,
  65520,
  57328,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  49152,
  50160,
  1136,
  3120,
  4208,
  12400,
  16496,
  16432,
  16400,
  28160,
  32512,
  32640
},
{ // BLUEGLOW_NE
  0,
  0,
  512,
  768,
  128,
  192,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  48,
  1008,
  7904,
  16352,
  8096,
  8160,
  8128,
  16320,
  32704,
  63616,
  61440,
  57344,
  /* Plane 2 */
  65472,
  65472,
  65264,
  65520,
  65456,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  48,
  31792,
  25104,
  17168,
  24720,
  24784,
  24624,
  16432,
  48,
  1904,
  4080,
  8176
},
{ // BLUEGLOW_SW
  0,
  0,
  0,
  0,
  0,
  0,
  12288,
  4096,
  3072,
  1024,
  0,
  0,
  /* Plane 1 */
  112,
  240,
  4592,
  16352,
  16320,
  16256,
  32640,
  24448,
  32704,
  30592,
  64512,
  49152,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  57328,
  65520,
  63472,
  16368,
  16368,
  /* Plane 3 */
  0,
  32512,
  28160,
  16400,
  16432,
  16496,
  12400,
  4208,
  3120,
  1136,
  50160,
  65520
},
{ // BLUEGLOW_SE
  0,
  0,
  0,
  0,
  0,
  0,
  192,
  128,
  768,
  512,
  0,
  0,
  /* Plane 1 */
  57344,
  61440,
  63616,
  32704,
  16320,
  8128,
  8160,
  8096,
  16352,
  7904,
  1008,
  48,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65456,
  65520,
  65264,
  65472,
  65472,
  /* Plane 3 */
  0,
  4080,
  1904,
  48,
  16432,
  24624,
  24784,
  24720,
  17168,
  25104,
  31792,
  32752
},
{ // YELLOWHEADUP
  0,
  0,
  1536,
  8064,
  16320,
  32736,
  30432,
  32736,
  16320,
  3840,
  3840,
  3840,
  /* Plane 1 */
  1536,
  1536,
  1536,
  8064,
  16320,
  32736,
  30432,
  32736,
  16320,
  3840,
  3840,
  3840,
  /* Plane 2 */
  65520,
  65520,
  63984,
  57456,
  49200,
  32784,
  45264,
  47568,
  49200,
  61680,
  61680,
  61680,
  /* Plane 3 */
  0,
  31216,
  31216,
  24688,
  16432,
  16,
  12496,
  14800,
  16432,
  28912,
  28912,
  28912
},
{ // YELLOWHEADDOWN
  3840,
  3840,
  3840,
  16320,
  32736,
  30432,
  32736,
  16320,
  8064,
  1536,
  0,
  0,
  /* Plane 1 */
  3840,
  3840,
  3840,
  16320,
  32736,
  30432,
  32736,
  16320,
  8064,
  1536,
  1536,
  1536,
  /* Plane 2 */
  61680,
  61680,
  61680,
  49200,
  47568,
  45264,
  32784,
  49200,
  57456,
  63984,
  65520,
  65520,
  /* Plane 3 */
  0,
  28912,
  28912,
  16432,
  14800,
  12496,
  16,
  16432,
  24688,
  31216,
  31216,
  31216
},
{ // YELLOWHEADLEFT
  0,
  1792,
  3968,
  8064,
  7664,
  16368,
  16368,
  7664,
  8064,
  3968,
  1792,
  0,
  /* Plane 1 */
  0,
  1792,
  3968,
  8064,
  7664,
  65520,
  65520,
  7664,
  8064,
  3968,
  1792,
  0,
  /* Plane 2 */
  65520,
  63728,
  62320,
  58224,
  57600,
  49152,
  49152,
  57600,
  58224,
  62320,
  63728,
  65520,
  /* Plane 3 */
  0,
  30960,
  29552,
  25456,
  24832,
  0,
  0,
  24832,
  25456,
  29552,
  30960,
  32752
},
{ // YELLOWHEADRIGHT
  0,
  3584,
  7936,
  8064,
  64384,
  65472,
  65472,
  64384,
  8064,
  7936,
  3584,
  0,
  /* Plane 1 */
  0,
  3584,
  7936,
  8064,
  64384,
  65520,
  65520,
  64384,
  8064,
  7936,
  3584,
  0,
  /* Plane 2 */
  65520,
  61936,
  60656,
  60528,
  2160,
  48,
  48,
  2160,
  60528,
  60656,
  61936,
  65520,
  /* Plane 3 */
  0,
  29168,
  27888,
  27760,
  2160,
  0,
  0,
  2160,
  27760,
  27888,
  29168,
  32752
},
{ // YELLOWHEAD_NW
  0,
  15360,
  30592,
  32704,
  24448,
  32640,
  16256,
  16320,
  16352,
  4592,
  240,
  112,
  /* Plane 1 */
  49152,
  64512,
  30592,
  32704,
  24448,
  32640,
  16256,
  16320,
  16352,
  4592,
  240,
  112,
  /* Plane 2 */
  65520,
  50160,
  33904,
  35888,
  36976,
  45168,
  49264,
  49200,
  49168,
  60928,
  65280,
  65408,
  /* Plane 3 */
  0,
  1008,
  1136,
  3120,
  4208,
  12400,
  16496,
  16432,
  16400,
  28160,
  32512,
  32640
},
{ // YELLOWHEAD_NE
  0,
  960,
  7904,
  16352,
  8096,
  8160,
  8128,
  16320,
  32704,
  63616,
  61440,
  57344,
  /* Plane 1 */
  48,
  1008,
  7904,
  16352,
  8096,
  8160,
  8128,
  16320,
  32704,
  63616,
  61440,
  57344,
  /* Plane 2 */
  65520,
  64560,
  57872,
  49936,
  57488,
  57552,
  57392,
  49200,
  32816,
  1904,
  4080,
  8176,
  /* Plane 3 */
  0,
  31744,
  25104,
  17168,
  24720,
  24784,
  24624,
  16432,
  48,
  1904,
  4080,
  8176
},
{ // YELLOWHEAD_SW
  112,
  240,
  4592,
  16352,
  16320,
  16256,
  32640,
  24448,
  32704,
  30592,
  15360,
  0,
  /* Plane 1 */
  112,
  240,
  4592,
  16352,
  16320,
  16256,
  32640,
  24448,
  32704,
  30592,
  64512,
  49152,
  /* Plane 2 */
  65408,
  65280,
  60928,
  49168,
  49200,
  49264,
  45168,
  36976,
  35888,
  33904,
  50160,
  65520,
  /* Plane 3 */
  0,
  32512,
  28160,
  16400,
  16432,
  16496,
  12400,
  4208,
  3120,
  1136,
  1008,
  16368
},
{ // YELLOWHEAD_SE
  57344,
  61440,
  63616,
  32704,
  16320,
  8128,
  8160,
  8096,
  16352,
  7904,
  960,
  0,
  /* Plane 1 */
  57344,
  61440,
  63616,
  32704,
  16320,
  8128,
  8160,
  8096,
  16352,
  7904,
  1008,
  48,
  /* Plane 2 */
  8176,
  4080,
  1904,
  32816,
  49200,
  57392,
  57552,
  57488,
  49936,
  57872,
  64560,
  65520,
  /* Plane 3 */
  0,
  4080,
  1904,
  48,
  16432,
  24624,
  24784,
  24720,
  17168,
  25104,
  31744,
  32704
},
{ // YELLOWGLOWUP
  0,
  0,
  1536,
  8064,
  16320,
  32736,
  30432,
  32736,
  16320,
  3840,
  3840,
  3840,
  /* Plane 1 */
  1536,
  1536,
  1536,
  8064,
  16320,
  32736,
  30432,
  32736,
  16320,
  3840,
  3840,
  3840,
  /* Plane 2 */
  65520,
  65520,
  63984,
  57456,
  49200,
  32784,
  45264,
  47568,
  49200,
  61680,
  61680,
  61680,
  /* Plane 3 */
  0,
  31216,
  32752,
  32752,
  32752,
  32752,
  30448,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // YELLOWGLOWDOWN
  3840,
  3840,
  3840,
  16320,
  32736,
  30432,
  32736,
  16320,
  8064,
  1536,
  0,
  0,
  /* Plane 1 */
  3840,
  3840,
  3840,
  16320,
  32736,
  30432,
  32736,
  16320,
  8064,
  1536,
  1536,
  1536,
  /* Plane 2 */
  61680,
  61680,
  61680,
  49200,
  47568,
  45264,
  32784,
  49200,
  57456,
  63984,
  65520,
  65520,
  /* Plane 3 */
  3840,
  32752,
  32752,
  32752,
  32752,
  30448,
  32752,
  32752,
  32752,
  32752,
  31216,
  31216
},
{ // YELLOWGLOWLEFT
  0,
  1792,
  3968,
  8064,
  7664,
  16368,
  16368,
  7664,
  8064,
  3968,
  1792,
  0,
  /* Plane 1 */
  0,
  1792,
  3968,
  8064,
  7664,
  65520,
  65520,
  7664,
  8064,
  3968,
  1792,
  0,
  /* Plane 2 */
  65520,
  63728,
  62320,
  58224,
  57600,
  49152,
  49152,
  57600,
  58224,
  62320,
  63728,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32240,
  16368,
  16368,
  32240,
  32752,
  32752,
  32752,
  32752
},
{ // YELLOWGLOWRIGHT
  0,
  3584,
  7936,
  8064,
  64384,
  65472,
  65472,
  64384,
  8064,
  7936,
  3584,
  0,
  /* Plane 1 */
  0,
  3584,
  7936,
  8064,
  64384,
  65520,
  65520,
  64384,
  8064,
  7936,
  3584,
  0,
  /* Plane 2 */
  65520,
  61936,
  60656,
  60528,
  2160,
  48,
  48,
  2160,
  60528,
  60656,
  61936,
  65520,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  64496,
  65472,
  65472,
  64496,
  32752,
  32752,
  32752,
  32752
},
{ // YELLOWGLOW_NW
  0,
  15360,
  30592,
  32704,
  24448,
  32640,
  16256,
  16320,
  16352,
  4592,
  240,
  112,
  /* Plane 1 */
  49152,
  64512,
  30592,
  32704,
  24448,
  32640,
  16256,
  16320,
  16352,
  4592,
  240,
  112,
  /* Plane 2 */
  65520,
  50160,
  33904,
  35888,
  36976,
  45168,
  49264,
  49200,
  49168,
  60928,
  65280,
  65408,
  /* Plane 3 */
  0,
  16368,
  30704,
  32752,
  24560,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // YELLOWGLOW_NE
  0,
  960,
  7904,
  16352,
  8096,
  8160,
  8128,
  16320,
  32704,
  63616,
  61440,
  57344,
  /* Plane 1 */
  48,
  1008,
  7904,
  16352,
  8096,
  8160,
  8128,
  16320,
  32704,
  63616,
  61440,
  57344,
  /* Plane 2 */
  65520,
  64560,
  57872,
  49936,
  57488,
  57552,
  57392,
  49200,
  32816,
  1904,
  4080,
  8176,
  /* Plane 3 */
  0,
  32704,
  32496,
  32752,
  32688,
  32752,
  32752,
  32752,
  32752,
  65520,
  65520,
  65520
},
{ // YELLOWGLOW_SW
  112,
  240,
  4592,
  16352,
  16320,
  16256,
  32640,
  24448,
  32704,
  30592,
  15360,
  0,
  /* Plane 1 */
  112,
  240,
  4592,
  16352,
  16320,
  16256,
  32640,
  24448,
  32704,
  30592,
  64512,
  49152,
  /* Plane 2 */
  65408,
  65280,
  60928,
  49168,
  49200,
  49264,
  45168,
  36976,
  35888,
  33904,
  50160,
  65520,
  /* Plane 3 */
  112,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  24560,
  32752,
  30704,
  16368,
  16368
},
{ // YELLOWGLOW_SE
  57344,
  61440,
  63616,
  32704,
  16320,
  8128,
  8160,
  8096,
  16352,
  7904,
  960,
  0,
  /* Plane 1 */
  57344,
  61440,
  63616,
  32704,
  16320,
  8128,
  8160,
  8096,
  16352,
  7904,
  1008,
  48,
  /* Plane 2 */
  8176,
  4080,
  1904,
  32816,
  49200,
  57392,
  57552,
  57488,
  49936,
  57872,
  64560,
  65520,
  /* Plane 3 */
  57344,
  65520,
  65520,
  32752,
  32752,
  32752,
  32752,
  32688,
  32752,
  32496,
  32704,
  32704
},
{ // GN_E_NE or GN_NE_E
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x01F0,
  0x01F0,
  0x03F0,
  0x0780,
  0x07F0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFE00,
  0xFE00,
  0xFC00,
  0xF800,
  0xF800,
  0xF800,
  0xFC00,
  0xFE00,
  0xFF00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7E00,
  0x7C00,
  0x7800,
  0x7800,
  0x7800,
  0x7C00,
  0x7E00,
  0x7F00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GN_E_S or GN_S_E
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x07F0,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF800,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7800,
  0x7000,
  0x7000,
  0x7000,
  0x7000,
  0x7070,
  0x7070,
  0x7070
},
{ // GN_E_SE or GN_SE_E
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x03F0,
  0x07F0,
  0x07F0,
  0x0780,
  0x03F0,
  0x01F0,
  0x01F0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFE00,
  0xFC00,
  0xF800,
  0xF800,
  0xF800,
  0xFC00,
  0xFE00,
  0xFE00,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7E00,
  0x7C00,
  0x7800,
  0x7800,
  0x7800,
  0x7C00,
  0x7E00,
  0x7E00
},
{ // GN_NE_SE or GN_SE_NE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0780,
  0x0780,
  0x07C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xFC00,
  0xF800,
  0xF810,
  0xF830,
  0xF830,
  0xFC10,
  0xFE00,
  0xFF00,
  0xFF80,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7C00,
  0x7800,
  0x7810,
  0x7830,
  0x7830,
  0x7C10,
  0x7E00,
  0x7F00,
  0x7F80
},
{ // GN_NE_SW or GN_SW_NE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0F80,
  0x1F00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xFC00,
  0xF800,
  0xF010,
  0xE030,
  0xC070,
  0x80F0,
  0x01F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7C00,
  0x7800,
  0x7010,
  0x6030,
  0x4070,
  0x00F0,
  0x01F0,
  0x03F0,
  0x07F0
},
{ // GN_NW_E or GN_E_NW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7E00,
  0x3FF0,
  0x1FF0,
  0x0FF0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0FF0,
  0x0FF0,
  0x07F0,
  0x81F0,
  0xC000,
  0xE000,
  0xF000,
  0xF800,
  0xFF00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x0FF0,
  0x07F0,
  0x01F0,
  0x4000,
  0x6000,
  0x7000,
  0x7800,
  0x7F00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GN_NW_NE or GN_NE_NW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xE070,
  0xF0F0,
  0xF9F0,
  0x7FE0,
  0x3FC0,
  0x1F80,
  0x0F00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0F80,
  0x0F00,
  0x0600,
  0x8000,
  0xC000,
  0xE010,
  0xF030,
  0xF870,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x0F00,
  0x0600,
  0x0000,
  0x4000,
  0x6010,
  0x7030,
  0x7870,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GN_NW_SE or GN_SE_NW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3E00,
  0x1F00,
  0x0F80,
  0x07C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0x1FF0,
  0x0FF0,
  0x07F0,
  0x03F0,
  0x81F0,
  0xC0F0,
  0xE070,
  0xF030,
  0xF810,
  0xFC00,
  0xFE00,
  0xFF00,
  /* Plane 3 */
  0x0000,
  0x0FF0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x40F0,
  0x6070,
  0x7030,
  0x7810,
  0x7C00,
  0x7E00,
  0x7F00
},
{ // GN_NW_SW or GN_SW_NW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0x1FF0,
  0x0FF0,
  0x07F0,
  0x03F0,
  0xC1F0,
  0xE0F0,
  0xE0F0,
  0xC0F0,
  0x80F0,
  0x01F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0x0000,
  0x0FF0,
  0x07F0,
  0x03F0,
  0x41F0,
  0x60F0,
  0x60F0,
  0x40F0,
  0x00F0,
  0x01F0,
  0x03F0,
  0x07F0
},
{ // GN_N_E or GN_E_N
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x07F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF000,
  0xF000,
  0xF000,
  0xF800,
  0xFC00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x7000,
  0x7000,
  0x7000,
  0x7800,
  0x7C00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GN_N_NE or GN_NE_N
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F70,
  0x0F70,
  0x0F70,
  0x0FF0,
  0x0FF0,
  0x07C0,
  0x0380,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF800,
  0xFC10,
  0xFE30,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7000,
  0x7000,
  0x7000,
  0x7000,
  0x7800,
  0x7C10,
  0x7E30,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GN_N_NW or GN_NW_N
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xEF00,
  0xEF00,
  0xEF00,
  0xFF00,
  0xFF00,
  0x3E00,
  0x1C00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0xE0F0,
  0xF1F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x60F0,
  0x71F0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GN_N_S or GN_S_N
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070
},
{ // GN_N_SE or GN_SE_N
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0780,
  0x0780,
  0x07C0,
  0x03C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF870,
  0xF830,
  0xF830,
  0xFC10,
  0xFC10,
  0xFE00,
  0xFF00,
  0xFF80,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x7870,
  0x7830,
  0x7830,
  0x7C10,
  0x7C10,
  0x7E00,
  0x7F00,
  0x7F80
},
{ // GN_N_SW or GN_SW_N
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x3C00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xE070,
  0xE0F0,
  0xC0F0,
  0xC0F0,
  0x81F0,
  0x01F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x6070,
  0x60F0,
  0x40F0,
  0x40F0,
  0x01F0,
  0x01F0,
  0x03F0,
  0x07F0
},
{ // GN_N_W or GN_W_N
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0xFF00,
  0xFF00,
  0xFF00,
  0xFE00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x00F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x00F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GN_SW_E or GN_E_SW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x0FF0,
  0x1FF0,
  0x3FF0,
  0x7E00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFE00,
  0xF000,
  0xE000,
  0xC000,
  0x8000,
  0x00F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7E00,
  0x7000,
  0x6000,
  0x4000,
  0x0000,
  0x00F0,
  0x03F0,
  0x07F0
},
{ // GN_SW_SE or GN_SE_SW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0F00,
  0x1F80,
  0x3FC0,
  0x7FE0,
  0xF9F0,
  0xF0F0,
  0xE070,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF0F0,
  0xE070,
  0xC030,
  0x8010,
  0x0000,
  0x0300,
  0x0780,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x70F0,
  0x6070,
  0x4030,
  0x0010,
  0x0000,
  0x0300,
  0x0780
},
{ // GN_S_NE or GN_NE_S
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x03C0,
  0x07C0,
  0x0780,
  0x0780,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xFC00,
  0xFC00,
  0xF810,
  0xF810,
  0xF830,
  0xF030,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7C00,
  0x7C00,
  0x7810,
  0x7810,
  0x7830,
  0x7030,
  0x7070,
  0x7070,
  0x7070
},
{ // GN_S_NW or GN_NW_S
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0x1FF0,
  0x0FF0,
  0x07F0,
  0x03F0,
  0xC1F0,
  0xC1F0,
  0xE0F0,
  0xE0F0,
  0xF0F0,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0000,
  0x0FF0,
  0x07F0,
  0x03F0,
  0x41F0,
  0x41F0,
  0x60F0,
  0x60F0,
  0x70F0,
  0x7070,
  0x7070,
  0x7070
},
{ // GN_S_SE or GN_SE_S
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0380,
  0x07C0,
  0x0FF0,
  0x0FF0,
  0x0F70,
  0x0F70,
  0x0F70,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFC70,
  0xF830,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7C70,
  0x7830,
  0x7000,
  0x7000,
  0x7000,
  0x7000,
  0x7000
},
{ // GN_S_SW or GN_SW_S
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x1C00,
  0x3E00,
  0xFF00,
  0xFF00,
  0xEF00,
  0xEF00,
  0xEF00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xE3F0,
  0xC1F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x63F0,
  0x41F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0x0070
},
{ // GN_W_E or GN_E_W
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GN_W_NE or GN_NE_W
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x07E0,
  0xFFC0,
  0xFF80,
  0xFF00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xF800,
  0x0000,
  0x0010,
  0x0030,
  0x0070,
  0x03F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7800,
  0x0000,
  0x0010,
  0x0030,
  0x0070,
  0x03F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GN_W_NW or GN_NW_W
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xF800,
  0xF800,
  0xFC00,
  0x1E00,
  0xFE00,
  0xFE00,
  0xFC00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x03F0,
  0x03F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x03F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GN_W_S or GN_S_W
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFE00,
  0xFF00,
  0xFF00,
  0xFF00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x01F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x01F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0x7070,
  0x7070,
  0x7070
},
{ // GN_W_SE or GN_SE_W
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFF00,
  0xFF80,
  0xFFC0,
  0x07E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x07F0,
  0x00F0,
  0x0070,
  0x0030,
  0x0010,
  0xFE00,
  0xFF00,
  0xFF80,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x07F0,
  0x00F0,
  0x0070,
  0x0030,
  0x0010,
  0x7E00,
  0x7F00,
  0x7F80
},
{ // GN_W_SW or GN_SW_W
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFC00,
  0xFE00,
  0xFE00,
  0x1E00,
  0xFC00,
  0xF800,
  0xF800,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0
},
{ 0, // Green Tail
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 2 */
  65520,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  /* Plane 3 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0
},
{ // GG_NE_E or GG_E_NE
  0x01F0,
  0x01F0,
  0x03F0,
  0x0780,
  0x07F0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x01F0,
  0x01F0,
  0x03F0,
  0x0780,
  0x07F0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF80,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7E00,
  0x7C00,
  0x7800,
  0x7800,
  0x7800,
  0x7C00,
  0x7E00,
  0x7F00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GG_S_E or GG_E_S
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x07F0,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x07F0,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF00,
  0xFF70,
  0xFF70,
  0xFF70,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7800,
  0x7000,
  0x7000,
  0x7000,
  0x7000,
  0x7070,
  0x7070,
  0x7070
},
{ // GG_SE_E or GG_E_SE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x03F0,
  0x07F0,
  0x07F0,
  0x0780,
  0x03F0,
  0x01F0,
  0x01F0,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x03F0,
  0x07F0,
  0x07F0,
  0x0780,
  0x03F0,
  0x01F0,
  0x01F0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF80,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7E00,
  0x7C00,
  0x7800,
  0x7800,
  0x7800,
  0x7C00,
  0x7E00,
  0x7E00
},
{ // GG_NE_SE or GG_SE_NE
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0780,
  0x0780,
  0x07C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0780,
  0x0780,
  0x07C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFE0,
  0xFFC0,
  0xFF90,
  0xFFB0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7C00,
  0x7800,
  0x7810,
  0x7830,
  0x7830,
  0x7C10,
  0x7E00,
  0x7F00,
  0x7F80
},
{ // GG_SW_NE or GG_NE_SW
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0F80,
  0x1F00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0F80,
  0x1F00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFE0,
  0xFFC0,
  0xFF90,
  0xFF30,
  0xFE70,
  0xFCF0,
  0xF9F0,
  0xF3F0,
  0xE7F0,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7C00,
  0x7800,
  0x7010,
  0x6030,
  0x4070,
  0x00F0,
  0x01F0,
  0x03F0,
  0x07F0
},
{ // GG_NW_E or GG_E_NW
  0xE000,
  0xF000,
  0xF800,
  0x7E00,
  0x3FF0,
  0x1FF0,
  0x0FF0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7E00,
  0x3FF0,
  0x1FF0,
  0x0FF0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xEFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF9F0,
  0xFF00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x0FF0,
  0x07F0,
  0x01F0,
  0x4000,
  0x6000,
  0x7000,
  0x7800,
  0x7F00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GG_NW_NE or GG_NE_NW
  0xE070,
  0xF0F0,
  0xF9F0,
  0x7FE0,
  0x3FC0,
  0x1F80,
  0x0F00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xE070,
  0xF0F0,
  0xF9F0,
  0x7FE0,
  0x3FC0,
  0x1F80,
  0x0F00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xEFF0,
  0xFFF0,
  0xFFF0,
  0xFFE0,
  0xFFC0,
  0xFF90,
  0xFF30,
  0xF870,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x0F00,
  0x0600,
  0x0000,
  0x4000,
  0x6010,
  0x7030,
  0x7870,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GG_NW_SE or GG_SE_NW
  57344,
  61440,
  63488,
  31744,
  15872,
  7936,
  3968,
  1984,
  992,
  496,
  240,
  112,
  /* Plane 1 */
  57344,
  61440,
  63488,
  31744,
  15872,
  7936,
  3968,
  1984,
  992,
  496,
  240,
  112,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  4080,
  2032,
  1008,
  16880,
  24816,
  28784,
  30768,
  31760,
  32256,
  32512,
  32640
},
{ // GG_NW_SW or GG_SW_NW
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x7FF0,
  0xFFF0,
  0xFEF0,
  0xFEF0,
  0xFEF0,
  0xFCF0,
  0xF9F0,
  0xF3F0,
  0xE7F0,
  /* Plane 3 */
  0x0000,
  0x0FF0,
  0x07F0,
  0x03F0,
  0x41F0,
  0x60F0,
  0x60F0,
  0x40F0,
  0x00F0,
  0x01F0,
  0x03F0,
  0x07F0
},
{ // GG_N_E or GG_E_N
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x07F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x07F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFC00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x7000,
  0x7000,
  0x7000,
  0x7800,
  0x7C00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GG_N_NE or GG_NE_N
  0x0F70,
  0x0F70,
  0x0F70,
  0x0FF0,
  0x0FF0,
  0x07C0,
  0x0380,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F70,
  0x0F70,
  0x0F70,
  0x0FF0,
  0x0FF0,
  0x07C0,
  0x0380,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF70,
  0xFF70,
  0xFF70,
  0xFFF0,
  0xFFF0,
  0xFFC0,
  0xFF90,
  0xFE30,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7000,
  0x7000,
  0x7000,
  0x7000,
  0x7800,
  0x7C10,
  0x7E30,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GG_N_NW or GG_NW_N
  0xEF00,
  0xEF00,
  0xEF00,
  0xFF00,
  0xFF00,
  0x3E00,
  0x1C00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xEF00,
  0xEF00,
  0xEF00,
  0xFF00,
  0xFF00,
  0x3E00,
  0x1C00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xEF70,
  0xEF70,
  0xEF70,
  0xFF70,
  0xFF70,
  0x3E70,
  0xFCF0,
  0xF1F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x60F0,
  0x71F0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GG_N_S or GG_S_N
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070
},
{ // GG_SE_N or GG_N_SE
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0780,
  0x0780,
  0x07C0,
  0x03C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0780,
  0x0780,
  0x07C0,
  0x03C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFFF0,
  0xFFB0,
  0xFFF0,
  0xFFD0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x7870,
  0x7830,
  0x7830,
  0x7C10,
  0x7C10,
  0x7E00,
  0x7F00,
  0x7F80
},
{ // GG_SW_N or GG_N_SW
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x3C00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x3C00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFE70,
  0xFEF0,
  0xFEF0,
  0xFCF0,
  0xFDF0,
  0xF9F0,
  0xF3F0,
  0xE7F0,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x6070,
  0x60F0,
  0x40F0,
  0x40F0,
  0x01F0,
  0x01F0,
  0x03F0,
  0x07F0
},
{ // GG_W_N or GG_N_W
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0xFF00,
  0xFF00,
  0xFF00,
  0xFE00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0xFF00,
  0xFF00,
  0xFF00,
  0xFE00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFE70,
  0x00F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x00F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GG_SW_E or GG_E_SW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x0FF0,
  0x1FF0,
  0x3FF0,
  0x7E00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x0FF0,
  0x1FF0,
  0x3FF0,
  0x7E00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFE00,
  0xF8F0,
  0xF3F0,
  0xE7F0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7E00,
  0x7000,
  0x6000,
  0x4000,
  0x0000,
  0x00F0,
  0x03F0,
  0x07F0
},
{ // GG_SW_SE or GG_SE_SW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0F00,
  0x1F80,
  0x3FC0,
  0x7FE0,
  0xF9F0,
  0xF0F0,
  0xE070,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0F00,
  0x1F80,
  0x3FC0,
  0x7FE0,
  0xF9F0,
  0xF0F0,
  0xE070,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF9F0,
  0xF3F0,
  0xE7F0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x70F0,
  0x6070,
  0x4030,
  0x0010,
  0x0000,
  0x0300,
  0x0780
},
{ // GG_NE_S or GG_S_NE
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x03C0,
  0x07C0,
  0x0780,
  0x0780,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x03C0,
  0x07C0,
  0x0780,
  0x0780,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFE0,
  0xFFC0,
  0xFFD0,
  0xFF90,
  0xFFB0,
  0xFF30,
  0xFF70,
  0xFF70,
  0xFF70,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7C00,
  0x7C00,
  0x7810,
  0x7810,
  0x7830,
  0x7030,
  0x7070,
  0x7070,
  0x7070
},
{ // GG_NW_S or GG_S_NW
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x7FF0,
  0xFDF0,
  0xFFF0,
  0xFEF0,
  0xFEF0,
  0xFFF0,
  0xFF70,
  0xFF70,
  0xFF70,
  /* Plane 3 */
  0x0000,
  0x0FF0,
  0x07F0,
  0x03F0,
  0x41F0,
  0x41F0,
  0x60F0,
  0x60F0,
  0x70F0,
  0x7070,
  0x7070,
  0x7070
},
{ // GG_S_SE or GG_SE_S
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0380,
  0x07C0,
  0x0FF0,
  0x0FF0,
  0x0F70,
  0x0F70,
  0x0F70,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0380,
  0x07C0,
  0x0FF0,
  0x0FF0,
  0x0F70,
  0x0F70,
  0x0F70,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF70,
  0xFF70,
  0xFF70,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7C70,
  0x7830,
  0x7000,
  0x7000,
  0x7000,
  0x7000,
  0x7000
},
{ // GG_S_SW or GG_SW_S
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x1C00,
  0x3E00,
  0xFF00,
  0xFF00,
  0xEF00,
  0xEF00,
  0xEF00,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x1C00,
  0x3E00,
  0xFF00,
  0xFF00,
  0xEF00,
  0xEF00,
  0xEF00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF70,
  0xEF70,
  0xEF70,
  0xEF70,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x63F0,
  0x41F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0x0070
},
{ // GG_W_E or GG_E_W
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GG_NE_W or GG_W_NE
  0x0070,
  0x00F0,
  0x01F0,
  0x07E0,
  0xFFC0,
  0xFF80,
  0xFF00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x07E0,
  0xFFC0,
  0xFF80,
  0xFF00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFE0,
  0xFFC0,
  0xFF90,
  0xFF30,
  0xF870,
  0x03F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7800,
  0x0000,
  0x0010,
  0x0030,
  0x0070,
  0x03F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GG_NW_W or GG_W_NW
  0xF800,
  0xF800,
  0xFC00,
  0x1E00,
  0xFE00,
  0xFE00,
  0xFC00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xF800,
  0xF800,
  0xFC00,
  0x1E00,
  0xFE00,
  0xFE00,
  0xFC00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFBF0,
  0xFBF0,
  0xFFF0,
  0x1FF0,
  0xFEF0,
  0xFEF0,
  0xFCF0,
  0xF9F0,
  0x03F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x03F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // GG_W_S or GG_S_W
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFE00,
  0xFF00,
  0xFF00,
  0xFF00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFE00,
  0xFF00,
  0xFF00,
  0xFF00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF70,
  0xFF70,
  0x0F70,
  0xFF70,
  0xFF70,
  0xFF70,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x01F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0x7070,
  0x7070,
  0x7070
},
{ // GG_SE_W or GG_W_SE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFF00,
  0xFF80,
  0xFFC0,
  0x07E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFF00,
  0xFF80,
  0xFFC0,
  0x07E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x07F0,
  0xFDF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x07F0,
  0x00F0,
  0x0070,
  0x0030,
  0x0010,
  0x7C00,
  0x7F00,
  0x7F80
},
{ // GG_SW_W or GG_W_SW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFC00,
  0xFE00,
  0xFE00,
  0x1E00,
  0xFC00,
  0xF800,
  0xF800,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFC00,
  0xFE00,
  0xFE00,
  0x1E00,
  0xFC00,
  0xF800,
  0xF800,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFEF0,
  0x1EF0,
  0xFCF0,
  0xF9F0,
  0xFBF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0
},
{ 0, // Green Glow
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 1 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0
},
{ // RN_E_NE or RN_NE_E
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFE00,
  0xFE00,
  0xFC00,
  0xF800,
  0xF800,
  0xF800,
  0xFC00,
  0xFE00,
  0xFF00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x01F0,
  0x7FF0,
  0x7FF0,
  0x7F80,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7F00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RN_E_S or RN_S_E
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF800,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7F00,
  0x7F70,
  0x7F70,
  0x7F70
},
{ // RN_E_SE or RN_SE_E
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFE00,
  0xFC00,
  0xF800,
  0xF800,
  0xF800,
  0xFC00,
  0xFE00,
  0xFE00,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7F80,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RN_NE_SE or RN_SE_NE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xFC00,
  0xF800,
  0xF810,
  0xF830,
  0xF830,
  0xFC10,
  0xFE00,
  0xFF00,
  0xFF80,
  /* Plane 3 */
  0x0070,
  0x7FF0,
  0x7FF0,
  0x7FE0,
  0x7FC0,
  0x7F90,
  0x7FB0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RN_NE_SW or RN_SW_NE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xFC00,
  0xF800,
  0xF010,
  0xE030,
  0xC070,
  0x80F0,
  0x01F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0x0070,
  0x7FF0,
  0x7FF0,
  0x7FE0,
  0x7FC0,
  0x7F90,
  0x7F30,
  0x7E70,
  0x7CF0,
  0xF9F0,
  0xF3F0,
  0xE7F0
},
{ // RN_NW_E or RN_E_NW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0FF0,
  0x0FF0,
  0x07F0,
  0x81F0,
  0xC000,
  0xE000,
  0xF000,
  0xF800,
  0xFF00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xE000,
  0xFFF0,
  0xFFF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x79F0,
  0x7F00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RN_NW_NE or RN_NE_NW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0F80,
  0x0F00,
  0x0600,
  0x8000,
  0xC000,
  0xE010,
  0xF030,
  0xF870,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xE070,
  0xFFF0,
  0xFFF0,
  0x7FE0,
  0x7FC0,
  0x7F90,
  0x7F30,
  0x7870,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RN_NW_SE or RN_SE_NW
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x1FF0,
  0x0FF0,
  0x07F0,
  0x03F0,
  0x81F0,
  0xC0F0,
  0xE070,
  0xF030,
  0xF810,
  0xFC00,
  0xFE00,
  0xFF00,
  /* Plane 3 */
  0xE00F,
  0xFFFF,
  0xFFFF,
  0x7FFF,
  0x3FFF,
  0x5FFF,
  0x6FFF,
  0x77FF,
  0x7BFF,
  0x7DFF,
  0x7EFF,
  0x7F7F
},
{ // RN_NW_SW OR RN_SW_NW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x1FF0,
  0x0FF0,
  0x07F0,
  0x03F0,
  0xC1F0,
  0xE0F0,
  0xE0F0,
  0xC0F0,
  0x80F0,
  0x01F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0xE000,
  0xFFF0,
  0xFFF0,
  0x7FF0,
  0x7FF0,
  0x7EF0,
  0x7EF0,
  0x7EF0,
  0x7CF0,
  0xF9F0,
  0xF3F0,
  0xE7F0
},
{ // RN_N_E or RN_E_N
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF000,
  0xF000,
  0xF000,
  0xF800,
  0xFC00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0F00,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7C00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RN_N_NE or RN_NE_N
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF800,
  0xFC10,
  0xFE30,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0F70,
  0x7F70,
  0x7F70,
  0x7FF0,
  0x7FF0,
  0x7FC0,
  0x7F90,
  0x7E30,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RN_N_NW or RN_NW_N
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0xE0F0,
  0xF1F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xEF00,
  0xEF70,
  0xEF70,
  0xFF70,
  0xFF70,
  0x3E70,
  0x7CF0,
  0x71F0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RN_N_S or RN_S_N
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0F00,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70
},
{ // RN_N_SE or RN_SE_N
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF870,
  0xF830,
  0xF830,
  0xFC10,
  0xFC10,
  0xFE00,
  0xFF00,
  0xFF80,
  /* Plane 3 */
  0x0F00,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7FF0,
  0x7FB0,
  0x7FF0,
  0x7FD0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RN_SW_N or RN_N_SW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xE070,
  0xE0F0,
  0xC0F0,
  0xC0F0,
  0x81F0,
  0x01F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0x0F00,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7E70,
  0x7EF0,
  0x7EF0,
  0x7CF0,
  0x7DF0,
  0xF9F0,
  0xF3F0,
  0xE7F0
},
{ // RN_N_W or RN_W_N
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x00F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0F00,
  0x7F70,
  0x7F70,
  0x7F70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFE70,
  0x00F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RN_SW_E or RN_E_SW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFE00,
  0xF000,
  0xE000,
  0xC000,
  0x8000,
  0x00F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7E00,
  0xF8F0,
  0xF3F0,
  0xE7F0
},
{ // RN_SW_SE or RN_SE_SW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF0F0,
  0xE070,
  0xC030,
  0x8010,
  0x0000,
  0x0300,
  0x0780,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0xF9F0,
  0xF3F0,
  0xE7F0
},
{ // RN_S_NE or RN_NE_S
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xFC00,
  0xFC00,
  0xF810,
  0xF810,
  0xF830,
  0xF030,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0070,
  0x7FF0,
  0x7FF0,
  0x7FE0,
  0x7FC0,
  0x7FD0,
  0x7F90,
  0x7FB0,
  0x7F30,
  0x7F70,
  0x7F70,
  0x7F70
},
{ // RN_NW_S or RN_S_NW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x1FF0,
  0x0FF0,
  0x07F0,
  0x03F0,
  0xC1F0,
  0xC1F0,
  0xE0F0,
  0xE0F0,
  0xF0F0,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0xE000,
  0xFFF0,
  0xFFF0,
  0x7FF0,
  0x7DF0,
  0x7FF0,
  0x7EF0,
  0x7EF0,
  0x7FF0,
  0x7F70,
  0x7F70,
  0x7F70
},
{ // RN_SE_S or RN_S_SE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFC70,
  0xF830,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7F70,
  0x7F70,
  0x7F70
},
{ // RN_SW_S or RN_S_SW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xE3F0,
  0xC1F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0xFFF0,
  0xFF70,
  0xEF70,
  0xEF70,
  0xEF70
},
{ // RN_W_E or RN_E_W
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RN_W_NE or RN_NE_W
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xF800,
  0x0000,
  0x0010,
  0x0030,
  0x0070,
  0x03F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0070,
  0x7FF0,
  0x7FF0,
  0x7FE0,
  0xFFC0,
  0xFF90,
  0xFF30,
  0xF870,
  0x03F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RN_W_NW or RN_NW_W
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x03F0,
  0x03F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xF800,
  0xFBF0,
  0xFFF0,
  0x1FF0,
  0xFEF0,
  0xFEF0,
  0xFCF0,
  0xF9F0,
  0x03F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RN_W_S or RN_S_W
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x01F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0xFFF0,
  0xFFF0,
  0xFF70,
  0xFF70,
  0x0F70,
  0x7F70,
  0x7F70,
  0x7F70
},
{ // RN_W_SE or RN_SE_W
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x07F0,
  0x00F0,
  0x0070,
  0x0030,
  0x0010,
  0xFE00,
  0xFF00,
  0xFF80,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x07F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RN_W_SW or RN_SW_W
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFEF0,
  0x1EF0,
  0xFCF0,
  0xF9F0,
  0xFBF0
},
{ // Red Tail
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // RG_NE_E or RG_E_NE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x01F0,
  0x01F0,
  0x03F0,
  0x0780,
  0x07F0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFE00,
  0xFE00,
  0xFC00,
  0xF800,
  0xF800,
  0xF800,
  0xFC00,
  0xFE00,
  0xFF00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x01F0,
  0x7FF0,
  0x7FF0,
  0x7F80,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7F00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RG_E_S or RG_S_E
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x07F0,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF800,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7F00,
  0x7F70,
  0x7F70,
  0x7F70
},
{ // RG_SE_E or RG_E_SE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x03F0,
  0x07F0,
  0x07F0,
  0x0780,
  0x03F0,
  0x01F0,
  0x01F0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFE00,
  0xFC00,
  0xF800,
  0xF800,
  0xF800,
  0xFC00,
  0xFE00,
  0xFE00,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7F80,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RG_NE_SE or RG_SE_NE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0780,
  0x0780,
  0x07C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xFC00,
  0xF800,
  0xF810,
  0xF830,
  0xF830,
  0xFC10,
  0xFE00,
  0xFF00,
  0xFF80,
  /* Plane 3 */
  0x0070,
  0x7FF0,
  0x7FF0,
  0x7FE0,
  0x7FC0,
  0x7F90,
  0x7FB0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RG_NE_SW or RG_SW_NE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0F80,
  0x1F00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xFC00,
  0xF800,
  0xF010,
  0xE030,
  0xC070,
  0x80F0,
  0x01F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0x0070,
  0x7FF0,
  0x7FF0,
  0x7FE0,
  0x7FC0,
  0x7F90,
  0x7F30,
  0x7E70,
  0x7CF0,
  0xF9F0,
  0xF3F0,
  0xE7F0
},
{ // RG_NW_E or RG_E_NW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7E00,
  0x3FF0,
  0x1FF0,
  0x0FF0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0FF0,
  0x0FF0,
  0x07F0,
  0x81F0,
  0xC000,
  0xE000,
  0xF000,
  0xF800,
  0xFF00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xE000,
  0xFFF0,
  0xFFF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x79F0,
  0x7F00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RG_NW_NE or RG_NE_NW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xE070,
  0xF0F0,
  0xF9F0,
  0x7FE0,
  0x3FC0,
  0x1F80,
  0x0F00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0F80,
  0x0F00,
  0x0600,
  0x8000,
  0xC000,
  0xE010,
  0xF030,
  0xF870,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xE070,
  0xFFF0,
  0xFFF0,
  0x7FE0,
  0x7FC0,
  0x7F90,
  0x7F30,
  0x7870,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RG_NW_SE or RG_SE_NW
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3E00,
  0x1F00,
  0x0F80,
  0x07C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0x1FF0,
  0x0FF0,
  0x07F0,
  0x03F0,
  0x81F0,
  0xC0F0,
  0xE070,
  0xF030,
  0xF810,
  0xFC00,
  0xFE00,
  0xFF00,
  /* Plane 3 */
  0xE00F,
  0xFFFF,
  0xFFFF,
  0x7FFF,
  0x3FFF,
  0x5FFF,
  0x6FFF,
  0x77FF,
  0x7BFF,
  0x7DFF,
  0x7EFF,
  0x7F7F
},
{ // RG_NW_SW or RG_SW_NW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0x1FF0,
  0x0FF0,
  0x07F0,
  0x03F0,
  0xC1F0,
  0xE0F0,
  0xE0F0,
  0xC0F0,
  0x80F0,
  0x01F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0xE000,
  0xFFF0,
  0xFFF0,
  0x7FF0,
  0x7FF0,
  0x7EF0,
  0x7EF0,
  0x7EF0,
  0x7CF0,
  0xF9F0,
  0xF3F0,
  0xE7F0
},
{ // RG_N_E or RG_E_N
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x07F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF000,
  0xF000,
  0xF000,
  0xF800,
  0xFC00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0F00,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7C00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RG_NE_N or RG_N_NE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F70,
  0x0F70,
  0x0F70,
  0x0FF0,
  0x0FF0,
  0x07C0,
  0x0380,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF800,
  0xFC10,
  0xFE30,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0F70,
  0x7F70,
  0x7F70,
  0x7FF0,
  0x7FF0,
  0x7FC0,
  0x7F90,
  0x7E30,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RG_NW_N or RG_N_NW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xEF00,
  0xEF00,
  0xEF00,
  0xFF00,
  0xFF00,
  0x3E00,
  0x1C00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0xE0F0,
  0xF1F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xEF00,
  0xEF70,
  0xEF70,
  0xFF70,
  0xFF70,
  0x3E70,
  0x7CF0,
  0x71F0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RG_N_S or RG_S_N
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0F00,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70
},
{ // RG_N_SE or RG_SE_N
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0780,
  0x0780,
  0x07C0,
  0x03C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF870,
  0xF830,
  0xF830,
  0xFC10,
  0xFC10,
  0xFE00,
  0xFF00,
  0xFF80,
  /* Plane 3 */
  0x0F00,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7FF0,
  0x7FB0,
  0x7FF0,
  0x7FD0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RG_N_SW or RG_SW_N
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x3C00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xE070,
  0xE0F0,
  0xC0F0,
  0xC0F0,
  0x81F0,
  0x01F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0x0F00,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7E70,
  0x7EF0,
  0x7EF0,
  0x7CF0,
  0x7DF0,
  0xF9F0,
  0xF3F0,
  0xE7F0
},
{ // RG_N_W or RG_W_N
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0xFF00,
  0xFF00,
  0xFF00,
  0xFE00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x00F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0F00,
  0x7F70,
  0x7F70,
  0x7F70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFE70,
  0x00F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RG_E_SW or RG_SW_E
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x0FF0,
  0x1FF0,
  0x3FF0,
  0x7E00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFE00,
  0xF000,
  0xE000,
  0xC000,
  0x8000,
  0x00F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7E00,
  0xF8F0,
  0xF3F0,
  0xE7F0
},
{ // RG_SW_SE or RG_SE_SW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0F00,
  0x1F80,
  0x3FC0,
  0x7FE0,
  0xF9F0,
  0xF0F0,
  0xE070,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF0F0,
  0xE070,
  0xC030,
  0x8010,
  0x0000,
  0x0300,
  0x0780,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0xF9F0,
  0xF3F0,
  0xE7F0
},
{ // RG_NE_S or RG_S_NE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x03C0,
  0x07C0,
  0x0780,
  0x0780,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xFC00,
  0xFC00,
  0xF810,
  0xF810,
  0xF830,
  0xF030,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0070,
  0x7FF0,
  0x7FF0,
  0x7FE0,
  0x7FC0,
  0x7FD0,
  0x7F90,
  0x7FB0,
  0x7F30,
  0x7F70,
  0x7F70,
  0x7F70
},
{ // RG_NW_S or RG_S_NW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0x1FF0,
  0x0FF0,
  0x07F0,
  0x03F0,
  0xC1F0,
  0xC1F0,
  0xE0F0,
  0xE0F0,
  0xF0F0,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0xE000,
  0xFFF0,
  0xFFF0,
  0x7FF0,
  0x7DF0,
  0x7FF0,
  0x7EF0,
  0x7EF0,
  0x7FF0,
  0x7F70,
  0x7F70,
  0x7F70
},
{ // RG_SE_S or RG_S_SE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0380,
  0x07C0,
  0x0FF0,
  0x0FF0,
  0x0F70,
  0x0F70,
  0x0F70,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFC70,
  0xF830,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7F70,
  0x7F70,
  0x7F70
},
{ // RG_SW_S or RG_S_SW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x1C00,
  0x3E00,
  0xFF00,
  0xFF00,
  0xEF00,
  0xEF00,
  0xEF00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xE3F0,
  0xC1F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0xFFF0,
  0xFF70,
  0xEF70,
  0xEF70,
  0xEF70
},
{ // RG_W_E or RG_E_W
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RG_NE_W or RG_W_NE
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x07E0,
  0xFFC0,
  0xFF80,
  0xFF00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xF800,
  0x0000,
  0x0010,
  0x0030,
  0x0070,
  0x03F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0070,
  0x7FF0,
  0x7FF0,
  0x7FE0,
  0xFFC0,
  0xFF90,
  0xFF30,
  0xF870,
  0x03F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RG_NW_W or RG_W_NW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xF800,
  0xF800,
  0xFC00,
  0x1E00,
  0xFE00,
  0xFE00,
  0xFC00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x03F0,
  0x03F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xF800,
  0xFBF0,
  0xFFF0,
  0x1FF0,
  0xFEF0,
  0xFEF0,
  0xFCF0,
  0xF9F0,
  0x03F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // RG_W_S or RG_S_W
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFE00,
  0xFF00,
  0xFF00,
  0xFF00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x01F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0xFFF0,
  0xFFF0,
  0xFF70,
  0xFF70,
  0x0F70,
  0x7F70,
  0x7F70,
  0x7F70
},
{ // RG_W_SE or RG_SE_W
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFF00,
  0xFF80,
  0xFFC0,
  0x07E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x07F0,
  0x00F0,
  0x0070,
  0x0030,
  0x0010,
  0xFC00,
  0xFF00,
  0xFF80,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x07F0,
  0x7DF0,
  0x7FF0,
  0x7FF0
},
{ // RG_SW_W or RG_W_SW
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFC00,
  0xFE00,
  0xFE00,
  0x1E00,
  0xFC00,
  0xF800,
  0xF800,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFEF0,
  0x1EF0,
  0xFCF0,
  0xF9F0,
  0xFBF0
},
{ // Red Glow
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 2 */
  65520,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ // bn_e_ne.c
  0x01F0,
  0x01F0,
  0x03F0,
  0x0780,
  0x07F0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF80,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7E00,
  0x7C00,
  0x7800,
  0x7800,
  0x7800,
  0x7C00,
  0x7E00,
  0x7F00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // bn_e_s.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x07F0,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF00,
  0xFF70,
  0xFF70,
  0xFF70,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7800,
  0x7000,
  0x7000,
  0x7000,
  0x7000,
  0x7070,
  0x7070,
  0x7070
},
{ // bn_e_se.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x03F0,
  0x07F0,
  0x07F0,
  0x0780,
  0x03F0,
  0x01F0,
  0x01F0,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF80,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7E00,
  0x7C00,
  0x7800,
  0x7800,
  0x7800,
  0x7C00,
  0x7E00,
  0x7E00
},
{ // bn_ne_se.c
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0780,
  0x0780,
  0x07C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFE0,
  0xFFC0,
  0xFF90,
  0xFFB0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7C00,
  0x7800,
  0x7810,
  0x7830,
  0x7830,
  0x7C10,
  0x7E00,
  0x7F00,
  0x7F80
},
{ // bn_ne_sw.c
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0F80,
  0x1F00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFE0,
  0xFFC0,
  0xFF90,
  0xFF30,
  0xFE70,
  0xFCF0,
  0xF9F0,
  0xF3F0,
  0xE7F0,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7C00,
  0x7800,
  0x7010,
  0x6030,
  0x4070,
  0x00F0,
  0x01F0,
  0x03F0,
  0x07F0
},
{ // bn_nw_e.c
  0xE000,
  0xF000,
  0xF800,
  0x7E00,
  0x3FF0,
  0x1FF0,
  0x0FF0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xEFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF9F0,
  0xFF00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x0FF0,
  0x07F0,
  0x01F0,
  0x4000,
  0x6000,
  0x7000,
  0x7800,
  0x7F00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // bn_nw_ne.c
  0xE070,
  0xF0F0,
  0xF9F0,
  0x7FE0,
  0x3FC0,
  0x1F80,
  0x0F00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xEFF0,
  0xFFF0,
  0xFFF0,
  0xFFE0,
  0xFFC0,
  0xFF90,
  0xFF30,
  0xF870,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x0F00,
  0x0600,
  0x0000,
  0x4000,
  0x6010,
  0x7030,
  0x7870,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // bn_nw_se.c
  0xE00F,
  0xF00F,
  0xF80F,
  0x7C0F,
  0x3E0F,
  0x1F0F,
  0x0F8F,
  0x07CF,
  0x03EF,
  0x01FF,
  0x00FF,
  0x007F,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x7FF0,
  0xBFF0,
  0xDFF0,
  0xEFF0,
  0xF7F0,
  0xFBF0,
  0xFDF0,
  0xFEF0,
  0xFF70,
  /* Plane 3 */
  0x000F,
  0x0FFF,
  0x07FF,
  0x03FF,
  0x01FF,
  0x40FF,
  0x607F,
  0x703F,
  0x781F,
  0x7C0F,
  0x7E0F,
  0x7F0F
},
{ // bn_nw_sw.c
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x7FF0,
  0xFFF0,
  0xFEF0,
  0xFEF0,
  0xFEF0,
  0xFCF0,
  0xF9F0,
  0xF3F0,
  0xE7F0,
  /* Plane 3 */
  0x0000,
  0x0FF0,
  0x07F0,
  0x03F0,
  0x41F0,
  0x60F0,
  0x60F0,
  0x40F0,
  0x00F0,
  0x01F0,
  0x03F0,
  0x07F0
},
{ // bn_n_e.c
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x07F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFC00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x7000,
  0x7000,
  0x7000,
  0x7800,
  0x7C00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // bn_n_ne.c
  0x0F70,
  0x0F70,
  0x0F70,
  0x0FF0,
  0x0FF0,
  0x07C0,
  0x0380,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF70,
  0xFF70,
  0xFF70,
  0xFFF0,
  0xFFF0,
  0xFFC0,
  0xFF90,
  0xFE30,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7000,
  0x7000,
  0x7000,
  0x7000,
  0x7800,
  0x7C10,
  0x7E30,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // bn_n_nw.c
  0xEF00,
  0xEF00,
  0xEF00,
  0xFF00,
  0xFF00,
  0x3E00,
  0x1C00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xEF70,
  0xEF70,
  0xEF70,
  0xFF70,
  0xFF70,
  0x3E70,
  0xFCF0,
  0xF1F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x60F0,
  0x71F0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // bn_n_s.c
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070
},
{ // bn_n_se.c
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0780,
  0x0780,
  0x07C0,
  0x03C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFFF0,
  0xFFB0,
  0xFFF0,
  0xFFD0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x7870,
  0x7830,
  0x7830,
  0x7C10,
  0x7C10,
  0x7E00,
  0x7F00,
  0x7F80
},
{ // bn_n_sw.c
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x3C00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFE70,
  0xFEF0,
  0xFEF0,
  0xFCF0,
  0xFDF0,
  0xF9F0,
  0xF3F0,
  0xE7F0,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x6070,
  0x60F0,
  0x40F0,
  0x40F0,
  0x01F0,
  0x01F0,
  0x03F0,
  0x07F0
},
{ // bn_n_w.c
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0xFF00,
  0xFF00,
  0xFF00,
  0xFE00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFE70,
  0x00F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x00F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // bn_sw_e.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x0FF0,
  0x1FF0,
  0x3FF0,
  0x7E00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFE00,
  0xF8F0,
  0xF3F0,
  0xE7F0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7E00,
  0x7000,
  0x6000,
  0x4000,
  0x0000,
  0x00F0,
  0x03F0,
  0x07F0
},
{ // bn_sw_se.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0F00,
  0x1F80,
  0x3FC0,
  0x7FE0,
  0xF9F0,
  0xF0F0,
  0xE070,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF9F0,
  0xF3F0,
  0xE7F0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x70F0,
  0x6070,
  0x4030,
  0x0010,
  0x0000,
  0x0300,
  0x0780
},
{ // bn_ne_s.c
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x03C0,
  0x07C0,
  0x0780,
  0x0780,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFE0,
  0xFFC0,
  0xFFD0,
  0xFF90,
  0xFFB0,
  0xFF30,
  0xFF70,
  0xFF70,
  0xFF70,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7C00,
  0x7C00,
  0x7810,
  0x7810,
  0x7830,
  0x7030,
  0x7070,
  0x7070,
  0x7070
},
{ // bn_nw_s.c
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x7FF0,
  0xFDF0,
  0xFFF0,
  0xFEF0,
  0xFEF0,
  0xFFF0,
  0xFF70,
  0xFF70,
  0xFF70,
  /* Plane 3 */
  0x0000,
  0x0FF0,
  0x07F0,
  0x03F0,
  0x41F0,
  0x41F0,
  0x60F0,
  0x60F0,
  0x70F0,
  0x7070,
  0x7070,
  0x7070
},
{ // bn_s_se.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0380,
  0x07C0,
  0x0FF0,
  0x0FF0,
  0x0F70,
  0x0F70,
  0x0F70,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF70,
  0xFF70,
  0xFF70,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7C70,
  0x7830,
  0x7000,
  0x7000,
  0x7000,
  0x7000,
  0x7000
},
{ // bn_s_sw.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x1C00,
  0x3E00,
  0xFF00,
  0xFF00,
  0xEF00,
  0xEF00,
  0xEF00,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF70,
  0xEF70,
  0xEF70,
  0xEF70,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x63F0,
  0x41F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0x0070
},
{ // bn_w_e.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // bn_w_ne.c
  0x0070,
  0x00F0,
  0x01F0,
  0x07E0,
  0xFFC0,
  0xFF80,
  0xFF00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFE0,
  0xFFC0,
  0xFF90,
  0xFF30,
  0xF870,
  0x03F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7800,
  0x0000,
  0x0010,
  0x0030,
  0x0070,
  0x03F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // bn_w_nw.c
  0xF800,
  0xF800,
  0xFC00,
  0x1E00,
  0xFE00,
  0xFE00,
  0xFC00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFBF0,
  0xFBF0,
  0xFFF0,
  0x1FF0,
  0xFEF0,
  0xFEF0,
  0xFCF0,
  0xF9F0,
  0x03F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x03F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // bn_w_s.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFE00,
  0xFF00,
  0xFF00,
  0xFF00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF70,
  0xFF70,
  0x0F70,
  0xFF70,
  0xFF70,
  0xFF70,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x01F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0x7070,
  0x7070,
  0x7070
},
{ // bn_w_se.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFF00,
  0xFF80,
  0xFFC0,
  0x07E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x07F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x07F0,
  0x00F0,
  0x0070,
  0x0030,
  0x0010,
  0x7E00,
  0x7F00,
  0x7F80
},
{ // bn_w_sw.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFC00,
  0xFE00,
  0xFE00,
  0x1E00,
  0xFC00,
  0xF800,
  0xF800,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFEF0,
  0x1EF0,
  0xFCF0,
  0xF9F0,
  0xFBF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0
},
{ // Blue Tail
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 1 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0
},
{ // Bg_ne_e.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x01F0,
  0x01F0,
  0x03F0,
  0x0780,
  0x07F0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF80,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7E00,
  0x7C00,
  0x7800,
  0x7800,
  0x7800,
  0x7C00,
  0x7E00,
  0x7F00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // Bg_e_s.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x07F0,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF00,
  0xFF70,
  0xFF70,
  0xFF70,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7800,
  0x7000,
  0x7000,
  0x7000,
  0x7000,
  0x7070,
  0x7070,
  0x7070
},
{ // Bg_e_se.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x03F0,
  0x07F0,
  0x07F0,
  0x0780,
  0x03F0,
  0x01F0,
  0x01F0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF80,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7E00,
  0x7C00,
  0x7800,
  0x7800,
  0x7800,
  0x7C00,
  0x7E00,
  0x7E00
},
{ // Bg_ne_se.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0780,
  0x0780,
  0x07C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFE0,
  0xFFC0,
  0xFF90,
  0xFFB0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7C00,
  0x7800,
  0x7810,
  0x7830,
  0x7830,
  0x7C10,
  0x7E00,
  0x7F00,
  0x7F80
},
{ // Bg_ne_sw.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0F80,
  0x1F00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFE0,
  0xFFC0,
  0xFF90,
  0xFF30,
  0xFE70,
  0xFCF0,
  0xF9F0,
  0xF3F0,
  0xE7F0,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7C00,
  0x7800,
  0x7010,
  0x6030,
  0x4070,
  0x00F0,
  0x01F0,
  0x03F0,
  0x07F0
},
{ // Bg_nw_e.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7E00,
  0x3FF0,
  0x1FF0,
  0x0FF0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xEFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF9F0,
  0xFF00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x0FF0,
  0x07F0,
  0x01F0,
  0x4000,
  0x6000,
  0x7000,
  0x7800,
  0x7F00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // Bg_nw_ne.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xE070,
  0xF0F0,
  0xF9F0,
  0x7FE0,
  0x3FC0,
  0x1F80,
  0x0F00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xEFF0,
  0xFFF0,
  0xFFF0,
  0xFFE0,
  0xFFC0,
  0xFF90,
  0xFF30,
  0xF870,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x0F00,
  0x0600,
  0x0000,
  0x4000,
  0x6010,
  0x7030,
  0x7870,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // Bg_nw_se.c
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  0x000F,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3E00,
  0x1F00,
  0x0F80,
  0x07C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x7FF0,
  0xBFF0,
  0xDFF0,
  0xEFF0,
  0xF7F0,
  0xFBF0,
  0xFDF0,
  0xFEF0,
  0xFF70,
  /* Plane 3 */
  0x000F,
  0x0FFF,
  0x07FF,
  0x03FF,
  0x01FF,
  0x40FF,
  0x607F,
  0x703F,
  0x781F,
  0x7C0F,
  0x7E0F,
  0x7F0F
},
{ // Bg_nw_sw.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x7FF0,
  0xFFF0,
  0xFEF0,
  0xFEF0,
  0xFEF0,
  0xFCF0,
  0xF9F0,
  0xF3F0,
  0xE7F0,
  /* Plane 3 */
  0x0000,
  0x0FF0,
  0x07F0,
  0x03F0,
  0x41F0,
  0x60F0,
  0x60F0,
  0x40F0,
  0x00F0,
  0x01F0,
  0x03F0,
  0x07F0
},
{ // Bg_n_e.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x07F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFC00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x7000,
  0x7000,
  0x7000,
  0x7800,
  0x7C00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // Bg_n_ne.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F70,
  0x0F70,
  0x0F70,
  0x0FF0,
  0x0FF0,
  0x07C0,
  0x0380,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF70,
  0xFF70,
  0xFF70,
  0xFFF0,
  0xFFF0,
  0xFFC0,
  0xFF90,
  0xFE30,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7000,
  0x7000,
  0x7000,
  0x7000,
  0x7800,
  0x7C10,
  0x7E30,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // Bg_n_nw.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xEF00,
  0xEF00,
  0xEF00,
  0xFF00,
  0xFF00,
  0x3E00,
  0x1C00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xEF70,
  0xEF70,
  0xEF70,
  0xFF70,
  0xFF70,
  0x3E70,
  0xFCF0,
  0xF1F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x60F0,
  0x71F0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // Bg_n_s.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070
},
{ // Bg_n_se.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0780,
  0x0780,
  0x07C0,
  0x03C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFFF0,
  0xFFB0,
  0xFFF0,
  0xFFD0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x7870,
  0x7830,
  0x7830,
  0x7C10,
  0x7C10,
  0x7E00,
  0x7F00,
  0x7F80
},
{ // Bg_n_sw.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x3C00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFE70,
  0xFEF0,
  0xFEF0,
  0xFCF0,
  0xFDF0,
  0xF9F0,
  0xF3F0,
  0xE7F0,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x6070,
  0x60F0,
  0x40F0,
  0x40F0,
  0x01F0,
  0x01F0,
  0x03F0,
  0x07F0
},
{ // Bg_n_w.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0xFF00,
  0xFF00,
  0xFF00,
  0xFE00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFE70,
  0x00F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x00F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // Bg_sw_e.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x0FF0,
  0x1FF0,
  0x3FF0,
  0x7E00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFE00,
  0xF8F0,
  0xF3F0,
  0xE7F0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7E00,
  0x7000,
  0x6000,
  0x4000,
  0x0000,
  0x00F0,
  0x03F0,
  0x07F0
},
{ // Bg_sw_se.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0F00,
  0x1F80,
  0x3FC0,
  0x7FE0,
  0xF9F0,
  0xF0F0,
  0xE070,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF9F0,
  0xF3F0,
  0xE7F0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x70F0,
  0x6070,
  0x4030,
  0x0010,
  0x0000,
  0x0300,
  0x0780
},
{ // Bg_ne_s.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x03C0,
  0x07C0,
  0x0780,
  0x0780,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFE0,
  0xFFC0,
  0xFFD0,
  0xFF90,
  0xFFB0,
  0xFF30,
  0xFF70,
  0xFF70,
  0xFF70,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7C00,
  0x7C00,
  0x7810,
  0x7810,
  0x7830,
  0x7030,
  0x7070,
  0x7070,
  0x7070
},
{ // Bg_nw_s.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x7FF0,
  0xFDF0,
  0xFFF0,
  0xFEF0,
  0xFEF0,
  0xFFF0,
  0xFF70,
  0xFF70,
  0xFF70,
  /* Plane 3 */
  0x0000,
  0x0FF0,
  0x07F0,
  0x03F0,
  0x41F0,
  0x41F0,
  0x60F0,
  0x60F0,
  0x70F0,
  0x7070,
  0x7070,
  0x7070
},
{ // Bg_s_se.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0380,
  0x07C0,
  0x0FF0,
  0x0FF0,
  0x0F70,
  0x0F70,
  0x0F70,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF70,
  0xFF70,
  0xFF70,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7C70,
  0x7830,
  0x7000,
  0x7000,
  0x7000,
  0x7000,
  0x7000
},
{ // Bg_s_sw.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x1C00,
  0x3E00,
  0xFF00,
  0xFF00,
  0xEF00,
  0xEF00,
  0xEF00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF70,
  0xEF70,
  0xEF70,
  0xEF70,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x63F0,
  0x41F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0x0070
},
{ // Bg_w_e.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // Bg_ne_w.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x07E0,
  0xFFC0,
  0xFF80,
  0xFF00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFE0,
  0xFFC0,
  0xFF90,
  0xFF30,
  0xF870,
  0x03F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7800,
  0x0000,
  0x0010,
  0x0030,
  0x0070,
  0x03F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // Bg_nw_w.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xF800,
  0xF800,
  0xFC00,
  0x1E00,
  0xFE00,
  0xFE00,
  0xFC00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFBF0,
  0xFBF0,
  0xFFF0,
  0x1FF0,
  0xFEF0,
  0xFEF0,
  0xFCF0,
  0xF9F0,
  0x03F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x03F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // Bg_w_s.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFE00,
  0xFF00,
  0xFF00,
  0xFF00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFF70,
  0xFF70,
  0x0F70,
  0xFF70,
  0xFF70,
  0xFF70,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x01F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0x7070,
  0x7070,
  0x7070
},
{ // Bg_w_se.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFF00,
  0xFF80,
  0xFFC0,
  0x07E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x07F0,
  0xFDF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x07F0,
  0x00F0,
  0x0070,
  0x0030,
  0x0010,
  0x7C00,
  0x7F00,
  0x7F80
},
{ // Bg_w_sw.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFC00,
  0xFE00,
  0xFE00,
  0x1E00,
  0xFC00,
  0xF800,
  0xF800,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFEF0,
  0x1EF0,
  0xFCF0,
  0xF9F0,
  0xFBF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0
},
{ // Blue Glow
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  /* Plane 1 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 2 */
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  65520,
  /* Plane 3 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0
},
{ // yn_ne_e.c
  0x01F0,
  0x01F0,
  0x03F0,
  0x0780,
  0x07F0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x01F0,
  0x01F0,
  0x03F0,
  0x0780,
  0x07F0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFE00,
  0xFE00,
  0xFC00,
  0xF800,
  0xF800,
  0xF800,
  0xFC00,
  0xFE00,
  0xFF00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7E00,
  0x7C00,
  0x7800,
  0x7800,
  0x7800,
  0x7C00,
  0x7E00,
  0x7F00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yn_s_e.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x07F0,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x07F0,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF800,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7800,
  0x7000,
  0x7000,
  0x7000,
  0x7000,
  0x7070,
  0x7070,
  0x7070
},
{ // yn_e_se.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x03F0,
  0x07F0,
  0x07F0,
  0x0780,
  0x03F0,
  0x01F0,
  0x01F0,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x03F0,
  0x07F0,
  0x07F0,
  0x0780,
  0x03F0,
  0x01F0,
  0x01F0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFE00,
  0xFC00,
  0xF800,
  0xF800,
  0xF800,
  0xFC00,
  0xFE00,
  0xFE00,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7E00,
  0x7C00,
  0x7800,
  0x7800,
  0x7800,
  0x7C00,
  0x7E00,
  0x7E00
},
{ // yn_ne_se.c
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0780,
  0x0780,
  0x07C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0780,
  0x0780,
  0x07C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xFC00,
  0xF800,
  0xF810,
  0xF830,
  0xF830,
  0xFC10,
  0xFE00,
  0xFF00,
  0xFF80,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7C00,
  0x7800,
  0x7810,
  0x7830,
  0x7830,
  0x7C10,
  0x7E00,
  0x7F00,
  0x7F80
},
{ // yn_ne_sw.c
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0F80,
  0x1F00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0F80,
  0x1F00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xFC00,
  0xF800,
  0xF010,
  0xE030,
  0xC070,
  0x80F0,
  0x01F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7C00,
  0x7800,
  0x7010,
  0x6030,
  0x4070,
  0x00F0,
  0x01F0,
  0x03F0,
  0x07F0
},
{ // yn_nw_e.c
  0xE000,
  0xF000,
  0xF800,
  0x7E00,
  0x3FF0,
  0x1FF0,
  0x0FF0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7E00,
  0x3FF0,
  0x1FF0,
  0x0FF0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0FF0,
  0x0FF0,
  0x07F0,
  0x81F0,
  0xC000,
  0xE000,
  0xF000,
  0xF800,
  0xFF00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x0FF0,
  0x07F0,
  0x01F0,
  0x4000,
  0x6000,
  0x7000,
  0x7800,
  0x7F00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yn_nw_ne.c
  0xE070,
  0xF0F0,
  0xF9F0,
  0x7FE0,
  0x3FC0,
  0x1F80,
  0x0F00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xE070,
  0xF0F0,
  0xF9F0,
  0x7FE0,
  0x3FC0,
  0x1F80,
  0x0F00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0F80,
  0x0F00,
  0x0600,
  0x8000,
  0xC000,
  0xE010,
  0xF030,
  0xF870,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x0F00,
  0x0600,
  0x0000,
  0x4000,
  0x6010,
  0x7030,
  0x7870,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yn_nw_se.c
  0xE00F,
  0xF00F,
  0xF80F,
  0x7C0F,
  0x3E0F,
  0x1F0F,
  0x0F8F,
  0x07CF,
  0x03EF,
  0x01FF,
  0x00FF,
  0x007F,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3E00,
  0x1F00,
  0x0F80,
  0x07C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0x1FF0,
  0x0FF0,
  0x07F0,
  0x03F0,
  0x81F0,
  0xC0F0,
  0xE070,
  0xF030,
  0xF810,
  0xFC00,
  0xFE00,
  0xFF00,
  /* Plane 3 */
  0x000F,
  0x0FFF,
  0x07FF,
  0x03FF,
  0x01FF,
  0x40FF,
  0x607F,
  0x703F,
  0x781F,
  0x7C0F,
  0x7E0F,
  0x7F0F
},
{ // yn_nw_sw.c
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0x1FF0,
  0x0FF0,
  0x07F0,
  0x03F0,
  0xC1F0,
  0xE0F0,
  0xE0F0,
  0xC0F0,
  0x80F0,
  0x01F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0x0000,
  0x0FF0,
  0x07F0,
  0x03F0,
  0x41F0,
  0x60F0,
  0x60F0,
  0x40F0,
  0x00F0,
  0x01F0,
  0x03F0,
  0x07F0
},
{ // yn_n_e.c
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x07F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x07F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF000,
  0xF000,
  0xF000,
  0xF800,
  0xFC00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x7000,
  0x7000,
  0x7000,
  0x7800,
  0x7C00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yn_n_ne.c
  0x0F70,
  0x0F70,
  0x0F70,
  0x0FF0,
  0x0FF0,
  0x07C0,
  0x0380,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F70,
  0x0F70,
  0x0F70,
  0x0FF0,
  0x0FF0,
  0x07C0,
  0x0380,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF800,
  0xFC10,
  0xFE30,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7000,
  0x7000,
  0x7000,
  0x7000,
  0x7800,
  0x7C10,
  0x7E30,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0xEF00, // YN_N_NW or YN_NW_N
  0xEF00,
  0xEF00,
  0xFF00,
  0xFF00,
  0x3E00,
  0x1C00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xEF00,
  0xEF00,
  0xEF00,
  0xFF00,
  0xFF00,
  0x3E00,
  0x1C00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0xE0F0,
  0xF1F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x60F0,
  0x71F0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yn_n_s.c
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070,
  0x7070
},
{ // yn_n_se.c
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0780,
  0x0780,
  0x07C0,
  0x03C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0780,
  0x0780,
  0x07C0,
  0x03C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF870,
  0xF830,
  0xF830,
  0xFC10,
  0xFC10,
  0xFE00,
  0xFF00,
  0xFF80,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x7870,
  0x7830,
  0x7830,
  0x7C10,
  0x7C10,
  0x7E00,
  0x7F00,
  0x7F80
},
{ // yn_n_sw.c
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x3C00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x3C00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xE070,
  0xE0F0,
  0xC0F0,
  0xC0F0,
  0x81F0,
  0x01F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x6070,
  0x60F0,
  0x40F0,
  0x40F0,
  0x01F0,
  0x01F0,
  0x03F0,
  0x07F0
},
{ // yn_n_w.c
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0xFF00,
  0xFF00,
  0xFF00,
  0xFE00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0xFF00,
  0xFF00,
  0xFF00,
  0xFE00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x00F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7070,
  0x7070,
  0x7070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x00F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yn_e_sw.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x0FF0,
  0x1FF0,
  0x3FF0,
  0x7E00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x0FF0,
  0x1FF0,
  0x3FF0,
  0x7E00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFE00,
  0xF000,
  0xE000,
  0xC000,
  0x8000,
  0x00F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7E00,
  0x7000,
  0x6000,
  0x4000,
  0x0000,
  0x00F0,
  0x03F0,
  0x07F0
},
{ // yn_sw_se.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0F00,
  0x1F80,
  0x3FC0,
  0x7FE0,
  0xF9F0,
  0xF0F0,
  0xE070,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0F00,
  0x1F80,
  0x3FC0,
  0x7FE0,
  0xF9F0,
  0xF0F0,
  0xE070,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF0F0,
  0xE070,
  0xC030,
  0x8010,
  0x0000,
  0x0300,
  0x0780,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x70F0,
  0x6070,
  0x4030,
  0x0010,
  0x0000,
  0x0300,
  0x0780
},
{ // yn_ne_s.c
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x03C0,
  0x07C0,
  0x0780,
  0x0780,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x03C0,
  0x07C0,
  0x0780,
  0x0780,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xFC00,
  0xFC00,
  0xF810,
  0xF810,
  0xF830,
  0xF030,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7C00,
  0x7C00,
  0x7810,
  0x7810,
  0x7830,
  0x7030,
  0x7070,
  0x7070,
  0x7070
},
{ // yn_nw_s.c
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0x1FF0,
  0x0FF0,
  0x07F0,
  0x03F0,
  0xC1F0,
  0xC1F0,
  0xE0F0,
  0xE0F0,
  0xF0F0,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0000,
  0x0FF0,
  0x07F0,
  0x03F0,
  0x41F0,
  0x41F0,
  0x60F0,
  0x60F0,
  0x70F0,
  0x7070,
  0x7070,
  0x7070
},
{ // yn_s_se.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0380,
  0x07C0,
  0x0FF0,
  0x0FF0,
  0x0F70,
  0x0F70,
  0x0F70,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0380,
  0x07C0,
  0x0FF0,
  0x0FF0,
  0x0F70,
  0x0F70,
  0x0F70,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFC70,
  0xF830,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7C70,
  0x7830,
  0x7000,
  0x7000,
  0x7000,
  0x7000,
  0x7000
},
{ // yn_s_sw.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x1C00,
  0x3E00,
  0xFF00,
  0xFF00,
  0xEF00,
  0xEF00,
  0xEF00,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x1C00,
  0x3E00,
  0xFF00,
  0xFF00,
  0xEF00,
  0xEF00,
  0xEF00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xE3F0,
  0xC1F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x63F0,
  0x41F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0x0070
},
{ // yn_w_e.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yn_w_ne.c
  0x0070,
  0x00F0,
  0x01F0,
  0x07E0,
  0xFFC0,
  0xFF80,
  0xFF00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x07E0,
  0xFFC0,
  0xFF80,
  0xFF00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xF800,
  0x0000,
  0x0010,
  0x0030,
  0x0070,
  0x03F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7F00,
  0x7E00,
  0x7800,
  0x0000,
  0x0010,
  0x0030,
  0x0070,
  0x03F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yn_nw_w.c
  0xF800,
  0xF800,
  0xFC00,
  0x1E00,
  0xFE00,
  0xFE00,
  0xFC00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xF800,
  0xF800,
  0xFC00,
  0x1E00,
  0xFE00,
  0xFE00,
  0xFC00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x03F0,
  0x03F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x03F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yn_w_s.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFE00,
  0xFF00,
  0xFF00,
  0xFF00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFE00,
  0xFF00,
  0xFF00,
  0xFF00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x01F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x01F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0x7070,
  0x7070,
  0x7070
},
{ // yn_w_se.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFF00,
  0xFF80,
  0xFFC0,
  0x07E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFF00,
  0xFF80,
  0xFFC0,
  0x07E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x07F0,
  0x00F0,
  0x0070,
  0x0030,
  0x0010,
  0xFE00,
  0xFF00,
  0xFF80,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x07F0,
  0x00F0,
  0x0070,
  0x0030,
  0x0010,
  0x7E00,
  0x7F00,
  0x7F80
},
{ // yn_w_sw.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFC00,
  0xFE00,
  0xFE00,
  0x1E00,
  0xFC00,
  0xF800,
  0xF800,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFC00,
  0xFE00,
  0xFE00,
  0x1E00,
  0xFC00,
  0xF800,
  0xF800,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0
},
{ // Yellow Tail
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 1 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 2 */
  65520,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  /* Plane 3 */
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0
},
{ // yg_e_ne.c
  0x01F0,
  0x01F0,
  0x03F0,
  0x0780,
  0x07F0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x01F0,
  0x01F0,
  0x03F0,
  0x0780,
  0x07F0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFE00,
  0xFE00,
  0xFC00,
  0xF800,
  0xF800,
  0xF800,
  0xFC00,
  0xFE00,
  0xFF00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x01F0,
  0x7FF0,
  0x7FF0,
  0x7F80,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7F00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yg_e_s.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x07F0,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x07F0,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF800,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7F00,
  0x7F70,
  0x7F70,
  0x7F70
},
{ // yg_e_se.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x03F0,
  0x07F0,
  0x07F0,
  0x0780,
  0x03F0,
  0x01F0,
  0x01F0,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x03F0,
  0x07F0,
  0x07F0,
  0x0780,
  0x03F0,
  0x01F0,
  0x01F0,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFE00,
  0xFC00,
  0xF800,
  0xF800,
  0xF800,
  0xFC00,
  0xFE00,
  0xFE00,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7F80,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yg_ne_se.c
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0780,
  0x0780,
  0x07C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0780,
  0x0780,
  0x07C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xFC00,
  0xF800,
  0xF810,
  0xF830,
  0xF830,
  0xFC10,
  0xFE00,
  0xFF00,
  0xFF80,
  /* Plane 3 */
  0x0070,
  0x7FF0,
  0x7FF0,
  0x7FE0,
  0x7FC0,
  0x7F90,
  0x7FB0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yg_ne_sw.c
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0F80,
  0x1F00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x07C0,
  0x0F80,
  0x1F00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xFC00,
  0xF800,
  0xF010,
  0xE030,
  0xC070,
  0x80F0,
  0x01F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0x0070,
  0x7FF0,
  0x7FF0,
  0x7FE0,
  0x7FC0,
  0x7F90,
  0x7F30,
  0x7E70,
  0x7CF0,
  0xF9F0,
  0xF3F0,
  0xE7F0
},
{ // yg_e_nw.c
  0xE000,
  0xF000,
  0xF800,
  0x7E00,
  0x3FF0,
  0x1FF0,
  0x0FF0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7E00,
  0x3FF0,
  0x1FF0,
  0x0FF0,
  0x01F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0FF0,
  0x0FF0,
  0x07F0,
  0x81F0,
  0xC000,
  0xE000,
  0xF000,
  0xF800,
  0xFF00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xE000,
  0xFFF0,
  0xFFF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x79F0,
  0x7F00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yg_nw_ne.c
  0xE070,
  0xF0F0,
  0xF9F0,
  0x7FE0,
  0x3FC0,
  0x1F80,
  0x0F00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xE070,
  0xF0F0,
  0xF9F0,
  0x7FE0,
  0x3FC0,
  0x1F80,
  0x0F00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0F80,
  0x0F00,
  0x0600,
  0x8000,
  0xC000,
  0xE010,
  0xF030,
  0xF870,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xE070,
  0xFFF0,
  0xFFF0,
  0x7FE0,
  0x7FC0,
  0x7F90,
  0x7F30,
  0x7870,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yg_nw_se.c
  0xE00F,
  0xF00F,
  0xF80F,
  0x7C0F,
  0x3E0F,
  0x1F0F,
  0x0F8F,
  0x07CF,
  0x03EF,
  0x01FF,
  0x00FF,
  0x007F,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3E00,
  0x1F00,
  0x0F80,
  0x07C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0x1FF0,
  0x0FF0,
  0x07F0,
  0x03F0,
  0x81F0,
  0xC0F0,
  0xE070,
  0xF030,
  0xF810,
  0xFC00,
  0xFE00,
  0xFF00,
  /* Plane 3 */
  0xE00F,
  0xFFFF,
  0xFFFF,
  0x7FFF,
  0x3FFF,
  0x5FFF,
  0x6FFF,
  0x77FF,
  0x7BFF,
  0x7DFF,
  0x7EFF,
  0x7F7F
},
{ // yg_nw_sw.c
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0x1FF0,
  0x0FF0,
  0x07F0,
  0x03F0,
  0xC1F0,
  0xE0F0,
  0xE0F0,
  0xC0F0,
  0x80F0,
  0x01F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0xE000,
  0xFFF0,
  0xFFF0,
  0x7FF0,
  0x7FF0,
  0x7EF0,
  0x7EF0,
  0x7EF0,
  0x7CF0,
  0xF9F0,
  0xF3F0,
  0xE7F0
},
{ // yg_e_n.c
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x07F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0FF0,
  0x0FF0,
  0x0FF0,
  0x07F0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF000,
  0xF000,
  0xF000,
  0xF800,
  0xFC00,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0F00,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7C00,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yg_n_ne.c
  0x0F70,
  0x0F70,
  0x0F70,
  0x0FF0,
  0x0FF0,
  0x07C0,
  0x0380,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F70,
  0x0F70,
  0x0F70,
  0x0FF0,
  0x0FF0,
  0x07C0,
  0x0380,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF800,
  0xFC10,
  0xFE30,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0F70,
  0x7F70,
  0x7F70,
  0x7FF0,
  0x7FF0,
  0x7FC0,
  0x7F90,
  0x7E30,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yg_n_nw.c
  0xEF00,
  0xEF00,
  0xEF00,
  0xFF00,
  0xFF00,
  0x3E00,
  0x1C00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xEF00,
  0xEF00,
  0xEF00,
  0xFF00,
  0xFF00,
  0x3E00,
  0x1C00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0xE0F0,
  0xF1F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xEF00,
  0xEF70,
  0xEF70,
  0xFF70,
  0xFF70,
  0x3E70,
  0x7CF0,
  0x71F0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yg_n_s.c
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0F00,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7F70
},
{ // yg_n_se.c
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0780,
  0x0780,
  0x07C0,
  0x03C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0780,
  0x0780,
  0x07C0,
  0x03C0,
  0x03E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xF870,
  0xF830,
  0xF830,
  0xFC10,
  0xFC10,
  0xFE00,
  0xFF00,
  0xFF80,
  /* Plane 3 */
  0x0F00,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7FF0,
  0x7FB0,
  0x7FF0,
  0x7FD0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yg_n_sw.c
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x3C00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x1E00,
  0x1E00,
  0x3E00,
  0x3C00,
  0x7C00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0xE070,
  0xE0F0,
  0xC0F0,
  0xC0F0,
  0x81F0,
  0x01F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0x0F00,
  0x7F70,
  0x7F70,
  0x7F70,
  0x7E70,
  0x7EF0,
  0x7EF0,
  0x7CF0,
  0x7DF0,
  0xF9F0,
  0xF3F0,
  0xE7F0
},
{ // yg_n_w.c
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0xFF00,
  0xFF00,
  0xFF00,
  0xFE00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  0xFF00,
  0xFF00,
  0xFF00,
  0xFE00,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xF070,
  0xF070,
  0xF070,
  0xF070,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  0x00F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0F00,
  0x7F70,
  0x7F70,
  0x7F70,
  0xFF70,
  0xFF70,
  0xFF70,
  0xFE70,
  0x00F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yg_e_sw.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x0FF0,
  0x1FF0,
  0x3FF0,
  0x7E00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x01F0,
  0x0FF0,
  0x1FF0,
  0x3FF0,
  0x7E00,
  0xF800,
  0xF000,
  0xE000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFE00,
  0xF000,
  0xE000,
  0xC000,
  0x8000,
  0x00F0,
  0x03F0,
  0x07F0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7E00,
  0xF8F0,
  0xF3F0,
  0xE7F0
},
{ // yg_sw_se.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0F00,
  0x1F80,
  0x3FC0,
  0x7FE0,
  0xF9F0,
  0xF0F0,
  0xE070,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0F00,
  0x1F80,
  0x3FC0,
  0x7FE0,
  0xF9F0,
  0xF0F0,
  0xE070,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xF0F0,
  0xE070,
  0xC030,
  0x8010,
  0x0000,
  0x0300,
  0x0780,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0xF9F0,
  0xF3F0,
  0xE7F0
},
{ // yg_s_ne.c
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x03C0,
  0x07C0,
  0x0780,
  0x0780,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x03E0,
  0x03C0,
  0x07C0,
  0x0780,
  0x0780,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xFC00,
  0xFC00,
  0xF810,
  0xF810,
  0xF830,
  0xF030,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0070,
  0x7FF0,
  0x7FF0,
  0x7FE0,
  0x7FC0,
  0x7FD0,
  0x7F90,
  0x7FB0,
  0x7F30,
  0x7F70,
  0x7F70,
  0x7F70
},
{ // yg_s_nw.c
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0xE000,
  0xF000,
  0xF800,
  0x7C00,
  0x3C00,
  0x3E00,
  0x1E00,
  0x1E00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0x1FF0,
  0x0FF0,
  0x07F0,
  0x03F0,
  0xC1F0,
  0xC1F0,
  0xE0F0,
  0xE0F0,
  0xF0F0,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0xE000,
  0xFFF0,
  0xFFF0,
  0x7FF0,
  0x7DF0,
  0x7FF0,
  0x7EF0,
  0x7EF0,
  0x7FF0,
  0x7F70,
  0x7F70,
  0x7F70
},
{ // yg_s_se.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0380,
  0x07C0,
  0x0FF0,
  0x0FF0,
  0x0F70,
  0x0F70,
  0x0F70,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0380,
  0x07C0,
  0x0FF0,
  0x0FF0,
  0x0F70,
  0x0F70,
  0x0F70,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFC70,
  0xF830,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  0xF000,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7F70,
  0x7F70,
  0x7F70
},
{ // yg_s_sw.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x1C00,
  0x3E00,
  0xFF00,
  0xFF00,
  0xEF00,
  0xEF00,
  0xEF00,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x1C00,
  0x3E00,
  0xFF00,
  0xFF00,
  0xEF00,
  0xEF00,
  0xEF00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xE3F0,
  0xC1F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0x0070,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0xFFF0,
  0xFF70,
  0xEF70,
  0xEF70,
  0xEF70
},
{ // yg_w_e.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yg_w_ne.c
  0x0070,
  0x00F0,
  0x01F0,
  0x07E0,
  0xFFC0,
  0xFF80,
  0xFF00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0070,
  0x00F0,
  0x01F0,
  0x07E0,
  0xFFC0,
  0xFF80,
  0xFF00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFF80,
  0xFF00,
  0xFE00,
  0xF800,
  0x0000,
  0x0010,
  0x0030,
  0x0070,
  0x03F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0070,
  0x7FF0,
  0x7FF0,
  0x7FE0,
  0xFFC0,
  0xFF90,
  0xFF30,
  0xF870,
  0x03F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yg_w_nw.c
  0xF800,
  0xF800,
  0xFC00,
  0x1E00,
  0xFE00,
  0xFE00,
  0xFC00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0xF800,
  0xF800,
  0xFC00,
  0x1E00,
  0xFE00,
  0xFE00,
  0xFC00,
  0xF800,
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0x03F0,
  0x03F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0xF800,
  0xFBF0,
  0xFFF0,
  0x1FF0,
  0xFEF0,
  0xFEF0,
  0xFCF0,
  0xF9F0,
  0x03F0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ // yg_w_s.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFE00,
  0xFF00,
  0xFF00,
  0xFF00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xFE00,
  0xFF00,
  0xFF00,
  0xFF00,
  0x0F00,
  0x0F00,
  0x0F00,
  0x0F00,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x01F0,
  0x00F0,
  0x0070,
  0x0070,
  0x0070,
  0xF070,
  0xF070,
  0xF070,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0xFFF0,
  0xFFF0,
  0xFF70,
  0xFF70,
  0x0F70,
  0x7F70,
  0x7F70,
  0x7F70
},
{ // yg_w_se.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFF00,
  0xFF80,
  0xFFC0,
  0x07E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFF00,
  0xFF80,
  0xFFC0,
  0x07E0,
  0x01F0,
  0x00F0,
  0x0070,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x07F0,
  0x00F0,
  0x0070,
  0x0030,
  0x0010,
  0xFC00,
  0xFF00,
  0xFF80,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x07F0,
  0x7DF0,
  0x7FF0,
  0x7FF0
},
{ // yg_w_sw.c
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFC00,
  0xFE00,
  0xFE00,
  0x1E00,
  0xFC00,
  0xF800,
  0xF800,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0xF800,
  0xFC00,
  0xFE00,
  0xFE00,
  0x1E00,
  0xFC00,
  0xF800,
  0xF800,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0x07F0,
  0x03F0,
  0x01F0,
  0x00F0,
  0x00F0,
  0x00F0,
  0x01F0,
  0x03F0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFEF0,
  0x1EF0,
  0xFCF0,
  0xF9F0,
  0xFBF0
},
{ // Yellow Glow
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 1 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  /* Plane 2 */
  65520,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  32768,
  /* Plane 3 */
  0,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752,
  32752
},
{ 0x0000, // ZERO
  0x0000,
  0x0700,
  0x0880,
  0x0880,
  0x0880,
  0x0880,
  0x0880,
  0x0880,
  0x0880,
  0x0700,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0700,
  0x0880,
  0x0880,
  0x0880,
  0x0880,
  0x0880,
  0x0880,
  0x0880,
  0x0700,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // COLON
  0x0000,
  0x0000,
  0x0000,
  0x0200,
  0x0000,
  0x0000,
  0x0000,
  0x0200,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0200,
  0x0000,
  0x0000,
  0x0000,
  0x0200,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // MULTIPLICATION
  0x0000,
  0x2020,
  0x1040,
  0x0880,
  0x0500,
  0x0200,
  0x0500,
  0x0880,
  0x1040,
  0x2020,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x2020,
  0x1040,
  0x0880,
  0x0500,
  0x0200,
  0x0500,
  0x0880,
  0x1040,
  0x2020,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
},
{ 0x0000, // EQUALS
  0x0000,
  0x0000,
  0x0000,
  0x0F80,
  0x0000,
  0x0000,
  0x0000,
  0x0F80,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 1 */
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x0F80,
  0x0000,
  0x0000,
  0x0000,
  0x0F80,
  0x0000,
  0x0000,
  0x0000,
  /* Plane 2 */
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  0xFFF0,
  /* Plane 3 */
  0x0000,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0,
  0x7FF0
} };

#ifdef AMIGA
EXPORT struct Image Squares =
{   0, 0,
    SQUAREX, SQUAREY, 4,
    NULL,
    0xff, 0x0,
    NULL
};

EXPORT void draw(int x, int y, UWORD image)
{   // level editor uses this to draw the pseudo-gadgets

    if (superturbo)
    {   return;
    }

    if (image == EMPTY && engraved && a != LEVELEDIT)
    {   image = (UWORD) FIRSTPATTERN + engraving;
    }

    Squares.ImageData = SquaresData[image];
    DrawImage
    (   MainWindowPtr->RPort,
        &Squares,
        STARTXPIXEL + (SQUAREX * x),
        STARTYPIXEL + (SQUAREY * y)
    );
}
EXPORT void intro_draw(int x, int y, UWORD what)
{   raw_draw(FIELDCENTREX + (x * SQUAREX), INTROY + 3 - (11 * SQUAREY) + (y * SQUAREY), what);
}
EXPORT void raw_draw(int x, int y, UWORD what)
{   Squares.ImageData = SquaresData[what];
    DrawImage(MainWindowPtr->RPort, &Squares, x, y);
}
EXPORT void le_draw(int x, int y, UWORD image)
{   raw_draw
    (   STARTXPIXEL + (SQUAREX * (WW_LEFTGAP + x)),
        STARTYPIXEL + (SQUAREY * ( WW_TOPGAP + y)),
        image
    );
}
#endif

#if defined(__AROS__) && (AROS_BIG_ENDIAN == 0)
EXPORT void squares_swap_byteorder(void)
{   swap_byteorder((UWORD*) OriginalSquaresData, sizeof(OriginalSquaresData) / 2);
}
#endif
