/*
    Tiny_Tetris_SDL :  A tiny and simply Tetris with SDL
    Copyright (C) 2008-2009 Loc Bartoletti
    http://coder.tuxfamily.org/

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    Loc Bartoletti
    coder@tuxfamily.org
*/

#include "compte.h"

/*!
* \file compte.c
* \brief Check fulled lines functions
* \author L. Bartoletti
* \version 1.3
* \date 08 March 2009
*/

/*!
* \fn int VerifLigne(SDL_Surface *global_ecran, int fullscreen)
* \brief check if the line is full and return the number of line full
* \param global_ecran main screen
* \param fullscreen enable or disable variable for fullscreen mode
*/
int VerifLigne(SDL_Surface *global_ecran, int fullscreen)
{

    /** \code
    /** in case of fullscreen make correction */
    int fullscreen_bord_x, fullscreen_bord_y;
    if (fullscreen == 1)
    {
        fullscreen_bord_x = FULLSCREEN_BORD_X;
        fullscreen_bord_y = FULLSCREEN_BORD_Y;
    }
    else
    {
        fullscreen_bord_x = 0;
        fullscreen_bord_y = 0;
    }

    /* Position of the line checked */
    SDL_Rect posLigne;

    /* number of lines fulled in once */
    int nbLignesSuit = 0;

    /* count of block fulled on line */
    int count = 0;


    /* Variables for check pixel color on screen */
    Uint32 pixEcran;
    Uint8 rEcran, gEcran, bEcran;
    int sEcran;

    int x, y;

    /* set position of line */
    posLigne.x = BORD_X + BLOC + fullscreen_bord_x;
    posLigne.y = BORD_Y + fullscreen_bord_y;


    /* for each line on each colonne */
    /* check if the NB_COL is colored on line */
    for (y = 0; y < NB_LIGNE; y++)
    {
        count = 0;
        for (x = 0; x < NB_COL; x++)
        {
            /* check if the block is colored */
            pixEcran = getpixel(global_ecran, posLigne.x+x*BLOC, posLigne.y+y*BLOC);
            SDL_GetRGB(pixEcran, global_ecran->format, &rEcran, &gEcran, &bEcran);
            sEcran = rEcran + gEcran + bEcran;

            /* if colored up count */
            if (sEcran != 0)
            {
                count += 1;

            }

        }

        /* if the number of count is egual to NB_COL the line is fulled */
        if (count == NB_COL)
        {


            /* deplace the screen down */

            /* make copy of screen on the line fulled */
            SDL_Rect Ecr, copEcr;

            Ecr.x = copEcr.x = BORD_X + fullscreen_bord_x;
            Ecr.y = BORD_Y + fullscreen_bord_y;
            Ecr.w = copEcr.w = NB_COL*BLOC + BLOC;
            Ecr.h = copEcr.w = posLigne.y + y*BLOC - BORD_Y - fullscreen_bord_y;

            copEcr.y = Ecr.y+BLOC;

            /* copy the screen on a line down */
            SDL_BlitSurface(global_ecran, &Ecr, global_ecran, &copEcr);


            /* add one to the number of line fulled in once */
            nbLignesSuit += 1;

        }




    }

    /* return the number of line fulled in once */
    return nbLignesSuit;

    /** \endcode */
}
