/*
    Tiny_Tetris_SDL :  A tiny and simply Tetris with SDL
    Copyright (C) 2008-2009 Loc Bartoletti
    http://coder.tuxfamily.org/

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    Loc Bartoletti
    coder@tuxfamily.org
*/

/*!
* \file main.h
* \brief Definition of functions and constants
* \author L. Bartoletti
* \version 1.3
* \date 08 March 2009
*/


#ifndef _MAIN_H_
#define _MAIN_H_


#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_ttf.h>


/**
 * \ingroup B
 */

/**
 * \defgroup Constants Constants
 */

/*@{*/

/** X Bording of game */
#define BORD_X 0
/** Y Bording of game */
#define BORD_Y 0
/** Size of block weight/height*/
#define BLOC 6
/** Number of line in tetromino */
#define NB_LIGNE 22
/** Number of colonne in tetromino */
#define NB_COL 10
/** Delay */
#define DELAY 300
/** Delay keys */
#define DELAY_KEYS 60
/** Number of block's image : 7 types of block in 4 position each */
#define NB_BLOC_IMG 28
/** Space between tetromino and frame */
#define ESPACE 10
/** Speed up in each level. Calculate on DELAY/15. 15 is the Max speed level */
#define SPEED_FACTOR 20
/** X position variable correction in fullscreen */
#define FULLSCREEN_BORD_X   640/2 - (NB_COL*BLOC)
/** Y position variable correction in fullscreen */
#define FULLSCREEN_BORD_Y   480/2 - (NB_LIGNE*BLOC)/2
/*@}*/
int initialisationSDLetTTF(void);
int creationFenetre(int fullscreen);
void moteur(int fullscreen);
SDL_Rect actionTouche(SDL_Rect posBloc, int fullscreen);
void dessineInterface(SDL_Surface *global_ecran, int fullscreen);
void posProchBloc(SDL_Surface *ecran, SDL_Surface *nBloc, int fullscreen);
SDL_Surface *chargeIMG(int numIMG);
SDL_Rect VerifSiBlocBouge(SDL_Rect posBloc, int x, int y, int fullscreen);
int VerifSiBlocTourne(SDL_Rect posBloc, int numCurBloc, int numBloc);
Uint32 getpixel(SDL_Surface *surface, int x, int y);
void putpixel(SDL_Surface *surface, int x, int y, Uint32 pixel);
int VerifLigne(SDL_Surface *global_ecran, int fullscreen);
void affichage(SDL_Surface *global_ecran, int niveau, int nbLignes, long points, int fullscreen);
int verifGameOver(SDL_Surface *global_ecran, SDL_Surface *curBloc, SDL_Rect posBloc);
void gameOver(SDL_Surface *global_ecran, long points, int lignes, int niveau);
void affichBest(SDL_Surface *global_ecran);
void pause(SDL_Surface *global_ecran, int choix, int fullscreen);
void writeTexte(SDL_Surface *global_ecran, const char* texte, SDL_Color couleur_texte, int posX, int posY);
#endif

