#include "uade_tnplug.h"

int32 TNPlug_DecodeFramePlayer (struct TNPlugIFace *Self, struct TuneNet *inTuneNet,
	int16 *outbuffer)
{
	struct TNDecHandle *handle = inTuneNet->handle;
	if (handle->player_proc) {
		handle->player_port->mp_SigTask = IExec->FindTask(NULL);
		dbug2(("DecodeFramePlayer: Sending Data Signal.\n"));
		IExec->Signal((struct Task *)handle->player_proc, handle->data_sig);
		IExec->WaitPort(handle->player_port);
		if (IExec->GetMsg(handle->player_port) == (struct Message *)handle->death_msg) {
			dbug2(("DecodeFramePlayer: Received Death Message.\n"));
			handle->player_proc = NULL;
		} else {
			dbug2(("DecodeFramePlayer: Received PCM Data: %ld\n",
				handle->adata_msg->adm_NumPCMFrames));
			return handle->adata_msg->adm_NumPCMFrames;
		}
	} else {
		dbug2(("DecodeFramePlayer: Player process is gone.\n"));
	}
	return 0;
}

int32 TNPlug_SeekPlayer (struct TNPlugIFace *Self, struct TuneNet *inTuneNet, uint32 seconds) {
	dbug(("SeekPlayer: Not implemented.\n"));
	return 0;
}
