;-------------------------------------------------------------------
;vbrCheck
;by Nightshft, 2025

;an Amiga cli program to check if the vbr is zero or has been moved.
;The released source of vbrMove helped me in writing this
;so thanks a lot to Arthur Hagen.

;exit status/return code is 
;  0 when vectorbase at 0
;  5 when vectorbase is moved / not zero

;----------------
;History:
;v1.0 22.3.2025
;initial version.

;v1.1 26.3.2025
;prints the vb adress (in hex) if it's not zero.

;v1.11 27.3.2025
;exit status/return code tells if vb is moved
;(f.e. for scripts)

;v1.12 27.3.2025
;slight code cleanup

;------------------------------------------------------------

                 machine    mc68000                                        ;most of pgm shall be compiled for target 000

                 incdir     include/
                 include    'lvos.i'
                 include    'exec/memory.i'
                 include    'exec/execbase.i'

VBRCheck:       
;main
                ;open doslib
                 movea.l    (4).w,a6                                       ;
                 lea        dosname(pc),a1                                 ;open dos.library
                 jsr        _LVOOldOpenLibrary(a6)
                 movea.l    d0,a4                                          ;a4..dosbase (we need a5 later for sth. else)
                 exg.l      a4,a6                                          ;a6..dos a4..exec
                 jsr        _LVOOutput(a6)                                 ;d0=output file handle
                 move.l     d0,varOutputhandle
                 exg.l      a4,a6                                          ;a6..exec a4..dos

                ;print title
                 moveq      #titleTxt_end-titleTxt,d3                      ;d3..textlen
                 lea        titleTxt(pc),a0                                ;a0..textaddr
                 bsr        writeit

	            ;check if cpu is > 000
                 btst       #AFB_68010,AttnFlags+1(a6)                
                 bne.s      checkVectorbase 

cpuis000       
;we cant do nottin'
                 moveq      #cpuIs000txt_end-cpuIs000txt,d3
                 lea        cpuIs000txt(pc),a0
                 bsr        writeit
                 bra        quit

checkVectorbase
;we are 010+. check vectorbase
;(only checkVB if cpu is 010+ - otherwise it would guru #0000.0004)

                 lea        getVbrSup(pc),a5                               ;jsr getVbrSup() in supervisor mode
                 jsr        _LVOSupervisor(a6)
	             ;d1 now is the VB
                 move.l     d1,varVectorbase
                 bne        vbIsInFastmem                                  ;if vb<>0

vbisZero
                 moveq      #vbIsZeroTxt_end-vbIsZeroTxt,d3                ;"vectorbase is at zero"
                 lea        vbIsZeroTxt(pc),a0
                 bsr        writeit

quit             movea.l    a4,a1
                 jsr        _LVOCloseLibrary(a6)
                 moveq      #0,d0
                 move.w     varExitcode,d0
                 rts                                                       ;program end

getVbrSup
                 machine    mc68010                                
                 movec      vbr,d1                                         ;works on 010+. on 000 this opcode leads to guru.
                 machine    mc68000
                 rte

vbIsInFastmem	
;print "Vectorbase is in Fastmem: $"+adress in hex

                 moveq      #vbInFastmemTxt_end-vbInFastmemTxt,d3          ;"vectorbase is in fastmem at $"
                 lea        vbInFastmemTxt(pc),a0
                 bsr.s      writeit

                 move.l     varVectorbase,d0
                 bsr.s      writeLongAsHexstring

                 move.w     #5,varExitcode
                 bra        quit

;--------------------------------------------------------------------------------                 

writeit	
;print the given string to output handle
;a0..textaddr
;d3..textlen
;returns d0
;preserves d1,d2
                 movem.l    d1-d2,-(SP)
                 move.l     varOutputhandle(pc),d1
                 move.l     a0,d2                                          ;d2..extaddr
                 exg.l      a4,a6                                          ;a6..dosbase
                 jsr        _LVOWrite(a6)
	             ;d0 returnedLength = dos.write(d1 file, d2 buffer/string, d3 length)
                 exg.l      a4,a6                                          ;a6..back to execbase
                 movem.l    (SP)+,d1-d2                
                 rts

writeLongAsHexstring
;assemble a hexstring
;input: d0 .. unsigned long (f.e. an adress)
;currently trashes a0,d0,d1,d3,d7
;written from scratch. "nogipity"
                 lea        minibuffer(pc),a0
                 moveq      #8-1,d7
.loop                
                 rol.l      #4,d0                                          ;get next nibble as lowest nibble
                 move.b     d0,d1                                          ;get that to d1
                 and.w      #$000f,d1                                      ;

                ;nibble to ascii
                ;map val 0..f   to those ascii chars
                 add.w      #$30,d1                                        ;map 0 to "0"
                 cmp.w      #$39,d1                                        ;if d1<=$39 ("9"): skip
                 bls        .skip
                 add.w      #$41-$3a,d1                                    ;otherwise map "9"+1 to "A"
.skip                                                                      ;we got our ascii char
                 move.b     d1,(a0)+                                       ;assemble string of 8 chars
                 dbra       d7,.loop

                 move.b     #$0a,(a0)+                                     ;add linefeed
                ;write string to std output
                 lea        minibuffer(pc),a0                              ;string
                 move.l     #9,d3                                          ;length                
                 jsr        writeit

                 rts

;-------------------------------
;data

varVectorbase    dc.l       0
varOutputhandle  dc.l       0
varExitcode      dc.w       0

minibuffer       ds.b       16
                 even

dosname          dc.b       'dos.library',0

titleTxt         dc.b       'VBRCheck 1.12 by Nightshft',$0A
titleTxt_end

vbIsZeroTxt      dc.b       'Vectorbase is at zero.',$0A
vbIsZeroTxt_end

vbInFastmemTxt   dc.b       'Vectorbase is in Fastmem at $'
vbInFastmemTxt_end

cpuIs000txt      dc.b       'Vectorbase is at zero (CPU is 68000).',$0A
cpuIs000txt_end

                 even

                 END
