/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.distcp2;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.distcp2.DistCpOptionSwitch;
import org.apache.hadoop.tools.distcp2.DistCpOptions;

public class OptionsParser {
    private static final Log LOG = LogFactory.getLog(OptionsParser.class);
    private static final Options cliOptions = new Options();

    public static DistCpOptions parse(String[] args) throws IllegalArgumentException {
        DistCpOptions option;
        CommandLine command;
        CustomParser parser = new CustomParser();
        try {
            command = parser.parse(cliOptions, args, true);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unable to parse arguments. " + Arrays.toString(args), e);
        }
        ArrayList<Path> sourcePaths = new ArrayList<Path>();
        String[] leftOverArgs = command.getArgs();
        if (leftOverArgs == null || leftOverArgs.length < 1) {
            throw new IllegalArgumentException("Target path not specified");
        }
        Path targetPath = new Path(leftOverArgs[leftOverArgs.length - 1].trim());
        for (int index = 0; index < leftOverArgs.length - 1; ++index) {
            sourcePaths.add(new Path(leftOverArgs[index].trim()));
        }
        if (command.hasOption(DistCpOptionSwitch.SOURCE_FILE_LISTING.getSwitch())) {
            if (!sourcePaths.isEmpty()) {
                throw new IllegalArgumentException("Both source file listing and source paths present");
            }
            option = new DistCpOptions(new Path(OptionsParser.getVal(command, DistCpOptionSwitch.SOURCE_FILE_LISTING.getSwitch())), targetPath);
        } else {
            if (sourcePaths.isEmpty()) {
                throw new IllegalArgumentException("Neither source file listing nor source paths present");
            }
            option = new DistCpOptions(sourcePaths, targetPath);
        }
        if (command.hasOption(DistCpOptionSwitch.IGNORE_FAILURES.getSwitch())) {
            option.setIgnoreFailures(true);
        }
        if (command.hasOption(DistCpOptionSwitch.ATOMIC_COMMIT.getSwitch())) {
            option.setAtomicCommit(true);
        }
        if (command.hasOption(DistCpOptionSwitch.WORK_PATH.getSwitch()) && option.shouldAtomicCommit()) {
            String workPath = OptionsParser.getVal(command, DistCpOptionSwitch.WORK_PATH.getSwitch());
            if (workPath != null && !workPath.isEmpty()) {
                option.setAtomicWorkPath(new Path(workPath));
            }
        } else if (command.hasOption(DistCpOptionSwitch.WORK_PATH.getSwitch())) {
            throw new IllegalArgumentException("-tmp work-path can only be specified along with -atomic");
        }
        if (command.hasOption(DistCpOptionSwitch.LOG_PATH.getSwitch())) {
            option.setLogPath(new Path(OptionsParser.getVal(command, DistCpOptionSwitch.LOG_PATH.getSwitch())));
        }
        if (command.hasOption(DistCpOptionSwitch.SYNC_FOLDERS.getSwitch())) {
            option.setSyncFolder(true);
        }
        if (command.hasOption(DistCpOptionSwitch.OVERWRITE.getSwitch())) {
            option.setOverwrite(true);
        }
        if (command.hasOption(DistCpOptionSwitch.DELETE_MISSING.getSwitch())) {
            option.setDeleteMissing(true);
        }
        if (command.hasOption(DistCpOptionSwitch.SKIP_CRC.getSwitch())) {
            option.setSkipCRC(true);
        }
        if (command.hasOption(DistCpOptionSwitch.BLOCKING.getSwitch())) {
            option.setBlocking(false);
        }
        if (command.hasOption(DistCpOptionSwitch.BANDWIDTH.getSwitch())) {
            try {
                Integer mapBandwidth = Integer.parseInt(OptionsParser.getVal(command, DistCpOptionSwitch.BANDWIDTH.getSwitch()).trim());
                if (mapBandwidth <= 0) {
                    throw new IllegalArgumentException("Bandwidth specified is not positive: " + mapBandwidth);
                }
                option.setMapBandwidth(mapBandwidth);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bandwidth specified is invalid: " + OptionsParser.getVal(command, DistCpOptionSwitch.BANDWIDTH.getSwitch()), e);
            }
        }
        if (command.hasOption(DistCpOptionSwitch.SSL_CONF.getSwitch())) {
            option.setSslConfigurationFile(command.getOptionValue(DistCpOptionSwitch.SSL_CONF.getSwitch()));
        }
        if (command.hasOption(DistCpOptionSwitch.MAX_MAPS.getSwitch())) {
            try {
                Integer maps = Integer.parseInt(OptionsParser.getVal(command, DistCpOptionSwitch.MAX_MAPS.getSwitch()).trim());
                option.setMaxMaps(maps);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Number of maps is invalid: " + OptionsParser.getVal(command, DistCpOptionSwitch.MAX_MAPS.getSwitch()), e);
            }
        }
        if (command.hasOption(DistCpOptionSwitch.COPY_STRATEGY.getSwitch())) {
            option.setCopyStrategy(OptionsParser.getVal(command, DistCpOptionSwitch.COPY_STRATEGY.getSwitch()));
        }
        if (command.hasOption(DistCpOptionSwitch.PRESERVE_STATUS.getSwitch())) {
            String attributes = OptionsParser.getVal(command, DistCpOptionSwitch.PRESERVE_STATUS.getSwitch());
            if (attributes == null || attributes.isEmpty()) {
                for (DistCpOptions.FileAttribute attribute : DistCpOptions.FileAttribute.values()) {
                    option.preserve(attribute);
                }
            } else {
                for (int index = 0; index < attributes.length(); ++index) {
                    option.preserve(DistCpOptions.FileAttribute.getAttribute(attributes.charAt(index)));
                }
            }
        }
        if (command.hasOption(DistCpOptionSwitch.FILE_LIMIT.getSwitch())) {
            String fileLimitString = OptionsParser.getVal(command, DistCpOptionSwitch.FILE_LIMIT.getSwitch().trim());
            try {
                Integer.parseInt(fileLimitString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("File-limit is invalid: " + fileLimitString, e);
            }
            LOG.warn(DistCpOptionSwitch.FILE_LIMIT.getSwitch() + " is a deprecated" + " option. Ignoring.");
        }
        if (command.hasOption(DistCpOptionSwitch.SIZE_LIMIT.getSwitch())) {
            String sizeLimitString = OptionsParser.getVal(command, DistCpOptionSwitch.SIZE_LIMIT.getSwitch().trim());
            try {
                Long.parseLong(sizeLimitString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Size-limit is invalid: " + sizeLimitString, e);
            }
            LOG.warn(DistCpOptionSwitch.SIZE_LIMIT.getSwitch() + " is a deprecated" + " option. Ignoring.");
        }
        return option;
    }

    private static String getVal(CommandLine command, String swtch) {
        String optionValue = command.getOptionValue(swtch);
        if (optionValue == null) {
            return null;
        }
        return optionValue.trim();
    }

    public static void usage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("distcp OPTIONS [source_path...] <target_path>\n\nOPTIONS", cliOptions);
    }

    static {
        for (DistCpOptionSwitch option : DistCpOptionSwitch.values()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding option " + option.getOption());
            }
            cliOptions.addOption(option.getOption());
        }
    }

    private static class CustomParser
    extends GnuParser {
        private CustomParser() {
        }

        @Override
        protected String[] flatten(Options options, String[] arguments, boolean stopAtNonOption) {
            for (int index = 0; index < arguments.length; ++index) {
                if (!arguments[index].equals("-" + DistCpOptionSwitch.PRESERVE_STATUS.getSwitch())) continue;
                arguments[index] = "-prbugp";
            }
            return super.flatten(options, arguments, stopAtNonOption);
        }
    }
}

