/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.distcp2.mapred;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.tools.distcp2.DistCpOptions;
import org.apache.hadoop.tools.distcp2.util.DistCpUtils;
import org.apache.hadoop.tools.distcp2.util.RetriableCommand;
import org.apache.hadoop.tools.distcp2.util.ThrottledInputStream;

public class RetriableFileCopyCommand
extends RetriableCommand {
    private static Log LOG = LogFactory.getLog(RetriableFileCopyCommand.class);
    private static int BUFFER_SIZE = 8192;
    private boolean skipCrc = false;

    public RetriableFileCopyCommand(String description) {
        super(description);
    }

    public RetriableFileCopyCommand(boolean skipCrc, String description) {
        this(description);
        this.skipCrc = skipCrc;
    }

    @Override
    protected Object doExecute(Object ... arguments) throws Exception {
        assert (arguments.length == 4) : "Unexpected argument list.";
        FileStatus source = (FileStatus)arguments[0];
        assert (!source.isDir()) : "Unexpected file-status. Expected file.";
        Path target = (Path)arguments[1];
        Mapper.Context context = (Mapper.Context)arguments[2];
        EnumSet fileAttributes = (EnumSet)arguments[3];
        return this.doCopy(source, target, context, fileAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doCopy(FileStatus sourceFileStatus, Path target, Mapper.Context context, EnumSet<DistCpOptions.FileAttribute> fileAttributes) throws IOException {
        Path tmpTargetPath = this.getTmpFile(target, context);
        Configuration configuration = context.getConfiguration();
        FileSystem targetFS = target.getFileSystem(configuration);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Copying " + sourceFileStatus.getPath() + " to " + target);
                LOG.debug("Tmp-file path: " + tmpTargetPath);
            }
            FileSystem sourceFS = sourceFileStatus.getPath().getFileSystem(configuration);
            long bytesRead = this.copyToTmpFile(tmpTargetPath, targetFS, sourceFileStatus, context, fileAttributes);
            this.compareFileLengths(sourceFileStatus, tmpTargetPath, configuration, bytesRead);
            if (bytesRead != 0L && !this.skipCrc) {
                this.compareCheckSums(sourceFS, sourceFileStatus.getPath(), targetFS, tmpTargetPath);
            }
            this.promoteTmpToTarget(tmpTargetPath, target, targetFS);
            long l = bytesRead;
            return l;
        }
        finally {
            if (targetFS.exists(tmpTargetPath)) {
                targetFS.delete(tmpTargetPath, false);
            }
        }
    }

    private long copyToTmpFile(Path tmpTargetPath, FileSystem targetFS, FileStatus sourceFileStatus, Mapper.Context context, EnumSet<DistCpOptions.FileAttribute> fileAttributes) throws IOException {
        BufferedOutputStream outStream = new BufferedOutputStream(targetFS.create(tmpTargetPath, true, BUFFER_SIZE, RetriableFileCopyCommand.getReplicationFactor(fileAttributes, sourceFileStatus, targetFS), RetriableFileCopyCommand.getBlockSize(fileAttributes, sourceFileStatus, targetFS), context));
        return this.copyBytes(sourceFileStatus, outStream, BUFFER_SIZE, context);
    }

    private void compareFileLengths(FileStatus sourceFileStatus, Path target, Configuration configuration, long bytesRead) throws IOException {
        Path sourcePath = sourceFileStatus.getPath();
        FileSystem fs = sourcePath.getFileSystem(configuration);
        if (fs.getFileStatus(sourcePath).getLen() != bytesRead) {
            throw new IOException("Mismatch in length of source:" + sourcePath + " and target:" + target);
        }
    }

    private void compareCheckSums(FileSystem sourceFS, Path source, FileSystem targetFS, Path target) throws IOException {
        if (!DistCpUtils.checksumsAreEqual(sourceFS, source, targetFS, target)) {
            throw new IOException("Check-sum mismatch between " + source + " and " + target);
        }
    }

    private void promoteTmpToTarget(Path tmpTarget, Path target, FileSystem fs) throws IOException {
        if (fs.exists(target) && !fs.delete(target, false) || !fs.exists(target.getParent()) && !fs.mkdirs(target.getParent()) || !fs.rename(tmpTarget, target)) {
            throw new IOException("Failed to promote tmp-file:" + tmpTarget + " to: " + target);
        }
    }

    private Path getTmpFile(Path target, Mapper.Context context) {
        Path targetWorkPath = new Path(context.getConfiguration().get("distcp.target.work.path"));
        Path root = target.equals(targetWorkPath) ? targetWorkPath.getParent() : targetWorkPath;
        LOG.info("Creating temp file: " + new Path(root, ".distcp.tmp." + context.getTaskAttemptID().toString()));
        return new Path(root, ".distcp.tmp." + context.getTaskAttemptID().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copyBytes(FileStatus sourceFileStatus, OutputStream outStream, int bufferSize, Mapper.Context context) throws IOException {
        Path source = sourceFileStatus.getPath();
        byte[] buf = new byte[bufferSize];
        ThrottledInputStream inStream = null;
        long totalBytesRead = 0L;
        try {
            inStream = RetriableFileCopyCommand.getInputStream(source, context.getConfiguration());
            int bytesRead = RetriableFileCopyCommand.readBytes(inStream, buf);
            while (bytesRead >= 0) {
                outStream.write(buf, 0, bytesRead);
                this.updateContextStatus(totalBytesRead += (long)bytesRead, context, sourceFileStatus);
                bytesRead = inStream.read(buf);
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(LOG, outStream, inStream);
            throw throwable;
        }
        IOUtils.cleanup(LOG, outStream, inStream);
        return totalBytesRead;
    }

    private void updateContextStatus(long totalBytesRead, Mapper.Context context, FileStatus sourceFileStatus) {
        StringBuilder message = new StringBuilder(DistCpUtils.getFormatter().format((float)totalBytesRead * 100.0f / (float)sourceFileStatus.getLen()));
        message.append("% ").append(this.description).append(" [").append(DistCpUtils.getStringDescriptionFor(totalBytesRead)).append('/').append(DistCpUtils.getStringDescriptionFor(sourceFileStatus.getLen())).append(']');
        context.setStatus(message.toString());
    }

    private static int readBytes(InputStream inStream, byte[] buf) throws IOException {
        try {
            return inStream.read(buf);
        }
        catch (IOException e) {
            throw new CopyReadException(e);
        }
    }

    private static ThrottledInputStream getInputStream(Path path, Configuration conf) throws IOException {
        try {
            FileSystem fs = path.getFileSystem(conf);
            long bandwidthMB = conf.getInt("distcp.map.bandwidth.mb", 100);
            return new ThrottledInputStream(new BufferedInputStream(fs.open(path)), bandwidthMB * 1024L * 1024L);
        }
        catch (IOException e) {
            throw new CopyReadException(e);
        }
    }

    private static short getReplicationFactor(EnumSet<DistCpOptions.FileAttribute> fileAttributes, FileStatus sourceFile, FileSystem targetFS) {
        return fileAttributes.contains((Object)DistCpOptions.FileAttribute.REPLICATION) ? sourceFile.getReplication() : targetFS.getDefaultReplication();
    }

    private static long getBlockSize(EnumSet<DistCpOptions.FileAttribute> fileAttributes, FileStatus sourceFile, FileSystem targetFS) {
        return fileAttributes.contains((Object)DistCpOptions.FileAttribute.BLOCKSIZE) ? sourceFile.getBlockSize() : targetFS.getDefaultBlockSize();
    }

    public static class CopyReadException
    extends IOException {
        public CopyReadException(Throwable rootCause) {
            super(rootCause);
        }
    }
}

