/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

public class GetImageServlet
extends HttpServlet {
    private static final long serialVersionUID = -7669068179452648952L;
    private static final Log LOG = LogFactory.getLog(GetImageServlet.class);
    private Object fsImageTransferLock = new Object();

    @Override
    public void doGet(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        Map pmap = request.getParameterMap();
        try {
            ServletContext context = this.getServletContext();
            final FSImage nnImage = (FSImage)context.getAttribute("name.system.image");
            final TransferFsImage ff = new TransferFsImage(pmap, request, response);
            final Configuration conf = (Configuration)this.getServletContext().getAttribute("current.conf");
            if (UserGroupInformation.isSecurityEnabled() && !this.isValidRequestor(request.getUserPrincipal().getName(), conf)) {
                response.sendError(403, "Only Namenode and Secondary Namenode may access this servlet");
                LOG.warn("Received non-NN/SNN request for image or edits from " + request.getUserPrincipal().getName() + " at " + request.getRemoteHost());
                return;
            }
            UserGroupInformation.getCurrentUser().doAs(new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    if (ff.getImage()) {
                        TransferFsImage.getFileServer(response.getOutputStream(), nnImage.getFsImageName(), GetImageServlet.this.getThrottler(conf));
                    } else if (ff.getEdit()) {
                        TransferFsImage.getFileServer(response.getOutputStream(), nnImage.getFsEditName(), GetImageServlet.this.getThrottler(conf));
                    } else if (ff.putImage()) {
                        Object object = GetImageServlet.this.fsImageTransferLock;
                        synchronized (object) {
                            final MD5Hash expectedChecksum = ff.getNewChecksum();
                            nnImage.validateCheckpointUpload(ff.getToken());
                            this.reloginIfNecessary().doAs(new PrivilegedExceptionAction<Void>(){

                                @Override
                                public Void run() throws Exception {
                                    MD5Hash actualChecksum = TransferFsImage.getFileClient(ff.getInfoServer(), "getimage=1", nnImage.getFsImageNameCheckpoint(), true);
                                    LOG.info("Downloaded new fsimage with checksum: " + actualChecksum);
                                    if (!actualChecksum.equals(expectedChecksum)) {
                                        throw new IOException("Actual checksum of transferred fsimage: " + actualChecksum + " does not match expected checksum: " + expectedChecksum);
                                    }
                                    return null;
                                }
                            });
                            nnImage.checkpointUploadDone();
                        }
                    }
                    return null;
                }

                private UserGroupInformation reloginIfNecessary() throws IOException {
                    return UserGroupInformation.loginUserFromKeytabAndReturnUGI(SecurityUtil.getServerPrincipal(conf.get("dfs.namenode.kerberos.principal"), NameNode.getAddress(conf).getHostName()), conf.get("dfs.namenode.keytab.file"));
                }
            });
        }
        catch (Throwable t) {
            String errMsg = "GetImage failed. " + StringUtils.stringifyException(t);
            response.sendError(410, errMsg);
            throw new IOException(errMsg);
        }
        finally {
            response.getOutputStream().close();
        }
    }

    private final DataTransferThrottler getThrottler(Configuration conf) {
        long transferBandwidth = conf.getLong("dfs.image.transfer.bandwidthPerSec", 0L);
        DataTransferThrottler throttler = null;
        if (transferBandwidth > 0L) {
            throttler = new DataTransferThrottler(transferBandwidth);
        }
        return throttler;
    }

    private boolean isValidRequestor(String remoteUser, Configuration conf) throws IOException {
        String[] validRequestors;
        if (remoteUser == null) {
            LOG.warn("Received null remoteUser while authorizing access to getImage servlet");
            return false;
        }
        for (String v : validRequestors = new String[]{SecurityUtil.getServerPrincipal(conf.get("dfs.namenode.kerberos.principal"), NameNode.getAddress(conf).getHostName()), SecurityUtil.getServerPrincipal(conf.get("dfs.secondary.namenode.kerberos.principal"), SecondaryNameNode.getHttpAddress(conf).getHostName())}) {
            if (v == null || !v.equals(remoteUser)) continue;
            LOG.info("GetImageServlet allowing: " + remoteUser);
            return true;
        }
        LOG.info("GetImageServlet rejecting: " + remoteUser);
        return false;
    }
}

