/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.MultiTransactionRecord;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.common.StringUtils;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.StatPersisted;
import org.apache.zookeeper.proto.CheckVersionRequest;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.CreateTTLRequest;
import org.apache.zookeeper.proto.DeleteRequest;
import org.apache.zookeeper.proto.ReconfigRequest;
import org.apache.zookeeper.proto.SetACLRequest;
import org.apache.zookeeper.proto.SetDataRequest;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.EphemeralType;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ZooKeeperCriticalThread;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.auth.AuthenticationProvider;
import org.apache.zookeeper.server.auth.ProviderRegistry;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.txn.CheckVersionTxn;
import org.apache.zookeeper.txn.CreateContainerTxn;
import org.apache.zookeeper.txn.CreateSessionTxn;
import org.apache.zookeeper.txn.CreateTTLTxn;
import org.apache.zookeeper.txn.CreateTxn;
import org.apache.zookeeper.txn.DeleteTxn;
import org.apache.zookeeper.txn.ErrorTxn;
import org.apache.zookeeper.txn.MultiTxn;
import org.apache.zookeeper.txn.SetACLTxn;
import org.apache.zookeeper.txn.SetDataTxn;
import org.apache.zookeeper.txn.Txn;
import org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepRequestProcessor
extends ZooKeeperCriticalThread
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(PrepRequestProcessor.class);
    static boolean skipACL = System.getProperty("zookeeper.skipACL", "no").equals("yes");
    private static boolean failCreate;
    LinkedBlockingQueue<Request> submittedRequests = new LinkedBlockingQueue();
    private final RequestProcessor nextProcessor;
    ZooKeeperServer zks;

    public PrepRequestProcessor(ZooKeeperServer zks, RequestProcessor nextProcessor) {
        super("ProcessThread(sid:" + zks.getServerId() + " cport:" + zks.getClientPort() + "):", zks.getZooKeeperServerListener());
        this.nextProcessor = nextProcessor;
        this.zks = zks;
    }

    public static void setFailCreate(boolean b) {
        failCreate = b;
    }

    @Override
    public void run() {
        try {
            while (true) {
                Request request = this.submittedRequests.take();
                long traceMask = 2L;
                if (request.type == 11) {
                    traceMask = 8L;
                }
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logRequest(LOG, traceMask, 'P', request, "");
                }
                if (Request.requestOfDeath != request) {
                    this.pRequest(request);
                    continue;
                }
                break;
            }
        }
        catch (RequestProcessor.RequestProcessorException e) {
            if (e.getCause() instanceof Leader.XidRolloverException) {
                LOG.info(e.getCause().getMessage());
            }
            this.handleException(this.getName(), e);
        }
        catch (Exception e) {
            this.handleException(this.getName(), e);
        }
        LOG.info("PrepRequestProcessor exited loop!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZooKeeperServer.ChangeRecord getRecordForPath(String path) throws KeeperException.NoNodeException {
        ZooKeeperServer.ChangeRecord lastChange = null;
        List<ZooKeeperServer.ChangeRecord> list = this.zks.outstandingChanges;
        synchronized (list) {
            DataNode n;
            lastChange = this.zks.outstandingChangesForPath.get(path);
            if (lastChange == null && (n = this.zks.getZKDatabase().getNode(path)) != null) {
                Set<String> children;
                DataNode dataNode = n;
                synchronized (dataNode) {
                    children = n.getChildren();
                }
                lastChange = new ZooKeeperServer.ChangeRecord(-1L, path, n.stat, children.size(), this.zks.getZKDatabase().aclForNode(n));
            }
        }
        if (lastChange == null || lastChange.stat == null) {
            throw new KeeperException.NoNodeException(path);
        }
        return lastChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZooKeeperServer.ChangeRecord getOutstandingChange(String path) {
        List<ZooKeeperServer.ChangeRecord> list = this.zks.outstandingChanges;
        synchronized (list) {
            return this.zks.outstandingChangesForPath.get(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChangeRecord(ZooKeeperServer.ChangeRecord c) {
        List<ZooKeeperServer.ChangeRecord> list = this.zks.outstandingChanges;
        synchronized (list) {
            this.zks.outstandingChanges.add(c);
            this.zks.outstandingChangesForPath.put(c.path, c);
        }
    }

    private Map<String, ZooKeeperServer.ChangeRecord> getPendingChanges(MultiTransactionRecord multiRequest) {
        HashMap<String, ZooKeeperServer.ChangeRecord> pendingChangeRecords = new HashMap<String, ZooKeeperServer.ChangeRecord>();
        for (Op op : multiRequest) {
            String parentPath;
            ZooKeeperServer.ChangeRecord parentCr;
            int lastSlash;
            String path = op.getPath();
            ZooKeeperServer.ChangeRecord cr = this.getOutstandingChange(path);
            if (cr != null) {
                pendingChangeRecords.put(path, cr);
            }
            if ((lastSlash = path.lastIndexOf(47)) == -1 || path.indexOf(0) != -1 || (parentCr = this.getOutstandingChange(parentPath = path.substring(0, lastSlash))) == null) continue;
            pendingChangeRecords.put(parentPath, parentCr);
        }
        return pendingChangeRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackPendingChanges(long zxid, Map<String, ZooKeeperServer.ChangeRecord> pendingChangeRecords) {
        List<ZooKeeperServer.ChangeRecord> list = this.zks.outstandingChanges;
        synchronized (list) {
            ListIterator<ZooKeeperServer.ChangeRecord> iter = this.zks.outstandingChanges.listIterator(this.zks.outstandingChanges.size());
            while (iter.hasPrevious()) {
                ZooKeeperServer.ChangeRecord c = iter.previous();
                if (c.zxid != zxid) break;
                iter.remove();
                this.zks.outstandingChangesForPath.remove(c.path);
            }
            if (this.zks.outstandingChanges.isEmpty()) {
                return;
            }
            long firstZxid = this.zks.outstandingChanges.get((int)0).zxid;
            for (ZooKeeperServer.ChangeRecord c : pendingChangeRecords.values()) {
                if (c.zxid < firstZxid) continue;
                this.zks.outstandingChangesForPath.put(c.path, c);
            }
        }
    }

    static void checkACL(ZooKeeperServer zks, List<ACL> acl, int perm, List<Id> ids) throws KeeperException.NoAuthException {
        if (skipACL) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Permission requested: {} ", (Object)perm);
            LOG.debug("ACLs for node: {}", acl);
            LOG.debug("Client credentials: {}", ids);
        }
        if (acl == null || acl.size() == 0) {
            return;
        }
        for (Id authId : ids) {
            if (!authId.getScheme().equals("super")) continue;
            return;
        }
        for (ACL a : acl) {
            Id id = a.getId();
            if ((a.getPerms() & perm) == 0) continue;
            if (id.getScheme().equals("world") && id.getId().equals("anyone")) {
                return;
            }
            AuthenticationProvider ap = ProviderRegistry.getProvider(id.getScheme());
            if (ap == null) continue;
            for (Id authId : ids) {
                if (!authId.getScheme().equals(id.getScheme()) || !ap.matches(authId.getId(), id.getId())) continue;
                return;
            }
        }
        throw new KeeperException.NoAuthException();
    }

    private String validatePathForCreate(String path, long sessionId) throws KeeperException.BadArgumentsException {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash == -1 || path.indexOf(0) != -1 || failCreate) {
            LOG.info("Invalid path %s with session 0x%s", (Object)path, (Object)Long.toHexString(sessionId));
            throw new KeeperException.BadArgumentsException(path);
        }
        return path.substring(0, lastSlash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pRequest2Txn(int type, long zxid, Request request, Record record, boolean deserialize) throws KeeperException, IOException, RequestProcessor.RequestProcessorException {
        request.setHdr(new TxnHeader(request.sessionId, request.cxid, zxid, Time.currentWallTime(), type));
        switch (type) {
            case 1: 
            case 15: 
            case 19: 
            case 21: {
                this.pRequest2TxnCreate(type, request, record, deserialize);
                break;
            }
            case 20: {
                String path = new String(request.request.array());
                String parentPath = this.getParentPathAndValidate(path);
                ZooKeeperServer.ChangeRecord parentRecord = this.getRecordForPath(parentPath);
                ZooKeeperServer.ChangeRecord nodeRecord = this.getRecordForPath(path);
                if (nodeRecord.childCount > 0) {
                    throw new KeeperException.NotEmptyException(path);
                }
                if (EphemeralType.get(nodeRecord.stat.getEphemeralOwner()) == EphemeralType.NORMAL) {
                    throw new KeeperException.BadVersionException(path);
                }
                request.setTxn(new DeleteTxn(path));
                parentRecord = parentRecord.duplicate(request.getHdr().getZxid());
                --parentRecord.childCount;
                this.addChangeRecord(parentRecord);
                this.addChangeRecord(new ZooKeeperServer.ChangeRecord(request.getHdr().getZxid(), path, null, -1, null));
                break;
            }
            case 2: {
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                DeleteRequest deleteRequest = (DeleteRequest)record;
                if (deserialize) {
                    ByteBufferInputStream.byteBuffer2Record(request.request, deleteRequest);
                }
                String path = deleteRequest.getPath();
                String parentPath = this.getParentPathAndValidate(path);
                ZooKeeperServer.ChangeRecord parentRecord = this.getRecordForPath(parentPath);
                ZooKeeperServer.ChangeRecord nodeRecord = this.getRecordForPath(path);
                PrepRequestProcessor.checkACL(this.zks, parentRecord.acl, 8, request.authInfo);
                PrepRequestProcessor.checkAndIncVersion(nodeRecord.stat.getVersion(), deleteRequest.getVersion(), path);
                if (nodeRecord.childCount > 0) {
                    throw new KeeperException.NotEmptyException(path);
                }
                request.setTxn(new DeleteTxn(path));
                parentRecord = parentRecord.duplicate(request.getHdr().getZxid());
                --parentRecord.childCount;
                this.addChangeRecord(parentRecord);
                this.addChangeRecord(new ZooKeeperServer.ChangeRecord(request.getHdr().getZxid(), path, null, -1, null));
                break;
            }
            case 5: {
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                SetDataRequest setDataRequest = (SetDataRequest)record;
                if (deserialize) {
                    ByteBufferInputStream.byteBuffer2Record(request.request, setDataRequest);
                }
                String path = setDataRequest.getPath();
                this.validatePath(path, request.sessionId);
                ZooKeeperServer.ChangeRecord nodeRecord = this.getRecordForPath(path);
                PrepRequestProcessor.checkACL(this.zks, nodeRecord.acl, 2, request.authInfo);
                int newVersion = PrepRequestProcessor.checkAndIncVersion(nodeRecord.stat.getVersion(), setDataRequest.getVersion(), path);
                request.setTxn(new SetDataTxn(path, setDataRequest.getData(), newVersion));
                nodeRecord = nodeRecord.duplicate(request.getHdr().getZxid());
                nodeRecord.stat.setVersion(newVersion);
                this.addChangeRecord(nodeRecord);
                break;
            }
            case 16: {
                String msg;
                LeaderZooKeeperServer lzks;
                if (!QuorumPeerConfig.isReconfigEnabled()) {
                    LOG.error("Reconfig operation requested but reconfig feature is disabled.");
                    throw new KeeperException.ReconfigDisabledException();
                }
                if (skipACL) {
                    LOG.warn("skipACL is set, reconfig operation will skip ACL checks!");
                }
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                ReconfigRequest reconfigRequest = (ReconfigRequest)record;
                try {
                    lzks = (LeaderZooKeeperServer)this.zks;
                }
                catch (ClassCastException e) {
                    throw new KeeperException.UnimplementedException();
                }
                QuorumVerifier lastSeenQV = lzks.self.getLastSeenQuorumVerifier();
                if (lastSeenQV.getVersion() != lzks.self.getQuorumVerifier().getVersion()) {
                    throw new KeeperException.ReconfigInProgress();
                }
                long configId = reconfigRequest.getCurConfigId();
                if (configId != -1L && configId != lzks.self.getLastSeenQuorumVerifier().getVersion()) {
                    String msg2 = "Reconfiguration from version " + configId + " failed -- last seen version is " + lzks.self.getLastSeenQuorumVerifier().getVersion();
                    throw new KeeperException.BadVersionException(msg2);
                }
                String newMembers = reconfigRequest.getNewMembers();
                if (newMembers != null) {
                    LOG.info("Non-incremental reconfig");
                    newMembers = newMembers.replaceAll(",", "\n");
                    try {
                        Properties props = new Properties();
                        props.load(new StringReader(newMembers));
                        request.qv = QuorumPeerConfig.parseDynamicConfig(props, lzks.self.getElectionType(), true, false);
                        request.qv.setVersion(request.getHdr().getZxid());
                    }
                    catch (IOException e) {
                        throw new KeeperException.BadArgumentsException(e.getMessage());
                    }
                    catch (QuorumPeerConfig.ConfigException e) {
                        throw new KeeperException.BadArgumentsException(e.getMessage());
                    }
                }
                LOG.info("Incremental reconfig");
                List<String> joiningServers = null;
                String joiningServersString = reconfigRequest.getJoiningServers();
                if (joiningServersString != null) {
                    joiningServers = StringUtils.split(joiningServersString, ",");
                }
                List<String> leavingServers = null;
                String leavingServersString = reconfigRequest.getLeavingServers();
                if (leavingServersString != null) {
                    leavingServers = StringUtils.split(leavingServersString, ",");
                }
                if (!(lastSeenQV instanceof QuorumMaj)) {
                    String msg3 = "Incremental reconfiguration requested but last configuration seen has a non-majority quorum system";
                    LOG.warn(msg3);
                    throw new KeeperException.BadArgumentsException(msg3);
                }
                HashMap<Long, QuorumPeer.QuorumServer> nextServers = new HashMap<Long, QuorumPeer.QuorumServer>(lastSeenQV.getAllMembers());
                try {
                    if (leavingServers != null) {
                        for (String leaving : leavingServers) {
                            long sid = Long.parseLong(leaving);
                            nextServers.remove(sid);
                        }
                    }
                    if (joiningServers != null) {
                        for (String joiner : joiningServers) {
                            String[] parts = StringUtils.split(joiner, "=").toArray(new String[0]);
                            if (parts.length != 2) {
                                throw new KeeperException.BadArgumentsException("Wrong format of server string");
                            }
                            Long sid = Long.parseLong(parts[0].substring(parts[0].lastIndexOf(46) + 1));
                            QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer((long)sid, parts[1]);
                            if (qs.clientAddr == null || qs.electionAddr == null || qs.addr == null) {
                                throw new KeeperException.BadArgumentsException("Wrong format of server string - each server should have 3 ports specified");
                            }
                            for (QuorumPeer.QuorumServer nqs : nextServers.values()) {
                                if (qs.id == nqs.id) continue;
                                qs.checkAddressDuplicate(nqs);
                            }
                            nextServers.remove(qs.id);
                            nextServers.put(qs.id, qs);
                        }
                    }
                }
                catch (QuorumPeerConfig.ConfigException e) {
                    throw new KeeperException.BadArgumentsException("Reconfiguration failed");
                }
                request.qv = new QuorumMaj(nextServers);
                request.qv.setVersion(request.getHdr().getZxid());
                if (QuorumPeerConfig.isStandaloneEnabled() && request.qv.getVotingMembers().size() < 2) {
                    msg = "Reconfig failed - new configuration must include at least 2 followers";
                    LOG.warn(msg);
                    throw new KeeperException.BadArgumentsException(msg);
                }
                if (request.qv.getVotingMembers().size() < 1) {
                    msg = "Reconfig failed - new configuration must include at least 1 follower";
                    LOG.warn(msg);
                    throw new KeeperException.BadArgumentsException(msg);
                }
                if (!lzks.getLeader().isQuorumSynced(request.qv)) {
                    String msg2 = "Reconfig failed - there must be a connected and synced quorum in new configuration";
                    LOG.warn(msg2);
                    throw new KeeperException.NewConfigNoQuorum();
                }
                ZooKeeperServer.ChangeRecord nodeRecord = this.getRecordForPath("/zookeeper/config");
                PrepRequestProcessor.checkACL(this.zks, nodeRecord.acl, 2, request.authInfo);
                request.setTxn(new SetDataTxn("/zookeeper/config", request.qv.toString().getBytes(), -1));
                nodeRecord = nodeRecord.duplicate(request.getHdr().getZxid());
                nodeRecord.stat.setVersion(-1);
                this.addChangeRecord(nodeRecord);
                break;
            }
            case 7: {
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                SetACLRequest setAclRequest = (SetACLRequest)record;
                if (deserialize) {
                    ByteBufferInputStream.byteBuffer2Record(request.request, setAclRequest);
                }
                String path = setAclRequest.getPath();
                this.validatePath(path, request.sessionId);
                List<ACL> listACL = this.fixupACL(path, request.authInfo, setAclRequest.getAcl());
                ZooKeeperServer.ChangeRecord nodeRecord = this.getRecordForPath(path);
                PrepRequestProcessor.checkACL(this.zks, nodeRecord.acl, 16, request.authInfo);
                int newVersion = PrepRequestProcessor.checkAndIncVersion(nodeRecord.stat.getAversion(), setAclRequest.getVersion(), path);
                request.setTxn(new SetACLTxn(path, listACL, newVersion));
                nodeRecord = nodeRecord.duplicate(request.getHdr().getZxid());
                nodeRecord.stat.setAversion(newVersion);
                this.addChangeRecord(nodeRecord);
                break;
            }
            case -10: {
                request.request.rewind();
                int to = request.request.getInt();
                request.setTxn(new CreateSessionTxn(to));
                request.request.rewind();
                if (request.isLocalSession()) {
                    this.zks.sessionTracker.addSession(request.sessionId, to);
                } else {
                    this.zks.sessionTracker.addGlobalSession(request.sessionId, to);
                }
                this.zks.setOwner(request.sessionId, request.getOwner());
                break;
            }
            case -11: {
                Set<String> es = this.zks.getZKDatabase().getEphemerals(request.sessionId);
                List<ZooKeeperServer.ChangeRecord> nextServers = this.zks.outstandingChanges;
                synchronized (nextServers) {
                    for (ZooKeeperServer.ChangeRecord c : this.zks.outstandingChanges) {
                        if (c.stat == null) {
                            es.remove(c.path);
                            continue;
                        }
                        if (c.stat.getEphemeralOwner() != request.sessionId) continue;
                        es.add(c.path);
                    }
                    for (String path2Delete : es) {
                        this.addChangeRecord(new ZooKeeperServer.ChangeRecord(request.getHdr().getZxid(), path2Delete, null, 0, null));
                    }
                    this.zks.sessionTracker.setSessionClosing(request.sessionId);
                }
                LOG.info("Processed session termination for sessionid: 0x" + Long.toHexString(request.sessionId));
                break;
            }
            case 13: {
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                CheckVersionRequest checkVersionRequest = (CheckVersionRequest)record;
                if (deserialize) {
                    ByteBufferInputStream.byteBuffer2Record(request.request, checkVersionRequest);
                }
                String path = checkVersionRequest.getPath();
                this.validatePath(path, request.sessionId);
                ZooKeeperServer.ChangeRecord nodeRecord = this.getRecordForPath(path);
                PrepRequestProcessor.checkACL(this.zks, nodeRecord.acl, 1, request.authInfo);
                request.setTxn(new CheckVersionTxn(path, PrepRequestProcessor.checkAndIncVersion(nodeRecord.stat.getVersion(), checkVersionRequest.getVersion(), path)));
                break;
            }
            default: {
                LOG.warn("unknown type " + type);
            }
        }
    }

    private void pRequest2TxnCreate(int type, Request request, Record record, boolean deserialize) throws IOException, KeeperException {
        boolean ephemeralParent;
        long ttl;
        byte[] data;
        List<ACL> acl;
        String path;
        int flags;
        if (deserialize) {
            ByteBufferInputStream.byteBuffer2Record(request.request, record);
        }
        if (type == 21) {
            CreateTTLRequest createTtlRequest = (CreateTTLRequest)record;
            flags = createTtlRequest.getFlags();
            path = createTtlRequest.getPath();
            acl = createTtlRequest.getAcl();
            data = createTtlRequest.getData();
            ttl = createTtlRequest.getTtl();
        } else {
            CreateRequest createRequest = (CreateRequest)record;
            flags = createRequest.getFlags();
            path = createRequest.getPath();
            acl = createRequest.getAcl();
            data = createRequest.getData();
            ttl = 0L;
        }
        CreateMode createMode = CreateMode.fromFlag(flags);
        this.validateCreateRequest(createMode, request);
        String parentPath = this.validatePathForCreate(path, request.sessionId);
        List<ACL> listACL = this.fixupACL(path, request.authInfo, acl);
        ZooKeeperServer.ChangeRecord parentRecord = this.getRecordForPath(parentPath);
        PrepRequestProcessor.checkACL(this.zks, parentRecord.acl, 4, request.authInfo);
        int parentCVersion = parentRecord.stat.getCversion();
        if (createMode.isSequential()) {
            path = path + String.format(Locale.ENGLISH, "%010d", parentCVersion);
        }
        this.validatePath(path, request.sessionId);
        try {
            if (this.getRecordForPath(path) != null) {
                throw new KeeperException.NodeExistsException(path);
            }
        }
        catch (KeeperException.NoNodeException e) {
            // empty catch block
        }
        boolean bl = ephemeralParent = EphemeralType.get(parentRecord.stat.getEphemeralOwner()) == EphemeralType.NORMAL;
        if (ephemeralParent) {
            throw new KeeperException.NoChildrenForEphemeralsException(path);
        }
        int newCversion = parentRecord.stat.getCversion() + 1;
        if (type == 19) {
            request.setTxn(new CreateContainerTxn(path, data, listACL, newCversion));
        } else if (type == 21) {
            request.setTxn(new CreateTTLTxn(path, data, listACL, newCversion, ttl));
        } else {
            request.setTxn(new CreateTxn(path, data, listACL, createMode.isEphemeral(), newCversion));
        }
        StatPersisted s = new StatPersisted();
        if (createMode.isEphemeral()) {
            s.setEphemeralOwner(request.sessionId);
        }
        parentRecord = parentRecord.duplicate(request.getHdr().getZxid());
        ++parentRecord.childCount;
        parentRecord.stat.setCversion(newCversion);
        this.addChangeRecord(parentRecord);
        this.addChangeRecord(new ZooKeeperServer.ChangeRecord(request.getHdr().getZxid(), path, s, 0, listACL));
    }

    private void validatePath(String path, long sessionId) throws KeeperException.BadArgumentsException {
        try {
            PathUtils.validatePath(path);
        }
        catch (IllegalArgumentException ie) {
            LOG.info("Invalid path {} with session 0x{}, reason: {}", new Object[]{path, Long.toHexString(sessionId), ie.getMessage()});
            throw new KeeperException.BadArgumentsException(path);
        }
    }

    private String getParentPathAndValidate(String path) throws KeeperException.BadArgumentsException {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash == -1 || path.indexOf(0) != -1 || this.zks.getZKDatabase().isSpecialPath(path)) {
            throw new KeeperException.BadArgumentsException(path);
        }
        return path.substring(0, lastSlash);
    }

    private static int checkAndIncVersion(int currentVersion, int expectedVersion, String path) throws KeeperException.BadVersionException {
        if (expectedVersion != -1 && expectedVersion != currentVersion) {
            throw new KeeperException.BadVersionException(path);
        }
        return currentVersion + 1;
    }

    protected void pRequest(Request request) throws RequestProcessor.RequestProcessorException {
        block27: {
            request.setHdr(null);
            request.setTxn(null);
            try {
                switch (request.type) {
                    case 1: 
                    case 15: 
                    case 19: {
                        CreateRequest create2Request = new CreateRequest();
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, create2Request, true);
                        break;
                    }
                    case 21: {
                        CreateTTLRequest createTtlRequest = new CreateTTLRequest();
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, createTtlRequest, true);
                        break;
                    }
                    case 2: 
                    case 20: {
                        DeleteRequest deleteRequest = new DeleteRequest();
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, deleteRequest, true);
                        break;
                    }
                    case 5: {
                        SetDataRequest setDataRequest = new SetDataRequest();
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, setDataRequest, true);
                        break;
                    }
                    case 16: {
                        ReconfigRequest reconfigRequest = new ReconfigRequest();
                        ByteBufferInputStream.byteBuffer2Record(request.request, reconfigRequest);
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, reconfigRequest, true);
                        break;
                    }
                    case 7: {
                        SetACLRequest setAclRequest = new SetACLRequest();
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, setAclRequest, true);
                        break;
                    }
                    case 13: {
                        CheckVersionRequest checkRequest = new CheckVersionRequest();
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, checkRequest, true);
                        break;
                    }
                    case 14: {
                        MultiTransactionRecord multiRequest = new MultiTransactionRecord();
                        try {
                            ByteBufferInputStream.byteBuffer2Record(request.request, multiRequest);
                        }
                        catch (IOException e) {
                            request.setHdr(new TxnHeader(request.sessionId, request.cxid, this.zks.getNextZxid(), Time.currentWallTime(), 14));
                            throw e;
                        }
                        ArrayList<Txn> txns = new ArrayList<Txn>();
                        long zxid = this.zks.getNextZxid();
                        KeeperException ke = null;
                        Map<String, ZooKeeperServer.ChangeRecord> pendingChanges = this.getPendingChanges(multiRequest);
                        for (Op op : multiRequest) {
                            Record txn;
                            int type;
                            Record subrequest = op.toRequestRecord();
                            if (ke != null) {
                                type = -1;
                                txn = new ErrorTxn(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue());
                            } else {
                                try {
                                    this.pRequest2Txn(op.getType(), zxid, request, subrequest, false);
                                    type = request.getHdr().getType();
                                    txn = request.getTxn();
                                }
                                catch (KeeperException e) {
                                    ke = e;
                                    type = -1;
                                    txn = new ErrorTxn(e.code().intValue());
                                    LOG.info("Got user-level KeeperException when processing " + request.toString() + " aborting remaining multi ops." + " Error Path:" + e.getPath() + " Error:" + e.getMessage());
                                    request.setException(e);
                                    this.rollbackPendingChanges(zxid, pendingChanges);
                                }
                            }
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
                            txn.serialize(boa, "request");
                            ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
                            txns.add(new Txn(type, bb.array()));
                        }
                        request.setHdr(new TxnHeader(request.sessionId, request.cxid, zxid, Time.currentWallTime(), request.type));
                        request.setTxn(new MultiTxn(txns));
                        break;
                    }
                    case -11: 
                    case -10: {
                        if (!request.isLocalSession()) {
                            this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, null, true);
                        }
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 17: 
                    case 18: 
                    case 101: {
                        this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                        break;
                    }
                    default: {
                        LOG.warn("unknown type " + request.type);
                        break;
                    }
                }
            }
            catch (KeeperException e) {
                if (request.getHdr() != null) {
                    request.getHdr().setType(-1);
                    request.setTxn(new ErrorTxn(e.code().intValue()));
                }
                LOG.info("Got user-level KeeperException when processing " + request.toString() + " Error Path:" + e.getPath() + " Error:" + e.getMessage());
                request.setException(e);
            }
            catch (Exception e) {
                LOG.error("Failed to process " + request, (Throwable)e);
                StringBuilder sb = new StringBuilder();
                ByteBuffer bb = request.request;
                if (bb != null) {
                    bb.rewind();
                    while (bb.hasRemaining()) {
                        sb.append(Integer.toHexString(bb.get() & 0xFF));
                    }
                } else {
                    sb.append("request buffer is null");
                }
                LOG.error("Dumping request buffer: 0x" + sb.toString());
                if (request.getHdr() == null) break block27;
                request.getHdr().setType(-1);
                request.setTxn(new ErrorTxn(KeeperException.Code.MARSHALLINGERROR.intValue()));
            }
        }
        request.zxid = this.zks.getZxid();
        this.nextProcessor.processRequest(request);
    }

    private List<ACL> removeDuplicates(List<ACL> acl) {
        ArrayList<ACL> retval = new ArrayList<ACL>();
        for (ACL a : acl) {
            if (retval.contains(a)) continue;
            retval.add(a);
        }
        return retval;
    }

    private void validateCreateRequest(CreateMode createMode, Request request) throws KeeperException {
        if (createMode.isEphemeral()) {
            if (request.getException() != null) {
                throw request.getException();
            }
            this.zks.sessionTracker.checkGlobalSession(request.sessionId, request.getOwner());
        } else {
            this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
        }
    }

    private List<ACL> fixupACL(String path, List<Id> authInfo, List<ACL> acls) throws KeeperException.InvalidACLException {
        List<ACL> uniqacls = this.removeDuplicates(acls);
        LinkedList<ACL> rv = new LinkedList<ACL>();
        if (uniqacls == null || uniqacls.size() == 0) {
            throw new KeeperException.InvalidACLException(path);
        }
        for (ACL a : uniqacls) {
            LOG.debug("Processing ACL: {}", (Object)a);
            if (a == null) {
                throw new KeeperException.InvalidACLException(path);
            }
            Id id = a.getId();
            if (id == null || id.getScheme() == null) {
                throw new KeeperException.InvalidACLException(path);
            }
            if (id.getScheme().equals("world") && id.getId().equals("anyone")) {
                rv.add(a);
                continue;
            }
            if (id.getScheme().equals("auth")) {
                boolean authIdValid = false;
                for (Id cid : authInfo) {
                    AuthenticationProvider ap = ProviderRegistry.getProvider(cid.getScheme());
                    if (ap == null) {
                        LOG.error("Missing AuthenticationProvider for " + cid.getScheme());
                        continue;
                    }
                    if (!ap.isAuthenticated()) continue;
                    authIdValid = true;
                    rv.add(new ACL(a.getPerms(), cid));
                }
                if (authIdValid) continue;
                throw new KeeperException.InvalidACLException(path);
            }
            AuthenticationProvider ap = ProviderRegistry.getProvider(id.getScheme());
            if (ap == null || !ap.isValid(id.getId())) {
                throw new KeeperException.InvalidACLException(path);
            }
            rv.add(a);
        }
        return rv;
    }

    @Override
    public void processRequest(Request request) {
        this.submittedRequests.add(request);
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down");
        this.submittedRequests.clear();
        this.submittedRequests.add(Request.requestOfDeath);
        this.nextProcessor.shutdown();
    }

    static {
        if (skipACL) {
            LOG.info("zookeeper.skipACL==\"yes\", ACL checks will be skipped");
        }
        failCreate = false;
    }
}

