/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service;

import com.twitter.finagle.builder.Server;
import java.io.File;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.shims.zk.ZooKeeperServerShim;
import org.apache.bookkeeper.stats.NullStatsProvider;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.util.LocalBookKeeper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LocalDLMEmulator;
import org.apache.distributedlog.client.routing.RoutingService;
import org.apache.distributedlog.client.routing.SingleHostRoutingService;
import org.apache.distributedlog.impl.metadata.BKDLConfig;
import org.apache.distributedlog.metadata.DLMetadata;
import org.apache.distributedlog.service.DLSocketAddress;
import org.apache.distributedlog.service.DistributedLogServer;
import org.apache.distributedlog.service.DistributedLogServiceImpl;
import org.apache.distributedlog.service.config.ServerConfiguration;
import org.apache.distributedlog.service.placement.EqualLoadAppraiser;
import org.apache.distributedlog.service.streamset.IdentityStreamPartitionConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedLogCluster {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedLogCluster.class);
    private final DistributedLogConfiguration dlConf;
    private final ZooKeeperServerShim zks;
    private final LocalDLMEmulator dlmEmulator;
    private DLServer dlServer;
    private final boolean shouldStartProxy;
    private final int proxyPort;
    private final boolean thriftmux;
    private final List<File> tmpDirs = new ArrayList<File>();

    public static Builder newBuilder() {
        return new Builder();
    }

    private DistributedLogCluster(DistributedLogConfiguration dlConf, org.apache.bookkeeper.conf.ServerConfiguration bkConf, int numBookies, boolean shouldStartZK, String zkServers, int zkPort, boolean shouldStartProxy, int proxyPort, boolean thriftmux) throws Exception {
        this.dlConf = dlConf;
        if (shouldStartZK) {
            File zkTmpDir = IOUtils.createTempDir((String)"zookeeper", (String)"distrlog");
            this.tmpDirs.add(zkTmpDir);
            if (0 == zkPort) {
                Pair serverAndPort = LocalDLMEmulator.runZookeeperOnAnyPort((File)zkTmpDir);
                this.zks = (ZooKeeperServerShim)serverAndPort.getLeft();
                zkPort = (Integer)serverAndPort.getRight();
            } else {
                this.zks = LocalBookKeeper.runZookeeper((int)1000, (int)zkPort, (File)zkTmpDir);
            }
        } else {
            this.zks = null;
        }
        this.dlmEmulator = LocalDLMEmulator.newBuilder().numBookies(numBookies).zkHost(zkServers).zkPort(zkPort).serverConf(bkConf).shouldStartZK(false).build();
        this.shouldStartProxy = shouldStartProxy;
        this.proxyPort = proxyPort;
        this.thriftmux = thriftmux;
    }

    public void start() throws Exception {
        this.dlmEmulator.start();
        BKDLConfig bkdlConfig = new BKDLConfig(this.dlmEmulator.getZkServers(), "/ledgers").setACLRootPath(".acl");
        DLMetadata.create((BKDLConfig)bkdlConfig).update(this.dlmEmulator.getUri());
        this.dlServer = this.shouldStartProxy ? new DLServer(this.dlConf, this.dlmEmulator.getUri(), this.proxyPort, this.thriftmux) : null;
    }

    public void stop() throws Exception {
        if (null != this.dlServer) {
            this.dlServer.shutdown();
        }
        this.dlmEmulator.teardown();
        if (null != this.zks) {
            this.zks.stop();
        }
        for (File dir : this.tmpDirs) {
            FileUtils.forceDeleteOnExit((File)dir);
        }
    }

    public URI getUri() {
        return this.dlmEmulator.getUri();
    }

    public String getZkServers() {
        return this.dlmEmulator.getZkServers();
    }

    public String getProxyFinagleStr() {
        return "inet!" + (this.dlServer == null ? "127.0.0.1:" + this.proxyPort : this.dlServer.getAddress().toString());
    }

    public static class DLServer {
        static final int MAX_RETRIES = 20;
        static final int MIN_PORT = 1025;
        static final int MAX_PORT = 65535;
        int proxyPort;
        public final InetSocketAddress address;
        public final Pair<DistributedLogServiceImpl, Server> dlServer;
        private final SingleHostRoutingService routingService = SingleHostRoutingService.of(null);

        protected DLServer(DistributedLogConfiguration dlConf, URI uri, int basePort, boolean thriftmux) throws Exception {
            this.proxyPort = basePort;
            boolean success = false;
            int retries = 0;
            Pair<DistributedLogServiceImpl, Server> serverPair = null;
            while (!success) {
                try {
                    ServerConfiguration serverConf = new ServerConfiguration();
                    serverConf.loadConf(dlConf);
                    serverConf.setServerShardId(this.proxyPort);
                    serverPair = DistributedLogServer.runServer(serverConf, dlConf, uri, new IdentityStreamPartitionConverter(), (RoutingService)this.routingService, (StatsProvider)new NullStatsProvider(), this.proxyPort, thriftmux, new EqualLoadAppraiser());
                    this.routingService.setAddress((SocketAddress)DLSocketAddress.getSocketAddress((int)this.proxyPort));
                    this.routingService.startService();
                    ((DistributedLogServiceImpl)serverPair.getLeft()).startPlacementPolicy();
                    success = true;
                }
                catch (BindException be) {
                    if (++retries > 20) {
                        throw be;
                    }
                    ++this.proxyPort;
                    if (this.proxyPort <= 65535) continue;
                    this.proxyPort = 1025;
                }
            }
            LOG.info("Running DL on port {}", (Object)this.proxyPort);
            this.dlServer = serverPair;
            this.address = DLSocketAddress.getSocketAddress((int)this.proxyPort);
        }

        public InetSocketAddress getAddress() {
            return this.address;
        }

        public void shutdown() {
            DistributedLogServer.closeServer(this.dlServer, 0L, TimeUnit.MILLISECONDS);
            this.routingService.stopService();
        }
    }

    public static class Builder {
        int numBookies = 3;
        boolean shouldStartZK = true;
        String zkHost = "127.0.0.1";
        int zkPort = 0;
        boolean shouldStartProxy = true;
        int proxyPort = 7000;
        boolean thriftmux = false;
        DistributedLogConfiguration dlConf = new DistributedLogConfiguration().setLockTimeout(10L).setOutputBufferSize(0).setImmediateFlushEnabled(true);
        org.apache.bookkeeper.conf.ServerConfiguration bkConf = new org.apache.bookkeeper.conf.ServerConfiguration();

        private Builder() {
        }

        public Builder numBookies(int numBookies) {
            this.numBookies = numBookies;
            return this;
        }

        public Builder shouldStartZK(boolean startZK) {
            this.shouldStartZK = startZK;
            return this;
        }

        public Builder zkServers(String zkServers) {
            this.zkHost = zkServers;
            return this;
        }

        public Builder zkPort(int zkPort) {
            this.zkPort = zkPort;
            return this;
        }

        public Builder shouldStartProxy(boolean startProxy) {
            this.shouldStartProxy = startProxy;
            return this;
        }

        public Builder proxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder dlConf(DistributedLogConfiguration dlConf) {
            this.dlConf = dlConf;
            return this;
        }

        public Builder bkConf(org.apache.bookkeeper.conf.ServerConfiguration bkConf) {
            this.bkConf = bkConf;
            return this;
        }

        public Builder thriftmux(boolean enabled) {
            this.thriftmux = enabled;
            return this;
        }

        public DistributedLogCluster build() throws Exception {
            return new DistributedLogCluster(this.dlConf, this.bkConf, this.numBookies, this.shouldStartZK, this.zkHost, this.zkPort, this.shouldStartProxy, this.proxyPort, this.thriftmux);
        }
    }
}

