/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.jshell;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import org.openjdk.source.tree.Tree;
import org.openjdk.tools.javac.code.Source;
import org.openjdk.tools.javac.parser.Scanner;
import org.openjdk.tools.javac.parser.ScannerFactory;
import org.openjdk.tools.javac.parser.Tokens;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.jshell.JShell;
import org.openjdk.tools.jshell.SourceCodeAnalysis;
import org.openjdk.tools.jshell.TaskFactory;

class CompletenessAnalyzer {
    private final ScannerFactory scannerFactory;
    private final JShell proc;
    private static final int XEXPR = 1;
    private static final int XDECL = 2;
    private static final int XSTMT = 4;
    private static final int XEXPR1o = 8;
    private static final int XDECL1o = 16;
    private static final int XSTMT1o = 32;
    private static final int XEXPR1 = 9;
    private static final int XDECL1 = 18;
    private static final int XSTMT1 = 36;
    private static final int XANY1 = 56;
    private static final int XTERM = 256;
    private static final int XSTART = 512;
    private static final int XERRO = 1024;

    private static SourceCodeAnalysis.Completeness error() {
        return SourceCodeAnalysis.Completeness.UNKNOWN;
    }

    CompletenessAnalyzer(JShell proc) {
        this.proc = proc;
        Context context = new Context();
        CaLog log = CaLog.createLog(context);
        context.put(Log.class, log);
        context.put(Source.class, Source.JDK1_9);
        this.scannerFactory = ScannerFactory.instance(context);
    }

    CaInfo scan(String s) {
        try {
            Scanner scanner = this.scannerFactory.newScanner(s, false);
            Matched in = new Matched(scanner);
            Parser parser = new Parser(in, this.proc, s);
            SourceCodeAnalysis.Completeness stat = parser.parseUnit();
            int endPos = stat == SourceCodeAnalysis.Completeness.UNKNOWN ? s.length() : ((Matched)in).prevCT.endPos;
            return new CaInfo(stat, endPos);
        }
        catch (SyntaxException ex) {
            return new CaInfo(CompletenessAnalyzer.error(), s.length());
        }
    }

    private static void die() {
        throw new SyntaxException();
    }

    private static class Parser {
        final Matched in;
        CT token;
        SourceCodeAnalysis.Completeness checkResult;
        final JShell proc;
        final String scannedInput;

        Parser(Matched in, JShell proc, String scannedInput) {
            this.in = in;
            this.nextToken();
            this.proc = proc;
            this.scannedInput = scannedInput;
        }

        final void nextToken() {
            this.in.next();
            this.token = this.in.currentCT;
        }

        boolean shouldAbort(TK tk) {
            if (this.token.kind == tk) {
                this.nextToken();
                return false;
            }
            switch (this.token.kind) {
                case EOF: {
                    this.checkResult = tk == TK.SEMI && ((Matched)this.in).prevCT.kind.isOkToTerminate() ? SourceCodeAnalysis.Completeness.COMPLETE_WITH_SEMI : SourceCodeAnalysis.Completeness.DEFINITELY_INCOMPLETE;
                    return true;
                }
                case UNMATCHED: {
                    this.checkResult = SourceCodeAnalysis.Completeness.DEFINITELY_INCOMPLETE;
                    return true;
                }
            }
            this.checkResult = CompletenessAnalyzer.error();
            return true;
        }

        SourceCodeAnalysis.Completeness lastly(TK tk) {
            if (this.shouldAbort(tk)) {
                return this.checkResult;
            }
            return SourceCodeAnalysis.Completeness.COMPLETE;
        }

        SourceCodeAnalysis.Completeness optionalFinalSemi() {
            if (!this.shouldAbort(TK.SEMI)) {
                return SourceCodeAnalysis.Completeness.COMPLETE;
            }
            if (this.checkResult == SourceCodeAnalysis.Completeness.COMPLETE_WITH_SEMI) {
                return SourceCodeAnalysis.Completeness.COMPLETE;
            }
            return this.checkResult;
        }

        boolean shouldAbort(SourceCodeAnalysis.Completeness flags) {
            this.checkResult = flags;
            return flags != SourceCodeAnalysis.Completeness.COMPLETE;
        }

        public SourceCodeAnalysis.Completeness parseUnit() {
            switch (this.token.kind.belongs & 0x38) {
                case 8: {
                    return this.parseExpressionOptionalSemi();
                }
                case 32: {
                    SourceCodeAnalysis.Completeness stat = this.parseSimpleStatement();
                    return stat == null ? CompletenessAnalyzer.error() : stat;
                }
                case 16: {
                    return this.parseDeclaration();
                }
                case 24: 
                case 48: {
                    return this.disambiguateDeclarationVsExpression();
                }
                case 0: {
                    if ((this.token.kind.belongs & 0x400) != 0) {
                        return this.parseExpressionStatement();
                    }
                    return CompletenessAnalyzer.error();
                }
            }
            throw new InternalError("Case not covered " + this.token.kind.belongs + " in " + (Object)((Object)this.token.kind));
        }

        public SourceCodeAnalysis.Completeness parseDeclaration() {
            boolean isImport;
            boolean bl = isImport = this.token.kind == TK.IMPORT;
            while (this.token.kind.isDeclaration()) {
                this.nextToken();
            }
            switch (this.token.kind) {
                case EQ: {
                    this.nextToken();
                    if (this.token.kind == TK.BRACES) {
                        this.nextToken();
                        return this.lastly(TK.SEMI);
                    }
                    return this.parseExpressionStatement();
                }
                case BRACES: 
                case SEMI: {
                    this.nextToken();
                    return SourceCodeAnalysis.Completeness.COMPLETE;
                }
                case UNMATCHED: {
                    this.nextToken();
                    return SourceCodeAnalysis.Completeness.DEFINITELY_INCOMPLETE;
                }
                case EOF: {
                    switch (((Matched)this.in).prevCT.kind) {
                        case BRACES: 
                        case SEMI: {
                            return SourceCodeAnalysis.Completeness.COMPLETE;
                        }
                        case IDENTIFIER: 
                        case BRACKETS: {
                            return SourceCodeAnalysis.Completeness.COMPLETE_WITH_SEMI;
                        }
                        case STAR: {
                            if (isImport) {
                                return SourceCodeAnalysis.Completeness.COMPLETE_WITH_SEMI;
                            }
                            return SourceCodeAnalysis.Completeness.DEFINITELY_INCOMPLETE;
                        }
                    }
                    return SourceCodeAnalysis.Completeness.DEFINITELY_INCOMPLETE;
                }
            }
            return CompletenessAnalyzer.error();
        }

        public SourceCodeAnalysis.Completeness disambiguateDeclarationVsExpression() {
            TaskFactory taskFactory = this.proc.taskFactory;
            taskFactory.getClass();
            TaskFactory.ParseTask pt = taskFactory.new TaskFactory.ParseTask(this.scannedInput);
            List<? extends Tree> units = pt.units();
            if (units.isEmpty()) {
                return CompletenessAnalyzer.error();
            }
            Tree unitTree = units.get(0);
            switch (unitTree.getKind()) {
                case EXPRESSION_STATEMENT: {
                    return this.parseExpressionOptionalSemi();
                }
                case LABELED_STATEMENT: {
                    if (this.shouldAbort(TK.IDENTIFIER)) {
                        return this.checkResult;
                    }
                    if (this.shouldAbort(TK.COLON)) {
                        return this.checkResult;
                    }
                    return this.parseStatement();
                }
                case VARIABLE: 
                case IMPORT: 
                case CLASS: 
                case ENUM: 
                case ANNOTATION_TYPE: 
                case INTERFACE: 
                case METHOD: {
                    return this.parseDeclaration();
                }
            }
            return CompletenessAnalyzer.error();
        }

        public SourceCodeAnalysis.Completeness parseExpressionStatement() {
            if (this.shouldAbort(this.parseExpression())) {
                return this.checkResult;
            }
            return this.lastly(TK.SEMI);
        }

        public SourceCodeAnalysis.Completeness parseExpressionOptionalSemi() {
            if (this.shouldAbort(this.parseExpression())) {
                return this.checkResult;
            }
            return this.optionalFinalSemi();
        }

        public SourceCodeAnalysis.Completeness parseExpression() {
            while (this.token.kind.isExpression()) {
                this.nextToken();
            }
            return SourceCodeAnalysis.Completeness.COMPLETE;
        }

        public SourceCodeAnalysis.Completeness parseStatement() {
            SourceCodeAnalysis.Completeness stat = this.parseSimpleStatement();
            if (stat == null) {
                return this.parseExpressionStatement();
            }
            return stat;
        }

        public SourceCodeAnalysis.Completeness parseSimpleStatement() {
            switch (this.token.kind) {
                case BRACES: {
                    return this.lastly(TK.BRACES);
                }
                case IF: {
                    this.nextToken();
                    if (this.shouldAbort(TK.PARENS)) {
                        return this.checkResult;
                    }
                    SourceCodeAnalysis.Completeness thenpart = this.parseStatement();
                    if (this.shouldAbort(thenpart)) {
                        return thenpart;
                    }
                    if (this.token.kind == TK.ELSE) {
                        this.nextToken();
                        return this.parseStatement();
                    }
                    return thenpart;
                }
                case FOR: {
                    this.nextToken();
                    if (this.shouldAbort(TK.PARENS)) {
                        return this.checkResult;
                    }
                    if (this.shouldAbort(this.parseStatement())) {
                        return this.checkResult;
                    }
                    return SourceCodeAnalysis.Completeness.COMPLETE;
                }
                case WHILE: {
                    this.nextToken();
                    if (this.shouldAbort(TK.PARENS)) {
                        return CompletenessAnalyzer.error();
                    }
                    return this.parseStatement();
                }
                case DO: {
                    this.nextToken();
                    switch (this.parseStatement()) {
                        case DEFINITELY_INCOMPLETE: 
                        case CONSIDERED_INCOMPLETE: 
                        case COMPLETE_WITH_SEMI: {
                            return SourceCodeAnalysis.Completeness.DEFINITELY_INCOMPLETE;
                        }
                        case UNKNOWN: {
                            return CompletenessAnalyzer.error();
                        }
                    }
                    if (this.shouldAbort(TK.WHILE)) {
                        return this.checkResult;
                    }
                    if (this.shouldAbort(TK.PARENS)) {
                        return this.checkResult;
                    }
                    return this.lastly(TK.SEMI);
                }
                case TRY: {
                    boolean hasResources = false;
                    this.nextToken();
                    if (this.token.kind == TK.PARENS) {
                        this.nextToken();
                        hasResources = true;
                    }
                    if (this.shouldAbort(TK.BRACES)) {
                        return this.checkResult;
                    }
                    if (this.token.kind == TK.CATCH || this.token.kind == TK.FINALLY) {
                        while (this.token.kind == TK.CATCH) {
                            if (this.shouldAbort(TK.CATCH)) {
                                return this.checkResult;
                            }
                            if (this.shouldAbort(TK.PARENS)) {
                                return this.checkResult;
                            }
                            if (!this.shouldAbort(TK.BRACES)) continue;
                            return this.checkResult;
                        }
                        if (this.token.kind == TK.FINALLY) {
                            if (this.shouldAbort(TK.FINALLY)) {
                                return this.checkResult;
                            }
                            if (this.shouldAbort(TK.BRACES)) {
                                return this.checkResult;
                            }
                        }
                    } else if (!hasResources) {
                        if (this.token.kind == TK.EOF) {
                            return SourceCodeAnalysis.Completeness.DEFINITELY_INCOMPLETE;
                        }
                        return CompletenessAnalyzer.error();
                    }
                    return SourceCodeAnalysis.Completeness.COMPLETE;
                }
                case SWITCH: {
                    this.nextToken();
                    if (this.shouldAbort(TK.PARENS)) {
                        return this.checkResult;
                    }
                    return this.lastly(TK.BRACES);
                }
                case SYNCHRONIZED: {
                    this.nextToken();
                    if (this.shouldAbort(TK.PARENS)) {
                        return this.checkResult;
                    }
                    return this.lastly(TK.BRACES);
                }
                case THROW: {
                    this.nextToken();
                    if (this.shouldAbort(this.parseExpression())) {
                        return this.checkResult;
                    }
                    return this.lastly(TK.SEMI);
                }
                case SEMI: {
                    return this.lastly(TK.SEMI);
                }
                case ASSERT: {
                    this.nextToken();
                    return this.parseExpressionStatement();
                }
                case RETURN: 
                case BREAK: 
                case CONTINUE: {
                    this.nextToken();
                    return this.parseExpressionStatement();
                }
                case ELSE: 
                case FINALLY: 
                case CATCH: {
                    return CompletenessAnalyzer.error();
                }
                case EOF: {
                    return SourceCodeAnalysis.Completeness.CONSIDERED_INCOMPLETE;
                }
            }
            return null;
        }
    }

    private static class Matched
    implements Iterator<CT> {
        private final Scanner scanner;
        private Tokens.Token current;
        private CT prevCT;
        private CT currentCT;
        private final Deque<Tokens.Token> stack = new ArrayDeque<Tokens.Token>();

        Matched(Scanner scanner) {
            this.scanner = scanner;
            this.advance();
            this.prevCT = this.currentCT = new CT(TK.SEMI, 0);
        }

        @Override
        public boolean hasNext() {
            return this.currentCT.kind != TK.EOF;
        }

        private Tokens.Token advance() {
            Tokens.Token prev = this.current;
            this.scanner.nextToken();
            this.current = this.scanner.token();
            return prev;
        }

        @Override
        public CT next() {
            this.prevCT = this.currentCT;
            this.currentCT = this.nextCT();
            return this.currentCT;
        }

        private CT match(TK tk, Tokens.TokenKind open) {
            Tokens.Token tok = this.advance();
            this.db("match desired-tk=%s, open=%s, seen-tok=%s", new Object[]{tk, open, tok.kind});
            if (this.stack.isEmpty()) {
                return new CT(TK.ERROR, tok, "Encountered '" + tok + "' with no opening '" + open + "'");
            }
            Tokens.Token p = this.stack.pop();
            if (p.kind != open) {
                return new CT(TK.ERROR, tok, "No match for '" + p + "' instead encountered '" + tok + "'");
            }
            return new CT(tk, tok);
        }

        private void db(String format, Object ... args) {
        }

        private CT nextCT() {
            TK prevTK = this.currentCT.kind;
            block7: while (true) {
                CT ct2;
                this.db("nextCT", new Object[0]);
                switch (this.current.kind) {
                    case EOF: {
                        this.db("eof", new Object[0]);
                        if (this.stack.isEmpty()) {
                            ct2 = new CT(TK.EOF, this.current);
                            break;
                        }
                        Tokens.TokenKind unmatched = this.stack.pop().kind;
                        this.stack.clear();
                        ct2 = new CT(TK.UNMATCHED, this.current, "Unmatched " + unmatched);
                        break;
                    }
                    case LPAREN: 
                    case LBRACE: 
                    case LBRACKET: {
                        this.stack.push(this.advance());
                        prevTK = TK.SEMI;
                        continue block7;
                    }
                    case RPAREN: {
                        ct2 = this.match(TK.PARENS, Tokens.TokenKind.LPAREN);
                        break;
                    }
                    case RBRACE: {
                        ct2 = this.match(TK.BRACES, Tokens.TokenKind.LBRACE);
                        break;
                    }
                    case RBRACKET: {
                        ct2 = this.match(TK.BRACKETS, Tokens.TokenKind.LBRACKET);
                        break;
                    }
                    default: {
                        ct2 = new CT(TK.tokenKindToTK(this.current.kind), this.advance());
                    }
                }
                if (ct2.kind.isStart() && !prevTK.isOkToTerminate()) {
                    return new CT(TK.ERROR, this.current, "No '" + (Object)((Object)prevTK) + "' before '" + (Object)((Object)ct2.kind) + "'");
                }
                if (this.stack.isEmpty() || ct2.kind.isError()) {
                    return ct2;
                }
                prevTK = ct2.kind;
            }
        }
    }

    private static class CT {
        public final TK kind;
        public final int endPos;
        public final String message;

        private CT(TK tk, Tokens.Token tok, String msg) {
            this.kind = tk;
            this.endPos = tok.endPos;
            this.message = msg;
        }

        private CT(TK tk, Tokens.Token tok) {
            this.kind = tk;
            this.endPos = tok.endPos;
            this.message = null;
        }

        private CT(TK tk, int endPos) {
            this.kind = tk;
            this.endPos = endPos;
            this.message = null;
        }
    }

    static enum TK {
        EOF(Tokens.TokenKind.EOF, 0),
        ERROR(Tokens.TokenKind.ERROR, 1024),
        IDENTIFIER(Tokens.TokenKind.IDENTIFIER, 283),
        UNDERSCORE(Tokens.TokenKind.UNDERSCORE, 1024),
        CLASS(Tokens.TokenKind.CLASS, 275),
        MONKEYS_AT(Tokens.TokenKind.MONKEYS_AT, 19),
        IMPORT(Tokens.TokenKind.IMPORT, 530),
        SEMI(Tokens.TokenKind.SEMI, 804),
        PACKAGE(Tokens.TokenKind.PACKAGE, 1024),
        CONST(Tokens.TokenKind.CONST, 1024),
        GOTO(Tokens.TokenKind.GOTO, 1024),
        CUSTOM(Tokens.TokenKind.CUSTOM, 1024),
        ENUM(Tokens.TokenKind.ENUM, 18),
        IMPLEMENTS(Tokens.TokenKind.IMPLEMENTS, 2),
        INTERFACE(Tokens.TokenKind.INTERFACE, 18),
        THROWS(Tokens.TokenKind.THROWS, 2),
        BOOLEAN(Tokens.TokenKind.BOOLEAN, 19),
        BYTE(Tokens.TokenKind.BYTE, 19),
        CHAR(Tokens.TokenKind.CHAR, 19),
        DOUBLE(Tokens.TokenKind.DOUBLE, 19),
        FLOAT(Tokens.TokenKind.FLOAT, 19),
        INT(Tokens.TokenKind.INT, 19),
        LONG(Tokens.TokenKind.LONG, 19),
        SHORT(Tokens.TokenKind.SHORT, 19),
        VOID(Tokens.TokenKind.VOID, 19),
        ABSTRACT(Tokens.TokenKind.ABSTRACT, 18),
        FINAL(Tokens.TokenKind.FINAL, 18),
        NATIVE(Tokens.TokenKind.NATIVE, 18),
        STATIC(Tokens.TokenKind.STATIC, 18),
        STRICTFP(Tokens.TokenKind.STRICTFP, 18),
        PRIVATE(Tokens.TokenKind.PRIVATE, 18),
        PROTECTED(Tokens.TokenKind.PROTECTED, 18),
        PUBLIC(Tokens.TokenKind.PUBLIC, 18),
        TRANSIENT(Tokens.TokenKind.TRANSIENT, 18),
        VOLATILE(Tokens.TokenKind.VOLATILE, 18),
        EXTENDS(Tokens.TokenKind.EXTENDS, 3),
        COMMA(Tokens.TokenKind.COMMA, 3),
        AMP(Tokens.TokenKind.AMP, 3),
        GT(Tokens.TokenKind.GT, 3),
        LT(Tokens.TokenKind.LT, 19),
        LTLT(Tokens.TokenKind.LTLT, 19),
        GTGT(Tokens.TokenKind.GTGT, 3),
        GTGTGT(Tokens.TokenKind.GTGTGT, 3),
        QUES(Tokens.TokenKind.QUES, 3),
        DOT(Tokens.TokenKind.DOT, 3),
        STAR(Tokens.TokenKind.STAR, 259),
        ASSERT(Tokens.TokenKind.ASSERT, 548),
        BREAK(Tokens.TokenKind.BREAK, 804),
        CATCH(Tokens.TokenKind.CATCH, 548),
        CONTINUE(Tokens.TokenKind.CONTINUE, 804),
        DO(Tokens.TokenKind.DO, 548),
        ELSE(Tokens.TokenKind.ELSE, 804),
        FINALLY(Tokens.TokenKind.FINALLY, 548),
        FOR(Tokens.TokenKind.FOR, 548),
        IF(Tokens.TokenKind.IF, 548),
        RETURN(Tokens.TokenKind.RETURN, 804),
        SWITCH(Tokens.TokenKind.SWITCH, 548),
        SYNCHRONIZED(Tokens.TokenKind.SYNCHRONIZED, 38),
        THROW(Tokens.TokenKind.THROW, 548),
        TRY(Tokens.TokenKind.TRY, 548),
        WHILE(Tokens.TokenKind.WHILE, 548),
        CASE(Tokens.TokenKind.CASE, 516),
        DEFAULT(Tokens.TokenKind.DEFAULT, 516),
        INTLITERAL(Tokens.TokenKind.INTLITERAL, 265),
        LONGLITERAL(Tokens.TokenKind.LONGLITERAL, 265),
        FLOATLITERAL(Tokens.TokenKind.FLOATLITERAL, 265),
        DOUBLELITERAL(Tokens.TokenKind.DOUBLELITERAL, 265),
        CHARLITERAL(Tokens.TokenKind.CHARLITERAL, 265),
        STRINGLITERAL(Tokens.TokenKind.STRINGLITERAL, 265),
        TRUE(Tokens.TokenKind.TRUE, 265),
        FALSE(Tokens.TokenKind.FALSE, 265),
        NULL(Tokens.TokenKind.NULL, 265),
        THIS(Tokens.TokenKind.THIS, 265),
        PLUSPLUS(Tokens.TokenKind.PLUSPLUS, 265),
        SUBSUB(Tokens.TokenKind.SUBSUB, 265),
        INSTANCEOF(Tokens.TokenKind.INSTANCEOF, 1),
        NEW(Tokens.TokenKind.NEW, 9),
        SUPER(Tokens.TokenKind.SUPER, 11),
        ARROW(Tokens.TokenKind.ARROW, 1),
        COLCOL(Tokens.TokenKind.COLCOL, 1),
        LPAREN(Tokens.TokenKind.LPAREN, 1),
        RPAREN(Tokens.TokenKind.RPAREN, 1),
        LBRACE(Tokens.TokenKind.LBRACE, 1),
        RBRACE(Tokens.TokenKind.RBRACE, 1),
        LBRACKET(Tokens.TokenKind.LBRACKET, 1),
        RBRACKET(Tokens.TokenKind.RBRACKET, 1),
        ELLIPSIS(Tokens.TokenKind.ELLIPSIS, 1),
        EQ(Tokens.TokenKind.EQ, 1),
        BANG(Tokens.TokenKind.BANG, 9),
        TILDE(Tokens.TokenKind.TILDE, 9),
        COLON(Tokens.TokenKind.COLON, 257),
        EQEQ(Tokens.TokenKind.EQEQ, 1),
        LTEQ(Tokens.TokenKind.LTEQ, 1),
        GTEQ(Tokens.TokenKind.GTEQ, 1),
        BANGEQ(Tokens.TokenKind.BANGEQ, 1),
        AMPAMP(Tokens.TokenKind.AMPAMP, 1),
        BARBAR(Tokens.TokenKind.BARBAR, 1),
        PLUS(Tokens.TokenKind.PLUS, 9),
        SUB(Tokens.TokenKind.SUB, 9),
        SLASH(Tokens.TokenKind.SLASH, 1),
        BAR(Tokens.TokenKind.BAR, 1),
        CARET(Tokens.TokenKind.CARET, 1),
        PERCENT(Tokens.TokenKind.PERCENT, 1),
        PLUSEQ(Tokens.TokenKind.PLUSEQ, 1),
        SUBEQ(Tokens.TokenKind.SUBEQ, 1),
        STAREQ(Tokens.TokenKind.STAREQ, 1),
        SLASHEQ(Tokens.TokenKind.SLASHEQ, 1),
        AMPEQ(Tokens.TokenKind.AMPEQ, 1),
        BAREQ(Tokens.TokenKind.BAREQ, 1),
        CARETEQ(Tokens.TokenKind.CARETEQ, 1),
        PERCENTEQ(Tokens.TokenKind.PERCENTEQ, 1),
        LTLTEQ(Tokens.TokenKind.LTLTEQ, 1),
        GTGTEQ(Tokens.TokenKind.GTGTEQ, 1),
        GTGTGTEQ(Tokens.TokenKind.GTGTGTEQ, 1),
        UNMATCHED(1024),
        PARENS(271),
        BRACKETS(259),
        BRACES(293);

        static final EnumMap<Tokens.TokenKind, TK> tokenKindToTKMap;
        final Tokens.TokenKind tokenKind;
        final int belongs;

        private TK(int b) {
            this.tokenKind = null;
            this.belongs = b;
        }

        private TK(Tokens.TokenKind tokenKind, int b) {
            this.tokenKind = tokenKind;
            this.belongs = b;
        }

        private static TK tokenKindToTK(Tokens.TokenKind kind) {
            TK tk = tokenKindToTKMap.get(kind);
            if (tk == null) {
                System.err.printf("No corresponding %s for %s: %s\n", TK.class.getCanonicalName(), Tokens.TokenKind.class.getCanonicalName(), kind);
                throw new InternalError("No corresponding TK for TokenKind: " + kind);
            }
            return tk;
        }

        boolean isOkToTerminate() {
            return (this.belongs & 0x100) != 0;
        }

        boolean isExpression() {
            return (this.belongs & 1) != 0;
        }

        boolean isDeclaration() {
            return (this.belongs & 2) != 0;
        }

        boolean isError() {
            return (this.belongs & 0x400) != 0;
        }

        boolean isStart() {
            return (this.belongs & 0x200) != 0;
        }

        static {
            tokenKindToTKMap = new EnumMap(Tokens.TokenKind.class);
            for (TK tK : TK.values()) {
                if (tK.tokenKind == null) continue;
                tokenKindToTKMap.put(tK.tokenKind, tK);
            }
            for (Enum enum_ : Tokens.TokenKind.values()) {
                TK.tokenKindToTK((Tokens.TokenKind)enum_);
            }
        }
    }

    private static class CaLog
    extends Log {
        private static CaLog createLog(Context context) {
            PrintWriter pw = new PrintWriter(new StringWriter());
            CaLog log = new CaLog(context, pw, pw, pw);
            context.put(outKey, pw);
            context.put(logKey, log);
            return log;
        }

        private CaLog(Context context, PrintWriter errWriter, PrintWriter warnWriter, PrintWriter noticeWriter) {
            super(context, errWriter, warnWriter, noticeWriter);
        }

        @Override
        public void error(String key, Object ... args) {
            CompletenessAnalyzer.die();
        }

        @Override
        public void error(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
            CompletenessAnalyzer.die();
        }

        @Override
        public void error(JCDiagnostic.DiagnosticFlag flag, JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
            CompletenessAnalyzer.die();
        }

        @Override
        public void error(int pos, String key, Object ... args) {
            CompletenessAnalyzer.die();
        }

        @Override
        public void error(JCDiagnostic.DiagnosticFlag flag, int pos, String key, Object ... args) {
            CompletenessAnalyzer.die();
        }

        @Override
        public void report(JCDiagnostic diagnostic) {
        }
    }

    private static class SyntaxException
    extends RuntimeException {
        private SyntaxException() {
        }
    }

    static class CaInfo {
        final int unitEndPos;
        final SourceCodeAnalysis.Completeness status;

        CaInfo(SourceCodeAnalysis.Completeness status, int unitEndPos) {
            this.status = status;
            this.unitEndPos = unitEndPos;
        }
    }
}

