/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl.metadata;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.metadata.DLMetadata;
import org.apache.distributedlog.metadata.MetadataResolver;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.data.Stat;

public class ZkMetadataResolver
implements MetadataResolver {
    private final ZooKeeperClient zkc;

    public ZkMetadataResolver(ZooKeeperClient zkc) {
        this.zkc = zkc;
    }

    @Override
    public DLMetadata resolve(URI uri) throws IOException {
        String dlPath = uri.getPath();
        PathUtils.validatePath((String)dlPath);
        Object[] parts = StringUtils.split((String)dlPath, (char)'/');
        if (null == parts || 0 == parts.length) {
            throw new IOException("Invalid dlPath to resolve dl metadata : " + dlPath);
        }
        for (int i = parts.length; i >= 0; --i) {
            byte[] data;
            String pathToResolve = String.format("/%s", StringUtils.join((Object[])parts, (char)'/', (int)0, (int)i));
            try {
                data = this.zkc.get().getData(pathToResolve, false, new Stat());
            }
            catch (KeeperException.NoNodeException nne) {
                continue;
            }
            catch (KeeperException ke) {
                throw new IOException("Fail to resolve dl path : " + pathToResolve);
            }
            catch (InterruptedException ie) {
                throw new IOException("Interrupted when resolving dl path : " + pathToResolve);
            }
            if (null == data || data.length == 0) continue;
            try {
                return DLMetadata.deserialize(uri, data);
            }
            catch (IOException ie) {
                throw new IOException("Failed to deserialize uri : " + uri);
            }
        }
        throw new IOException("No bkdl config bound under dl path : " + dlPath);
    }
}

