/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.buildspec.tasks.package_;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import java.util.Map;
import org.apache.camel.v1.buildspec.tasks.package_.runtime.Capabilities;
import org.apache.camel.v1.buildspec.tasks.package_.runtime.Dependencies;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"applicationClass", "capabilities", "dependencies", "metadata", "provider", "version"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Runtime
implements KubernetesResource {
    @JsonProperty(value="applicationClass")
    @Required
    @JsonPropertyDescription(value="application entry point (main) to be executed")
    @JsonSetter(nulls=Nulls.SKIP)
    private String applicationClass;
    @JsonProperty(value="capabilities")
    @JsonPropertyDescription(value="features offered by this runtime")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, Capabilities> capabilities;
    @JsonProperty(value="dependencies")
    @Required
    @JsonPropertyDescription(value="list of dependencies needed to run the application")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Dependencies> dependencies;
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="set of metadata")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> metadata;
    @JsonProperty(value="provider")
    @Required
    @JsonPropertyDescription(value="Camel main application provider, ie, Camel Quarkus")
    @JsonSetter(nulls=Nulls.SKIP)
    private String provider;
    @JsonProperty(value="version")
    @Required
    @JsonPropertyDescription(value="Camel K Runtime version")
    @JsonSetter(nulls=Nulls.SKIP)
    private String version;

    public String getApplicationClass() {
        return this.applicationClass;
    }

    public void setApplicationClass(String applicationClass) {
        this.applicationClass = applicationClass;
    }

    public Map<String, Capabilities> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Map<String, Capabilities> capabilities) {
        this.capabilities = capabilities;
    }

    public List<Dependencies> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Dependencies> dependencies) {
        this.dependencies = dependencies;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return "Runtime(applicationClass=" + this.getApplicationClass() + ", capabilities=" + this.getCapabilities() + ", dependencies=" + this.getDependencies() + ", metadata=" + this.getMetadata() + ", provider=" + this.getProvider() + ", version=" + this.getVersion() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Runtime)) {
            return false;
        }
        Runtime other = (Runtime)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$applicationClass = this.getApplicationClass();
        String other$applicationClass = other.getApplicationClass();
        if (this$applicationClass == null ? other$applicationClass != null : !this$applicationClass.equals(other$applicationClass)) {
            return false;
        }
        Map<String, Capabilities> this$capabilities = this.getCapabilities();
        Map<String, Capabilities> other$capabilities = other.getCapabilities();
        if (this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities)) {
            return false;
        }
        List<Dependencies> this$dependencies = this.getDependencies();
        List<Dependencies> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Runtime;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationClass = this.getApplicationClass();
        result = result * 59 + ($applicationClass == null ? 43 : $applicationClass.hashCode());
        Map<String, Capabilities> $capabilities = this.getCapabilities();
        result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
        List<Dependencies> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

