/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationstatus.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.integrationstatus.traits.PullSecretBuilder;
import org.apache.camel.v1.integrationstatus.traits.pullsecret.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"auto", "configuration", "enabled", "imagePullerDelegation", "secretName"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class PullSecret
implements Editable<PullSecretBuilder>,
KubernetesResource {
    @JsonProperty(value="auto")
    @JsonPropertyDescription(value="Automatically configures the platform registry secret on the pod if it is of type `kubernetes.io/dockerconfigjson`.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean auto;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters.\nDeprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Can be used to enable or disable a trait. All traits share this common property.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="imagePullerDelegation")
    @JsonPropertyDescription(value="When using a global operator with a shared platform, this enables delegation of the `system:image-puller` cluster role on the operator namespace to the integration service account.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean imagePullerDelegation;
    @JsonProperty(value="secretName")
    @JsonPropertyDescription(value="The pull secret name to set on the Pod. If left empty this is automatically taken from the `IntegrationPlatform` registry configuration.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String secretName;

    public PullSecretBuilder edit() {
        return new PullSecretBuilder(this);
    }

    public Boolean getAuto() {
        return this.auto;
    }

    public void setAuto(Boolean auto) {
        this.auto = auto;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getImagePullerDelegation() {
        return this.imagePullerDelegation;
    }

    public void setImagePullerDelegation(Boolean imagePullerDelegation) {
        this.imagePullerDelegation = imagePullerDelegation;
    }

    public String getSecretName() {
        return this.secretName;
    }

    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

    public String toString() {
        return "PullSecret(auto=" + this.getAuto() + ", configuration=" + this.getConfiguration() + ", enabled=" + this.getEnabled() + ", imagePullerDelegation=" + this.getImagePullerDelegation() + ", secretName=" + this.getSecretName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PullSecret)) {
            return false;
        }
        PullSecret other = (PullSecret)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$auto = this.getAuto();
        Boolean other$auto = other.getAuto();
        if (this$auto == null ? other$auto != null : !((Object)this$auto).equals(other$auto)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$imagePullerDelegation = this.getImagePullerDelegation();
        Boolean other$imagePullerDelegation = other.getImagePullerDelegation();
        if (this$imagePullerDelegation == null ? other$imagePullerDelegation != null : !((Object)this$imagePullerDelegation).equals(other$imagePullerDelegation)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        String this$secretName = this.getSecretName();
        String other$secretName = other.getSecretName();
        return !(this$secretName == null ? other$secretName != null : !this$secretName.equals(other$secretName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PullSecret;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $auto = this.getAuto();
        result = result * 59 + ($auto == null ? 43 : ((Object)$auto).hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $imagePullerDelegation = this.getImagePullerDelegation();
        result = result * 59 + ($imagePullerDelegation == null ? 43 : ((Object)$imagePullerDelegation).hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        String $secretName = this.getSecretName();
        result = result * 59 + ($secretName == null ? 43 : $secretName.hashCode());
        return result;
    }
}

