/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionDistribution;
import org.apache.cassandra.stress.settings.OptionSimple;

public class SettingsSamples
implements Serializable {
    public final int liveCount;
    public final int historyCount;
    public final int reportCount;

    public SettingsSamples(SampleOptions options) {
        this.liveCount = (int)OptionDistribution.parseLong(options.liveCount.value());
        this.historyCount = (int)OptionDistribution.parseLong(options.historyCount.value());
        this.reportCount = (int)OptionDistribution.parseLong(options.reportCount.value());
    }

    public static SettingsSamples get(Map<String, String[]> clArgs) {
        String[] params = clArgs.remove("-sample");
        if (params == null) {
            return new SettingsSamples(new SampleOptions());
        }
        SampleOptions options = (SampleOptions)GroupedOptions.select((String[])params, (GroupedOptions[])new SampleOptions[]{new SampleOptions()});
        if (options == null) {
            SettingsSamples.printHelp();
            System.out.println("Invalid -sample options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsSamples(options);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-sample", new SampleOptions());
    }

    public static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsSamples.printHelp();
            }
        };
    }

    private static final class SampleOptions
    extends GroupedOptions {
        final OptionSimple historyCount = new OptionSimple("history=", "[0-9]+[bmk]?", "50K", "The number of samples to save across the whole run", false);
        final OptionSimple liveCount = new OptionSimple("live=", "[0-9]+[bmk]?", "1M", "The number of samples to save between reports", false);
        final OptionSimple reportCount = new OptionSimple("report=", "[0-9]+[bmk]?", "100K", "The maximum number of samples to use when building a report", false);

        private SampleOptions() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.historyCount, this.liveCount, this.reportCount);
        }
    }
}

