/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class EmptySerializer
implements TypeSerializer<Void> {
    public static final EmptySerializer instance = new EmptySerializer();

    @Override
    public Void deserialize(ByteBuffer bytes) {
        this.validate(bytes);
        return null;
    }

    @Override
    public ByteBuffer serialize(Void value) {
        return ByteBufferUtil.EMPTY_BYTE_BUFFER;
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() > 0) {
            throw new MarshalException("EmptyType only accept empty values. A non-empty value can be a result of a Thrift write into CQL-created dense table. See CASSANDRA-15778 for details.");
        }
    }

    @Override
    public String toString(Void value) {
        return "";
    }

    @Override
    public Class<Void> getType() {
        return Void.class;
    }
}

