/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.Slice;

public abstract class CBuilder {
    public static CBuilder STATIC_BUILDER = new CBuilder(){

        @Override
        public int count() {
            return 0;
        }

        @Override
        public int remainingCount() {
            return 0;
        }

        @Override
        public ClusteringComparator comparator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CBuilder add(ByteBuffer value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CBuilder add(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Clustering build() {
            return Clustering.STATIC_CLUSTERING;
        }

        @Override
        public Slice.Bound buildBound(boolean isStart, boolean isInclusive) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Slice buildSlice() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Clustering buildWith(ByteBuffer value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Clustering buildWith(List<ByteBuffer> newValues) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Slice.Bound buildBoundWith(ByteBuffer value, boolean isStart, boolean isInclusive) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Slice.Bound buildBoundWith(List<ByteBuffer> newValues, boolean isStart, boolean isInclusive) {
            throw new UnsupportedOperationException();
        }
    };

    public static CBuilder create(ClusteringComparator comparator) {
        return new ArrayBackedBuilder(comparator);
    }

    public abstract int count();

    public abstract int remainingCount();

    public abstract ClusteringComparator comparator();

    public abstract CBuilder add(ByteBuffer var1);

    public abstract CBuilder add(Object var1);

    public abstract Clustering build();

    public abstract Slice.Bound buildBound(boolean var1, boolean var2);

    public abstract Slice buildSlice();

    public abstract Clustering buildWith(ByteBuffer var1);

    public abstract Clustering buildWith(List<ByteBuffer> var1);

    public abstract Slice.Bound buildBoundWith(ByteBuffer var1, boolean var2, boolean var3);

    public abstract Slice.Bound buildBoundWith(List<ByteBuffer> var1, boolean var2, boolean var3);

    private static class ArrayBackedBuilder
    extends CBuilder {
        private final ClusteringComparator type;
        private final ByteBuffer[] values;
        private int size;
        private boolean built;

        public ArrayBackedBuilder(ClusteringComparator type) {
            this.type = type;
            this.values = new ByteBuffer[type.size()];
        }

        @Override
        public int count() {
            return this.size;
        }

        @Override
        public int remainingCount() {
            return this.values.length - this.size;
        }

        @Override
        public ClusteringComparator comparator() {
            return this.type;
        }

        @Override
        public CBuilder add(ByteBuffer value) {
            if (this.isDone()) {
                throw new IllegalStateException();
            }
            this.values[this.size++] = value;
            return this;
        }

        @Override
        public CBuilder add(Object value) {
            return this.add(this.type.subtype(this.size).decompose(value));
        }

        private boolean isDone() {
            return this.remainingCount() == 0 || this.built;
        }

        @Override
        public Clustering build() {
            this.built = true;
            return this.size == 0 ? Clustering.EMPTY : new Clustering(this.values);
        }

        @Override
        public Slice.Bound buildBound(boolean isStart, boolean isInclusive) {
            this.built = true;
            if (this.size == 0) {
                return isStart ? Slice.Bound.BOTTOM : Slice.Bound.TOP;
            }
            return Slice.Bound.create(Slice.Bound.boundKind(isStart, isInclusive), this.size == this.values.length ? this.values : Arrays.copyOfRange(this.values, 0, this.size));
        }

        @Override
        public Slice buildSlice() {
            this.built = true;
            if (this.size == 0) {
                return Slice.ALL;
            }
            return Slice.make(this.buildBound(true, true), this.buildBound(false, true));
        }

        @Override
        public Clustering buildWith(ByteBuffer value) {
            assert (this.size + 1 <= this.type.size());
            ByteBuffer[] newValues = Arrays.copyOf(this.values, this.type.size());
            newValues[this.size] = value;
            return new Clustering(newValues);
        }

        @Override
        public Clustering buildWith(List<ByteBuffer> newValues) {
            assert (this.size + newValues.size() <= this.type.size());
            ByteBuffer[] buffers = Arrays.copyOf(this.values, this.type.size());
            int newSize = this.size;
            for (ByteBuffer value : newValues) {
                buffers[newSize++] = value;
            }
            return new Clustering(buffers);
        }

        @Override
        public Slice.Bound buildBoundWith(ByteBuffer value, boolean isStart, boolean isInclusive) {
            ByteBuffer[] newValues = Arrays.copyOf(this.values, this.size + 1);
            newValues[this.size] = value;
            return Slice.Bound.create(Slice.Bound.boundKind(isStart, isInclusive), newValues);
        }

        @Override
        public Slice.Bound buildBoundWith(List<ByteBuffer> newValues, boolean isStart, boolean isInclusive) {
            ByteBuffer[] buffers = Arrays.copyOf(this.values, this.size + newValues.size());
            int newSize = this.size;
            for (ByteBuffer value : newValues) {
                buffers[newSize++] = value;
            }
            return Slice.Bound.create(Slice.Bound.boundKind(isStart, isInclusive), buffers);
        }
    }
}

