/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.io.sstable.IndexHelper;

public class ClusteringComparator
implements Comparator<Clusterable> {
    private final List<AbstractType<?>> clusteringTypes;
    private final Comparator<IndexHelper.IndexInfo> indexComparator;
    private final Comparator<IndexHelper.IndexInfo> indexReverseComparator;
    private final Comparator<Clusterable> reverseComparator;
    private final Comparator<Row> rowComparator = (r1, r2) -> this.compare(r1.clustering(), r2.clustering());

    public ClusteringComparator(AbstractType<?> ... clusteringTypes) {
        this((List<AbstractType<?>>)ImmutableList.copyOf((Object[])clusteringTypes));
    }

    public ClusteringComparator(List<AbstractType<?>> clusteringTypes) {
        this.clusteringTypes = ImmutableList.copyOf(clusteringTypes);
        this.indexComparator = (o1, o2) -> this.compare(o1.lastName, o2.lastName);
        this.indexReverseComparator = (o1, o2) -> this.compare(o1.firstName, o2.firstName);
        this.reverseComparator = (c1, c2) -> this.compare((Clusterable)c2, (Clusterable)c1);
        for (AbstractType<?> type : clusteringTypes) {
            type.checkComparable();
        }
    }

    public int size() {
        return this.clusteringTypes.size();
    }

    public List<AbstractType<?>> subtypes() {
        return this.clusteringTypes;
    }

    public AbstractType<?> subtype(int i) {
        return this.clusteringTypes.get(i);
    }

    public Clustering make(Object ... values) {
        if (values.length != this.size()) {
            throw new IllegalArgumentException(String.format("Invalid number of components, expecting %d but got %d", this.size(), values.length));
        }
        CBuilder builder = CBuilder.create(this);
        for (Object val : values) {
            if (val instanceof ByteBuffer) {
                builder.add((ByteBuffer)val);
                continue;
            }
            builder.add(val);
        }
        return builder.build();
    }

    @Override
    public int compare(Clusterable c1, Clusterable c2) {
        return this.compare(c1.clustering(), c2.clustering());
    }

    @Override
    public int compare(ClusteringPrefix c1, ClusteringPrefix c2) {
        int s1 = c1.size();
        int s2 = c2.size();
        int minSize = Math.min(s1, s2);
        for (int i = 0; i < minSize; ++i) {
            int cmp = this.compareComponent(i, c1.get(i), c2.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        if (s1 == s2) {
            return ClusteringPrefix.Kind.compare(c1.kind(), c2.kind());
        }
        return s1 < s2 ? c1.kind().comparedToClustering : -c2.kind().comparedToClustering;
    }

    @Override
    public int compare(Clustering c1, Clustering c2) {
        for (int i = 0; i < this.size(); ++i) {
            int cmp = this.compareComponent(i, c1.get(i), c2.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public int compareComponent(int i, ByteBuffer v1, ByteBuffer v2) {
        if (v1 == null) {
            return v2 == null ? 0 : -1;
        }
        if (v2 == null) {
            return 1;
        }
        return this.clusteringTypes.get(i).compare(v1, v2);
    }

    public boolean isCompatibleWith(ClusteringComparator previous) {
        if (this == previous) {
            return true;
        }
        if (this.size() < previous.size()) {
            return false;
        }
        for (int i = 0; i < previous.size(); ++i) {
            AbstractType<?> tprev = previous.subtype(i);
            AbstractType<?> tnew = this.subtype(i);
            if (tnew.isCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    public void validate(ClusteringPrefix clustering) {
        for (int i = 0; i < clustering.size(); ++i) {
            ByteBuffer value = clustering.get(i);
            if (value == null) continue;
            this.subtype(i).validate(value);
        }
    }

    public Comparator<Row> rowComparator() {
        return this.rowComparator;
    }

    public Comparator<IndexHelper.IndexInfo> indexComparator(boolean reversed) {
        return reversed ? this.indexReverseComparator : this.indexComparator;
    }

    @Override
    public Comparator<Clusterable> reversed() {
        return this.reverseComparator;
    }

    public String toString() {
        return String.format("comparator(%s)", Joiner.on((String)", ").join(this.clusteringTypes));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusteringComparator)) {
            return false;
        }
        ClusteringComparator that = (ClusteringComparator)o;
        return this.clusteringTypes.equals(that.clusteringTypes);
    }

    public int hashCode() {
        return Objects.hashCode(this.clusteringTypes);
    }
}

