/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.metrics.StorageMetrics;
import org.apache.cassandra.service.StorageService;

public final class CompactionInfo
implements Serializable {
    private static final long serialVersionUID = 3695381572726744816L;
    private final CFMetaData cfm;
    private final OperationType tasktype;
    private final long completed;
    private final long total;
    private final Unit unit;
    private final UUID compactionId;

    public CompactionInfo(CFMetaData cfm, OperationType tasktype, long bytesComplete, long totalBytes, UUID compactionId) {
        this(cfm, tasktype, bytesComplete, totalBytes, Unit.BYTES, compactionId);
    }

    public CompactionInfo(OperationType tasktype, long completed, long total, Unit unit, UUID compactionId) {
        this(null, tasktype, completed, total, unit, compactionId);
    }

    public CompactionInfo(CFMetaData cfm, OperationType tasktype, long completed, long total, Unit unit, UUID compactionId) {
        this.tasktype = tasktype;
        this.completed = completed;
        this.total = total;
        this.cfm = cfm;
        this.unit = unit;
        this.compactionId = compactionId;
    }

    public CompactionInfo forProgress(long complete, long total) {
        return new CompactionInfo(this.cfm, this.tasktype, complete, total, this.unit, this.compactionId);
    }

    public UUID getId() {
        return this.cfm != null ? this.cfm.cfId : null;
    }

    public String getKeyspace() {
        return this.cfm != null ? this.cfm.ksName : null;
    }

    public String getColumnFamily() {
        return this.cfm != null ? this.cfm.cfName : null;
    }

    public CFMetaData getCFMetaData() {
        return this.cfm;
    }

    public long getCompleted() {
        return this.completed;
    }

    public long getTotal() {
        return this.total;
    }

    public OperationType getTaskType() {
        return this.tasktype;
    }

    public UUID compactionId() {
        return this.compactionId;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append((Object)this.getTaskType());
        if (this.cfm != null) {
            buff.append('@').append(this.getId()).append('(');
            buff.append(this.getKeyspace()).append(", ").append(this.getColumnFamily()).append(", ");
        } else {
            buff.append('(');
        }
        buff.append(this.getCompleted()).append('/').append(this.getTotal());
        return buff.append(')').append((Object)this.unit).toString();
    }

    public Map<String, String> asMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("id", this.getId() == null ? "" : this.getId().toString());
        ret.put("keyspace", this.getKeyspace());
        ret.put("columnfamily", this.getColumnFamily());
        ret.put("completed", Long.toString(this.completed));
        ret.put("total", Long.toString(this.total));
        ret.put("taskType", this.tasktype.toString());
        ret.put("unit", this.unit.toString());
        ret.put("compactionId", this.compactionId == null ? "" : this.compactionId.toString());
        return ret;
    }

    public static abstract class Holder {
        private volatile boolean stopRequested = false;
        double load = StorageMetrics.load.getCount();
        double reportedSeverity = 0.0;

        public abstract CompactionInfo getCompactionInfo();

        public void stop() {
            this.stopRequested = true;
        }

        public abstract boolean isGlobal();

        public boolean isStopRequested() {
            return this.stopRequested || this.isGlobal() && CompactionManager.instance.isGlobalCompactionPaused();
        }

        public void started() {
            this.reportedSeverity = (double)this.getCompactionInfo().getTotal() / this.load;
            StorageService.instance.reportSeverity(this.reportedSeverity);
        }

        public void finished() {
            if (this.reportedSeverity != 0.0) {
                StorageService.instance.reportSeverity(-this.reportedSeverity);
            }
            this.reportedSeverity = 0.0;
        }
    }

    public static enum Unit {
        BYTES("bytes"),
        RANGES("ranges"),
        KEYS("keys");

        private final String name;

        private Unit(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static boolean isFileSize(String unit) {
            return BYTES.toString().equals(unit);
        }
    }
}

