/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.metrics.ConnectionMetrics;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.OutboundTcpConnection;
import org.apache.cassandra.security.SSLFactory;
import org.apache.cassandra.utils.FBUtilities;

public class OutboundTcpConnectionPool {
    public static final long LARGE_MESSAGE_THRESHOLD = Long.getLong("cassandra.otcp_large_message_threshold", 65536L);
    private final InetAddress id;
    private final CountDownLatch started;
    public final OutboundTcpConnection smallMessages;
    public final OutboundTcpConnection largeMessages;
    public final OutboundTcpConnection gossipMessages;
    private InetAddress resetEndpoint;
    private ConnectionMetrics metrics;

    OutboundTcpConnectionPool(InetAddress remoteEp) {
        this.id = remoteEp;
        this.resetEndpoint = SystemKeyspace.getPreferredIP(remoteEp);
        this.started = new CountDownLatch(1);
        this.smallMessages = new OutboundTcpConnection(this);
        this.largeMessages = new OutboundTcpConnection(this);
        this.gossipMessages = new OutboundTcpConnection(this);
    }

    OutboundTcpConnection getConnection(MessageOut msg) {
        if (Stage.GOSSIP == msg.getStage()) {
            return this.gossipMessages;
        }
        return msg.payloadSize(this.smallMessages.getTargetVersion()) > LARGE_MESSAGE_THRESHOLD ? this.largeMessages : this.smallMessages;
    }

    void reset() {
        for (OutboundTcpConnection conn : new OutboundTcpConnection[]{this.smallMessages, this.largeMessages, this.gossipMessages}) {
            conn.closeSocket(false);
        }
    }

    public void resetToNewerVersion(int version) {
        for (OutboundTcpConnection conn : new OutboundTcpConnection[]{this.smallMessages, this.largeMessages, this.gossipMessages}) {
            if (version <= conn.getTargetVersion()) continue;
            conn.softCloseSocket();
        }
    }

    public void reset(InetAddress remoteEP) {
        SystemKeyspace.updatePreferredIP(this.id, remoteEP);
        this.resetEndpoint = remoteEP;
        for (OutboundTcpConnection conn : new OutboundTcpConnection[]{this.smallMessages, this.largeMessages, this.gossipMessages}) {
            conn.softCloseSocket();
        }
        this.metrics.release();
        this.metrics = new ConnectionMetrics(this.resetEndpoint, this);
    }

    public long getTimeouts() {
        return this.metrics.timeouts.getCount();
    }

    public void incrementTimeout() {
        this.metrics.timeouts.mark();
    }

    public Socket newSocket() throws IOException {
        return OutboundTcpConnectionPool.newSocket(this.endPoint());
    }

    public static Socket newSocket(InetAddress endpoint) throws IOException {
        if (DatabaseDescriptor.getServerEncryptionOptions().shouldEncrypt(endpoint)) {
            if (DatabaseDescriptor.getOutboundBindAny()) {
                return SSLFactory.getSocket(DatabaseDescriptor.getServerEncryptionOptions(), endpoint, DatabaseDescriptor.getSSLStoragePort());
            }
            return SSLFactory.getSocket(DatabaseDescriptor.getServerEncryptionOptions(), endpoint, DatabaseDescriptor.getSSLStoragePort(), FBUtilities.getLocalAddress(), 0);
        }
        SocketChannel channel = SocketChannel.open();
        if (!DatabaseDescriptor.getOutboundBindAny()) {
            channel.bind(new InetSocketAddress(FBUtilities.getLocalAddress(), 0));
        }
        channel.connect(new InetSocketAddress(endpoint, DatabaseDescriptor.getStoragePort()));
        return channel.socket();
    }

    public InetAddress endPoint() {
        if (this.id.equals(FBUtilities.getBroadcastAddress())) {
            return FBUtilities.getLocalAddress();
        }
        return this.resetEndpoint;
    }

    public void start() {
        this.smallMessages.start();
        this.largeMessages.start();
        this.gossipMessages.start();
        this.metrics = new ConnectionMetrics(this.id, this);
        this.started.countDown();
    }

    public void waitForStarted() {
        if (this.started.getCount() == 0L) {
            return;
        }
        boolean error = false;
        try {
            if (!this.started.await(1L, TimeUnit.MINUTES)) {
                error = true;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            error = true;
        }
        if (error) {
            throw new IllegalStateException(String.format("Connections to %s are not started!", this.id.getHostAddress()));
        }
    }

    public void close() {
        if (this.largeMessages != null) {
            this.largeMessages.closeSocket(true);
        }
        if (this.smallMessages != null) {
            this.smallMessages.closeSocket(true);
        }
        if (this.gossipMessages != null) {
            this.gossipMessages.closeSocket(true);
        }
        this.metrics.release();
    }
}

