/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.BufferClusteringBound;
import org.apache.cassandra.db.BufferClusteringBoundOrBoundary;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringBoundary;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.ByteBufferCloner;

public class BufferClusteringBoundary
extends BufferClusteringBoundOrBoundary
implements ClusteringBoundary<ByteBuffer> {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new BufferClusteringBoundary(ClusteringPrefix.Kind.INCL_START_BOUND, EMPTY_VALUES_ARRAY));

    public BufferClusteringBoundary(ClusteringPrefix.Kind kind, ByteBuffer[] values) {
        super(kind, values);
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapOf((ByteBuffer[])this.values);
    }

    public static ClusteringBoundary<ByteBuffer> create(ClusteringPrefix.Kind kind, ByteBuffer[] values) {
        Preconditions.checkArgument((boolean)kind.isBoundary(), (String)"Expected boundary clustering kind, got %s", (Object)((Object)kind));
        return new BufferClusteringBoundary(kind, values);
    }

    @Override
    public ClusteringBoundary<ByteBuffer> invert() {
        return BufferClusteringBoundary.create(this.kind().invert(), (ByteBuffer[])this.values);
    }

    public ClusteringBoundary<ByteBuffer> clone(ByteBufferCloner cloner) {
        return (ClusteringBoundary)super.clone(cloner);
    }

    @Override
    public ClusteringBound<ByteBuffer> openBound(boolean reversed) {
        return BufferClusteringBound.create(this.kind.openBoundOfBoundary(reversed), (ByteBuffer[])this.values);
    }

    @Override
    public ClusteringBound<ByteBuffer> closeBound(boolean reversed) {
        return BufferClusteringBound.create(this.kind.closeBoundOfBoundary(reversed), (ByteBuffer[])this.values);
    }
}

