/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.cassandra.db.BufferClusteringBound;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.UnfilteredDeserializer;
import org.apache.cassandra.db.UnfilteredValidation;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.DeserializationHelper;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredSerializer;
import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.vint.VIntCoding;

public abstract class AbstractSSTableIterator<RIE extends AbstractRowIndexEntry>
implements UnfilteredRowIterator {
    protected final SSTableReader sstable;
    protected final TableMetadata metadata;
    protected final DecoratedKey key;
    protected final DeletionTime partitionLevelDeletion;
    protected final ColumnFilter columns;
    protected final DeserializationHelper helper;
    protected final Row staticRow;
    protected final Reader reader;
    protected final FileHandle ifile;
    private boolean isClosed;
    protected final Slices slices;

    protected AbstractSSTableIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, RIE indexEntry, Slices slices, ColumnFilter columnFilter, FileHandle ifile) {
        this.sstable = sstable;
        this.metadata = sstable.metadata();
        this.ifile = ifile;
        this.key = key;
        this.columns = columnFilter;
        this.slices = slices;
        this.helper = new DeserializationHelper(this.metadata, sstable.descriptor.version.correspondingMessagingVersion(), DeserializationHelper.Flag.LOCAL, columnFilter);
        if (indexEntry == null) {
            this.partitionLevelDeletion = DeletionTime.LIVE;
            this.reader = null;
            this.staticRow = Rows.EMPTY_STATIC_ROW;
        } else {
            boolean shouldCloseFile = file == null;
            try {
                boolean needSeekAtPartitionStart;
                boolean bl = needSeekAtPartitionStart = !((AbstractRowIndexEntry)indexEntry).isIndexed() || !this.columns.fetchedColumns().statics.isEmpty();
                if (needSeekAtPartitionStart) {
                    if (file == null) {
                        file = sstable.getFileDataInput(((AbstractRowIndexEntry)indexEntry).position);
                    } else {
                        file.seek(((AbstractRowIndexEntry)indexEntry).position);
                    }
                    ByteBufferUtil.skipShortLength(file);
                    this.partitionLevelDeletion = DeletionTime.getSerializer(sstable.descriptor.version).deserialize(file);
                    this.reader = this.createReader(indexEntry, file, shouldCloseFile);
                    this.staticRow = AbstractSSTableIterator.readStaticRow(sstable, file, this.helper, this.columns.fetchedColumns().statics);
                } else {
                    this.partitionLevelDeletion = ((AbstractRowIndexEntry)indexEntry).deletionTime();
                    this.staticRow = Rows.EMPTY_STATIC_ROW;
                    this.reader = this.createReader(indexEntry, file, shouldCloseFile);
                }
                if (!this.partitionLevelDeletion.validate()) {
                    UnfilteredValidation.handleInvalid(this.metadata(), key, sstable, "partitionLevelDeletion=" + this.partitionLevelDeletion.toString());
                }
                if (this.reader != null && !slices.isEmpty()) {
                    this.reader.setForSlice(this.nextSlice());
                }
                if (this.reader == null && file != null && shouldCloseFile) {
                    file.close();
                }
            }
            catch (IOException e) {
                sstable.markSuspect();
                String filePath = file.getPath();
                if (shouldCloseFile) {
                    try {
                        file.close();
                    }
                    catch (IOException suppressed) {
                        e.addSuppressed(suppressed);
                    }
                }
                throw new CorruptSSTableException((Throwable)e, filePath);
            }
        }
    }

    private Slice nextSlice() {
        return this.slices.get(this.nextSliceIndex());
    }

    protected abstract int nextSliceIndex();

    protected abstract boolean hasMoreSlices();

    private static Row readStaticRow(SSTableReader sstable, FileDataInput file, DeserializationHelper helper, Columns statics) throws IOException {
        if (!sstable.header.hasStatic()) {
            return Rows.EMPTY_STATIC_ROW;
        }
        if (statics.isEmpty()) {
            UnfilteredSerializer.serializer.skipStaticRow(file, sstable.header, helper);
            return Rows.EMPTY_STATIC_ROW;
        }
        return UnfilteredSerializer.serializer.deserializeStaticRow(file, sstable.header, helper);
    }

    protected abstract Reader createReaderInternal(RIE var1, FileDataInput var2, boolean var3, Version var4);

    private Reader createReader(RIE indexEntry, FileDataInput file, boolean shouldCloseFile) {
        return this.slices.isEmpty() ? new NoRowsReader(file, shouldCloseFile) : this.createReaderInternal(indexEntry, file, shouldCloseFile, this.sstable.descriptor.version);
    }

    @Override
    public TableMetadata metadata() {
        return this.metadata;
    }

    @Override
    public RegularAndStaticColumns columns() {
        return this.columns.fetchedColumns();
    }

    @Override
    public DecoratedKey partitionKey() {
        return this.key;
    }

    @Override
    public DeletionTime partitionLevelDeletion() {
        return this.partitionLevelDeletion;
    }

    @Override
    public Row staticRow() {
        return this.staticRow;
    }

    @Override
    public EncodingStats stats() {
        return this.sstable.stats();
    }

    @Override
    public boolean hasNext() {
        while (this.reader != null) {
            if (this.reader.hasNext()) {
                return true;
            }
            if (!this.hasMoreSlices()) {
                return false;
            }
            this.slice(this.nextSlice());
        }
        return false;
    }

    @Override
    public Unfiltered next() {
        assert (this.reader != null);
        return (Unfiltered)this.reader.next();
    }

    private void slice(Slice slice) {
        try {
            if (this.reader != null) {
                this.reader.setForSlice(slice);
            }
        }
        catch (IOException e) {
            try {
                this.closeInternal();
            }
            catch (IOException suppressed) {
                e.addSuppressed(suppressed);
            }
            this.sstable.markSuspect();
            throw new CorruptSSTableException((Throwable)e, this.reader.toString());
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void closeInternal() throws IOException {
        if (this.isClosed) {
            return;
        }
        if (this.reader != null) {
            this.reader.close();
        }
        this.isClosed = true;
    }

    @Override
    public void close() {
        try {
            this.closeInternal();
        }
        catch (IOException e) {
            this.sstable.markSuspect();
            throw new CorruptSSTableException((Throwable)e, this.reader.toString());
        }
    }

    private class NoRowsReader
    extends AbstractReader {
        private NoRowsReader(FileDataInput file, boolean shouldCloseFile) {
            super(file, shouldCloseFile);
        }

        @Override
        public void setForSlice(Slice slice) {
        }

        @Override
        public boolean hasNextInternal() {
            return false;
        }

        @Override
        protected Unfiltered nextInternal() throws IOException {
            throw new NoSuchElementException();
        }
    }

    protected class ForwardReader
    extends AbstractReader {
        protected ClusteringBound<?> start;
        protected ClusteringBound<?> end;
        protected Unfiltered next;
        protected boolean sliceDone;

        public ForwardReader(FileDataInput file, boolean shouldCloseFile) {
            super(file, shouldCloseFile);
            this.end = BufferClusteringBound.TOP;
        }

        @Override
        public void setForSlice(Slice slice) throws IOException {
            this.start = slice.start().isBottom() ? null : slice.start();
            this.end = slice.end();
            this.sliceDone = false;
            this.next = null;
        }

        private Unfiltered handlePreSliceData() throws IOException {
            assert (this.deserializer != null);
            while (this.deserializer.hasNext() && this.deserializer.compareNextTo(this.start) <= 0) {
                if (this.deserializer.nextIsRow()) {
                    this.deserializer.skipNext();
                    continue;
                }
                this.updateOpenMarker((RangeTombstoneMarker)this.deserializer.readNext());
            }
            ClusteringBound<?> sliceStart = this.start;
            this.start = null;
            if (this.openMarker != null) {
                return new RangeTombstoneBoundMarker(sliceStart, this.openMarker);
            }
            return null;
        }

        protected Unfiltered computeNext() throws IOException {
            Unfiltered next;
            assert (this.deserializer != null);
            do {
                if (!this.deserializer.hasNext() || this.deserializer.compareNextTo(this.end) >= 0) {
                    return null;
                }
                next = this.deserializer.readNext();
                UnfilteredValidation.maybeValidateUnfiltered(next, AbstractSSTableIterator.this.metadata(), AbstractSSTableIterator.this.key, AbstractSSTableIterator.this.sstable);
            } while (next.isEmpty());
            if (next.kind() == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
                this.updateOpenMarker((RangeTombstoneMarker)next);
            }
            return next;
        }

        @Override
        protected boolean hasNextInternal() throws IOException {
            Unfiltered unfiltered;
            if (this.next != null) {
                return true;
            }
            if (this.sliceDone) {
                return false;
            }
            if (this.start != null && (unfiltered = this.handlePreSliceData()) != null) {
                this.next = unfiltered;
                return true;
            }
            this.next = this.computeNext();
            if (this.next != null) {
                return true;
            }
            this.sliceDone = true;
            if (this.openMarker != null) {
                this.next = new RangeTombstoneBoundMarker(this.end, this.openMarker);
                return true;
            }
            return false;
        }

        @Override
        protected Unfiltered nextInternal() throws IOException {
            if (!this.hasNextInternal()) {
                throw new NoSuchElementException();
            }
            Unfiltered toReturn = this.next;
            this.next = null;
            return toReturn;
        }
    }

    public abstract class AbstractReader
    implements Reader {
        private final boolean shouldCloseFile;
        public FileDataInput file;
        public UnfilteredDeserializer deserializer;
        public DeletionTime openMarker;

        protected AbstractReader(FileDataInput file, boolean shouldCloseFile) {
            this.file = file;
            this.shouldCloseFile = shouldCloseFile;
            if (file != null) {
                this.createDeserializer();
            }
        }

        private void createDeserializer() {
            assert (this.file != null && this.deserializer == null);
            this.deserializer = UnfilteredDeserializer.create(AbstractSSTableIterator.this.metadata, this.file, AbstractSSTableIterator.this.sstable.header, AbstractSSTableIterator.this.helper);
        }

        @Override
        public void seekToPosition(long position) throws IOException {
            if (this.file == null) {
                this.file = AbstractSSTableIterator.this.sstable.getFileDataInput(position);
                this.createDeserializer();
            } else {
                this.file.seek(position);
                this.deserializer.clearState();
            }
        }

        protected void updateOpenMarker(RangeTombstoneMarker marker) {
            this.openMarker = marker.isOpen(false) ? marker.openDeletionTime(false) : null;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.hasNextInternal();
            }
            catch (IOException | IndexOutOfBoundsException | VIntCoding.VIntOutOfRangeException e) {
                try {
                    AbstractSSTableIterator.this.closeInternal();
                }
                catch (IOException suppressed) {
                    e.addSuppressed(suppressed);
                }
                AbstractSSTableIterator.this.sstable.markSuspect();
                throw new CorruptSSTableException((Throwable)e, this.toString());
            }
        }

        @Override
        public Unfiltered next() {
            try {
                return this.nextInternal();
            }
            catch (IOException e) {
                try {
                    AbstractSSTableIterator.this.closeInternal();
                }
                catch (IOException suppressed) {
                    e.addSuppressed(suppressed);
                }
                AbstractSSTableIterator.this.sstable.markSuspect();
                throw new CorruptSSTableException((Throwable)e, this.toString());
            }
        }

        @Override
        public abstract void setForSlice(Slice var1) throws IOException;

        protected abstract boolean hasNextInternal() throws IOException;

        protected abstract Unfiltered nextInternal() throws IOException;

        @Override
        public void close() throws IOException {
            if (this.shouldCloseFile && this.file != null) {
                this.file.close();
            }
        }

        public String toString() {
            return this.file != null ? this.file.toString() : "null";
        }
    }

    public static interface Reader
    extends Iterator<Unfiltered>,
    Closeable {
        public void setForSlice(Slice var1) throws IOException;

        public void seekToPosition(long var1) throws IOException;
    }
}

