/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import com.google.common.collect.Range;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;

public class ListSerializer<T>
extends CollectionSerializer<List<T>> {
    private static final ConcurrentMap<TypeSerializer<?>, ListSerializer> instances = new ConcurrentHashMap();
    public final TypeSerializer<T> elements;

    public static <T> ListSerializer<T> getInstance(TypeSerializer<T> elements) {
        ListSerializer t = (ListSerializer)instances.get(elements);
        if (t == null) {
            t = instances.computeIfAbsent(elements, ListSerializer::new);
        }
        return t;
    }

    private ListSerializer(TypeSerializer<T> elements) {
        this.elements = elements;
    }

    @Override
    protected List<ByteBuffer> serializeValues(List<T> values) {
        ArrayList<ByteBuffer> output = new ArrayList<ByteBuffer>(values.size());
        for (T value : values) {
            output.add(this.elements.serialize(value));
        }
        return output;
    }

    @Override
    public int getElementCount(List<T> value) {
        return value.size();
    }

    @Override
    public <V> void validate(V input, ValueAccessor<V> accessor) {
        if (accessor.isEmpty(input)) {
            throw new MarshalException("Not enough bytes to read a list");
        }
        try {
            int n = ListSerializer.readCollectionSize(input, accessor);
            int offset = ListSerializer.sizeOfCollectionSize();
            for (int i = 0; i < n; ++i) {
                V value = ListSerializer.readNonNullValue(input, accessor, offset);
                offset += ListSerializer.sizeOfValue(value, accessor);
                this.elements.validate(value, accessor);
            }
            if (!accessor.isEmptyFromOffset(input, offset)) {
                throw new MarshalException("Unexpected extraneous bytes after list value");
            }
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a list");
        }
    }

    @Override
    public <V> List<T> deserialize(V input, ValueAccessor<V> accessor) {
        try {
            int n = ListSerializer.readCollectionSize(input, accessor);
            int offset = ListSerializer.sizeOfCollectionSize();
            if (n < 0) {
                throw new MarshalException("The data cannot be deserialized as a list");
            }
            ArrayList<T> l = new ArrayList<T>(Math.min(n, 256));
            for (int i = 0; i < n; ++i) {
                V databb = ListSerializer.readValue(input, accessor, offset);
                offset += ListSerializer.sizeOfValue(databb, accessor);
                if (databb != null) {
                    this.elements.validate(databb, accessor);
                    l.add(this.elements.deserialize(databb, accessor));
                    continue;
                }
                l.add(null);
            }
            if (!accessor.isEmptyFromOffset(input, offset)) {
                throw new MarshalException("Unexpected extraneous bytes after list value");
            }
            return l;
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a list");
        }
    }

    public boolean anyMatch(ByteBuffer serializedList, Predicate<ByteBuffer> predicate) {
        return this.anyMatch(serializedList, ByteBufferAccessor.instance, predicate);
    }

    public <V> boolean anyMatch(V input, ValueAccessor<V> accessor, Predicate<V> predicate) {
        try {
            int s = ListSerializer.readCollectionSize(input, accessor);
            int offset = ListSerializer.sizeOfCollectionSize();
            for (int i = 0; i < s; ++i) {
                int size = accessor.getInt(input, offset);
                if (size < 0) continue;
                V value = accessor.slice(input, offset += 4, size);
                if (predicate.test(value)) {
                    return true;
                }
                offset += size;
            }
            return false;
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a list");
        }
    }

    public <V> V getElement(V input, ValueAccessor<V> accessor, int index) {
        try {
            int n = ListSerializer.readCollectionSize(input, accessor);
            int offset = ListSerializer.sizeOfCollectionSize();
            if (n <= index) {
                return null;
            }
            for (int i = 0; i < index; ++i) {
                int length = accessor.getInt(input, offset);
                offset += 4 + length;
            }
            return ListSerializer.readValue(input, accessor, offset);
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a list");
        }
    }

    public ByteBuffer getElement(ByteBuffer input, int index) {
        return this.getElement(input, ByteBufferAccessor.instance, index);
    }

    @Override
    public String toString(List<T> value) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        sb.append('[');
        for (T element : value) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.elements.toString(element));
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Class<List<T>> getType() {
        return List.class;
    }

    @Override
    public ByteBuffer getSerializedValue(ByteBuffer collection, ByteBuffer key, AbstractType<?> comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer getSliceFromSerialized(ByteBuffer collection, ByteBuffer from, ByteBuffer to, AbstractType<?> comparator, boolean frozen) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIndexFromSerialized(ByteBuffer collection, ByteBuffer key, AbstractType<?> comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Range<Integer> getIndexesRangeFromSerialized(ByteBuffer collection, ByteBuffer from, ByteBuffer to, AbstractType<?> comparator) {
        throw new UnsupportedOperationException();
    }
}

