/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.repair;

import java.util.List;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.service.reads.repair.ReadRepair;
import org.apache.cassandra.service.reads.repair.RowIteratorMergeListener;

public class PartitionIteratorMergeListener<E extends Endpoints<E>>
implements UnfilteredPartitionIterators.MergeListener {
    private final ReplicaPlan.ForRead<E, ?> replicaPlan;
    private final ReadCommand command;
    private final ReadRepair readRepair;

    public PartitionIteratorMergeListener(ReplicaPlan.ForRead<E, ?> replicaPlan, ReadCommand command, ReadRepair readRepair) {
        this.replicaPlan = replicaPlan;
        this.command = command;
        this.readRepair = readRepair;
    }

    @Override
    public UnfilteredRowIterators.MergeListener getRowMergeListener(DecoratedKey partitionKey, List<UnfilteredRowIterator> versions) {
        return new RowIteratorMergeListener<E>(partitionKey, PartitionIteratorMergeListener.columns(versions), this.isReversed(versions), this.replicaPlan, this.command, this.readRepair);
    }

    public static RegularAndStaticColumns columns(List<UnfilteredRowIterator> versions) {
        Columns statics = Columns.NONE;
        Columns regulars = Columns.NONE;
        for (UnfilteredRowIterator iter : versions) {
            if (iter == null) continue;
            RegularAndStaticColumns cols = iter.columns();
            statics = statics.mergeTo(cols.statics);
            regulars = regulars.mergeTo(cols.regulars);
        }
        return new RegularAndStaticColumns(statics, regulars);
    }

    protected boolean isReversed(List<UnfilteredRowIterator> versions) {
        for (UnfilteredRowIterator iter : versions) {
            if (iter == null) continue;
            return iter.isReverseOrder();
        }
        assert (false) : "Expected at least one iterator";
        return false;
    }

    @Override
    public void close() {
    }
}

